/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.hyades.trace.internal.ui.PDPluginImages;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.core.TraceProfileTypeGroupUI;
import org.eclipse.hyades.trace.ui.internal.launcher.ProfileFiltersTab;
import org.eclipse.hyades.trace.ui.internal.launcher.ProfilingSet;
import org.eclipse.hyades.trace.ui.internal.launcher.ProfilingSetType;
import org.eclipse.hyades.trace.ui.internal.launcher.ProfilingSetsManager;
import org.eclipse.hyades.trace.ui.internal.util.AbstractChangeable;
import org.eclipse.hyades.trace.ui.internal.util.FilterSetElement;
import org.eclipse.hyades.trace.ui.launcher.IProfilingSet;
import org.eclipse.hyades.trace.ui.launcher.IProfilingSetType;
import org.eclipse.hyades.trace.ui.launcher.IProfilingSetTypeGroup;
import org.eclipse.hyades.trace.ui.launcher.IProfilingType;
import org.eclipse.hyades.trace.ui.launcher.ProfilingAttribute;
import org.eclipse.hyades.trace.ui.launcher.ProfilingSetsManagerCopy;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.help.WorkbenchHelp;

public class TraceProfileOverviewUI
extends AbstractChangeable {
    private Composite _result;
    private List _profilingTypeList;
    private Table _table;
    private Table _profilingSetTable;
    private TableViewer _tableViewer;
    private CheckboxTableViewer _profilingSetTableViewer;
    private Button _addSetBtn;
    private Button _renameSetBtn;
    private Button _removeSetBtn;
    private Button _editBtn;
    private Label _contentLabel;
    private Label _profilingSetLabel;
    private ProfilingSetsManagerCopy _managerCopy;
    private Listener _listener = new Listener(){

        public void handleEvent(Event event) {
            TraceProfileOverviewUI.this.changed();
        }
    };

    public Composite createControl(Composite parent) {
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.verticalSpacing = 0;
        this._result = new Composite(parent, 0);
        this._result.setLayout((Layout)layout);
        this._result.setLayoutData((Object)GridUtil.createFill());
        this.createProfilingSetTable(this._result);
        this.createProfilingTypeTable(this._result);
        return this._result;
    }

    private void createProfilingSetTable(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(UIPlugin.getResourceString("STR_SELECT_PROFILING_SET"));
        GridData data = new GridData();
        data.horizontalSpan = 2;
        label.setLayoutData((Object)data);
        Composite tableGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        tableGroup.setLayout((Layout)layout);
        data = GridUtil.createFill();
        data.heightHint = 100;
        tableGroup.setLayoutData((Object)data);
        this._profilingSetTable = new Table(tableGroup, 68132);
        this._profilingSetTable.setLayoutData((Object)GridUtil.createFill());
        this._profilingSetTable.setLinesVisible(false);
        TableColumn column = new TableColumn(this._profilingSetTable, 0);
        column.setWidth(340);
        this._profilingSetTableViewer = new CheckboxTableViewer(this._profilingSetTable);
        this._profilingSetTableViewer.setContentProvider((IContentProvider)new ProfilingSetContentProvider());
        this._profilingSetTableViewer.setLabelProvider((IBaseLabelProvider)new ProfilingSetLabelProvider());
        this._profilingSetTableViewer.setSorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                String a = ((IProfilingSet)e1).getName();
                String b = ((IProfilingSet)e2).getName();
                return a.compareTo(b);
            }
        });
        this._profilingSetTableViewer.setInput((Object)this.getManagerCopy());
        this._profilingSetTableViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                IProfilingSet set = (IProfilingSet)event.getElement();
                TraceProfileOverviewUI.this._profilingSetTableViewer.setSelection((ISelection)new StructuredSelection((Object)set));
            }
        });
        Composite btnGroup = new Composite(parent, 0);
        layout = new GridLayout();
        layout.numColumns = 1;
        btnGroup.setLayout((Layout)layout);
        btnGroup.setLayoutData((Object)GridUtil.createVerticalFill());
        Composite addGroup = new Composite(btnGroup, 0);
        layout = new GridLayout();
        layout.numColumns = 1;
        layout.makeColumnsEqualWidth = true;
        addGroup.setLayout((Layout)layout);
        addGroup.setLayoutData((Object)GridUtil.createVerticalFill());
        this._addSetBtn = new Button(addGroup, 8);
        this._addSetBtn.setText(UIPlugin.getResourceString("ADD_PROFILINGSET_TEXT"));
        this._addSetBtn.setToolTipText(UIPlugin.getResourceString("ADD_FILTER_TOOLTIP_TEXT"));
        this._addSetBtn.setLayoutData((Object)GridUtil.createHorizontalFill());
        this._renameSetBtn = new Button(addGroup, 8);
        this._renameSetBtn.setText(UIPlugin.getResourceString("RENAME_PROFILINGSET_TEXT"));
        this._renameSetBtn.setToolTipText(UIPlugin.getResourceString("EDIT_SET_TOOLTIP_TEXT"));
        this._renameSetBtn.setLayoutData((Object)GridUtil.createHorizontalFill());
        this._removeSetBtn = new Button(addGroup, 8);
        this._removeSetBtn.setText(UIPlugin.getResourceString("REMOVE_PROFILINGSET_TEXT"));
        this._removeSetBtn.setToolTipText(UIPlugin.getResourceString("REMOVE_TOOLTIP_TEXT"));
        this._removeSetBtn.setLayoutData((Object)GridUtil.createHorizontalFill());
        this._addSetBtn.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                TraceProfileOverviewUI.this.addProfilingSet();
            }
        });
        this._removeSetBtn.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                TraceProfileOverviewUI.this.removeProfilingSet();
            }
        });
        this._renameSetBtn.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                TraceProfileOverviewUI.this.renameProfilingSet();
            }
        });
        this._profilingSetTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (!selection.isEmpty()) {
                    IProfilingSet set = (IProfilingSet)selection.getFirstElement();
                    TraceProfileOverviewUI.this._profilingSetTableViewer.setAllChecked(false);
                    TraceProfileOverviewUI.this._profilingSetTableViewer.setChecked((Object)set, true);
                    TraceProfileOverviewUI.this._profilingSetTableViewer.refresh();
                    TraceProfileOverviewUI.this.getManagerCopy().setDefaultSet(set);
                    TraceProfileOverviewUI.this.showProfilingTypeDetails(set);
                    TraceProfileOverviewUI.this.changed();
                    TraceProfileOverviewUI.this._profilingSetLabel.setText(set.getDescription());
                    TraceProfileOverviewUI.this._removeSetBtn.setEnabled(TraceProfileOverviewUI.this.getManagerCopy().getProfilingSets().size() > 1);
                }
            }
        });
        data = new GridData();
        data.widthHint = 375;
        this._profilingSetLabel = new Label(parent, 64);
        this._profilingSetLabel.setLayoutData((Object)data);
        WorkbenchHelp.setHelp((Control)this._profilingSetTable, (String)(UIPlugin.getPluginId() + ".pfps0001"));
    }

    private void createProfilingTypeTable(Composite parent) {
        Label label = new Label(parent, 0);
        GridData data = new GridData();
        data.horizontalSpan = 2;
        label.setLayoutData((Object)data);
        this._contentLabel = new Label(parent, 0);
        this._contentLabel.setText(UIPlugin.getResourceString("STR_MODIFY_PROFILINGSET_CONTENTS"));
        this._contentLabel.setLayoutData((Object)data);
        Composite tableGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        tableGroup.setLayout((Layout)layout);
        data = GridUtil.createFill();
        data.heightHint = 180;
        tableGroup.setLayoutData((Object)data);
        TableLayout tableLayout = new TableLayout();
        this._table = new Table(tableGroup, 68354);
        this._table.setLinesVisible(false);
        this._table.setLayoutData((Object)GridUtil.createFill());
        this._table.setLayout((Layout)tableLayout);
        this._table.setHeaderVisible(true);
        String[] headers = new String[]{UIPlugin.getResourceString("HEADER_PROFILING_TYPE")};
        ColumnLayoutData[] layouts = new ColumnLayoutData[]{new ColumnPixelData(300, true)};
        TableColumn[] columns = new TableColumn[headers.length];
        int i = 0;
        while (i < headers.length) {
            tableLayout.addColumnData(layouts[i]);
            TableColumn tc = new TableColumn(this._table, 0, i);
            tc.setResizable(layouts[i].resizable);
            tc.setText(headers[i]);
            columns[i] = tc;
            ++i;
        }
        this._profilingTypeList = new ArrayList();
        this._tableViewer = new TableViewer(this._table);
        this._tableViewer.setContentProvider((IContentProvider)new ListContentProvider());
        this._tableViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this._tableViewer.setInput((Object)this._profilingTypeList);
        Composite btnGroup = new Composite(parent, 0);
        layout = new GridLayout();
        layout.numColumns = 1;
        btnGroup.setLayout((Layout)layout);
        btnGroup.setLayoutData((Object)GridUtil.createVerticalFill());
        Composite addGroup = new Composite(btnGroup, 0);
        layout = new GridLayout();
        layout.numColumns = 1;
        layout.makeColumnsEqualWidth = true;
        addGroup.setLayout((Layout)layout);
        addGroup.setLayoutData((Object)GridUtil.createVerticalFill());
        this._editBtn = new Button(addGroup, 8);
        this._editBtn.setText(UIPlugin.getResourceString("EDIT_PROFILINGSETCONTENTS_TEXT"));
        this._editBtn.setToolTipText(UIPlugin.getResourceString("EDIT_FILTER_TOOLTIP_TEXT"));
        this._editBtn.setLayoutData((Object)GridUtil.createHorizontalFill());
        Composite moveGroup = new Composite(btnGroup, 0);
        layout = new GridLayout();
        layout.numColumns = 1;
        layout.makeColumnsEqualWidth = true;
        moveGroup.setLayout((Layout)layout);
        moveGroup.setLayoutData((Object)GridUtil.createHorizontalFill());
        label = new Label(parent, 0);
        label.setLayoutData((Object)GridUtil.createHorizontalFill());
        this._editBtn.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                IStructuredSelection selection = (IStructuredSelection)TraceProfileOverviewUI.this._profilingSetTableViewer.getSelection();
                if (!selection.isEmpty()) {
                    IProfilingSet element = (IProfilingSet)selection.getFirstElement();
                    String name = element.getName();
                    TraceProfileOverviewUI.this.showEditProfilingSetDialog(UIPlugin.getResourceString("STR_EDIT_PROFILINGSET_DLG"), name, " ");
                    TraceProfileOverviewUI.this.showProfilingTypeDetails(element);
                }
            }
        });
        WorkbenchHelp.setHelp((Control)this._table, (String)(UIPlugin.getPluginId() + ".pfpp0002"));
    }

    private void showProfilingTypeDetails(IProfilingSet set) {
        this._profilingTypeList.clear();
        ArrayList<IProfilingSetType> types = new ArrayList<IProfilingSetType>();
        Iterator iter = set.getProfilingTypes().iterator();
        while (iter.hasNext()) {
            String type = (String)iter.next();
            IProfilingSetType pSetType = (IProfilingSetType)this.getManagerCopy().getProfilingTypes().get(type);
            types.add(pSetType);
        }
        IProfilingSetType[] sortedTypes = new IProfilingSetType[types.size()];
        types.toArray(sortedTypes);
        Arrays.sort(sortedTypes, new Comparator(){

            public int compare(Object o1, Object o2) {
                IProfilingSetType t1 = (IProfilingSetType)o1;
                IProfilingSetType t2 = (IProfilingSetType)o2;
                return t1.getName().compareTo(t2.getName());
            }
        });
        int i = 0;
        while (i < sortedTypes.length) {
            IProfilingSetType pSetType = sortedTypes[i];
            if (pSetType != null) {
                boolean descriptionExists;
                pSetType.setDescription(pSetType.getProfilingType().getDescription(this.getManagerCopy()));
                boolean bl = descriptionExists = pSetType.getDescription() != null && pSetType.getDescription().length() > 0;
                if (descriptionExists) {
                    if (i != 0) {
                        this._profilingTypeList.add("");
                    }
                    this._profilingTypeList.add(pSetType.getName());
                    this.addDescription(this._profilingTypeList, pSetType.getDescription());
                    this._profilingTypeList.add("");
                } else {
                    this._profilingTypeList.add(pSetType.getName());
                }
            }
            ++i;
        }
        this._table.setRedraw(false);
        this._tableViewer.refresh();
        this._table.setRedraw(true);
    }

    private void addDescription(List profilingList, String description) {
        String delim = "\n";
        StringTokenizer tokens = new StringTokenizer(description, delim, false);
        while (tokens.hasMoreElements()) {
            String token = tokens.nextToken();
            profilingList.add(token);
        }
    }

    private void showEditProfilingSetDialog(String title, String parentName, String profilingType) {
        EditWizard wizard = new EditWizard(parentName, this.getManagerCopy());
        EditWizardDialog dialog = new EditWizardDialog(new Shell(Display.getDefault()), (IWizard)wizard);
        wizard.init(PlatformUI.getWorkbench(), null);
        wizard.setParent(parentName);
        wizard.setWindowTitle(title);
        dialog.create();
        dialog.open();
    }

    private void addProfilingSet() {
        String name = UIPlugin.getResourceString("FILTER_SET_DEFAULT_NAME");
        String description = UIPlugin.getResourceString("FILTER_SET_DEFAULT_DESCRIPTION");
        EditWSetDialog dialog = new EditWSetDialog(this._result.getShell(), UIPlugin.getResourceString("STR_ADD_PROFILINGSET_DLG"), name, description, name);
        dialog.open();
        if (dialog.getReturnCode() == 0) {
            ProfilingSet set = new ProfilingSet(dialog._name, dialog._name, dialog._description);
            Map map = set.getAttributes();
            Iterator iter = ProfilingSetsManager.getDefaultProfilingOptions().iterator();
            while (iter.hasNext()) {
                ProfilingAttribute attr = (ProfilingAttribute)iter.next();
                map.put(attr.getName(), attr);
            }
            this.getManagerCopy().getProfilingSets().put(dialog._name, set);
            this.getManagerCopy().setDefaultSet(set);
            ProfilingSetsManager manager = ProfilingSetsManager.instance();
            manager.getProfilingSets().put(dialog._name, set);
            manager.setDefaultSet(set);
            manager.writeSetsToPreferences();
            this._profilingSetTableViewer.refresh(true);
            this._profilingSetTableViewer.setSelection((ISelection)new StructuredSelection((Object)set));
        }
    }

    private void renameProfilingSet() {
        IStructuredSelection selection = (IStructuredSelection)this._profilingSetTableViewer.getSelection();
        if (!selection.isEmpty()) {
            IProfilingSet set = (IProfilingSet)selection.getFirstElement();
            EditWSetDialog dialog = new EditWSetDialog(this._result.getShell(), UIPlugin.getResourceString("STR_EDIT_PROFILINGSET_DLG"), set.getName(), set.getDescription(), set.getId());
            dialog.open();
            if (dialog.getReturnCode() == 0) {
                ProfilingSetsManager manager = ProfilingSetsManager.instance();
                set.setName(dialog._name);
                set.setDescription(dialog._description);
                manager.writeSetsToPreferences();
                this._profilingSetTableViewer.refresh(true);
                this._profilingSetTableViewer.setSelection((ISelection)new StructuredSelection((Object)set));
            }
        }
    }

    private void removeProfilingSet() {
        IStructuredSelection selection = (IStructuredSelection)this._profilingSetTableViewer.getSelection();
        if (!selection.isEmpty()) {
            IProfilingSet set = (IProfilingSet)selection.getFirstElement();
            this.getManagerCopy().getProfilingSets().remove(set.getId());
            ProfilingSetsManager manager = ProfilingSetsManager.instance();
            manager.getProfilingSets().remove(set.getId());
            manager.writeSetsToPreferences();
            this._profilingSetTableViewer.refresh();
            IProfilingSet newSet = (IProfilingSet)this._profilingSetTableViewer.getElementAt(0);
            this._profilingSetTableViewer.setSelection((ISelection)new StructuredSelection((Object)newSet));
        }
    }

    public void initializeFrom(ILaunchConfiguration conf) {
        this.getManagerCopy().initializeFrom(conf);
        IProfilingSet set = this.getManagerCopy().getDefaultSet();
        if (set != null) {
            this._profilingSetTableViewer.setSelection((ISelection)new StructuredSelection((Object)set));
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy wc) {
        this._managerCopy.performApply(wc);
    }

    public boolean isValid(ILaunchConfiguration conf) {
        return true;
    }

    private ProfilingSetsManagerCopy getManagerCopy() {
        if (this._managerCopy == null) {
            this._managerCopy = new ProfilingSetsManagerCopy();
        }
        return this._managerCopy;
    }

    private class EditWSetDialog
    extends Dialog
    implements ModifyListener {
        private String _name;
        private Text _nameText;
        private String _title;
        private String _description;
        private String _id;
        private Text _descText;

        public EditWSetDialog(Shell shell, String title, String name, String desc, String id) {
            super(shell);
            this._name = name;
            this._title = title;
            this._description = desc;
            this._id = id;
        }

        protected void configureShell(Shell shell) {
            super.configureShell(shell);
            shell.setText(this._title);
        }

        protected Control createDialogArea(Composite parent) {
            Composite result = (Composite)super.createDialogArea(parent);
            GridLayout layout = new GridLayout();
            layout.numColumns = 2;
            result.setLayout((Layout)layout);
            GridData data = GridUtil.createFill();
            data.widthHint = 400;
            result.setLayoutData((Object)data);
            Label label1 = new Label(result, 0);
            label1.setText(UIPlugin.getResourceString("STR_PROFILING_SET_NAME"));
            this._nameText = new Text(result, 2048);
            this._nameText.setLayoutData((Object)GridUtil.createHorizontalFill());
            Label label2 = new Label(result, 0);
            label2.setText(UIPlugin.getResourceString("STR_PROFILING_SET_DESCRIPTION"));
            label2.setLayoutData((Object)new GridData(2));
            data = GridUtil.createHorizontalFill();
            data.heightHint = 80;
            this._descText = new Text(result, 2624);
            this._descText.setLayoutData((Object)data);
            this._nameText.addModifyListener((ModifyListener)this);
            this._descText.addModifyListener((ModifyListener)this);
            if (this._name == null) {
                this._name = UIPlugin.getResourceString("FILTER_SET_DEFAULT_NAME");
            }
            this._nameText.setText(this._name);
            if (this._description == null) {
                this._description = UIPlugin.getResourceString("FILTER_SET_DEFAULT_DESCRIPTION");
            }
            this._descText.setText(this._description);
            return result;
        }

        public void modifyText(ModifyEvent e) {
            Button ok = this.getButton(0);
            if (ok != null) {
                ok.setEnabled(this._nameText.getText().trim().length() != 0 && this._descText.getText().trim().length() != 0);
            }
        }

        protected void okPressed() {
            this._name = this._nameText.getText().trim();
            this._description = this._descText.getText().trim();
            super.okPressed();
        }
    }

    private class TreeContentProvider
    implements ITreeContentProvider {
        private TreeContentProvider() {
        }

        public Object[] getChildren(Object element) {
            if (element instanceof IProfilingSetTypeGroup) {
                return TraceProfileOverviewUI.this.getManagerCopy().getProfilingTypesForGroup(((IProfilingSetTypeGroup)element).getId());
            }
            return new Object[0];
        }

        public Object[] getElements(Object element) {
            return TraceProfileOverviewUI.this.getManagerCopy().getProfilingTypesGroups().values().toArray();
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element).length > 0;
        }

        public Object getParent(Object element) {
            String group;
            if (element instanceof IProfilingSetType && (group = ((IProfilingSetType)element).getGroup()) != null) {
                return TraceProfileOverviewUI.this.getManagerCopy().getProfilingTypesGroups().get(group);
            }
            return "";
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object old_input, Object new_input) {
        }
    }

    private class TreeLabelProvider
    extends LabelProvider {
        private Hashtable iconList = new Hashtable();

        public TreeLabelProvider(ImageDescriptor[] descList) {
            int i = 0;
            while (i < descList.length) {
                if (!this.iconList.containsKey(descList[i])) {
                    this.iconList.put(descList[i], descList[i].createImage());
                }
                ++i;
            }
        }

        public String getText(Object element) {
            if (element instanceof IProfilingSetType) {
                return ((IProfilingSetType)element).getName();
            }
            if (element instanceof IProfilingSetTypeGroup) {
                return ((IProfilingSetTypeGroup)element).getName();
            }
            return element.toString();
        }

        public Image getImage(Object element) {
            ImageDescriptor imageDesc = null;
            if (element instanceof IProfilingSetType) {
                imageDesc = ((IProfilingSetType)element).getImage();
            } else if (element instanceof IProfilingSetTypeGroup) {
                imageDesc = ((IProfilingSetTypeGroup)element).getIcon();
            }
            if (imageDesc == null) {
                return null;
            }
            return (Image)this.iconList.get(imageDesc);
        }

        public void dispose() {
            Iterator list = this.iconList.keySet().iterator();
            while (list.hasNext()) {
                ((Image)this.iconList.get(list.next())).dispose();
            }
            this.iconList.clear();
            this.iconList = null;
        }
    }

    private static class PageContent
    extends Composite {
        private StackLayout detailsLayout;
        private Control[] controls;
        private IProfilingSetType[] profilingTypes;
        private Control currentControl = null;
        private TraceProfileTypeGroupUI _traceProfileTypeGroupUI;
        private Map groupControls = new HashMap();

        public PageContent(Composite composite, int style) {
            super(composite, style);
        }

        public Composite createContent(IProfilingSetType[] types, ProfilingSetsManagerCopy copy) {
            this.detailsLayout = new StackLayout();
            this.setLayout((Layout)this.detailsLayout);
            this.setLayoutData(new GridData(1808));
            this.controls = new Control[types.length + 1];
            this.profilingTypes = types;
            int i = 0;
            while (i < types.length) {
                this.controls[i] = types[i].getProfilingType().createControl(this, copy);
                this.controls[i].setVisible(false);
                ++i;
            }
            this.controls[this.controls.length - 1] = new Composite((Composite)this, 0);
            this.controls[this.controls.length - 1].setVisible(false);
            Map groups = copy.getProfilingTypesGroups();
            Object[] keySet = groups.keySet().toArray();
            this._traceProfileTypeGroupUI = new TraceProfileTypeGroupUI();
            int j = 0;
            while (j < keySet.length) {
                IProfilingSetTypeGroup pTypeGroup = (IProfilingSetTypeGroup)groups.get(keySet[j]);
                this.groupControls.put(pTypeGroup.getId(), this._traceProfileTypeGroupUI.createControl(this, pTypeGroup.getName(), pTypeGroup.getDescription()));
                ++j;
            }
            return null;
        }

        public boolean performApply(ProfilingSetsManagerCopy copy) {
            IProfilingSet set = copy.getDefaultSet();
            if (set == null) {
                return true;
            }
            StringBuffer errorMsg = new StringBuffer();
            List types = set.getProfilingTypes();
            int i = 0;
            while (i < this.profilingTypes.length) {
                IProfilingType type;
                String msg;
                if (types.contains(this.profilingTypes[i].getId()) && (msg = (type = this.profilingTypes[i].getProfilingType()).validateConfiguration(copy)) != null) {
                    errorMsg.append(msg).append("\n");
                }
                ++i;
            }
            if (errorMsg.length() > 0) {
                String msg = UIPlugin.getResourceString("ERROR_DLG_CONFLICTS_MSG");
                if (!MessageDialog.openQuestion((Shell)this.getShell(), (String)UIPlugin.getResourceString("ERROR_DLG_CONFLICTS_TITLE"), (String)(msg + errorMsg.toString()))) {
                    return false;
                }
            }
            List optionsList = ProfilingSetsManager.getDefaultProfilingOptions();
            int i2 = 0;
            while (i2 < this.profilingTypes.length) {
                if (types.contains(this.profilingTypes[i2].getId())) {
                    IProfilingType type = this.profilingTypes[i2].getProfilingType();
                    ProfilingAttribute[] options = type.getAttributes();
                    int idx = 0;
                    while (idx < options.length) {
                        optionsList.add(options[idx]);
                        ++idx;
                    }
                }
                ++i2;
            }
            optionsList = ProfilingSetsManager.filterDuplicateOptions(optionsList);
            set.getAttributes().clear();
            Map attrs = set.getAttributes();
            int idx = 0;
            while (idx < optionsList.size()) {
                ProfilingAttribute option = (ProfilingAttribute)optionsList.get(idx);
                attrs.put(option.getName(), option);
                ++idx;
            }
            return true;
        }

        public void showDetailsFor(Control detail) {
            this.detailsLayout.topControl = detail;
            this.currentControl = detail;
            detail.setVisible(true);
            this.layout();
        }

        public void showGroupDetails(IProfilingSetTypeGroup pTypeGroup) {
            Control currentControl;
            Control newControl = (Control)this.groupControls.get(pTypeGroup.getId());
            if (!newControl.equals(currentControl = this.getCurrentlyDisplayingControl())) {
                this.showDetailsFor(newControl);
            }
            this.layout();
        }

        public void showEmptyDetails() {
            this.detailsLayout.topControl = this.controls[this.controls.length - 1];
            this.currentControl = this.controls[this.controls.length - 1];
            this.controls[this.controls.length - 1].setVisible(true);
            this.layout();
        }

        public void dispose() {
            this.currentControl = null;
            this.profilingTypes = null;
            int i = 0;
            while (i < this.controls.length) {
                if (this.controls[i] != null) {
                    this.controls[i].dispose();
                }
                ++i;
            }
            Object[] groupControlsArray = this.groupControls.values().toArray();
            int j = 0;
            while (j < groupControlsArray.length) {
                if ((Control)groupControlsArray[j] != null) {
                    ((Control)groupControlsArray[j]).dispose();
                }
                ++j;
            }
            this.groupControls.clear();
            this.groupControls = null;
            this.controls = null;
        }

        public Control getCurrentlyDisplayingControl() {
            return this.currentControl;
        }

        public void selectionChanged(SelectionChangedEvent event) {
        }
    }

    private class EditWizardPage1
    extends WizardPage
    implements ICheckStateListener,
    ISelectionChangedListener {
        private boolean canFlipToNext;
        private PageContent dc;
        private String profilingSetName;
        private CheckboxTreeViewer treeViewer;
        private TreeContentProvider provider;
        private ProfilingSetsManagerCopy copy;

        public EditWizardPage1(String pageId, String psName, ProfilingSetsManagerCopy managerCopy) {
            super(pageId);
            this.profilingSetName = psName;
            this.copy = managerCopy;
            this.setImageDescriptor(PDPluginImages.getImageDescriptor("profset_wiz.gif"));
        }

        public boolean isPageComplete() {
            return true;
        }

        public boolean canFlipToNextPage() {
            return this.canFlipToNext;
        }

        public void dispose() {
            this.dc.dispose();
            super.dispose();
        }

        public void createControl(Composite parent) {
            Composite result = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.numColumns = 2;
            result.setLayout((Layout)layout);
            GridData data = GridUtil.createFill();
            result.setLayoutData((Object)data);
            data = GridUtil.createFill();
            GridLayout layout2 = new GridLayout();
            layout2.numColumns = 1;
            this.provider = new TreeContentProvider();
            this.treeViewer = new CheckboxTreeViewer(result);
            this.treeViewer.setContentProvider((IContentProvider)this.provider);
            this.treeViewer.setSorter(new ViewerSorter(this){
                private Comparator c;
                private final /* synthetic */ EditWizardPage1 this$1;
                {
                    this.this$1 = this$1;
                    this.c = EditWizardPage1.access$500(this.this$1).new Sorter();
                }

                public int compare(Viewer viewer, Object e1, Object e2) {
                    return this.c.compare(e1, e2);
                }
            });
            Object[] profileTypeGroups = TraceProfileOverviewUI.this.getManagerCopy().getProfilingTypesGroups().values().toArray();
            Object[] profilingTypes = TraceProfileOverviewUI.this.getManagerCopy().getProfilingTypes().values().toArray();
            ImageDescriptor[] descriptorList = new ImageDescriptor[profileTypeGroups.length + profilingTypes.length];
            int i = 0;
            while (i < profileTypeGroups.length) {
                descriptorList[i] = ((IProfilingSetTypeGroup)profileTypeGroups[i]).getIcon();
                ++i;
            }
            int j = 0;
            while (j < profilingTypes.length) {
                IProfilingSetType pType = (IProfilingSetType)profilingTypes[j];
                descriptorList[j + profileTypeGroups.length] = pType.getImage();
                ++j;
            }
            this.treeViewer.setLabelProvider((IBaseLabelProvider)new TreeLabelProvider(descriptorList));
            this.treeViewer.setInput((Object)"");
            this.treeViewer.getTree().setLayout((Layout)layout2);
            this.treeViewer.getTree().setLayoutData((Object)GridUtil.createVerticalFill());
            ProfilingSetType[] array = new ProfilingSetType[TraceProfileOverviewUI.this.getManagerCopy().getProfilingTypes().size()];
            this.dc = new PageContent(result, 0);
            this.dc.createContent(TraceProfileOverviewUI.this.getManagerCopy().getProfilingTypes().values().toArray(array), this.copy);
            this.dc.setVisible(true);
            this.treeViewer.addCheckStateListener((ICheckStateListener)this);
            this.treeViewer.addSelectionChangedListener((ISelectionChangedListener)this);
            this.setControl((Control)result);
            this.setPageComplete(this.isPageComplete());
        }

        private void setChecked(IProfilingSetType ptype) {
            if (ptype == null) {
                return;
            }
            this.treeViewer.expandToLevel((Object)ptype, 0);
            this.treeViewer.setChecked((Object)ptype, true);
            Object parent = this.provider.getParent(ptype);
            Object[] parentsChildren = this.provider.getChildren(parent);
            boolean foundUnchecked = false;
            int i = 0;
            while (i < parentsChildren.length) {
                if (!this.treeViewer.getChecked(parentsChildren[i])) {
                    foundUnchecked = true;
                }
                ++i;
            }
            if (!foundUnchecked) {
                this.treeViewer.setChecked(parent, true);
            }
        }

        public void checkStateChanged(CheckStateChangedEvent event) {
            Object checkedElement = event.getElement();
            if (checkedElement instanceof IProfilingSetType) {
                this.treeViewer.setSelection((ISelection)new StructuredSelection(checkedElement));
                Object parent = this.provider.getParent(checkedElement);
                Object[] parentsChildren = this.provider.getChildren(parent);
                boolean foundChecked = false;
                int i = 0;
                while (i < parentsChildren.length) {
                    if (this.treeViewer.getChecked(parentsChildren[i])) {
                        foundChecked = true;
                    }
                    ++i;
                }
                this.treeViewer.setChecked(parent, foundChecked);
            } else if (checkedElement instanceof IProfilingSetTypeGroup) {
                this.treeViewer.setSelection((ISelection)new StructuredSelection(checkedElement));
                Object[] parentsChildren = this.provider.getChildren(checkedElement);
                int i = 0;
                while (i < parentsChildren.length) {
                    this.treeViewer.setChecked(parentsChildren[i], event.getChecked());
                    ++i;
                }
            }
            this.updateWizardButtons();
        }

        public void selectionChanged(SelectionChangedEvent event) {
            this.updateWizardButtons();
            IStructuredSelection selection = (IStructuredSelection)event.getSelection();
            if (selection.getFirstElement() instanceof IProfilingSetType) {
                this.updateGui((IProfilingSetType)selection.getFirstElement());
            } else if (selection.getFirstElement() instanceof IProfilingSetTypeGroup) {
                this.dc.showGroupDetails((IProfilingSetTypeGroup)selection.getFirstElement());
            } else {
                this.dc.showEmptyDetails();
            }
        }

        private void updateGui(IProfilingSetType newProfileType) {
            Control currentControl;
            Control newControl = newProfileType.getProfilingType().getControl(this.profilingSetName);
            if (!newControl.equals(currentControl = this.dc.getCurrentlyDisplayingControl())) {
                this.dc.showDetailsFor(newControl);
            }
        }

        private void updateWizardButtons() {
            Object[] checkedElementList = this.treeViewer.getCheckedElements();
            int i = 0;
            while (i < checkedElementList.length) {
                IProfilingSetType nextProfile;
                if (checkedElementList[i] instanceof IProfilingSetType && (nextProfile = (IProfilingSetType)checkedElementList[i]).isUseFilters()) {
                    this.canFlipToNext = nextProfile.isUseFilters();
                    this.getWizard().getContainer().updateButtons();
                    return;
                }
                ++i;
            }
            this.canFlipToNext = false;
            this.getWizard().getContainer().updateButtons();
        }

        public void initializeFrom(ProfilingSetsManagerCopy copy) {
            IProfilingType type;
            Object obj;
            IProfilingSet set = copy.getDefaultSet();
            if (set == null) {
                return;
            }
            List types = set.getProfilingTypes();
            int idx = 0;
            while (idx < types.size()) {
                String type2 = types.get(idx).toString();
                Object ptype = copy.getProfilingTypes().get(type2);
                if (type2 != null) {
                    this.setChecked((IProfilingSetType)ptype);
                }
                ++idx;
            }
            IStructuredSelection sel = (IStructuredSelection)this.treeViewer.getSelection();
            if (sel != null && !sel.isEmpty() && (obj = sel.getFirstElement()) != null && obj instanceof IProfilingSetType && (type = ((IProfilingSetType)obj).getProfilingType()) != null) {
                type.getControl(this.profilingSetName);
            }
        }

        public boolean performApply(ProfilingSetsManagerCopy copy) {
            IProfilingSet set = copy.getDefaultSet();
            set.getProfilingTypes().clear();
            Object[] selections = this.treeViewer.getCheckedElements();
            int idx = 0;
            while (idx < selections.length) {
                Object type = selections[idx];
                if (type != null && type instanceof IProfilingSetType) {
                    set.getProfilingTypes().add(((IProfilingSetType)type).getId());
                }
                ++idx;
            }
            return this.dc.performApply(copy);
        }

        static /* synthetic */ TraceProfileOverviewUI access$500(EditWizardPage1 x0) {
            return x0.TraceProfileOverviewUI.this;
        }
    }

    private class EditWizardPage2
    extends WizardPage {
        private ProfileFiltersTab _filterTab;

        public EditWizardPage2(String pageId) {
            super(pageId);
            this.setImageDescriptor(PDPluginImages.getImageDescriptor("profset_wiz.gif"));
            this._filterTab = new ProfileFiltersTab("name");
        }

        public void createControl(Composite parent) {
            Composite composite = this._filterTab.createControl(parent);
            this._filterTab.addListener(TraceProfileOverviewUI.this._listener);
            this.setControl((Control)composite);
        }

        public void initializeFrom(ProfilingSetsManagerCopy copy) {
            Collection set = copy.getFilterSets().values();
            FilterSetElement[] array = new FilterSetElement[set.size()];
            this._filterTab.activateFilters(set.toArray(array), copy.getDefaultFilterSet());
        }

        public boolean performApply(ProfilingSetsManagerCopy copy) {
            Map profilingFilters = copy.getFilterSets();
            profilingFilters.clear();
            ArrayList filters = this._filterTab.getFilterSet();
            int idx = 0;
            while (idx < filters.size()) {
                FilterSetElement elem = (FilterSetElement)filters.get(idx);
                profilingFilters.put(elem.getName(), elem);
                ++idx;
            }
            String name = this._filterTab.getActiveFilterSet();
            copy.setDefaultFilterSet((FilterSetElement)copy.getFilterSets().get(name));
            return true;
        }
    }

    private class EditWizard
    extends Wizard {
        private EditWizardPage1 wizPage1;
        private EditWizardPage2 wizPage2;
        private IStructuredSelection selection;
        private IWorkbench workbench;
        private String parentName;
        private ProfilingSetsManagerCopy original;
        private ProfilingSetsManagerCopy copy;

        public EditWizard(String psName, ProfilingSetsManagerCopy options) {
            this.parentName = psName;
            this.original = options;
            this.copy = this.original.createCopy();
        }

        public void setParent(String parent) {
            this.parentName = parent;
        }

        public void init(IWorkbench workbench, IStructuredSelection selection) {
            this.workbench = workbench;
            this.selection = selection;
        }

        public void addPages() {
            super.addPages();
            this.wizPage1 = new EditWizardPage1("profilingTypes", this.parentName, this.copy);
            this.wizPage1.setTitle(this.getWindowTitle());
            this.wizPage1.setDescription(this.getWindowTitle());
            this.addPage((IWizardPage)this.wizPage1);
            this.wizPage2 = new EditWizardPage2("filters");
            this.wizPage2.setTitle(this.getWindowTitle());
            this.wizPage2.setDescription(this.getWindowTitle());
            this.addPage((IWizardPage)this.wizPage2);
        }

        public ProfilingSetsManagerCopy getProfilingSetsManagerCopy() {
            return this.copy;
        }

        public boolean performFinish() {
            this.original.resetFrom(this.copy);
            this.original.applyChanges();
            TraceProfileOverviewUI.this.changed();
            return true;
        }
    }

    private static class EditWizardDialog
    extends WizardDialog {
        private ProfilingSetsManagerCopy _copy = ((EditWizard)this.getWizard()).getProfilingSetsManagerCopy();

        public EditWizardDialog(Shell parentShell, IWizard newWizard) {
            super(parentShell, newWizard);
        }

        protected Control createContents(Composite parent) {
            Control control = super.createContents(parent);
            EditWizardPage1 page1 = (EditWizardPage1)this.getWizard().getPages()[0];
            EditWizardPage2 page2 = (EditWizardPage2)this.getWizard().getPages()[1];
            page1.initializeFrom(this._copy);
            page2.initializeFrom(this._copy);
            return control;
        }

        protected void backPressed() {
            EditWizardPage2 page = (EditWizardPage2)this.getCurrentPage();
            if (page.performApply(this._copy)) {
                EditWizardPage1 previous = (EditWizardPage1)page.getPreviousPage();
                previous.initializeFrom(this._copy);
                super.backPressed();
            }
        }

        protected void nextPressed() {
            EditWizardPage1 page = (EditWizardPage1)this.getCurrentPage();
            if (page.performApply(this._copy)) {
                EditWizardPage2 next = (EditWizardPage2)page.getNextPage();
                next.initializeFrom(this._copy);
                super.nextPressed();
            }
        }

        protected void finishPressed() {
            boolean ok = false;
            IWizardPage page = this.getCurrentPage();
            if (page instanceof EditWizardPage1) {
                ok = ((EditWizardPage1)page).performApply(this._copy);
            } else if (page instanceof EditWizardPage2) {
                ok = ((EditWizardPage2)page).performApply(this._copy);
            }
            if (ok) {
                super.finishPressed();
            }
        }
    }

    private class ListContentProvider
    implements IStructuredContentProvider {
        private ListContentProvider() {
        }

        public Object[] getElements(Object input) {
            if (input != null && input instanceof List) {
                return ((List)input).toArray();
            }
            return new Object[0];
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }
    }

    private static class ProfilingSetContentProvider
    implements IStructuredContentProvider {
        private ProfilingSetContentProvider() {
        }

        public Object[] getElements(Object parent) {
            ProfilingSetsManagerCopy copy = (ProfilingSetsManagerCopy)parent;
            return copy.getProfilingSets().values().toArray();
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }
    }

    private static class ProfilingSetLabelProvider
    extends LabelProvider {
        private ProfilingSetLabelProvider() {
        }

        public String getText(Object element) {
            return ((IProfilingSet)element).getName();
        }

        public Image getImage(Object element) {
            return PDPluginImages.getImage("filter_obj.gif");
        }
    }

    private class Sorter
    implements Comparator {
        private Sorter() {
        }

        public int compare(Object e1, Object e2) {
            if (e1 != null && e2 != null) {
                if (e1 instanceof IProfilingSetTypeGroup && e2 instanceof IProfilingSetTypeGroup) {
                    IProfilingSetTypeGroup g1 = (IProfilingSetTypeGroup)e1;
                    IProfilingSetTypeGroup g2 = (IProfilingSetTypeGroup)e2;
                    return g1.getName().compareTo(g2.getName());
                }
                if (e1 instanceof IProfilingSetType && e2 instanceof IProfilingSetType) {
                    IProfilingSetType t1 = (IProfilingSetType)e1;
                    IProfilingSetType t2 = (IProfilingSetType)e2;
                    return t1.getName().compareTo(t2.getName());
                }
            }
            return 0;
        }
    }
}

