/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.editors;

import java.util.Iterator;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCMonitor;
import org.eclipse.hyades.models.hierarchy.TRCNode;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.core.TraceProcessUI;
import org.eclipse.hyades.trace.ui.internal.util.TString;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.part.FileEditorInput;

public class TRCAgentEditor
extends EditorPart {
    TRCAgentProxy fAgent;

    public void createPartControl(Composite parent) {
        WorkbenchHelp.setHelp((Control)parent, (String)(UIPlugin.getPluginId() + ".agte0000"));
        TraceProcessUI processUI = new TraceProcessUI();
        processUI.createControl(parent);
        processUI.getLocationUI().setEnabled(false);
        processUI.getLaunchProcessUI().enable(false);
        processUI.getProcessIdUI().setEnabled(false);
        processUI.getNodeNameUI().setEnabled(false);
        if (this.fAgent != null) {
            TRCProcessProxy fProcess = this.fAgent.getProcessProxy();
            TRCNode fNode = fProcess.getNode();
            TRCMonitor fMonitor = fNode.getMonitor();
            Path path = new Path(TString.resourcePath(fMonitor.eResource().getURI()));
            processUI.getLocationUI().getLocation().setText(path.uptoSegment(path.segmentCount() - 1).toOSString());
            processUI.getLocationUI().getMonitor().setText(fMonitor.getName());
            String name = fProcess.getName();
            processUI.getLaunchProcessUI().getClassUI().setText(name);
            processUI.getProcessIdUI().setText(String.valueOf(fProcess.getPid()));
            processUI.getNodeNameUI().setText(fNode.getName());
            if (fProcess.getClasspath() != null) {
                processUI.getLaunchProcessUI().getClassPathUI().setText(fProcess.getClasspath());
            }
            if (fProcess.getParameters() != null) {
                processUI.getLaunchProcessUI().getParametersUI().setText(fProcess.getParameters());
            }
            if (fProcess.getVmArguments() != null) {
                processUI.getLaunchProcessUI().getVMArgsUI().setText(fProcess.getVmArguments());
            }
        }
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public void gotoMarker(IMarker marker) {
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        if (input instanceof IFileEditorInput) {
            this.setSite((IWorkbenchPartSite)site);
            this.setInput(input);
            this.loadAgentDoc();
            if (this.fAgent != null) {
                this.setTitle(this.fAgent.getName() + "[" + this.fAgent.getProcessProxy().getName() + "]");
            }
        }
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public boolean isSaveOnCloseNeeded() {
        return false;
    }

    private TRCAgentProxy loadAgentDoc() {
        block4: {
            if (this.fAgent != null) break block4;
            try {
                String name = ((FileEditorInput)this.getEditorInput()).getFile().getFullPath().toString();
                ResourceSet resourceSet = UIPlugin.getDefault().getResourceSet();
                Resource res = resourceSet.getResource(URI.createURI((String)("platform:/resource" + name)), true);
                if (res == null) {
                    return this.fAgent;
                }
                Iterator it = res.getContents().iterator();
                while (it.hasNext()) {
                    Object current = it.next();
                    if (!(current instanceof TRCAgentProxy)) continue;
                    this.fAgent = (TRCAgentProxy)current;
                    break;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.fAgent;
    }

    public void setFocus() {
    }
}

