/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.launcher;

import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.hyades.internal.execution.local.control.Agent;
import org.eclipse.hyades.internal.execution.local.control.InactiveProcessException;
import org.eclipse.hyades.internal.execution.local.control.Process;
import org.eclipse.hyades.trace.internal.ui.PDPluginImages;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.launcher.IProfileLaunchConfigurationConstants;
import org.eclipse.hyades.trace.ui.internal.launcher.ProfileAttachDelegate;
import org.eclipse.hyades.trace.ui.internal.util.DoubleCTree;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.help.WorkbenchHelp;

public class ProfileAgentsTab
extends AbstractLaunchConfigurationTab {
    private ILaunchConfiguration _conf;
    private DoubleCTree _list;

    public void createControl(Composite parent) {
        Composite content = new Composite(parent, 0);
        this.setControl((Control)content);
        content.setLayout((Layout)new GridLayout());
        this.createVerticalSpacer(content, 1);
        this._list = new DoubleCTree(content, 0, UIPlugin.getResourceString("STR_LIST_AGENTS"), UIPlugin.getResourceString("STR_LIST_SOURCE"), UIPlugin.getResourceString("STR_LIST_TARGET"));
        this._list.addListener(new Listener(){

            public void handleEvent(Event event) {
                ProfileAgentsTab.this.updateLaunchConfigurationDialog();
            }
        });
        Button refresh = new Button(content, 8);
        refresh.setText(UIPlugin.getResourceString("RESET_DATA"));
        refresh.setToolTipText(UIPlugin.getResourceString("REINITIALIZE_AGNT_TOOLTIP"));
        refresh.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProfileAgentsTab.this._list.initialize(new Vector(ProfileAttachDelegate.getNodeConfiguration(ProfileAgentsTab.this._conf)).elements(), false);
            }
        });
        WorkbenchHelp.setHelp((Control)this._list.getControl(), (String)(UIPlugin.getPluginId() + ".atlp0002"));
        WorkbenchHelp.setHelp((Control)refresh, (String)(UIPlugin.getPluginId() + ".atlp0000"));
        WorkbenchHelp.setHelp((Control)parent, (String)(UIPlugin.getPluginId() + ".atlp0002"));
    }

    public boolean isValid(ILaunchConfiguration conf) {
        this.setErrorMessage(null);
        this.setMessage(null);
        if (this._list.getSelectedAgents().size() == 0) {
            this.setErrorMessage(UIPlugin.getResourceString("TAB_ERROR_AGENTS"));
            return false;
        }
        return true;
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy wc) {
    }

    public void initializeFrom(ILaunchConfiguration conf) {
        this._conf = conf;
        BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                List nodes = ProfileAttachDelegate.getNodeConfiguration(ProfileAgentsTab.this._conf);
                List agents = ProfileAttachDelegate.getAgents(ProfileAgentsTab.this._conf, nodes);
                if (agents.size() == 0) {
                    ProfileAgentsTab.this._list.removeAll();
                }
                ProfileAgentsTab.this._list.initialize(new Vector(nodes).elements(), false);
                ProfileAgentsTab.this._list.setSelectedAgents(new Vector(agents));
            }
        });
    }

    public void performApply(ILaunchConfigurationWorkingCopy wc) {
        ArrayList<String> list = new ArrayList<String>();
        Vector v = this._list.getTargetItems();
        int i = 0;
        while (i < v.size()) {
            StringBuffer buf = new StringBuffer();
            try {
                TreeItem processItem = (TreeItem)v.get(i);
                Process process = (Process)processItem.getData();
                buf.append(process.getProcessId());
                buf.append(':');
                TreeItem[] agentItems = processItem.getItems();
                int j = 0;
                while (j < agentItems.length) {
                    Agent agent = (Agent)agentItems[j].getData();
                    buf.append(agent.getName());
                    if (j < agentItems.length) {
                        buf.append(',');
                    }
                    ++j;
                }
            }
            catch (InactiveProcessException e) {
                e.printStackTrace();
            }
            list.add(buf.toString());
            ++i;
        }
        wc.setAttribute(IProfileLaunchConfigurationConstants.ATTR_AGENTS, list);
    }

    public String getName() {
        return UIPlugin.getResourceString("TAB_NAME_AGENTS");
    }

    public Image getImage() {
        return PDPluginImages.getImage("agent_obj.gif");
    }

    void reset() {
        this._list.removeAll();
    }
}

