/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.launcher;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.ILaunchConfigurationDelegate;
import org.eclipse.hyades.internal.execution.local.control.Agent;
import org.eclipse.hyades.internal.execution.local.control.Process;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.launcher.IProfileLaunchConfigurationConstants;
import org.eclipse.hyades.trace.ui.internal.launcher.ProfileJavaApplicationDelegate;
import org.eclipse.hyades.trace.ui.internal.launcher.ProfilingSetsManager;
import org.eclipse.hyades.trace.ui.internal.util.AttachWarningDialog;
import org.eclipse.hyades.trace.ui.internal.util.PDCoreUtil;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class ProfileAttachDelegate
implements ILaunchConfigurationDelegate {
    public void launch(ILaunchConfiguration conf, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        try {
            monitor.beginTask("", 4);
            boolean success = ProfileJavaApplicationDelegate.performProfilingTypesLaunch(conf);
            monitor.worked(1);
            if (!success) {
                monitor.setCanceled(true);
                return;
            }
            IPreferenceStore store = UIPlugin.getDefault().getPreferenceStore();
            String hostName = conf.getAttribute(IProfileLaunchConfigurationConstants.ATTR_HOSTNAME, "localhost");
            int port = conf.getAttribute(IProfileLaunchConfigurationConstants.ATTR_PORT, store.getInt("localhost_port"));
            String projectName = conf.getAttribute(IProfileLaunchConfigurationConstants.ATTR_DESTINATION_PROJECT, store.getString("prj_name"));
            String monitorName = conf.getAttribute(IProfileLaunchConfigurationConstants.ATTR_DESTINATION_MONITOR, store.getString("mon_name"));
            String profileFile = null;
            if (conf.getAttribute(IProfileLaunchConfigurationConstants.ATTR_PROFILE_TO_FILE, false)) {
                profileFile = conf.getAttribute(IProfileLaunchConfigurationConstants.ATTR_DESTINATION_FILE, (String)null);
            }
            ProfilingSetsManager manager = ProfilingSetsManager.instance();
            ArrayList filters = manager.getFilters(conf);
            Vector options = manager.getOptions(conf);
            Vector agents = new Vector(ProfileAttachDelegate.getAgents(conf));
            monitor.worked(1);
            List agentList = conf.getAttribute(IProfileLaunchConfigurationConstants.ATTR_AGENTS, (List)null);
            int agentCount = 0;
            if (agentList != null) {
                Iterator iter = agentList.iterator();
                while (iter.hasNext()) {
                    String agentString = (String)iter.next();
                    agentCount += new StringTokenizer(agentString, ":,").countTokens() - 1;
                }
            }
            if (agentCount != agents.size()) {
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        Shell parent = UIPlugin.getActiveWorkbenchShell();
                        Status status = new Status(2, UIPlugin.getPluginId(), 2, UIPlugin.getResourceString("ERROR_DLG_INVALID_AGENTS_REASON"), null);
                        ErrorDialog.openError((Shell)parent, (String)UIPlugin.getResourceString("TRACE_MSG"), (String)UIPlugin.getResourceString("LAUNCH_ERROR_"), (IStatus)status);
                    }
                });
                monitor.setCanceled(true);
                return;
            }
            monitor.worked(1);
            PDCoreUtil.attach(hostName, agents, options, filters, projectName, monitorName, String.valueOf(port), profileFile);
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    try {
                        if (UIPlugin.getDefault().getPreferenceStore().getBoolean("profile_tips")) {
                            AttachWarningDialog infodialog = new AttachWarningDialog(null, UIPlugin.getResourceString("PROFILING_TIP_TITLE"));
                            infodialog.open();
                        }
                    }
                    catch (Exception exc) {
                        exc.printStackTrace();
                    }
                }
            });
            monitor.worked(1);
        }
        catch (CoreException e) {
            monitor.setCanceled(true);
            throw e;
        }
    }

    static List getNodeConfiguration(ILaunchConfiguration conf) {
        IPreferenceStore store = UIPlugin.getDefault().getPreferenceStore();
        try {
            String host = conf.getAttribute(IProfileLaunchConfigurationConstants.ATTR_HOSTNAME, "localhost");
            int port = conf.getAttribute(IProfileLaunchConfigurationConstants.ATTR_PORT, store.getDefaultInt("localhost_port"));
            Enumeration enumeration = PDCoreUtil.getNodeConfiguration(host, port);
            ArrayList list = new ArrayList();
            if (enumeration != null) {
                while (enumeration.hasMoreElements()) {
                    list.add(enumeration.nextElement());
                }
            }
            return list;
        }
        catch (CoreException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static List getAgents(ILaunchConfiguration conf) {
        return ProfileAttachDelegate.getAgents(conf, ProfileAttachDelegate.getNodeConfiguration(conf));
    }

    static List getAgents(ILaunchConfiguration conf, List nodes) {
        ArrayList<Agent> agents;
        block5: {
            agents = new ArrayList<Agent>();
            if (nodes == null) break block5;
            try {
                Iterator iter = nodes.iterator();
                List list = conf.getAttribute(IProfileLaunchConfigurationConstants.ATTR_AGENTS, (List)null);
                if (list != null) {
                    Map map = ProfileAttachDelegate.createMap(list);
                    Vector v = new Vector();
                    while (iter.hasNext()) {
                        Process process = (Process)iter.next();
                        String[] selected = (String[])map.get(process.getProcessId());
                        if (selected == null) continue;
                        int i = 0;
                        while (i < selected.length) {
                            agents.add(process.getAgent(selected[i]));
                            ++i;
                        }
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return agents;
    }

    private static Map createMap(List list) {
        HashMap<String, String[]> map = new HashMap<String, String[]>();
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            StringTokenizer tok = new StringTokenizer((String)iter.next(), ":");
            String pid = tok.nextToken();
            tok = new StringTokenizer(tok.nextToken(), ",");
            String[] agents = new String[tok.countTokens()];
            int i = 0;
            while (i < agents.length) {
                agents[i] = tok.nextToken();
                ++i;
            }
            map.put(pid, agents);
        }
        return map;
    }
}

