/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.launcher;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.IDebugUIConstants;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.internal.junit.launcher.JUnitLaunchShortcut;
import org.eclipse.jdt.internal.junit.ui.JUnitMessages;
import org.eclipse.jdt.internal.junit.ui.JUnitPlugin;
import org.eclipse.jdt.internal.junit.util.TestSearchEngine;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

public class ProfileJUnitShortcut
extends JUnitLaunchShortcut {
    protected void launchType(Object[] search, String mode) {
        IType[] types = null;
        try {
            types = TestSearchEngine.findTests((Object[])search);
        }
        catch (InterruptedException e) {
            JUnitPlugin.log((Throwable)e);
            return;
        }
        catch (InvocationTargetException e) {
            JUnitPlugin.log((Throwable)e);
            return;
        }
        IType type = null;
        if (types.length == 0) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)JUnitMessages.getString((String)"LaunchTestAction.dialog.title"), (String)JUnitMessages.getString((String)"LaunchTestAction.message.notests"));
        } else {
            type = types.length > 1 ? this.chooseType(types, mode) : types[0];
        }
        if (type != null) {
            this.launch(type, mode);
        }
    }

    private void launch(IType type, final String mode) {
        String fullyQualifiedName = type.getFullyQualifiedName();
        ILaunchConfiguration config = this.findLaunchConfiguration(mode, (IJavaElement)type, "", fullyQualifiedName, "");
        if (config == null) {
            config = this.createConfiguration(type.getJavaProject(), type.getElementName(), fullyQualifiedName, "", "");
        }
        final ILaunchConfiguration conf = config;
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                Shell shell = UIPlugin.getActiveWorkbenchShell();
                int result = DebugUITools.openLaunchConfigurationPropertiesDialog((Shell)shell, (ILaunchConfiguration)conf, (String)IDebugUIConstants.ID_PROFILE_LAUNCH_GROUP);
                if (result == 0) {
                    DebugUITools.launch((ILaunchConfiguration)conf, (String)mode);
                }
            }
        });
    }

    private ILaunchConfiguration findLaunchConfiguration(String mode, IJavaElement element, String container, String testClass, String testName) {
        ILaunchConfigurationType configType = this.getJUnitLaunchConfigType();
        ArrayList<ILaunchConfiguration> candidateConfigs = Collections.EMPTY_LIST;
        try {
            ILaunchConfiguration[] configs = this.getLaunchManager().getLaunchConfigurations(configType);
            candidateConfigs = new ArrayList<ILaunchConfiguration>(configs.length);
            int i = 0;
            while (i < configs.length) {
                ILaunchConfiguration config = configs[i];
                if (config.getAttribute("org.eclipse.jdt.junit.CONTAINER", "").equals(container) && config.getAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, "").equals(testClass) && config.getAttribute("org.eclipse.jdt.junit.TESTNAME", "").equals(testName) && config.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, "").equals(element.getJavaProject().getElementName())) {
                    candidateConfigs.add(config);
                }
                ++i;
            }
        }
        catch (CoreException e) {
            JUnitPlugin.log((Throwable)e);
        }
        int candidateCount = candidateConfigs.size();
        if (candidateCount < 1) {
            return null;
        }
        if (candidateCount == 1) {
            return (ILaunchConfiguration)candidateConfigs.get(0);
        }
        ILaunchConfiguration config = this.chooseConfiguration(candidateConfigs, mode);
        if (config != null) {
            return config;
        }
        return null;
    }

    protected IType chooseType(IType[] types, String mode) {
        if (mode.equals("profile")) {
            ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)new JavaElementLabelProvider(2048));
            dialog.setElements((Object[])types);
            dialog.setTitle(UIPlugin.getResourceString("LAUNCH_SHORTCUT_SELECT_TEST_TITLE"));
            dialog.setMessage(UIPlugin.getResourceString("LAUNCH_SHORTCUT_SELECT_TEST_MSG"));
            dialog.setMultipleSelection(false);
            if (dialog.open() == 0) {
                return (IType)dialog.getFirstResult();
            }
            return null;
        }
        return super.chooseType(types, mode);
    }

    protected ILaunchConfiguration chooseConfiguration(List configList, String mode) {
        if (mode.equals("profile")) {
            IDebugModelPresentation labelProvider = DebugUITools.newDebugModelPresentation();
            ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)labelProvider);
            dialog.setElements(configList.toArray());
            dialog.setTitle(UIPlugin.getResourceString("LAUNCH_SHORTCUT_SELECT_CONF_TITLE"));
            dialog.setMessage(UIPlugin.getResourceString("LAUNCH_SHORTCUT_SELECT_CONF_MSG"));
            dialog.setMultipleSelection(false);
            int result = dialog.open();
            labelProvider.dispose();
            if (result == 0) {
                return (ILaunchConfiguration)dialog.getFirstResult();
            }
            return null;
        }
        return this.chooseConfiguration(configList, mode);
    }
}

