/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.util;

import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.hyades.internal.execution.local.control.Agent;
import org.eclipse.hyades.internal.execution.local.control.Node;
import org.eclipse.hyades.internal.execution.local.control.NodeFactory;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.loaders.util.XMLLoader;
import org.eclipse.hyades.models.hierarchy.CorrelationContainer;
import org.eclipse.hyades.models.hierarchy.CorrelationContainerProxy;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCMonitor;
import org.eclipse.hyades.models.hierarchy.TRCNode;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.models.hierarchy.util.EMFUtil;
import org.eclipse.hyades.models.hierarchy.util.HierarchyXMIResourceImpl;
import org.eclipse.hyades.models.hierarchy.util.SaveUtil;
import org.eclipse.hyades.trace.internal.ui.PDContentProvider;
import org.eclipse.hyades.trace.ui.IDeleteListener;
import org.eclipse.hyades.trace.ui.ProfileEvent;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.piclient.PIProcessListener;
import org.eclipse.hyades.trace.ui.internal.piclient.XMLTraceDataProcessor;
import org.eclipse.hyades.trace.ui.internal.util.ProcessMap;
import org.eclipse.hyades.trace.ui.internal.util.TString;
import org.eclipse.hyades.ui.extension.INavigatorContribution;
import org.eclipse.hyades.ui.extension.INavigatorItem;
import org.eclipse.hyades.ui.internal.extension.NavigatorExtensionUtil;

public class DeleteUtil {
    public static void deleteAgent(TRCAgentProxy agent, boolean refresh, boolean deleteContents) {
        if (agent == null) {
            return;
        }
        TRCProcessProxy process = agent.getProcessProxy();
        if (process == null) {
            return;
        }
        DeleteUtil.deleteExternalItems(agent, refresh, deleteContents);
        DeleteUtil.removeDoc(agent, deleteContents);
        agent.setProcessProxy(null);
        if (process.getAgentProxies().size() == 0) {
            DeleteUtil.deleteProcess(process, refresh, deleteContents);
        }
        if (refresh) {
            ProfileEvent event = UIPlugin.getDefault().getProfileEvent();
            event.setSource(null);
            event.setType(128);
            UIPlugin.getDefault().notifyProfileEventListener(event);
        }
    }

    public static void deleteMonitor(TRCMonitor monitor, boolean refresh, boolean deleteContents) {
        if (monitor == null) {
            return;
        }
        Iterator i = monitor.getNodes().iterator();
        while (i.hasNext()) {
            TRCNode node = (TRCNode)i.next();
            Iterator j = node.getProcessProxies().iterator();
            while (j.hasNext()) {
                TRCProcessProxy process = (TRCProcessProxy)j.next();
                Iterator k = process.getAgentProxies().iterator();
                while (k.hasNext()) {
                    TRCAgentProxy agent = (TRCAgentProxy)k.next();
                    DeleteUtil.deleteExternalItems(agent, refresh, deleteContents);
                }
                DeleteUtil.deleteExternalItems(process, refresh, deleteContents);
            }
            DeleteUtil.deleteExternalItems(node, refresh, deleteContents);
        }
        DeleteUtil.deleteExternalItems(monitor, refresh, deleteContents);
        Path path = new Path(TString.resourcePath(monitor.eResource().getURI()));
        if (path.segmentCount() > 1) {
            path = path.removeLastSegments(1);
        }
        PDContentProvider.removeMonitor(path.toOSString(), monitor);
        DeleteUtil.removeDoc(monitor, deleteContents);
        if (refresh) {
            ProfileEvent event = UIPlugin.getDefault().getProfileEvent();
            event.setSource(null);
            event.setType(128);
            UIPlugin.getDefault().notifyProfileEventListener(event);
        }
    }

    public static void deleteNode(TRCNode node, boolean refresh, boolean deleteContents) {
        if (node == null) {
            return;
        }
        TRCMonitor monitor = node.getMonitor();
        if (monitor == null) {
            return;
        }
        if (monitor.getNodes().size() == 1) {
            DeleteUtil.deleteMonitor(monitor, refresh, deleteContents);
        } else {
            DeleteUtil.removeDoc(node, deleteContents);
            DeleteUtil.deleteExternalItems(node, refresh, deleteContents);
            node.setMonitor(null);
        }
        if (refresh) {
            ProfileEvent event = UIPlugin.getDefault().getProfileEvent();
            event.setSource(null);
            event.setType(128);
            UIPlugin.getDefault().notifyProfileEventListener(event);
        }
    }

    public static void deleteProcess(TRCProcessProxy process, boolean refresh, boolean deleteContents) {
        if (process == null) {
            return;
        }
        TRCNode node = process.getNode();
        if (node == null) {
            return;
        }
        if (node.getProcessProxies().size() == 1) {
            DeleteUtil.deleteNode(node, refresh, deleteContents);
        } else {
            DeleteUtil.removeDoc(process, deleteContents);
            DeleteUtil.deleteExternalItems(process, refresh, deleteContents);
            process.setNode(null);
        }
        UIPlugin.getDefault().deleteLaunch(ProcessMap.get(process));
        if (refresh) {
            ProfileEvent event = UIPlugin.getDefault().getProfileEvent();
            event.setSource(null);
            event.setType(128);
            UIPlugin.getDefault().notifyProfileEventListener(event);
        }
    }

    public static void deleteContainer(IContainer container, boolean deleteContents) throws CoreException {
        if (container == null || !container.exists()) {
            return;
        }
        IResource[] members = container.members();
        if (members.length > 0) {
            int i = 0;
            while (i < members.length) {
                if (members[i] instanceof IFolder) {
                    IFolder member = (IFolder)members[i];
                    DeleteUtil.deleteContainer((IContainer)member, deleteContents);
                }
                ++i;
            }
        }
        ArrayList monitors = PDContentProvider.getMonitors(container);
        int idx = 0;
        while (idx < monitors.size()) {
            TRCMonitor mon;
            if (monitors.get(idx) instanceof TRCMonitor && (mon = (TRCMonitor)monitors.get(idx)) != null) {
                DeleteUtil.deleteMonitor(mon, true, deleteContents);
            }
            ++idx;
        }
        DeleteUtil.deleteExternalItems(container, true, deleteContents);
        PDContentProvider.removeContainer(container);
        container.delete(true, null);
    }

    public static void deleteResource(IResource resource, boolean deleteContents) {
        if (resource == null) {
            return;
        }
        try {
            IContainer parent = resource.getParent();
            if (resource == null || !resource.exists()) {
                return;
            }
            if (resource instanceof IProject || resource instanceof IFolder) {
                DeleteUtil.deleteContainer((IContainer)resource, deleteContents);
            } else {
                resource.delete(true, null);
            }
            ProfileEvent event = UIPlugin.getDefault().getProfileEvent();
            event.setSource(null);
            event.setType(128);
            UIPlugin.getDefault().notifyProfileEventListener(event);
        }
        catch (CoreException exc) {
            exc.printStackTrace();
        }
    }

    public static void deleteExternalItems(Object parent, boolean refresh, boolean deleteContents) {
        INavigatorContribution[] delegates = NavigatorExtensionUtil.getContributions(null);
        int i = 0;
        while (i < delegates.length) {
            List children = delegates[i].getChildren(parent);
            Iterator iter = children.iterator();
            while (iter.hasNext()) {
                INavigatorItem item = (INavigatorItem)iter.next();
                if (!item.isDeleteEnabled()) continue;
                item.delete(refresh, deleteContents);
            }
            ++i;
        }
    }

    public static void removeDoc(TRCAgentProxy agent, boolean deleteContents) {
        if (agent == null || agent.getAgent() == null || agent.getAgent().eResource() == null) {
            return;
        }
        XMLLoader dataProcessor = LoadersUtils.locateDataProcessor((TRCAgentProxy)agent);
        if (dataProcessor != null && dataProcessor instanceof XMLTraceDataProcessor) {
            ((XMLTraceDataProcessor)dataProcessor).dispose();
        }
        LoadersUtils.deregisterDataProcessor((TRCAgentProxy)agent);
        Object listener = LoadersUtils.locateAgentListener((TRCAgentProxy)agent);
        if (listener != null && listener instanceof PIProcessListener) {
            ((PIProcessListener)listener).dispose();
        }
        LoadersUtils.deregisterAgentListener((TRCAgentProxy)agent);
        LoadersUtils.deregisterAgentInstance((TRCAgentProxy)agent);
        LoadersUtils.deregisterAgentProxyContext((TRCAgentProxy)agent);
        if (deleteContents) {
            Path path = new Path(TString.resourcePath(agent.getAgent().eResource().getURI()));
            IResource res = UIPlugin.getPluginWorkbench().getRoot().findMember((IPath)path);
            DeleteUtil.deleteResource(res, true);
        }
        ArrayList list = UIPlugin.getDefault().getDeleteListeners();
        int idx = 0;
        while (idx < list.size()) {
            ((IDeleteListener)list.get(idx)).deregister(agent);
            ++idx;
        }
        TRCProcessProxy process = agent.getProcessProxy();
        TRCNode trcnode = process.getNode();
        if (process == null || trcnode == null) {
            return;
        }
        try {
            Agent a;
            Object instance;
            String nodeName = trcnode.getName();
            Node node = NodeFactory.createNode((String)nodeName);
            if (node.isConnected() && (instance = LoadersUtils.locateAgentInstance((TRCAgentProxy)agent)) != null && instance instanceof Agent && (a = (Agent)instance).isAttached()) {
                a.detach();
            }
        }
        catch (UnknownHostException uhe) {
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
        DeleteUtil.unloadDoc((EObject)agent.getAgent());
        Iterator iter = EMFUtil.delete((EObject)agent, (ResourceSet)agent.eResource().getResourceSet()).iterator();
        while (iter.hasNext()) {
            Resource res = (Resource)iter.next();
            if (res == null) continue;
            res.setModified(true);
        }
    }

    public static void removeDoc(TRCMonitor mon, boolean deleteContents) {
        if (mon == null) {
            return;
        }
        ArrayList list = UIPlugin.getDefault().getDeleteListeners();
        int idx = 0;
        while (idx < list.size()) {
            ((IDeleteListener)list.get(idx)).deregister(mon);
            ++idx;
        }
        if (mon.eResource() != null && deleteContents) {
            Path path = new Path(TString.resourcePath(mon.eResource().getURI()));
            IResource res = UIPlugin.getPluginWorkbench().getRoot().findMember((IPath)path);
            DeleteUtil.deleteResource(res, true);
        }
        Object[] nodes = mon.getNodes().toArray();
        int idx2 = 0;
        while (idx2 < nodes.length) {
            TRCNode node = (TRCNode)nodes[idx2];
            if (!node.eIsProxy()) {
                DeleteUtil.removeDoc(node, deleteContents);
            }
            ++idx2;
        }
        DeleteUtil.unloadDoc((EObject)mon);
    }

    public static void removeDoc(TRCNode node, boolean deleteContents) {
        if (node == null) {
            return;
        }
        ArrayList list = UIPlugin.getDefault().getDeleteListeners();
        int idx = 0;
        while (idx < list.size()) {
            ((IDeleteListener)list.get(idx)).deregister(node);
            ++idx;
        }
        if (node.eResource() != null && deleteContents) {
            Path path = new Path(TString.resourcePath(node.eResource().getURI()));
            IResource res = UIPlugin.getPluginWorkbench().getRoot().findMember((IPath)path);
            DeleteUtil.deleteResource(res, true);
        }
        Object[] processes = node.getProcessProxies().toArray();
        int idx2 = 0;
        while (idx2 < processes.length) {
            TRCProcessProxy process = (TRCProcessProxy)processes[idx2];
            if (!process.eIsProxy()) {
                DeleteUtil.removeDoc(process, deleteContents);
            }
            ++idx2;
        }
        TRCMonitor monitor = node.getMonitor();
        if (monitor == null) {
            return;
        }
        monitor.getNodes().remove((Object)node);
        if (deleteContents) {
            Path path = new Path(TString.resourcePath(monitor.eResource().getURI()));
            IResource res = UIPlugin.getPluginWorkbench().getRoot().findMember((IPath)path);
            if (res != null) {
                try {
                    SaveUtil.saveResource(null, (Resource)monitor.eResource());
                }
                catch (Exception exc) {
                    exc.printStackTrace();
                }
            }
        }
        DeleteUtil.unloadDoc((EObject)node);
    }

    public static void removeDoc(TRCProcessProxy process, boolean deleteContents) {
        if (process == null) {
            return;
        }
        if (deleteContents) {
            Path path = new Path(TString.resourcePath(process.eResource().getURI()));
            IResource res = UIPlugin.getPluginWorkbench().getRoot().findMember((IPath)path);
            DeleteUtil.deleteResource(res, true);
        }
        Object[] agents = process.getAgentProxies().toArray();
        int idx = 0;
        while (idx < agents.length) {
            TRCAgentProxy agent = (TRCAgentProxy)agents[idx];
            if (!agent.eIsProxy()) {
                DeleteUtil.removeDoc(agent, deleteContents);
            }
            ++idx;
        }
        TRCNode node = process.getNode();
        if (node != null) {
            node.getProcessProxies().remove((Object)process);
            if (deleteContents) {
                Path path = new Path(TString.resourcePath(node.eResource().getURI()));
                IResource res = UIPlugin.getPluginWorkbench().getRoot().findMember((IPath)path);
                if (res != null) {
                    try {
                        SaveUtil.saveResource(null, (Resource)node.eResource());
                    }
                    catch (Exception exc) {
                        exc.printStackTrace();
                    }
                }
            }
        }
        ArrayList list = UIPlugin.getDefault().getDeleteListeners();
        int idx2 = 0;
        while (idx2 < list.size()) {
            ((IDeleteListener)list.get(idx2)).deregister(process);
            ++idx2;
        }
        DeleteUtil.unloadDoc((EObject)process);
    }

    public static void unloadDoc(EObject object) {
        if (object == null || object.eResource() == null) {
            return;
        }
        UIPlugin.getDefault().removeSelectionModel(object);
        ((HierarchyXMIResourceImpl)object.eResource()).doShallowDelete();
    }

    public static void deleteCorrelationContainer(CorrelationContainerProxy correlationContainerProxy, boolean refresh, boolean deleteContents) {
        if (correlationContainerProxy == null) {
            return;
        }
        CorrelationContainer correlationContainer = correlationContainerProxy.getCorrelationContainer();
        if (correlationContainer != null && !correlationContainer.eIsProxy()) {
            if (deleteContents) {
                Path path = new Path(TString.resourcePath(correlationContainer.eResource().getURI()));
                IResource res = UIPlugin.getPluginWorkbench().getRoot().findMember((IPath)path);
                DeleteUtil.deleteResource(res, true);
            }
            ((HierarchyXMIResourceImpl)correlationContainer.eResource()).doShallowDelete();
            correlationContainer.setCorrelationContainerProxy(null);
        }
        Resource res = correlationContainerProxy.getMonitor().eResource();
        correlationContainerProxy.setMonitor(null);
        if (res != null && deleteContents) {
            try {
                SaveUtil.saveResource(null, (Resource)res);
            }
            catch (Exception exc) {
                exc.printStackTrace();
            }
        }
        Iterator iter = correlationContainerProxy.getCorrelatedAgents().iterator();
        while (iter.hasNext()) {
            TRCAgentProxy element = (TRCAgentProxy)iter.next();
            if (!element.getInternalCorrelations().contains((Object)correlationContainerProxy)) continue;
            element.getInternalCorrelations().remove((Object)correlationContainerProxy);
        }
        correlationContainerProxy.getCorrelatedAgents().clear();
        if (refresh) {
            ProfileEvent event = UIPlugin.getDefault().getProfileEvent();
            event.setSource(null);
            event.setType(128);
            UIPlugin.getDefault().notifyProfileEventListener(event);
        }
    }
}

