/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.wizard;

import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.hyades.internal.execution.local.common.CustomCommand;
import org.eclipse.hyades.internal.execution.local.control.Agent;
import org.eclipse.hyades.internal.execution.local.control.InactiveAgentException;
import org.eclipse.hyades.internal.execution.local.control.Node;
import org.eclipse.hyades.internal.execution.local.control.Process;
import org.eclipse.hyades.models.hierarchy.HierarchyFactory;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCConfiguration;
import org.eclipse.hyades.models.hierarchy.TRCFilter;
import org.eclipse.hyades.models.hierarchy.TRCNode;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.hyades.trace.internal.ui.PDProjectExplorer;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.core.TraceProfileFiltersUI;
import org.eclipse.hyades.trace.ui.internal.util.FilterSetElement;
import org.eclipse.hyades.trace.ui.internal.util.FilterTableElement;
import org.eclipse.hyades.trace.ui.internal.util.PDCoreUtil;
import org.eclipse.hyades.trace.ui.internal.wizard.OpenProfAgentWizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.help.WorkbenchHelp;

public class OpenProfAgentPage
extends WizardPage {
    protected PDProjectExplorer fViewer;
    protected TraceProfileFiltersUI _profileUI;

    public OpenProfAgentPage(String name, PDProjectExplorer viewer) {
        super(name);
        this.setTitle(UIPlugin.getResourceString("PROF_AGENT_TITLE"));
        this.setDescription(UIPlugin.getResourceString("PROF_AGENT_DESC"));
        this.fViewer = viewer;
    }

    public void createControl(Composite parent) {
        Composite content = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.verticalSpacing = 5;
        content.setLayout((Layout)layout);
        GridData gd = GridUtil.createFill();
        gd.widthHint = 500;
        gd.heightHint = 400;
        content.setLayoutData((Object)gd);
        this._profileUI = new TraceProfileFiltersUI();
        this._profileUI.createControl(content);
        TRCAgentProxy agent = ((OpenProfAgentWizard)this.getWizard()).getAgent();
        if (agent == null || !agent.isActive()) {
            this._profileUI.setAgentTerminated(true);
            this._profileUI.enable(false);
        }
        this.setControl((Control)content);
        this.populateData();
        WorkbenchHelp.setHelp((Control)parent, (String)(UIPlugin.getPluginId() + ".opap0000"));
    }

    public boolean finish() {
        TRCAgentProxy agent = ((OpenProfAgentWizard)this.getWizard()).getAgent();
        if (agent == null || !agent.isActive()) {
            return true;
        }
        try {
            Object[] configs = agent.getConfigurations().toArray();
            if (configs.length > 0) {
                this.setConfiguration((TRCConfiguration)configs[0]);
            } else {
                HierarchyFactory factory = UIPlugin.getDefault().getPerftraceFactory();
                TRCConfiguration config = factory.createTRCConfiguration();
                config.setActive(true);
                config.setName(UIPlugin.getResourceString("STR_DEFAULT_SET_NAME"));
                config.setAgentProxy(agent);
                agent.getConfigurations().add((Object)config);
                this.setConfiguration(config);
            }
            if (agent.isActive() && agent.isMonitored()) {
                TRCProcessProxy process = agent.getProcessProxy();
                TRCNode node = process.getNode();
                this.sendConfigurationToAgent(agent, node.getName(), process.getPid());
            }
        }
        catch (ConcurrentModificationException exc) {
            exc.printStackTrace();
        }
        return true;
    }

    private void sendConfigurationToAgent(TRCAgentProxy agent, String host, int processId) {
        block4: {
            Node node = PDCoreUtil.profileConnect(host, String.valueOf(agent.getProcessProxy().getNode().getPort()));
            if (node == null) {
                return;
            }
            Process p = node.getProcess(String.valueOf(processId));
            if (p == null) break block4;
            try {
                Agent a = p.getAgent(agent.getName());
                PDCoreUtil.setAgentConfiguration(agent, a);
                if (a != null && a.isActive()) {
                    a.publishConfiguration();
                    CustomCommand command = new CustomCommand();
                    command.setData("APPLYFILTERS");
                    a.invokeCustomCommand(command);
                }
            }
            catch (InactiveAgentException aex) {}
        }
    }

    protected void populateData() {
        TRCAgentProxy agent = ((OpenProfAgentWizard)this.getWizard()).getAgent();
        if (agent == null) {
            return;
        }
        EList filters = null;
        EList configs = agent.getConfigurations();
        Iterator i = configs.iterator();
        if (i.hasNext()) {
            TRCConfiguration config = (TRCConfiguration)i.next();
            filters = config.getFilters();
            this.updateConfigData(config.getName(), filters);
            return;
        }
        this.updateConfigData(UIPlugin.getResourceString("STR_DEFAULT_SET_NAME"), filters);
    }

    protected void setConfiguration(TRCConfiguration config) {
        try {
            Object[] filters = config.getFilters().toArray();
            int idx = 0;
            while (idx < filters.length) {
                ((TRCFilter)filters[idx]).setConfiguration(null);
                ++idx;
            }
            HierarchyFactory factory = UIPlugin.getDefault().getPerftraceFactory();
            String selected = this._profileUI.getActiveFilterSet();
            ArrayList filterSet = this._profileUI.getFilterSet();
            int i = 0;
            while (i < filterSet.size()) {
                FilterSetElement set = (FilterSetElement)filterSet.get(i);
                if (set.getName().equals(selected)) {
                    config.setActive(true);
                    config.setName(set.getName());
                    UIPlugin.getDefault().getPluginPreferences().setValue("filter_name", set.getName());
                    ArrayList filterList = set.getChildren();
                    int idx2 = 0;
                    while (idx2 < filterList.size()) {
                        FilterTableElement elem = (FilterTableElement)filterList.get(idx2);
                        TRCFilter filter = factory.createTRCFilter();
                        filter.setMode(elem.getVisibility().equals(UIPlugin.getResourceString("STR_INCLUDE")) ? "INCLUDE" : "EXCLUDE");
                        filter.setPattern(elem.getText());
                        filter.setOperation(elem.getMethod());
                        filter.setType("CLASS");
                        filter.setActive(new Boolean(true));
                        filter.setConfiguration(config);
                        ++idx2;
                    }
                    break;
                }
                ++i;
            }
        }
        catch (ConcurrentModificationException exc) {
            exc.printStackTrace();
        }
    }

    protected void updateConfigData(String name, EList filters) {
        ArrayList<FilterTableElement> list = new ArrayList<FilterTableElement>();
        if (filters != null) {
            Iterator i = filters.iterator();
            while (i.hasNext()) {
                TRCFilter filter = (TRCFilter)i.next();
                String method = filter.getOperation();
                if (method != null) {
                    list.add(new FilterTableElement(filter.getPattern(), method, filter.getMode().equals("INCLUDE") ? UIPlugin.getResourceString("STR_INCLUDE") : UIPlugin.getResourceString("STR_EXCLUDE")));
                    continue;
                }
                list.add(new FilterTableElement(filter.getPattern(), "*", filter.getMode().equals("INCLUDE") ? UIPlugin.getResourceString("STR_INCLUDE") : UIPlugin.getResourceString("STR_EXCLUDE")));
            }
        }
        FilterSetElement elem = new FilterSetElement(name);
        elem.setChildren(list);
        this._profileUI.addFilterSet(elem);
        this._profileUI.setActiveFilterSet(elem);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            if (!((OpenProfAgentWizard)this.getWizard()).isProfilingAgent()) {
                this.getControl().setEnabled(false);
                this.getControl().setVisible(false);
                this.setDescription(UIPlugin.getResourceString("STR_FILTER_IGNORED"));
            } else {
                this.getControl().setEnabled(true);
                this.getControl().setVisible(true);
                this.setDescription(UIPlugin.getResourceString("PROF_AGENT_DESC"));
            }
        }
    }
}

