/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.collection.threadanalyzer;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.hyades.collection.threadanalyzer.Arg;
import org.eclipse.hyades.collection.threadanalyzer.DummyDialog;
import org.eclipse.hyades.collection.threadanalyzer.TAReaderThread;
import org.eclipse.hyades.collection.threadanalyzer.TAUtils;
import org.eclipse.hyades.collection.threadanalyzer.TaTimedOutException;
import org.eclipse.hyades.collection.threadanalyzer.dumpparser.DumpParser;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ThreadAnalyzer {
    private static ThreadAnalyzer instance = null;
    private static boolean cmdLine = false;
    protected static Hashtable _args = new Hashtable();
    protected static String[] _validArgNames = new String[]{"analyze", "serverName", "was_home", "logLevel", "dumpOut", "dumpWait", "streamIn", "streamOut", "dumpIn", "detailXML", "reportOut", "reportType", "tmpDir", "dbDriver", "dbURL", "dumpType", "soapPort"};
    protected static Properties _pathMap = new Properties();
    protected static String _edition = null;
    public static final int DEBUG = 4;
    public static final int DETAIL = 3;
    public static final int INFO = 2;
    public static final int WARNING = 1;
    public static final int ERROR = 0;
    protected static int _logLevel = 2;
    protected static String _adminClasspath = null;
    protected static String _adminPath = null;
    protected static Properties _adminProperties = null;
    private static DummyDialog myDummyDialog = null;
    private static Process browserProcess = null;

    public static void main(String[] args) {
        instance = new ThreadAnalyzer();
        cmdLine = true;
        myDummyDialog = new DummyDialog();
        try {
            instance.doIt(args);
        }
        catch (TaTimedOutException ttoe) {
            // empty catch block
        }
        System.exit(0);
    }

    public static DummyDialog getDummyDialog() {
        return myDummyDialog;
    }

    public static boolean inCmdLineMode() {
        return cmdLine;
    }

    public boolean doIt(String[] args) throws TaTimedOutException {
        block37: {
            String myPath;
            String myClasspath;
            String javaExe;
            Vector<String> env;
            block36: {
                env = new Vector<String>();
                String thePath = null;
                String wasHome = null;
                javaExe = null;
                try {
                    BufferedReader r = new BufferedReader(new InputStreamReader(System.in));
                    while (r.ready()) {
                        int idx;
                        String sIn = r.readLine();
                        if (sIn == null || sIn.length() <= 0 || (idx = sIn.indexOf("=")) == -1) continue;
                        String sKey = sIn.substring(0, idx);
                        if (idx + 1 > sIn.length()) continue;
                        String sVal = sIn.substring(idx + 1);
                        if (!sKey.equalsIgnoreCase("path")) {
                            env.add(sIn);
                        } else {
                            thePath = sVal;
                        }
                        if (sKey.equalsIgnoreCase("was_home")) {
                            wasHome = sVal;
                        }
                        if (!sKey.equalsIgnoreCase("java_exe")) continue;
                        javaExe = sVal;
                    }
                }
                catch (IOException ioe) {
                    System.err.println(TAUtils.getNLSValue("ta.errmsg.CannotReadEnv", "Cannot read environment") + ".");
                }
                ThreadAnalyzer.parseArgs(args);
                if (ThreadAnalyzer.getArg("was_home") != null) {
                    wasHome = ThreadAnalyzer.getArg("was_home");
                } else {
                    ThreadAnalyzer.putArg("was_home", wasHome);
                }
                if (wasHome == null) {
                    System.err.println("was_home " + TAUtils.getNLSValue("ta.errmsg.NotSet", "not set") + ".");
                    ThreadAnalyzer.syntax();
                }
                myClasspath = System.getProperty("java.class.path");
                myPath = (thePath != null ? thePath : "") + System.getProperty("path.separator") + System.getProperty("java.library.path");
                try {
                    ThreadAnalyzer.getProductVersion(wasHome + "/properties/com/ibm/websphere/product.xml");
                }
                catch (FileNotFoundException not40) {
                    try {
                        File baseProductFile = new File(wasHome + "/properties/version/BASE.product");
                        File bobcatProductFile = new File(wasHome + "/properties/version/embeddedEXPRESS.product");
                        if (!baseProductFile.exists() && !bobcatProductFile.exists()) {
                            ThreadAnalyzer.logError("WAS 5.0 not detected");
                            throw new FileNotFoundException();
                        }
                        _edition = "BASE";
                    }
                    catch (FileNotFoundException not50) {
                        ThreadAnalyzer.logError("No valid WAS installation detected.");
                        return false;
                    }
                }
                ThreadAnalyzer.logDebug(TAUtils.getNLSValue("ta.logdebug.ProductEdition", "Product edition") + ": " + _edition);
                ThreadAnalyzer.loadWasProps();
                File fTemp = null;
                if (javaExe == null) {
                    javaExe = ThreadAnalyzer.getWasJavaExe();
                }
                ThreadAnalyzer.logDebug("[ThreadAnalyzer] servername: " + ThreadAnalyzer.getArg("servername"));
                if (ThreadAnalyzer.getArg("servername") != null) {
                    ThreadAnalyzer.logDebug("[ThreadAnalyzer] dumpOut: " + ThreadAnalyzer.getArg("dumpOut"));
                    if (ThreadAnalyzer.getArg("dumpOut") == null) {
                        ThreadAnalyzer.logDebug("[ThreadAnalyzer] dumpOut == null");
                        try {
                            fTemp = ThreadAnalyzer.getArg("tmpDir").equalsIgnoreCase("system") ? File.createTempFile("thread_", ".analyzed") : File.createTempFile("thread_", ".analyzed", new File(ThreadAnalyzer.getArg("tmpDir")));
                            fTemp.deleteOnExit();
                        }
                        catch (IOException ioe) {
                            System.err.println(TAUtils.getNLSValue("ta.errmsg.ErrCreatingTempFile", "Error creating temp file."));
                            ioe.printStackTrace();
                            return false;
                        }
                        _args.put("dumpOut".toUpperCase(), new Arg(fTemp.getPath()));
                    }
                    try {
                        if (!this.getThreadDump(javaExe, wasHome, env, myClasspath, myPath)) {
                            return false;
                        }
                        break block36;
                    }
                    catch (TaTimedOutException ttoe) {
                        ThreadAnalyzer.logDebug("[ThreadAnalyzer] throwing TaTimedOutException");
                        throw ttoe;
                    }
                }
                _args.put("dumpOut".toUpperCase(), new Arg(ThreadAnalyzer.getArg("dumpIn")));
            }
            if (ThreadAnalyzer.getArg("analyze").equalsIgnoreCase("none")) break block37;
            String outFilename = new String();
            try {
                if (ThreadAnalyzer.getArg("reportOut").equalsIgnoreCase("default")) {
                    String dumpOut = ThreadAnalyzer.getArg("dumpOut");
                    outFilename = ThreadAnalyzer.getArg("reportType").equalsIgnoreCase("html") ? dumpOut + ".html" : dumpOut + ".txt";
                } else {
                    outFilename = ThreadAnalyzer.getArg("reportOut");
                }
                File fOut = new File(outFilename);
                ThreadAnalyzer.logDebug("[ThreadAnalyzer] deleting: " + outFilename);
                fOut.delete();
                outFilename = fOut.getCanonicalPath();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                System.err.println(TAUtils.getNLSValue("ta.errmsg.ErrorOn", "error on") + " " + outFilename);
                ioe.getMessage();
            }
            this.parseAndAnalyze(javaExe, env, myClasspath, myPath, outFilename);
            Process p = null;
            String osName = System.getProperty("os.name");
            boolean fRptOut = ThreadAnalyzer.getArg("streamOut") == null && !ThreadAnalyzer.getArg("reportType").equalsIgnoreCase("none");
            File fOut = new File(outFilename);
            if (fRptOut && fOut.exists()) {
                ThreadAnalyzer.logInfo(TAUtils.getNLSValue("ta.errmsg.OutputFile", "Output file") + ": " + outFilename);
            }
            if (ThreadAnalyzer.getArg("StreamOut") == null && ThreadAnalyzer.getArg("reportType").equalsIgnoreCase("html")) {
                if (osName.indexOf("Windows") != -1) {
                    String[] cmd = new String[]{"cmd.exe", "/c", outFilename};
                    try {
                        ThreadAnalyzer.logInfo("attempting to launch browser...");
                        p = Runtime.getRuntime().exec(cmd);
                    }
                    catch (IOException ioe) {
                        System.err.println(TAUtils.getNLSValue("ta.errmsg.CannotStartBrowser", "Cannot start browser") + ".");
                    }
                    new TAReaderThread(p.getInputStream(), p.getErrorStream(), System.out).start();
                } else {
                    String[] cmd = new String[]{"netscape", outFilename};
                    try {
                        ThreadAnalyzer.logInfo("attempting to launch browser...");
                        p = Runtime.getRuntime().exec(cmd);
                        new TAReaderThread(p.getInputStream(), p.getErrorStream(), System.out).start();
                        try {
                            p.waitFor();
                        }
                        catch (InterruptedException ie) {
                        }
                    }
                    catch (IOException ioe) {
                        System.err.println(TAUtils.getNLSValue("ta.errmsg.CantStartNetscape", "Netscape could not be started"));
                    }
                }
            }
        }
        return true;
    }

    protected void parseAndAnalyze(String javaExe, Vector env, String myClasspath, String myPath, String outFilename) {
        String[] args = new String[]{"logLevel=" + ThreadAnalyzer.getArg("loglevel"), "dumpIn=" + ThreadAnalyzer.getArg("dumpOut"), "reportType=" + ThreadAnalyzer.getArg("reportType"), "reportOut=" + outFilename, "analyze=" + (ThreadAnalyzer.getArg("analyze") == null ? "all" : ThreadAnalyzer.getArg("analyze")), ThreadAnalyzer.getArg("StreamOut") == null ? "" : "StreamOut=" + ThreadAnalyzer.getArg("StreamOut")};
        new DumpParser(cmdLine).doIt(args);
    }

    protected boolean getThreadDump(String javaExe, String wasHome, Vector env, String myClasspath, String myPath) throws TaTimedOutException {
        Runtime r = Runtime.getRuntime();
        env.add("PATH=" + _adminPath + System.getProperty("path.separator") + myPath);
        String[] cmdLine = new String[]{javaExe, "-classpath", myClasspath, "com.ibm.ws.performance.threadanalyzer.getthreaddump.GetThreadDump", "loglevel=" + ThreadAnalyzer.getArg("loglevel"), "dumpWait=" + ThreadAnalyzer.getArg("dumpWait"), "servername=" + ThreadAnalyzer.getArg("servername"), "was_home=" + wasHome, "dumpOut=" + ThreadAnalyzer.getArg("dumpOut"), "dumpType=" + ThreadAnalyzer.getArg("dumpType")};
        Object p = null;
        Object rThd = null;
        try {
            String[] envp = new String[env.size()];
            int i = 0;
            while (i < env.size()) {
                envp[i] = (String)env.elementAt(i);
                ++i;
            }
            String[] getDumpArgs = new String[]{"loglevel=" + ThreadAnalyzer.getArg("loglevel"), "dumpWait=" + ThreadAnalyzer.getArg("dumpWait"), "servername=" + ThreadAnalyzer.getArg("servername"), "was_home=" + wasHome, "dumpOut=" + ThreadAnalyzer.getArg("dumpOut"), "dumpType=" + ThreadAnalyzer.getArg("dumpType")};
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    protected static void loadWasProps() {
        if (_edition == null || _edition.equalsIgnoreCase("BASE")) {
            return;
        }
        if (_edition.equalsIgnoreCase("AEs")) {
            _adminClasspath = "";
            _adminPath = "";
        } else {
            _adminClasspath = ThreadAnalyzer.getAdminProperty("com.ibm.ejs.sm.adminserver.classpath");
            _adminPath = ThreadAnalyzer.getAdminProperty("com.ibm.ejs.sm.util.process.Nanny.path");
        }
    }

    protected static String getWasJavaExe() {
        String javaExe = null;
        if (_edition.equalsIgnoreCase("AEs") || _edition.equalsIgnoreCase("BASE")) {
            javaExe = ThreadAnalyzer.getArg("WAS_HOME") + "/java/jre/bin/java";
        } else {
            javaExe = ThreadAnalyzer.getAdminProperty("com.ibm.ws.jdkexe.path");
            if (javaExe == null && (javaExe = ThreadAnalyzer.getAdminProperty("com.ibm.ws.jdk.path")) != null) {
                javaExe = javaExe + "/bin/java";
            }
        }
        File f = new File(javaExe);
        javaExe = f.getAbsolutePath();
        return javaExe;
    }

    public static void traverse(Node root, Node cur, String searchNode, String searchKey) {
        if (cur == root) {
            return;
        }
        if (root == null) {
            root = cur;
        }
        Node n = cur.getFirstChild();
        while (n != null) {
            int i;
            String nodeName = n.getNodeName();
            if (nodeName.equalsIgnoreCase("edition") && searchNode.equals("edition")) {
                ThreadAnalyzer.logDebug("!!!!edition!!!!");
                ThreadAnalyzer.traverse(root, cur, "value", "");
                return;
            }
            if (nodeName.equalsIgnoreCase("value") && searchNode.equals("value")) {
                ThreadAnalyzer.logDebug("!!!!value!!!!");
                ThreadAnalyzer.logDebug("nodeName = " + nodeName);
                NodeList nl = cur.getChildNodes();
                ThreadAnalyzer.logDebug("children = " + nl.getLength());
                i = 0;
                while (i < nl.getLength()) {
                    String nodeNm = nl.item(i).getNodeName();
                    ThreadAnalyzer.logDebug("nodeNm[" + i + "] = " + nodeNm);
                    if (nodeNm.equals("value")) {
                        _edition = ((CharacterData)nl.item(i).getFirstChild()).getData();
                    }
                    ++i;
                }
                return;
            }
            if (nodeName.equalsIgnoreCase("servers") && searchNode.equals("servers")) {
                ThreadAnalyzer.logDebug("!!!!servers!!!!");
                NamedNodeMap nm = n.getAttributes();
                ThreadAnalyzer.logDebug(":=> " + nm.getNamedItem("name"));
                if (nm.getNamedItem("name").getNodeValue().equalsIgnoreCase(searchKey)) {
                    ThreadAnalyzer.traverse(root, n, "ioRedirect", "");
                }
                return;
            }
            if (nodeName.equalsIgnoreCase("pathMap") && searchNode.equals("pathMap")) {
                ThreadAnalyzer.logDebug("!!!!pathMap!!!!");
                NodeList l = n.getChildNodes();
                i = 0;
                while (i < l.getLength()) {
                    Node item;
                    NamedNodeMap nm = l.item(i).getAttributes();
                    if (nm != null && (item = nm.getNamedItem("symbolicName")) != null) {
                        String symName = item.getNodeValue();
                        String path = nm.getNamedItem("path").getNodeValue();
                        ThreadAnalyzer.logDebug(symName + "=" + path);
                        _pathMap.put(symName, path);
                    }
                    ++i;
                }
                ThreadAnalyzer.logDebug("---Translated paths---");
                Enumeration<Object> enumeration = _pathMap.keys();
                String pathKey = null;
                while (enumeration.hasMoreElements()) {
                    pathKey = (String)enumeration.nextElement();
                    String path = _pathMap.getProperty(pathKey);
                    path = ThreadAnalyzer.replacePathVar(_pathMap, path);
                    File f = new File(path);
                    String cpath = null;
                    try {
                        cpath = f.getCanonicalPath();
                    }
                    catch (Throwable t) {
                        cpath = "?????";
                    }
                    ThreadAnalyzer.logDebug(pathKey + "=" + cpath);
                }
                ThreadAnalyzer.logDebug("------");
            }
            ThreadAnalyzer.traverse(root, n, searchNode, searchKey);
            n = n.getNextSibling();
        }
    }

    public static String replacePathVar(Properties _pathMap, String path) {
        String repVar = null;
        int idx1 = -1;
        while ((idx1 = path.indexOf("${")) != -1) {
            int idx2 = path.indexOf("}");
            if (idx2 == -1) continue;
            repVar = path.substring(idx1 + 2, idx2);
            String repVal = _pathMap.getProperty(repVar);
            ThreadAnalyzer.logDebug(repVar + " is " + repVal);
            String tmpPath = null;
            if (idx1 > 0) {
                tmpPath = path.substring(0, idx1);
                tmpPath = tmpPath + repVal;
            } else {
                tmpPath = repVal;
            }
            path = tmpPath = tmpPath + path.substring(idx2 + 1);
        }
        return path;
    }

    public static void getProductVersion(String xmlName) throws FileNotFoundException {
        DocumentBuilderFactory xmlDbf = DocumentBuilderFactory.newInstance();
        Document inDoc = null;
        try {
            File xmlFile = new File(xmlName);
            if (!xmlFile.exists()) {
                ThreadAnalyzer.logDebug("[ThreadAnalyzer] " + TAUtils.getNLSValue("ta.errmsg.FileDoesntExist", "File doesn't exist") + ": " + xmlFile);
                throw new FileNotFoundException();
            }
            xmlDbf.setValidating(false);
            DocumentBuilder xmlDb = xmlDbf.newDocumentBuilder();
            URL url = xmlFile.toURL();
            inDoc = xmlDb.parse(url.toString());
        }
        catch (FileNotFoundException fnfe) {
            throw fnfe;
        }
        catch (Exception e) {
            ThreadAnalyzer.logDebug(TAUtils.getNLSValue("ta.errmsg.XmlParseError", "XML parse error or XML input file not found") + ".  --" + e.getMessage());
            e.printStackTrace();
        }
        Element rootElem = inDoc.getDocumentElement();
        if (rootElem == null) {
            ThreadAnalyzer.logError(TAUtils.getNLSValue("ta.errmsg.CantReadXmlConfig", "Unable to read configuration xml document") + ".");
        }
        NodeList list = null;
        list = rootElem.getElementsByTagName("websphere");
        ThreadAnalyzer.traverse(null, rootElem, "edition", "");
        ThreadAnalyzer.traverse(null, rootElem, "version", "");
    }

    protected static void logDebug(String sMsg) {
        if (_logLevel >= 4) {
            System.err.println("DEBUG: " + sMsg);
        }
    }

    protected static void logError(String sMsg) {
        System.err.println(TAUtils.getNLSValue("ta.button.Error", "ERROR") + ": " + sMsg);
    }

    protected static void logInfo(String sMsg) {
        if (_logLevel >= 2) {
            System.err.println("INFO: " + sMsg);
        }
    }

    protected static String getAdminProperty(String property) {
        if (_adminProperties == null) {
            String wasHome = ThreadAnalyzer.getArg("was_home");
            String adminConfig = wasHome + "/bin/admin.config";
            _adminProperties = new Properties();
            try {
                _adminProperties.load(new FileInputStream(adminConfig));
            }
            catch (IOException e) {
                System.err.println(TAUtils.getNLSValue("ta.errmsg.CannotLoad", "Cannot load") + " " + adminConfig);
            }
        }
        String sRet = _adminProperties.getProperty(property);
        return sRet;
    }

    protected static void syntax() {
        System.out.println("ThreadAnalyzer");
        System.out.println("    " + TAUtils.getNLSValue("ta.string.syntax", "syntax") + ":");
        System.out.println("       { was_home=path to WebSphere (default from environment) }");
        System.out.println("       { serverName={servername | admin} }");
        System.out.println("       [ soapPort=portNumber (default is 8880) ]");
        System.out.println("       [ dumpOut=filename ] (default is temporary file)");
        System.out.println("       [ dumpWait=waitSeconds ] (time to wait for threaddump to complete) ");
        System.out.println("       [ reportType={ TEXT | HTML | NONE } ( default is HTML ) ] ");
        System.out.println("       [ logLevel={ERROR | DETAIL | DEBUG} ] (default:DETAIL)");
        System.out.println("       [ dumpIn=filename ]");
        System.out.println("       [ tmpDir={ dirname | SYSTEM } (default: SYSTEM) ]");
        System.out.println("       [ reportOut={ DEFAULT | filename } ] (default is [dumpOut].html) ");
        System.out.println("       [ dbDriver={JDBC driver class name} ]");
        System.out.println("       [ dbURL={JDBC server/database URL} ]");
        System.out.println();
    }

    public static String getArg(String argName) {
        String sRet = null;
        Arg arg = (Arg)_args.get(argName.toUpperCase());
        if (arg != null) {
            sRet = arg.get();
        } else {
            System.err.println(TAUtils.getNLSValue("ta.errmsg.CantFind", "can't find") + ": " + argName.toUpperCase());
        }
        return sRet;
    }

    public static void putArg(String argName, String argVal) {
        _args.put(argName.toUpperCase(), new Arg(argVal));
    }

    protected static void parseArgs(String[] args) {
        String wasHome;
        int i = 0;
        while (i < _validArgNames.length) {
            String sArg = null;
            if (_validArgNames[i].equals("dumpWait")) {
                sArg = "45";
            }
            if (_validArgNames[i].equals("detailXML")) {
                sArg = "./threadanalyzerdetail.xml";
            }
            if (_validArgNames[i].equals("reportOut")) {
                sArg = "default";
            }
            if (_validArgNames[i].equals("reportType")) {
                sArg = "html";
            }
            if (_validArgNames[i].equals("logLevel")) {
                sArg = "detail";
            }
            if (_validArgNames[i].equals("analyze")) {
                sArg = "all";
            }
            if (_validArgNames[i].equals("tmpDir")) {
                sArg = "SYSTEM";
            }
            if (_validArgNames[i].equals("dumpType")) {
                sArg = "old";
            }
            if (_validArgNames[i].equals("soapPort")) {
                sArg = "8880";
            }
            _args.put(_validArgNames[i].toUpperCase(), new Arg(sArg));
            ++i;
        }
        Object enum_ = null;
        String key = null;
        int i2 = 0;
        while (i2 < args.length) {
            int idx = args[i2].indexOf("=");
            if (idx > -1) {
                key = args[i2].substring(0, idx);
                if (_args.get(key.toUpperCase()) != null) {
                    String value = null;
                    idx = args[i2].toUpperCase().indexOf(key.toUpperCase() + "=");
                    if (idx == -1) {
                        ThreadAnalyzer.syntax();
                    }
                    if ((value = args[i2].substring((idx = args[i2].indexOf("=")) + 1)).length() <= 0) {
                        ThreadAnalyzer.syntax();
                    }
                    if (key.equalsIgnoreCase("logLevel")) {
                        if (value.equalsIgnoreCase("ERROR")) {
                            _logLevel = 0;
                        } else if (value.equalsIgnoreCase("WARN")) {
                            _logLevel = 1;
                        } else if (value.equalsIgnoreCase("INFO")) {
                            _logLevel = 2;
                        } else if (value.equalsIgnoreCase("DETAIL")) {
                            _logLevel = 3;
                        } else if (value.equalsIgnoreCase("DEBUG")) {
                            _logLevel = 4;
                        } else {
                            ThreadAnalyzer.syntax();
                        }
                    }
                    _args.put(key.toUpperCase(), new Arg(value));
                } else {
                    System.out.println(TAUtils.getNLSValue("ta.errmsg.InvalidArg", "Invalid argument") + ": " + key);
                }
            }
            ++i2;
        }
        if (ThreadAnalyzer.getArg("servername") == null && ThreadAnalyzer.getArg("dumpIn") == null) {
            System.err.println(TAUtils.getNLSValue("ta.errmsg.MustSpecifyServName", "serverName or dumpIn must be specified"));
            ThreadAnalyzer.syntax();
            System.exit(1);
        }
        if ((wasHome = ThreadAnalyzer.getArg("WAS_HOME")) == null) {
            wasHome = System.getProperty("WAS_HOME");
        }
        if (wasHome != null) {
            _args.put("WAS_HOME", new Arg(wasHome));
        }
    }
}

