/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.sdb.internal.editors;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Locale;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.internal.sdb.SDBDirective;
import org.eclipse.hyades.models.internal.sdb.SDBRuntime;
import org.eclipse.hyades.models.internal.sdb.SDBSolution;
import org.eclipse.hyades.models.internal.sdb.SDBSymptom;
import org.eclipse.hyades.models.internal.sdb.impl.SDBFactoryImpl;
import org.eclipse.hyades.sdb.internal.SDbPlugin;
import org.eclipse.hyades.sdb.internal.editors.DBContentProvider;
import org.eclipse.hyades.sdb.internal.editors.DBLabelProvider;
import org.eclipse.hyades.sdb.internal.editors.DetailsContent;
import org.eclipse.hyades.sdb.internal.editors.EditorPage;
import org.eclipse.hyades.sdb.internal.editors.SymptomDBEditor;
import org.eclipse.hyades.sdb.internal.help.ContextIds;
import org.eclipse.hyades.sdb.internal.util.GridUtil;
import org.eclipse.hyades.sdb.internal.util.RASWidgetFactory;
import org.eclipse.hyades.sdb.internal.util.SymptomDBSearchDialog;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.actions.SelectionListenerAction;
import org.eclipse.ui.help.WorkbenchHelp;

public class SymptomDBEditorDetailsPage
extends EditorPage
implements SelectionListener {
    private TreeViewer treeViewer;
    private DetailsContent details;
    private Menu popup;
    private FindAction findAction;
    private AddAction addAction;
    private AddSymptomAction addSymptomAction;
    private DeleteAction deleteAction;
    private Separator separator;
    private Button btnAdd;
    private Button btnDel;
    private Button btnSearch;
    private Object root;
    private EObject parentOfCurrentSel = null;
    private SDBFactoryImpl objFactory = null;
    private SymptomDBEditor fEditor;
    private EObject currentSelection = null;
    private boolean wasCurrentSelValidated = false;
    private static SymptomDBSearchDialog dialog;

    public SymptomDBEditorDetailsPage(RASWidgetFactory factory) {
        super(factory);
    }

    public void createContent(Composite parent) {
        this.createHeader(parent);
        Composite composite = this.factory.createComposite(parent);
        GridLayout detailLayout = new GridLayout();
        detailLayout.numColumns = 2;
        composite.setLayout((Layout)detailLayout);
        composite.setLayoutData((Object)GridUtil.createFill());
        this.createDetail(composite);
        Composite sepFooter = this.factory.createCompositeSeparator(composite);
        GridData sepFooterGrid = GridUtil.createHorizontalFill();
        sepFooterGrid.heightHint = 3;
        sepFooterGrid.horizontalSpan = 2;
        sepFooter.setLayoutData((Object)sepFooterGrid);
        this.createFooter(composite);
        this.factory.paintChildControlsFor(composite);
        this.treeViewer.setContentProvider((IContentProvider)new DBContentProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new DBLabelProvider());
        this.treeViewer.getTree().addSelectionListener((SelectionListener)this);
        this.objFactory = SDbPlugin.getDefault().getSDBFactory();
        this.makeActions();
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                SymptomDBEditorDetailsPage.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu((Control)this.treeViewer.getTree());
        this.treeViewer.getTree().setMenu(menu);
    }

    public void init(SymptomDBEditor editor) {
        this.fEditor = editor;
        if (this.getTreeRoot() != null) {
            this.details.init(this.fEditor);
        }
    }

    private void createHeader(Composite content) {
        Composite composite = this.factory.createCompositeSeparator(content);
    }

    private void createDetail(Composite composite) {
        Tree tree = this.factory.createTree(composite, 770);
        this.treeViewer = new TreeViewer(tree);
        GridData dummy = GridUtil.createFill();
        dummy.widthHint = 200;
        this.treeViewer.getTree().setLayoutData((Object)dummy);
        this.details = new DetailsContent(this.factory, composite, 0);
        this.details.createContent();
    }

    private void createFooter(Composite footer) {
        Composite buttons = this.factory.createComposite(footer);
        GridLayout buttonsLayout = new GridLayout();
        GridData data = GridUtil.createHorizontalFill();
        buttonsLayout.numColumns = 2;
        buttons.setLayout((Layout)buttonsLayout);
        buttons.setLayoutData((Object)data);
        this.createButtons(buttons);
    }

    private void createButtons(Composite buttons) {
        Composite update = this.factory.createComposite(buttons);
        GridLayout updateLayout = new GridLayout();
        GridData data = GridUtil.createHorizontalFill();
        updateLayout.numColumns = 4;
        update.setLayout((Layout)updateLayout);
        update.setLayoutData((Object)data);
        this.btnAdd = this.factory.createButton(update, SDbPlugin.getResourceString("STR_ADD_LABEL"), 8);
        GridData addGrid = new GridData(3);
        addGrid.widthHint = Locale.getDefault().toString().equals("en_US") ? 50 : 80;
        this.btnAdd.setLayoutData((Object)addGrid);
        this.btnDel = this.factory.createButton(update, SDbPlugin.getResourceString("STR_DELETE_LABEL"), 8);
        GridData delGrid = new GridData(3);
        delGrid.widthHint = Locale.getDefault().toString().equals("en_US") ? 50 : 80;
        this.btnDel.setLayoutData((Object)delGrid);
        Label label = new Label(update, 0);
        GridData labelGrid = new GridData(3);
        labelGrid.widthHint = 50;
        label.setLayoutData((Object)labelGrid);
        this.btnSearch = this.factory.createButton(update, SDbPlugin.getResourceString("STR_SEARCH_LABEL"), 8);
        GridData searchGrid = new GridData(3);
        searchGrid.widthHint = Locale.getDefault().toString().equals("en_US") ? 50 : 80;
        this.btnSearch.setLayoutData((Object)searchGrid);
        this.btnAdd.addSelectionListener((SelectionListener)this);
        this.btnDel.addSelectionListener((SelectionListener)this);
        this.btnSearch.addSelectionListener((SelectionListener)this);
    }

    public void fillContextMenu(IMenuManager menu) {
        IStructuredSelection selection = (IStructuredSelection)this.treeViewer.getSelection();
        this.updateActions(selection);
        Object object = selection.getFirstElement();
        if (object instanceof SDBSymptom) {
            menu.add((IAction)this.addSymptomAction);
            menu.add((IContributionItem)this.separator);
            WorkbenchHelp.setHelp((IAction)this.addSymptomAction, (String)ContextIds.SYMDB_EDITOR_POPUP_ADD_SYMPTOM);
        }
        if (object instanceof SDBRuntime || object instanceof SDBSymptom || object instanceof SDBSolution) {
            menu.add((IAction)this.addAction);
        }
        if (object instanceof SDBSymptom || object instanceof SDBSolution || object instanceof SDBDirective) {
            menu.add((IAction)this.deleteAction);
            WorkbenchHelp.setHelp((IAction)this.deleteAction, (String)ContextIds.SYMDB_EDITOR_POPUP_DELETE);
        }
    }

    protected void updateActions(IStructuredSelection selection) {
        this.addAction.selectionChanged(selection);
        this.addSymptomAction.selectionChanged(selection);
        this.deleteAction.selectionChanged(selection);
    }

    public void updateButtons(Object data) {
        if (data instanceof SDBRuntime) {
            this.btnAdd.setEnabled(true);
            this.btnDel.setEnabled(false);
        } else if (data instanceof SDBSymptom || data instanceof SDBSolution) {
            this.btnAdd.setEnabled(true);
            this.btnDel.setEnabled(true);
        } else if (data instanceof SDBDirective) {
            this.btnAdd.setEnabled(false);
            this.btnDel.setEnabled(true);
        } else {
            this.btnAdd.setEnabled(false);
            this.btnDel.setEnabled(false);
        }
    }

    private void makeActions() {
        this.addSymptomAction = new AddSymptomAction();
        this.separator = new Separator();
        this.addAction = new AddAction();
        this.deleteAction = new DeleteAction();
        if (this.findAction == null) {
            this.findAction = new FindAction(this);
        }
    }

    public Object getTreeRoot() {
        return ((Object[])this.root)[0];
    }

    public void setTreeRoot(Object newRoot) {
        this.root = newRoot;
        if (((Object[])this.root)[0] == null) {
            this.btnAdd.setEnabled(false);
            this.btnDel.setEnabled(false);
            this.btnSearch.setEnabled(false);
        }
    }

    public SymptomDBSearchDialog getDialog() {
        return dialog;
    }

    public void setDialog(SymptomDBSearchDialog dialog) {
        SymptomDBEditorDetailsPage.dialog = dialog;
    }

    public TreeViewer getViewer() {
        return this.treeViewer;
    }

    public Action getFindAction() {
        return this.findAction;
    }

    public void widgetDefaultSelected(SelectionEvent event) {
    }

    public void widgetSelected(SelectionEvent event) {
        this.statusErrorMessage("");
        if (event.item instanceof TreeItem) {
            EObject current = (EObject)event.item.getData();
            if (current == null) {
                return;
            }
            if (this.fEditor.isModelDirty()) {
                this.updateCurrentSelection(this.currentSelection);
            }
            this.details.showDetailsFor(current);
            if (current != this.currentSelection) {
                this.parentOfCurrentSel = current instanceof SDBSolution || current instanceof SDBDirective ? (EObject)((TreeItem)event.item).getParentItem().getData() : (current instanceof SDBSymptom ? (EObject)this.getTreeRoot() : null);
                this.currentSelection = current;
            }
            this.updateButtons(current);
            return;
        }
        if (event.widget == this.btnAdd) {
            TreeItem[] sel = this.treeViewer.getTree().getSelection();
            if (sel.length > 0) {
                this.add(new TreeSelection(sel[0]));
            } else {
                this.statusErrorMessage(SDbPlugin.getResourceString("STR_NO_SEL_ADD_MSG"));
            }
        }
        if (event.widget == this.btnDel) {
            TreeItem[] selection = this.treeViewer.getTree().getSelection();
            if (selection.length > 0) {
                Object[] sel = new Object[selection.length];
                int i = 0;
                while (i < selection.length) {
                    sel[i] = selection[i].getData();
                    ++i;
                }
                this.deleteAction.updateSelection((IStructuredSelection)new StructuredSelection(sel));
                this.deleteAction.run();
            } else {
                this.statusErrorMessage(SDbPlugin.getResourceString("STR_NO_SEL_DEL_MSG"));
            }
            return;
        }
        if (event.widget == this.btnSearch) {
            this.findAction.run();
        }
    }

    private void statusErrorMessage(String message) {
        IStatusLineManager manager = this.fEditor.getStatusLineManager();
        if (manager == null) {
            return;
        }
        manager.setMessage("");
        manager.setErrorMessage(message);
    }

    public EObject getCurrentSelection() {
        return this.currentSelection;
    }

    public EObject getParentOfCurrentSel() {
        return this.parentOfCurrentSel;
    }

    public boolean updateCurrentSelection(EObject currentSelection) {
        if (currentSelection != null) {
            this.details.updateCurrentSelection(currentSelection);
            this.fEditor.updateModelDirtyStatus(false);
            this.treeViewer.refresh();
            return true;
        }
        return false;
    }

    private void add(TreeSelection parentList) {
        SDBRuntime db;
        int i;
        if (!this.fEditor.validateState(null, null, null)) {
            return;
        }
        EObject parent = parentList.getObject();
        if (parent instanceof SDBRuntime) {
            SDBSymptom newSymptom = this.objFactory.createSDBSymptom();
            i = ((SDBRuntime)parent).getSymptoms().size();
            newSymptom.setDescription(SDbPlugin.getResourceString("STR_NEW_SYMPTOM_LABEL") + ++i);
            db = (SDBRuntime)this.getTreeRoot();
            db.getSymptoms().add((Object)newSymptom);
            this.treeViewer.add((Object)db, (Object)newSymptom);
            this.treeViewer.setExpandedState((Object)db, true);
            parentList.add((EObject)newSymptom);
        }
        if (parent instanceof SDBSymptom) {
            SDBSolution newSolution = this.objFactory.createSDBSolution();
            i = ((SDBRuntime)this.getTreeRoot()).getSolutions().size();
            newSolution.setDescription(SDbPlugin.getResourceString("STR_NEW_SOLUTION_INIT") + ++i);
            db = (SDBRuntime)this.getTreeRoot();
            db.getSolutions().add((Object)newSolution);
            ((SDBSymptom)parent).getSolutions().add((Object)newSolution);
            newSolution.getSymptoms().add((Object)((SDBSymptom)parent));
            this.treeViewer.add((Object)parent, (Object)newSolution);
            this.treeViewer.setExpandedState((Object)parent, true);
            parentList.add((EObject)newSolution);
        }
        if (parent instanceof SDBSolution) {
            SDBDirective newDirective = this.objFactory.createSDBDirective();
            i = ((SDBRuntime)this.getTreeRoot()).getDirectives().size();
            newDirective.setDescription(SDbPlugin.getResourceString("STR_NEW_DIRECTIVE_INIT") + ++i);
            newDirective.setDirectiveString("");
            db = (SDBRuntime)this.getTreeRoot();
            db.getDirectives().add((Object)newDirective);
            ((SDBSolution)parent).getDirectives().add((Object)newDirective);
            newDirective.getSolutions().add((Object)((SDBSolution)parent));
            this.treeViewer.add((Object)parent, (Object)newDirective);
            this.treeViewer.setExpandedState((Object)parent, true);
            parentList.add((EObject)newDirective);
        }
        this.setSelection(parentList.getSelection());
        this.fEditor.updateModelDirtyStatus(true);
        this.fEditor.updateUIDirtyStatus(true);
        this.details.setFocusFor(parentList.getObject());
    }

    private void addSymptom() {
        if (!this.fEditor.validateState(null, null, null)) {
            return;
        }
        SDBSymptom newSymptom = this.objFactory.createSDBSymptom();
        SDBRuntime db = (SDBRuntime)this.getTreeRoot();
        int i = db.getSymptoms().size();
        newSymptom.setDescription(SDbPlugin.getResourceString("STR_NEW_SYMPTOM_LABEL") + ++i);
        db.getSymptoms().add((Object)newSymptom);
        this.treeViewer.add((Object)db, (Object)newSymptom);
        this.fEditor.updateUIDirtyStatus(true);
        this.setSelection(new Object[]{this.getTreeRoot(), newSymptom, null, null});
        this.details.setFocusFor(newSymptom);
    }

    public void remove(ArrayList selections) {
        if (!this.fEditor.validateState(null, null, null)) {
            return;
        }
        ArrayList parents = new ArrayList();
        ArrayList current = null;
        int i = 0;
        i = 0;
        while (i < selections.size() - 1) {
            current = this.remove((TreeSelection)selections.get(i), false);
            parents.addAll(current);
            ++i;
        }
        current = this.remove((TreeSelection)selections.get(i), true);
        parents.addAll(current);
        i = 0;
        while (i < parents.size()) {
            this.treeViewer.refresh(parents.get(i));
            ++i;
        }
    }

    private ArrayList remove(TreeSelection sel, boolean newSel) {
        ArrayList<SDBRuntime> parentObj = new ArrayList<SDBRuntime>();
        Object[] selection = sel.getSelection();
        EObject object = sel.getObject();
        int index = -1;
        if (object instanceof SDBSymptom) {
            EList sol = ((SDBSymptom)object).getSolutions();
            ArrayList lst = new ArrayList();
            lst.addAll(sol);
            this.clearSolutions(object, lst);
            SDBRuntime db = (SDBRuntime)this.getTreeRoot();
            index = db.getSymptoms().indexOf((Object)((SDBSymptom)object));
            db.getSymptoms().remove((Object)((SDBSymptom)object));
            EList symptoms = db.getSymptoms();
            selection[1] = !symptoms.isEmpty() ? (index < symptoms.size() ? (SDBSymptom)symptoms.get(index) : (SDBSymptom)symptoms.get(index - 1)) : null;
            parentObj.add(db);
        } else if (object instanceof SDBSolution) {
            EList solutions;
            SDBSolution current = (SDBSolution)object;
            SDBSymptom parent = (SDBSymptom)sel.getSelection()[1];
            index = parent.getSolutions().indexOf((Object)current);
            parentObj.addAll((Collection<SDBRuntime>)current.getSymptoms());
            parent.getSolutions().remove((Object)current);
            current.getSymptoms().remove((Object)parent);
            if (current.getSymptoms().isEmpty()) {
                EList dir = current.getDirectives();
                ArrayList lst = new ArrayList();
                lst.addAll(dir);
                this.clearDirectives((EObject)current, lst);
                ((SDBRuntime)this.getTreeRoot()).getSolutions().remove((Object)current);
                this.details.updateRegistry((EObject)current, false);
            }
            selection[2] = !(solutions = parent.getSolutions()).isEmpty() ? (index < solutions.size() ? (SDBSolution)solutions.get(index) : (SDBSolution)solutions.get(index - 1)) : null;
        } else if (object instanceof SDBDirective) {
            EList directives;
            SDBDirective current = (SDBDirective)object;
            SDBSolution parent = (SDBSolution)sel.getSelection()[2];
            index = parent.getDirectives().indexOf((Object)current);
            int i = 0;
            while (i < current.getSolutions().size()) {
                parentObj.addAll((Collection<SDBRuntime>)((SDBSolution)current.getSolutions().get(i)).getSymptoms());
                ++i;
            }
            parent.getDirectives().remove((Object)current);
            current.getSolutions().remove((Object)parent);
            if (current.getSolutions().isEmpty()) {
                ((SDBRuntime)this.getTreeRoot()).getDirectives().remove((Object)current);
                this.details.updateRegistry((EObject)current, false);
            }
            selection[3] = !(directives = parent.getDirectives()).isEmpty() ? (index < directives.size() ? (SDBDirective)directives.get(index) : (SDBDirective)directives.get(index - 1)) : null;
        }
        this.fEditor.updateUIDirtyStatus(true);
        this.fEditor.updateModelDirtyStatus(false);
        if (newSel) {
            this.setSelection(selection);
        }
        return parentObj;
    }

    public void setSelection(Object[] sel) {
        if (sel[0] == null) {
            return;
        }
        TreeItem rootItem = this.treeViewer.getTree().getItems()[0];
        if (sel[1] == null) {
            this.notifyWidget(rootItem);
            return;
        }
        this.treeViewer.setExpandedState(this.root, true);
        TreeItem symptomItem = null;
        TreeItem[] items = rootItem.getItems();
        int i = 0;
        while (i < items.length) {
            Object data = items[i].getData();
            if (data != null && data.equals(sel[1])) {
                symptomItem = items[i];
                break;
            }
            ++i;
        }
        if (sel[2] == null) {
            this.notifyWidget(symptomItem);
            return;
        }
        symptomItem.setExpanded(true);
        this.treeViewer.refresh(sel[1]);
        TreeItem solItem = null;
        items = symptomItem.getItems();
        int i2 = 0;
        while (i2 < items.length) {
            Object data = items[i2].getData();
            if (data != null && data.equals(sel[2])) {
                solItem = items[i2];
                break;
            }
            ++i2;
        }
        if (sel[3] == null) {
            this.notifyWidget(solItem);
            return;
        }
        solItem.setExpanded(true);
        this.treeViewer.refresh(sel[1]);
        TreeItem directiveItem = null;
        items = solItem.getItems();
        int i3 = 0;
        while (i3 < items.length) {
            Object data = items[i3].getData();
            if (data != null && data.equals(sel[3])) {
                directiveItem = items[i3];
                break;
            }
            ++i3;
        }
        this.notifyWidget(directiveItem);
    }

    private void notifyWidget(TreeItem item) {
        Tree tree = this.treeViewer.getTree();
        tree.setSelection(new TreeItem[]{item});
        tree.showSelection();
        Event event = new Event();
        event.widget = tree;
        event.item = item;
        this.widgetSelected(new SelectionEvent(event));
    }

    private void clearSolutions(EObject parent, ArrayList lst) {
        int i = 0;
        while (i < lst.size()) {
            SDBSolution item = (SDBSolution)lst.get(i);
            EList dir = item.getDirectives();
            ArrayList dirLst = new ArrayList();
            dirLst.addAll(dir);
            item.getSymptoms().remove((Object)parent);
            if (item.getSymptoms().isEmpty()) {
                this.clearDirectives((EObject)item, dirLst);
                ((SDBRuntime)this.getTreeRoot()).getSolutions().remove((Object)item);
                this.details.updateRegistry((EObject)item, false);
            }
            ++i;
        }
        ((SDBSymptom)parent).getSolutions().clear();
        ((SDBSymptom)parent).getPatterns().clear();
    }

    private void clearDirectives(EObject parent, ArrayList lst) {
        int i = 0;
        while (i < lst.size()) {
            SDBDirective item = (SDBDirective)lst.get(i);
            item.getSolutions().remove((Object)parent);
            if (item.getSolutions().isEmpty()) {
                ((SDBRuntime)this.getTreeRoot()).getDirectives().remove((Object)item);
                this.details.updateRegistry((EObject)item, false);
            }
            ++i;
        }
        ((SDBSolution)parent).getDirectives().clear();
    }

    public class TreeSelection {
        private TreeItem selectedItem;
        private Object[] selection;

        public TreeSelection(TreeItem sel) {
            this.selectedItem = sel;
            this.selection = this.getSelectedObjectsFromTreeItem();
        }

        public Object[] getSelection() {
            return this.selection;
        }

        public void setSelection(Object[] newSel) {
            int i = 0;
            while (i < newSel.length) {
                this.selection[i] = newSel[i];
                ++i;
            }
        }

        public EObject getObject() {
            EObject object = null;
            if (this.selection[3] != null) {
                return (EObject)this.selection[3];
            }
            int i = 1;
            while (i < this.selection.length) {
                if (this.selection[i] == null) {
                    object = (EObject)this.selection[i - 1];
                    break;
                }
                ++i;
            }
            return object;
        }

        private Object[] getSelectedObjectsFromTreeItem() {
            Object current = this.selectedItem.getData();
            Object[] selection = new Object[4];
            if (current != null) {
                if (current instanceof SDBRuntime) {
                    selection[0] = current;
                } else if (current instanceof SDBSymptom) {
                    selection[0] = this.selectedItem.getParentItem().getData();
                    selection[1] = current;
                } else if (current instanceof SDBSolution) {
                    selection[0] = this.selectedItem.getParentItem().getParentItem().getData();
                    selection[1] = this.selectedItem.getParentItem().getData();
                    selection[2] = current;
                } else if (current instanceof SDBDirective) {
                    selection[3] = current;
                    TreeItem parent = this.selectedItem.getParentItem();
                    selection[2] = parent.getData();
                    selection[1] = parent.getParentItem().getData();
                    selection[0] = parent.getParentItem().getParentItem().getData();
                }
            }
            return selection;
        }

        public void add(EObject object) {
            if (object instanceof SDBRuntime) {
                this.selection[0] = object;
            } else if (object instanceof SDBSymptom) {
                this.selection[1] = object;
            } else if (object instanceof SDBSolution) {
                this.selection[2] = object;
            } else if (object instanceof SDBDirective) {
                this.selection[3] = object;
            }
        }
    }

    public class FindAction
    extends Action {
        private SymptomDBEditorDetailsPage page;

        public FindAction(SymptomDBEditorDetailsPage page) {
            this.page = page;
        }

        public void run() {
            SymptomDBSearchDialog dialog = this.page.getDialog();
            if (dialog != null && SymptomDBEditorDetailsPage.this.fEditor.getSite().getShell() != dialog.getParentShell()) {
                dialog.close();
            }
            if (dialog == null) {
                dialog = new SymptomDBSearchDialog(SymptomDBEditorDetailsPage.this.fEditor.getSite().getShell(), (SDBRuntime)SymptomDBEditorDetailsPage.this.getTreeRoot(), this.page);
                this.page.setDialog(dialog);
            } else {
                this.page.getDialog().setTarget(this.page);
            }
            dialog.open();
        }
    }

    class DeleteAction
    extends SelectionListenerAction {
        ArrayList selection = new ArrayList();

        public DeleteAction() {
            super(SDbPlugin.getResourceString("STR_DELETE_LABEL"));
        }

        public void run() {
            SymptomDBEditorDetailsPage.this.remove(this.selection);
        }

        public boolean updateSelection(IStructuredSelection s) {
            this.selection.clear();
            TreeItem[] sel = SymptomDBEditorDetailsPage.this.treeViewer.getTree().getSelection();
            if (!super.updateSelection(s)) {
                return false;
            }
            if (sel.length < 1) {
                return false;
            }
            int i = 0;
            while (i < sel.length) {
                Object current = sel[i].getData();
                if (!(current instanceof SDBSymptom || current instanceof SDBSolution || current instanceof SDBDirective)) {
                    return false;
                }
                this.selection.add(new TreeSelection(sel[i]));
                ++i;
            }
            return true;
        }
    }

    class AddSymptomAction
    extends SelectionListenerAction {
        Object selection;

        public AddSymptomAction() {
            super(SDbPlugin.getResourceString("STR_ADD_SYMPTOM_LABEL"));
        }

        public void run() {
            SymptomDBEditorDetailsPage.this.addSymptom();
        }

        public boolean updateSelection(IStructuredSelection s) {
            if (!super.updateSelection(s)) {
                return false;
            }
            if (s.isEmpty() || s.size() > 1) {
                return false;
            }
            Iterator i = s.iterator();
            if (i.hasNext()) {
                Object current = i.next();
                if (current instanceof SDBSymptom) {
                    this.selection = (SDBSymptom)current;
                } else {
                    return false;
                }
            }
            return true;
        }
    }

    class AddAction
    extends SelectionListenerAction {
        TreeSelection selection;

        public AddAction() {
            super(SDbPlugin.getResourceString("STR_ADD_LABEL"));
        }

        public void run() {
            SymptomDBEditorDetailsPage.this.add(this.selection);
        }

        public boolean updateSelection(IStructuredSelection s) {
            TreeItem[] sel = SymptomDBEditorDetailsPage.this.treeViewer.getTree().getSelection();
            if (!super.updateSelection(s)) {
                return false;
            }
            if (sel.length == 0 || sel.length > 1) {
                return false;
            }
            TreeItem item = sel[0];
            this.selection = new TreeSelection(item);
            Object current = item.getData();
            if (current != null) {
                if (current instanceof SDBRuntime) {
                    this.setText(SDbPlugin.getResourceString("STR_ADD_SYMPTOM_LABEL"));
                    WorkbenchHelp.setHelp((IAction)SymptomDBEditorDetailsPage.this.addAction, (String)ContextIds.SYMDB_EDITOR_POPUP_ADD_SYMPTOM);
                } else if (current instanceof SDBSymptom) {
                    this.setText(SDbPlugin.getResourceString("STR_ADD_SOLUTION_LABEL"));
                    WorkbenchHelp.setHelp((IAction)SymptomDBEditorDetailsPage.this.addAction, (String)ContextIds.SYMDB_EDITOR_POPUP_ADD_SOLUTION);
                } else if (current instanceof SDBSolution) {
                    this.setText(SDbPlugin.getResourceString("STR_ADD_DIRECTIVE_LABEL"));
                    WorkbenchHelp.setHelp((IAction)SymptomDBEditorDetailsPage.this.addAction, (String)ContextIds.SYMDB_EDITOR_POPUP_ADD_DIRECTIVE);
                } else if (current instanceof SDBDirective) {
                    return false;
                }
            }
            return true;
        }
    }
}

