/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.sdb.internal.editors;

import java.util.ArrayList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.internal.sdb.SDBMatchPattern;
import org.eclipse.hyades.models.internal.sdb.SDBSymptom;
import org.eclipse.hyades.models.internal.sdb.impl.SDBFactoryImpl;
import org.eclipse.hyades.sdb.internal.SDbPlugin;
import org.eclipse.hyades.sdb.internal.editors.IDetails;
import org.eclipse.hyades.sdb.internal.editors.SymptomDBEditor;
import org.eclipse.hyades.sdb.internal.help.ContextIds;
import org.eclipse.hyades.sdb.internal.util.GridUtil;
import org.eclipse.hyades.sdb.internal.util.RASWidgetFactory;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.help.WorkbenchHelp;

public class SymptomDetails
extends Composite
implements IDetails,
Listener {
    Text txtSymptom;
    Text lstMatch;
    private SDBFactoryImpl objFactory = null;
    private SymptomDBEditor editor;
    private SDBSymptom currentSel = null;
    private boolean isDisplaying = false;

    public SymptomDetails(RASWidgetFactory factory, Composite composite, int style) {
        super(composite, style);
        GridLayout descLayout = new GridLayout();
        descLayout.numColumns = 1;
        this.setLayout((Layout)descLayout);
        this.setLayoutData(GridUtil.createFill());
        Label lblSymptom = factory.createLabel(this, SDbPlugin.getResourceString("STR_SYMPTOM_LABEL"), 0);
        this.txtSymptom = factory.createText(this, "", 0);
        this.txtSymptom.setLayoutData((Object)GridUtil.createHorizontalFill());
        factory.createCompositeSeparator(this);
        Label lblMatch = factory.createLabel(this, SDbPlugin.getResourceString("STR_MATCH_SYMPTOM_LABEL"), 0);
        GridData lblMatchLayout = new GridData(768);
        lblMatch.setLayoutData((Object)lblMatchLayout);
        this.lstMatch = factory.createText(this, "", 770);
        GridData lstMatchLayout = new GridData(1808);
        lstMatchLayout.heightHint = 45;
        lstMatchLayout.verticalSpan = 3;
        this.lstMatch.setLayoutData((Object)lstMatchLayout);
        WorkbenchHelp.setHelp((Control)this.txtSymptom, (String)ContextIds.SYMDB_EDITOR_SYMPTOM);
        WorkbenchHelp.setHelp((Control)this.lstMatch, (String)ContextIds.SYMDB_EDITOR_SYMPTOM_DESCRIPTION);
        this.txtSymptom.addListener(24, (Listener)this);
        this.lstMatch.addListener(24, (Listener)this);
    }

    public void init(SymptomDBEditor editor) {
        this.editor = editor;
        this.objFactory = SDbPlugin.getDefault().getSDBFactory();
    }

    public void display(EObject object) {
        this.isDisplaying = true;
        this.currentSel = (SDBSymptom)object;
        this.txtSymptom.setText(this.currentSel.getDescription());
        this.lstMatch.setText(this.getMatchPattern());
        this.isDisplaying = false;
    }

    public void setFocusToTextBox() {
        this.txtSymptom.setFocus();
        this.txtSymptom.setSelection(0, this.txtSymptom.getText().length());
    }

    public void handleEvent(Event e) {
        Widget source = e.widget;
        if (source == this.txtSymptom || source == this.lstMatch) {
            boolean status = false;
            if (source == this.txtSymptom && !this.isDisplaying) {
                status = this.editor.validateState((Widget)this.txtSymptom, this, this.currentSel.getDescription());
            }
            if (source == this.lstMatch && !this.isDisplaying) {
                status = this.editor.validateState((Widget)this.lstMatch, this, this.getMatchPattern());
            }
            if (this.currentSel != null && !this.isDisplaying && status) {
                this.editor.updateUIDirtyStatus(true);
                this.editor.updateModelDirtyStatus(true);
            }
        }
    }

    private String getMatchPattern() {
        String pattern = "";
        EList lstPattern = this.currentSel.getPatterns();
        String nl = System.getProperties().getProperty("line.separator");
        int size = lstPattern.size();
        int i = 0;
        while (i < size) {
            pattern = pattern + ((SDBMatchPattern)lstPattern.get(i)).getValue() + (i == size - 1 ? "" : nl);
            ++i;
        }
        return pattern;
    }

    private ArrayList getPatternLines() {
        ArrayList<String> lines = new ArrayList<String>();
        String text = this.lstMatch.getText();
        String nl = System.getProperties().getProperty("line.separator");
        int i = 0;
        int j = 0;
        while (i <= text.length()) {
            j = text.indexOf(nl, i);
            if (j <= -1) {
                lines.add(text.substring(i));
                break;
            }
            lines.add(text.substring(i, j));
            i = j + nl.length();
        }
        return lines;
    }

    public boolean updateCurrentSelection(EObject sel) {
        this.currentSel = (SDBSymptom)sel;
        this.currentSel.setDescription(this.txtSymptom.getText());
        EList lstPattern = this.currentSel.getPatterns();
        int l = lstPattern.size();
        ArrayList lines = this.getPatternLines();
        int s = lines.size();
        if (s == 1 && ((String)lines.get(0)).equals("")) {
            this.currentSel.getPatterns().clear();
            return true;
        }
        if (l > s) {
            int i = 0;
            while (i < s) {
                ((SDBMatchPattern)lstPattern.get(i)).setValue((String)lines.get(i));
                ++i;
            }
            ArrayList<Object> delPattern = new ArrayList<Object>();
            int i2 = s;
            while (i2 < l) {
                delPattern.add(lstPattern.get(i2));
                ++i2;
            }
            this.currentSel.getPatterns().removeAll(delPattern);
        } else {
            int i = 0;
            while (i < l) {
                ((SDBMatchPattern)lstPattern.get(i)).setValue((String)lines.get(i));
                ++i;
            }
            if (l < s) {
                int i3 = l;
                while (i3 < s) {
                    SDBMatchPattern match = this.objFactory.createSDBMatchPattern();
                    match.setValue((String)lines.get(i3));
                    this.currentSel.getPatterns().add((Object)match);
                    ++i3;
                }
            }
        }
        return true;
    }
}

