/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.sdb.internal.preferences;

import java.util.ArrayList;
import org.eclipse.hyades.sdb.internal.SDbPlugin;
import org.eclipse.hyades.sdb.internal.SDbPluginImages;
import org.eclipse.hyades.sdb.internal.help.ContextIds;
import org.eclipse.hyades.sdb.internal.util.GridUtil;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.help.WorkbenchHelp;

public class SymptomDBurl
implements SelectionListener {
    private Composite result;
    private Table _list;
    private Button _moveUp;
    private Button _moveDown;
    private Button _restoreDefaults;
    private ArrayList _data = new ArrayList();
    private Item _oldSelection;
    private Button _add;
    private Button _edit;
    private Button _delete;
    private static final int _restoreDefaultsButtonId = 1025;

    public Composite createControl(Composite parent) {
        this.result = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.verticalSpacing = 15;
        this.result.setLayout((Layout)layout);
        GridData data = GridUtil.createFill();
        data.heightHint = 400;
        data.widthHint = 400;
        this.result.setLayoutData((Object)data);
        Label label = new Label(this.result, 0);
        data = GridUtil.createHorizontalFill();
        data.horizontalSpan = 3;
        data.heightHint = 10;
        label.setLayoutData((Object)data);
        Label description = new Label(this.result, 0);
        description.setText(SDbPlugin.getResourceString("STR_DB_URL_LOCATIONS"));
        Composite dataComp = new Composite(this.result, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        dataComp.setLayout((Layout)layout);
        data = GridUtil.createFill();
        data.heightHint = 250;
        data.horizontalSpan = 3;
        dataComp.setLayoutData((Object)data);
        this._list = new Table(dataComp, 2304);
        data = GridUtil.createFill();
        this._list.setLayoutData((Object)data);
        Composite buttonWidget = new Composite(dataComp, 0);
        data = new GridData();
        data.grabExcessVerticalSpace = true;
        data.verticalAlignment = 4;
        buttonWidget.setLayoutData((Object)data);
        GridLayout blayout = new GridLayout();
        blayout.numColumns = 1;
        buttonWidget.setLayout((Layout)blayout);
        this._moveUp = new Button(buttonWidget, 0);
        data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        this._moveUp.setLayoutData((Object)data);
        this._moveUp.setText(SDbPlugin.getResourceString("STR_COL_DLG_UP"));
        this._moveDown = new Button(buttonWidget, 0);
        data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        this._moveDown.setLayoutData((Object)data);
        this._moveDown.setText(SDbPlugin.getResourceString("STR_COL_DLG_DOWN"));
        label = new Label(buttonWidget, 0);
        this._edit = new Button(buttonWidget, 0);
        data = GridUtil.createHorizontalFill();
        data.horizontalAlignment = 4;
        data.verticalAlignment = 2;
        this._edit.setLayoutData((Object)data);
        this._edit.setText(SDbPlugin.getResourceString(SDbPlugin.getResourceString("STR_EDIT_LOCATION")));
        this._add = new Button(buttonWidget, 0);
        data = GridUtil.createHorizontalFill();
        data.horizontalAlignment = 4;
        data.verticalAlignment = 2;
        this._add.setLayoutData((Object)data);
        this._add.setText(SDbPlugin.getResourceString(SDbPlugin.getResourceString("STR_ADD_LOCATION")));
        this._delete = new Button(buttonWidget, 0);
        data = GridUtil.createHorizontalFill();
        data.horizontalAlignment = 4;
        data.verticalAlignment = 2;
        this._delete.setLayoutData((Object)data);
        this._delete.setText(SDbPlugin.getResourceString(SDbPlugin.getResourceString("STR_DEL_LOCATION")));
        this._list.addSelectionListener((SelectionListener)this);
        this._moveUp.addSelectionListener((SelectionListener)this);
        this._moveDown.addSelectionListener((SelectionListener)this);
        this._add.addSelectionListener((SelectionListener)this);
        this._edit.addSelectionListener((SelectionListener)this);
        this._delete.addSelectionListener((SelectionListener)this);
        this._moveUp.setEnabled(false);
        this._moveDown.setEnabled(false);
        WorkbenchHelp.setHelp((Control)this._list, (String)ContextIds.SYMDB_PREF_URL);
        return this.result;
    }

    public ArrayList getData() {
        return this._data;
    }

    protected void moveDown(int idx) {
        TableItem item = this._list.getItem(idx);
        ColumnData data = (ColumnData)item.getData();
        TableItem newitem = new TableItem(this._list, 32, idx + 2);
        newitem.setImage(SDbPluginImages.getImage("symptomdb_desc_obj.gif"));
        newitem.setChecked(item.getChecked());
        newitem.setText(item.getText());
        newitem.setData((Object)data);
        newitem.setGrayed(item.getGrayed());
        this._list.remove(idx);
        this._list.select(idx + 1);
    }

    protected void moveUp(int idx) {
        TableItem item = this._list.getItem(idx);
        ColumnData data = (ColumnData)item.getData();
        if (idx > 0) {
            TableItem previousItem = this._list.getItem(idx - 1);
            ColumnData previousItemData = (ColumnData)previousItem.getData();
        }
        TableItem newitem = new TableItem(this._list, 32, idx - 1);
        newitem.setChecked(item.getChecked());
        newitem.setText(item.getText());
        newitem.setImage(SDbPluginImages.getImage("symptomdb_desc_obj.gif"));
        newitem.setData((Object)data);
        newitem.setGrayed(item.getGrayed());
        this._list.remove(idx + 1);
        this._list.select(idx - 1);
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        this.widgetSelected(e);
    }

    public void widgetSelected(SelectionEvent e) {
        ColumnData data;
        int idx;
        if (e.widget == this._moveUp) {
            idx = this._list.getSelectionIndex();
            if (idx > 0) {
                this.moveUp(idx);
            }
        } else if (e.widget == this._moveDown) {
            idx = this._list.getSelectionIndex();
            if (idx != -1 && idx < this._list.getItemCount() - 1) {
                this.moveDown(idx);
            }
        } else if (e.widget == this._add) {
            this.showUrlDialog(SDbPlugin.getResourceString("STR_URL_LOCATION_DLG"), null, null);
        } else if (e.widget == this._edit) {
            idx = this._list.getSelectionIndex();
            if (idx != -1 && (data = (ColumnData)this._list.getItem(idx).getData()) != null) {
                this.showUrlDialog(SDbPlugin.getResourceString("STR_EURL_LOCATION_DLG"), data.name(), data.url());
            }
        } else if (e.widget == this._delete && (idx = this._list.getSelectionIndex()) != -1) {
            this._list.getItem(idx).dispose();
        }
        idx = this._list.getSelectionIndex();
        data = null;
        ColumnData previousData = null;
        if (idx > 0) {
            previousData = (ColumnData)this._list.getItem(idx - 1).getData();
        }
        if (idx != -1) {
            data = (ColumnData)this._list.getItem(idx).getData();
        }
        this._moveUp.setEnabled(data != null && previousData != null);
        this._moveDown.setEnabled(data != null && idx < this._list.getItemCount() - 1);
        this._delete.setEnabled(idx != -1);
        this._edit.setEnabled(idx != -1);
    }

    public void storeValues(IPreferenceStore store) {
        String str = "";
        int idx = 0;
        while (idx < this._list.getItemCount()) {
            TableItem item = this._list.getItem(idx);
            ColumnData data = (ColumnData)item.getData();
            if (str != null) {
                str = str + "\n" + data.name() + "\t" + data.url();
            }
            ++idx;
        }
        if (str.startsWith("\n") && str.length() > 1) {
            str = str.substring(1);
        }
        store.setValue("symptom_db_url", str);
    }

    private void showUrlDialog(String title, String name, String value) {
        EditDialog dialog = new EditDialog(this.result.getShell(), title, name, value);
        dialog.open();
        if (dialog.getReturnCode() == 0) {
            if (name == null) {
                ColumnData data = new ColumnData(dialog.name(), dialog.value());
                TableItem item = new TableItem(this._list, 0);
                item.setText(data.name() + "[" + data.url() + "]");
                item.setImage(SDbPluginImages.getImage("symptomdb_desc_obj.gif"));
                item.setData((Object)data);
            } else {
                TableItem item;
                ColumnData data;
                int idx = this._list.getSelectionIndex();
                if (idx != -1 && (data = (ColumnData)(item = this._list.getItem(idx)).getData()) != null) {
                    data.name(dialog.name());
                    data.url(dialog.value());
                    item.setText(data.name() + " [ " + data.url() + " ] ");
                }
            }
        }
    }

    public void initializeValues(String urls) {
        int idx;
        while (this._list.getItemCount() > 0) {
            this._list.getItem(0).dispose();
        }
        if (urls != null && !urls.equals("")) {
            idx = urls.indexOf("\n");
            while (idx != -1) {
                String value = urls.substring(0, idx);
                int i = value.indexOf("\t");
                if (i != -1) {
                    ColumnData data = new ColumnData(value.substring(0, i), value.substring(i + 1));
                    TableItem item = new TableItem(this._list, 0);
                    item.setText(data.name() + " [ " + data.url() + " ] ");
                    item.setImage(SDbPluginImages.getImage("symptomdb_desc_obj.gif"));
                    item.setData((Object)data);
                }
                urls = urls.substring(idx + 1);
                idx = urls.indexOf("\n");
            }
            int i = urls.indexOf("\t");
            if (i != -1) {
                ColumnData data = new ColumnData(urls.substring(0, i), urls.substring(i + 1));
                TableItem item = new TableItem(this._list, 0);
                item.setText(data.name() + " [ " + data.url() + " ] ");
                item.setImage(SDbPluginImages.getImage("symptomdb_desc_obj.gif"));
                item.setData((Object)data);
            }
        }
        this._delete.setEnabled((idx = this._list.getSelectionIndex()) != -1);
        this._edit.setEnabled(idx != -1);
    }

    class ColumnData {
        private String _name;
        private String _url;

        public ColumnData(String name, String url) {
            this._name = name;
            this._url = url;
        }

        public String name() {
            return this._name;
        }

        public String url() {
            return this._url;
        }

        public void name(String name) {
            this._name = name;
        }

        public void url(String url) {
            this._url = url;
        }
    }

    class EditDialog
    extends Dialog
    implements ModifyListener {
        private String _name;
        private String _value;
        private Text _nameText;
        private Text _valueText;
        private String _title;

        public EditDialog(Shell shell, String title, String name, String value) {
            super(shell);
            this._name = name;
            this._value = value;
            this._title = title;
        }

        protected void configureShell(Shell shell) {
            super.configureShell(shell);
            shell.setText(this._title);
        }

        public void name(String name) {
            this._name = name;
        }

        public String name() {
            return this._name;
        }

        public void value(String value) {
            this._value = value;
        }

        public String value() {
            return this._value;
        }

        protected Control createDialogArea(Composite parent) {
            Composite result = (Composite)super.createDialogArea(parent);
            GridLayout layout = new GridLayout();
            layout.numColumns = 2;
            result.setLayout((Layout)layout);
            GridData data = GridUtil.createFill();
            data.widthHint = 400;
            result.setLayoutData((Object)data);
            Label label = new Label(result, 0);
            label.setText(SDbPlugin.getResourceString("STR_URL_DB_NAME"));
            this._nameText = new Text(result, 2048);
            this._nameText.setLayoutData((Object)GridUtil.createHorizontalFill());
            label = new Label(result, 0);
            label.setText(SDbPlugin.getResourceString("STR_URL_DB_URL"));
            this._valueText = new Text(result, 2048);
            this._valueText.setLayoutData((Object)GridUtil.createHorizontalFill());
            this._nameText.addModifyListener((ModifyListener)this);
            this._valueText.addModifyListener((ModifyListener)this);
            if (this._name != null) {
                this._nameText.setText(this._name);
            }
            if (this._value != null) {
                this._valueText.setText(this._value);
            }
            if (this._title.equals(SDbPlugin.getResourceString("STR_URL_LOCATION_DLG"))) {
                WorkbenchHelp.setHelp((Control)this._nameText, (String)ContextIds.SYMDB_PREF_URL_ADD_DIALOG_NAME);
                WorkbenchHelp.setHelp((Control)this._valueText, (String)ContextIds.SYMDB_PREF_URL_ADD_DIALOG_URL);
            } else if (this._title.equals(SDbPlugin.getResourceString("STR_EURL_LOCATION_DLG"))) {
                WorkbenchHelp.setHelp((Control)this._nameText, (String)ContextIds.SYMDB_PREF_URL_EDIT_DIALOG_NAME);
                WorkbenchHelp.setHelp((Control)this._valueText, (String)ContextIds.SYMDB_PREF_URL_EDIT_DIALOG_URL);
            }
            return result;
        }

        public void modifyText(ModifyEvent e) {
            if ((e.widget == this._nameText || e.widget == this._valueText) && this.getButton(0) != null) {
                this.getButton(0).setEnabled(this._nameText.getText().trim() != "");
            }
        }

        protected void okPressed() {
            this._name = this._nameText.getText().trim();
            this._value = this._valueText.getText().trim();
            super.okPressed();
        }
    }
}

