/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.adapter.builder;

import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.hyades.logging.adapter.Adapter;
import org.eclipse.hyades.logging.adapter.AdapterException;

public class Builder
extends IncrementalProjectBuilder {
    protected IProject[] build(int kind, Map args, IProgressMonitor monitor) throws CoreException {
        if (kind == 6) {
            this.fullBuild(monitor);
        } else {
            IResourceDelta delta = this.getDelta(this.getProject());
            if (delta == null) {
                this.fullBuild(monitor);
            } else {
                this.incrementalBuild(delta, monitor);
            }
        }
        return null;
    }

    private void fullBuild(IProgressMonitor monitor) throws CoreException {
        this.getProject().accept((IResourceVisitor)new MyBuildVisitor());
    }

    private void incrementalBuild(IResourceDelta delta, IProgressMonitor monitor) throws CoreException {
        delta.accept((IResourceDeltaVisitor)new MyBuildDeltaVisitor());
    }

    private void buildResource(IResource resource) {
        block6: {
            try {
                resource.deleteMarkers("org.eclipse.hyades.logging.adapter.glaproblemmarker", true, 2);
            }
            catch (CoreException e) {
                // empty catch block
            }
            Adapter adapter = new Adapter();
            String path = resource.getLocation().toOSString();
            adapter.setComponentConfigPath(path);
            adapter.setContextConfigPath(path);
            try {
                adapter.validate();
            }
            catch (AdapterException e) {
                try {
                    IMarker marker = resource.createMarker("org.eclipse.hyades.logging.adapter.glaproblemmarker");
                    if (!marker.exists()) break block6;
                    marker.setAttribute("message", (Object)e.getLocalizedMessage());
                    marker.setAttribute("priority", 2);
                    marker.setAttribute("userEditable", true);
                }
                catch (CoreException eprime) {}
            }
        }
    }

    class MyBuildDeltaVisitor
    implements IResourceDeltaVisitor {
        public boolean visit(IResourceDelta delta) {
            IResource resource = delta.getResource();
            if (resource.getType() == 1) {
                Builder.this.buildResource(resource);
            }
            return true;
        }
    }

    class MyBuildVisitor
    implements IResourceVisitor {
        public boolean visit(IResource res) {
            if (res.getType() == 1) {
                Builder.this.buildResource(res);
            }
            return true;
        }
    }
}

