/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.adapter.ui.internal.util;

import java.util.Vector;
import org.eclipse.hyades.logging.adapter.ui.internal.util.ResultQueueEntry;

public class ResultQueue {
    private Vector entries = new Vector();
    private Vector partialResults = new Vector();
    private boolean valid = true;
    private int lockCount = 0;
    private int maxSize = 10;

    public void insertExtractorResult(Object entry) {
        ResultQueueEntry pair = new ResultQueueEntry();
        pair.extractorOutput = entry;
        this.partialResults.add(pair);
    }

    public void insertFormatterResult(Object entry) {
        ResultQueueEntry pair = (ResultQueueEntry)this.partialResults.remove(0);
        pair.formatterOutput = entry;
        this.insert(pair);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(int index) {
        int loopCount = 200;
        ResultQueue resultQueue = this;
        synchronized (resultQueue) {
            ++this.lockCount;
            while (index >= this.entries.size() && this.valid && loopCount > 0) {
                --loopCount;
                try {
                    ResultQueue resultQueue2 = this;
                    synchronized (resultQueue2) {
                        this.wait(10L);
                    }
                }
                catch (InterruptedException eprme) {
                    // empty catch block
                }
            }
            --this.lockCount;
            if (index >= this.entries.size()) {
                return null;
            }
            return this.entries.get(index);
        }
    }

    public Object getFirstEntry() {
        if (this.entries.size() > 0) {
            return this.entries.firstElement();
        }
        return "";
    }

    public Object getLastEntry() {
        if (this.entries.size() > 0) {
            return this.entries.lastElement();
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insert(Object entry) {
        ResultQueue resultQueue = this;
        synchronized (resultQueue) {
            ++this.lockCount;
            while (this.isFull() && this.valid) {
                ResultQueue resultQueue2 = this;
                synchronized (resultQueue2) {
                    try {
                        this.wait(1000L);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                }
            }
            if (!this.isFull() && this.valid) {
                this.entries.add(entry);
            }
            --this.lockCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object remove() {
        boolean isFull = this.isFull();
        Object result = this.entries.remove(0);
        if (isFull) {
            ResultQueue resultQueue = this;
            synchronized (resultQueue) {
                this.notifyAll();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        ResultQueue resultQueue = this;
        synchronized (resultQueue) {
            this.partialResults.removeAllElements();
            this.entries.removeAllElements();
            this.valid = false;
            while (this.lockCount-- > 0) {
                this.notifyAll();
            }
        }
    }

    public boolean isFull() {
        return this.entries.size() >= this.maxSize;
    }

    public void setMaxSize(int size) {
        this.maxSize = size;
    }

    public int getSize() {
        return this.entries.size();
    }

    public int getMaxSize() {
        return this.maxSize;
    }
}

