/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.models.internal.sdb.loader;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.models.internal.sdb.SDBDirective;
import org.eclipse.hyades.models.internal.sdb.SDBFactory;
import org.eclipse.hyades.models.internal.sdb.SDBMatchPattern;
import org.eclipse.hyades.models.internal.sdb.SDBRuntime;
import org.eclipse.hyades.models.internal.sdb.SDBSolution;
import org.eclipse.hyades.models.internal.sdb.SDBSymptom;
import org.eclipse.hyades.models.internal.sdb.impl.SDBFactoryImpl;
import org.eclipse.hyades.models.internal.sdb.impl.SDBPackageImpl;
import org.eclipse.hyades.models.internal.sdb.impl.SDBResourceFactoryImpl;
import org.eclipse.hyades.models.internal.sdb.impl.SDBResourceSetImpl;
import org.eclipse.hyades.models.internal.sdb.loader.IConstants;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class SDBLoader
extends DefaultHandler
implements IConstants {
    private HashMap _directives = new HashMap();
    private HashMap _references = new HashMap();
    private HashMap _solutions = new HashMap();
    private IProgressMonitor _monitor;
    private SDBFactory _factory;
    private SDBResourceSetImpl _resourceSet;
    private SDBRuntime _symptomDB;
    private SDBSymptom _symptom;
    private String errMsg;
    private StringBuffer buffer = new StringBuffer();
    private int counter;

    public SDBLoader() {
        SDBPackageImpl.init();
        this._factory = new SDBFactoryImpl();
        this._resourceSet = new SDBResourceSetImpl();
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("trcdbxmi", new SDBResourceFactoryImpl());
    }

    public String getErrorMessage() {
        return this.errMsg;
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        this.buffer.append(ch, start, length);
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        if (qName.equals("matchsymptomv")) {
            this.createMatchPattern();
        } else if (qName.equals("symptominfov")) {
            this.createSolution();
        }
        this.buffer.setLength(0);
    }

    public void error(SAXParseException ex) {
        this.errMsg = ex.getMessage();
        LoadersUtils.log((Throwable)ex);
    }

    public void fatalError(SAXParseException ex) throws SAXException {
        this.errMsg = ex.getMessage();
        LoadersUtils.log((Throwable)ex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadDatabase(String xmlFileName, String destination, IProgressMonitor mon) throws Exception {
        try {
            this._monitor = mon;
            File xmlFile = new File(xmlFileName);
            int length = (int)xmlFile.length();
            this._monitor.beginTask(xmlFileName, length / 1000);
            this.createRuntime(destination);
            if (this._symptomDB != null) {
                this._symptomDB.setLocalExternalFileLocation(xmlFileName);
            }
            this.parse(xmlFileName);
        }
        finally {
            try {
                HashMap<String, Boolean> options = new HashMap<String, Boolean>();
                options.put("DECLARE_XML", Boolean.TRUE);
                this._symptomDB.eResource().save(options);
            }
            catch (Exception exc) {
                this.errMsg = exc.toString();
                this._monitor.done();
                LoadersUtils.log((Throwable)exc);
            }
            this._monitor.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadDatabase(InputStream is, String urlLocation, String destination, IProgressMonitor mon) throws Exception {
        try {
            this._monitor = mon;
            this._monitor.beginTask(urlLocation, 100);
            this.createRuntime(destination);
            if (this._symptomDB != null) {
                this._symptomDB.setSymptomUrl(urlLocation);
                this._symptomDB.setName(destination);
            }
            this.parse(is);
        }
        finally {
            try {
                HashMap<String, Boolean> options = new HashMap<String, Boolean>();
                options.put("DECLARE_XML", Boolean.TRUE);
                this._symptomDB.eResource().save(options);
            }
            catch (Exception exc) {
                this.errMsg = exc.toString();
                this._monitor.done();
                LoadersUtils.log((Throwable)exc);
            }
            this._monitor.done();
        }
    }

    public void parse(String symptomDBFile) throws Exception {
        this.errMsg = null;
        FileInputStream is = new FileInputStream(symptomDBFile);
        if (is == null) {
            return;
        }
        this.parse(is);
    }

    protected SAXParser makeParser() throws ParserConfigurationException, SAXException {
        SAXParserFactory f = SAXParserFactory.newInstance();
        f.setValidating(false);
        return f.newSAXParser();
    }

    public void parse(InputStream is) throws Exception {
        this.errMsg = null;
        if (is == null) {
            return;
        }
        InputSource inputSource = new InputSource(is);
        try {
            SAXParser parser = this.makeParser();
            parser.parse(inputSource, (DefaultHandler)this);
            is.close();
        }
        catch (SAXException se) {
            this.errMsg = se.getMessage();
            LoadersUtils.log((Throwable)se);
        }
        catch (IOException ioe) {
            this.errMsg = ioe.getMessage();
            LoadersUtils.log((Throwable)ioe);
        }
    }

    public void startElement(String namespaceURI, String localName, String elementName, Attributes atts) throws SAXException {
        if (elementName.equals("runtime")) {
            this.createRuntime(atts);
        } else if (elementName.equals("matchPattern")) {
            this.createMatchPattern(atts);
        } else if (elementName.equals("solution")) {
            this.createSolution(atts);
        } else if (elementName.equals("symptom")) {
            this.createSymptom(atts);
        } else if (elementName.equals("directive")) {
            this.createDirective(atts);
        } else if (elementName.equals("symrec")) {
            this.createV4Symptom(atts);
        }
    }

    public void warning(SAXParseException ex) {
        this.errMsg = ex.getMessage();
        LoadersUtils.log((Throwable)ex);
    }

    private void addReference(String id, Object reference) {
        Object refs = this._references.get(id);
        if (refs != null) {
            ((ArrayList)refs).add(reference);
        } else {
            ArrayList<Object> list = new ArrayList<Object>();
            list.add(reference);
            this._references.put(id, list);
        }
    }

    private void createDirective(Attributes atts) {
        SDBDirective directive = this._factory.createSDBDirective();
        this._symptomDB.getDirectives().add((Object)directive);
        directive.setId(atts.getValue("id"));
        directive.setDescription(atts.getValue("description"));
        directive.setDirectiveString(atts.getValue("directiveString"));
        Object references = this._references.get(directive.getId());
        if (references != null) {
            ArrayList list = (ArrayList)references;
            int idx = 0;
            while (idx < list.size()) {
                SDBSolution solution = (SDBSolution)list.get(idx);
                solution.getDirectives().add((Object)directive);
                directive.getSolutions().add((Object)solution);
                ++idx;
            }
            this._references.remove(directive.getId());
        }
        this._directives.put(directive.getId(), directive);
    }

    private void createMatchPattern(Attributes atts) {
        SDBMatchPattern pattern = this._factory.createSDBMatchPattern();
        this._symptom.getPatterns().add((Object)pattern);
        pattern.setName(atts.getValue("name"));
        pattern.setValue(atts.getValue("value"));
        String desc = this._symptom.getDescription();
        if (desc == null || desc.equals("")) {
            this._symptom.setDescription(pattern.getValue());
        }
        this._monitor.worked(1);
        if (this._monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    private void createMatchPattern() {
        String data = this.buffer.toString();
        while (data.startsWith("\n") || data.startsWith(" ")) {
            data = data.substring(1);
        }
        int idx = data.indexOf("\n");
        if (idx != -1) {
            String desc = data.substring(0, idx);
            if (desc.length() > 0) {
                this._symptom.setDescription(desc);
            }
        } else if (data.length() > 0) {
            this._symptom.setDescription(data);
        }
        int counter = 0;
        while (idx != -1) {
            if (data.substring(0, idx).length() > 0) {
                SDBMatchPattern pattern = this._factory.createSDBMatchPattern();
                pattern.setName(String.valueOf(counter));
                pattern.setValue(data.substring(0, idx));
                this._symptom.getPatterns().add((Object)pattern);
                ++counter;
            }
            data = data.substring(idx + 1);
            idx = data.indexOf("\n");
        }
        this._monitor.worked(1);
        if (this._monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    private void createRuntime(String destination) {
        Resource monDoc = null;
        URI uri = null;
        uri = destination.startsWith("platform:/resource/") ? URI.createURI((String)destination) : URI.createFileURI((String)destination);
        monDoc = Resource.Factory.Registry.INSTANCE.getFactory(uri).createResource(uri);
        EList ext = monDoc.getContents();
        this._resourceSet.getResources().add((Object)monDoc);
        this._symptomDB = this._factory.createSDBRuntime();
        ext.add((Object)this._symptomDB);
        this._symptomDB.setId("");
        this._symptomDB.setName(destination);
        this._symptomDB.setSymptomUrl("");
        this._symptomDB.setLocalExternalFileLocation("");
        this._symptomDB.setDescription("");
    }

    private void createRuntime(Attributes atts) {
        if (this._symptomDB == null) {
            return;
        }
        this._symptomDB.setId(atts.getValue("id"));
        this._symptomDB.setName(atts.getValue("name"));
        this._symptomDB.setSymptomUrl(atts.getValue("symptomUrl"));
        this._symptomDB.setLocalExternalFileLocation(atts.getValue("localExternalFileLocation"));
    }

    private void createSolution(Attributes atts) {
        Object references;
        SDBSolution solution = this._factory.createSDBSolution();
        this._symptomDB.getSolutions().add((Object)solution);
        solution.setId(atts.getValue("id"));
        solution.setDescription(atts.getValue("description"));
        String directives = atts.getValue("directives");
        if (directives != null) {
            int idx = directives.indexOf(" ");
            while (idx != -1) {
                String sol = directives.substring(0, idx);
                this.resolveRefDirective(sol, solution);
                directives = directives.substring(idx + 1);
                idx = directives.indexOf(" ");
            }
            if (!directives.equals("")) {
                this.resolveRefDirective(directives, solution);
            }
        }
        if ((references = this._references.get(solution.getId())) != null) {
            ArrayList list = (ArrayList)references;
            int idx = 0;
            while (idx < list.size()) {
                SDBSymptom symptom = (SDBSymptom)list.get(idx);
                symptom.getSolutions().add((Object)solution);
                solution.getSymptoms().add((Object)symptom);
                ++idx;
            }
            this._references.remove(solution.getId());
        }
        this._solutions.put(solution.getId(), solution);
        this._monitor.worked(1);
        if (this._monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    private void createSolution() {
        SDBSolution solution = this._factory.createSDBSolution();
        this._symptomDB.getSolutions().add((Object)solution);
        solution.getSymptoms().add((Object)this._symptom);
        this._symptom.getSolutions().add((Object)solution);
        String descr = this.buffer.toString();
        while (descr.startsWith("\n") || descr.startsWith(" ")) {
            descr = descr.substring(1);
        }
        int idx = descr.indexOf("\n");
        if (idx != -1) {
            solution.setDescription(descr.substring(0, idx));
            descr = descr.substring(idx);
            descr = descr.trim();
            if (descr.length() > 0) {
                SDBDirective directive = this._factory.createSDBDirective();
                this._symptomDB.getDirectives().add((Object)directive);
                directive.setDescription(descr);
                directive.setId("Directive_" + this.counter++);
                directive.setDirectiveString("");
                solution.getDirectives().add((Object)directive);
                directive.getSolutions().add((Object)solution);
            }
        } else {
            solution.setDescription(descr);
        }
        solution.setId("Solution_" + this.counter);
        this._monitor.worked(1);
        if (this._monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    private void createSymptom(Attributes atts) {
        this._symptom = this._factory.createSDBSymptom();
        this._symptomDB.getSymptoms().add((Object)this._symptom);
        this._symptom.setId(atts.getValue("id"));
        this._symptom.setDescription(atts.getValue("description"));
        String solutions = atts.getValue("solutions");
        if (solutions != null) {
            int idx = solutions.indexOf(" ");
            while (idx != -1) {
                String sol = solutions.substring(0, idx);
                this.resolveRefSolution(sol, this._symptom);
                solutions = solutions.substring(idx + 1);
                idx = solutions.indexOf(" ");
            }
            if (!solutions.equals("")) {
                this.resolveRefSolution(solutions, this._symptom);
            }
        }
        this._monitor.worked(1);
        if (this._monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    private void createV4Symptom(Attributes attr) {
        this._symptom = this._factory.createSDBSymptom();
        this._symptom.setId(attr.getValue("recordid"));
        this._symptom.setDescription(attr.getValue("recordid"));
        this._symptomDB.getSymptoms().add((Object)this._symptom);
        this._monitor.worked(1);
        if (this._monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    private void resolveRefDirective(String id, SDBSolution solution) {
        Object directive = this._directives.get(id);
        if (directive != null) {
            SDBDirective dir = (SDBDirective)directive;
            dir.getSolutions().add((Object)solution);
            solution.getDirectives().add((Object)dir);
        } else {
            this.addReference(id, solution);
        }
    }

    private void resolveRefSolution(String id, SDBSymptom symptom) {
        Object solution = this._solutions.get(id);
        if (solution != null) {
            SDBSolution sol = (SDBSolution)solution;
            sol.getSymptoms().add((Object)symptom);
            symptom.getSolutions().add((Object)sol);
        } else {
            this.addReference(id, symptom);
        }
    }
}

