/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.log.ui.internal;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.hyades.log.ui.internal.LogUIPluginImages;
import org.eclipse.hyades.log.ui.internal.util.IRecordPaneViewerListener;
import org.eclipse.hyades.log.ui.internal.util.LogUIConstants;
import org.eclipse.hyades.log.ui.internal.util.RecordChangeEvent;
import org.eclipse.hyades.models.cbe.CBEPackage;
import org.eclipse.hyades.models.internal.sdb.impl.SDBFactoryImpl;
import org.eclipse.hyades.models.internal.sdb.impl.SDBPackageImpl;
import org.eclipse.hyades.models.internal.sdb.impl.SDBResourceSetImpl;
import org.eclipse.hyades.ui.internal.util.StringUtil;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class LogUIPlugin
extends AbstractUIPlugin {
    private static LogUIPlugin inst;
    private static ResourceBundle aResourceBundle;
    private SDBFactoryImpl factory;
    private ResourceSet resourceSet;
    private ArrayList recordChangeListeners = null;
    static /* synthetic */ Class class$java$lang$String;

    public LogUIPlugin(IPluginDescriptor descriptor) {
        super(descriptor);
        if (inst == null) {
            inst = this;
        }
        aResourceBundle = this.getDescriptor().getResourceBundle();
    }

    public static LogUIPlugin getDefault() {
        return inst;
    }

    public static String getPluginId() {
        return LogUIPlugin.getDefault().getDescriptor().getUniqueIdentifier();
    }

    public static ImageDescriptor getImageDescriptor(String name) {
        return LogUIPluginImages.getImageDescriptor(name);
    }

    public static ResourceBundle getResourceBundle() {
        return aResourceBundle;
    }

    public static String getResourceString(String key) {
        ResourceBundle bundle = LogUIPlugin.getResourceBundle();
        try {
            return bundle.getString(key);
        }
        catch (MissingResourceException e) {
            return key;
        }
    }

    public static String getResourceString(String key, String[] variables) {
        String value = LogUIPlugin.getResourceString(key);
        int i = variables.length;
        while (i > 0) {
            value = StringUtil.replace((String)value, (String)("%" + i), (String)variables[i - 1]);
            --i;
        }
        return value;
    }

    public static Shell getActiveWorkbenchShell() {
        return LogUIPlugin.getActiveWorkbenchWindow().getShell();
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        return LogUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
    }

    public static void log(Throwable e) {
        String msg = e.getMessage();
        LogUIPlugin.getDefault().getLog().log((IStatus)new Status(4, LogUIPlugin.getPluginId(), 4, msg == null ? "" : msg, e));
    }

    public static SimpleDateFormat getDateTimeFormat() {
        IPreferenceStore store = inst.getPreferenceStore();
        String dateFormat = store.getString("LogAnalyzer.DateFormat");
        boolean valid = false;
        int i = 0;
        while (i < LogUIConstants.LOG_ANALYZER_FORMAT_DATE_LIST.length) {
            if (dateFormat.equals(LogUIConstants.LOG_ANALYZER_FORMAT_DATE_LIST[i])) {
                valid = true;
                break;
            }
            ++i;
        }
        if (!valid) {
            dateFormat = LogUIConstants.LOG_ANALYZER_FORMAT_DATE_DEFAULT;
        }
        String timeFormat = store.getString("LogAnalyzer.TimeFormat");
        valid = false;
        int i2 = 0;
        while (i2 < LogUIConstants.LOG_ANALYZER_FORMAT_TIME_LIST.length) {
            if (timeFormat.equals(LogUIConstants.LOG_ANALYZER_FORMAT_TIME_LIST[i2])) {
                valid = true;
                break;
            }
            ++i2;
        }
        if (!valid) {
            timeFormat = LogUIConstants.LOG_ANALYZER_FORMAT_TIME_DEFAULT;
        }
        if (timeFormat.startsWith("h")) {
            timeFormat = timeFormat + " a";
        }
        SimpleDateFormat formatter = new SimpleDateFormat(dateFormat + " " + timeFormat);
        return formatter;
    }

    public void shutdown() throws CoreException {
        LogUIPluginImages.shutdown();
        super.shutdown();
    }

    public void startup() throws CoreException {
        SDBPackageImpl.init();
        this.factory = new SDBFactoryImpl();
        this.resourceSet = SDBResourceSetImpl.getInstance();
        super.startup();
    }

    public SDBFactoryImpl getSymptomDBFactory() {
        if (this.factory == null) {
            this.factory = new SDBFactoryImpl();
        }
        return this.factory;
    }

    public ResourceSet getResourceSet() {
        return this.resourceSet;
    }

    protected void initializeDefaultPreferences(IPreferenceStore store) {
        try {
            ArrayList sort = new ArrayList(40);
            ArrayList filter = new ArrayList(70);
            this.createSortAndFilterList(sort, filter, (EClassifier)CBEPackage.eINSTANCE.getCBECommonBaseEvent());
            sort.remove("timeZone");
            StringBuffer pdSortKey = new StringBuffer();
            this.generatePreferenceString(pdSortKey, sort, new String[]{"creationTime", "sequenceNumber"});
            store.setDefault("pd_sort_log_options", pdSortKey.toString().trim());
            filter.remove("timeZone");
            StringBuffer pdKey = new StringBuffer();
            Collections.sort(filter);
            this.generatePreferenceString(pdKey, filter, null);
            store.setDefault("pd_filter_options", pdKey.toString().trim());
            store.setDefault("pd_adv_filter_options", "");
            store.setDefault("pd_src_filter_options", "");
            store.setDefault("pd_src_direction_options", "1");
            store.setDefault("pd_filter_show_correlation_only", "1");
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
        store.setDefault("LogAnalyzer.DateFormat", LogUIConstants.LOG_ANALYZER_FORMAT_DATE_DEFAULT);
        store.setDefault("LogAnalyzer.TimeFormat", LogUIConstants.LOG_ANALYZER_FORMAT_TIME_DEFAULT);
    }

    private void generatePreferenceString(StringBuffer key, ArrayList list, String[] pref) {
        String keyVal = "";
        if (pref == null) {
            keyVal = ":1 ";
        } else {
            keyVal = ":1 ";
            int s = pref.length;
            int i = 0;
            while (i < s) {
                key.append(pref[i]);
                key.append(keyVal);
                list.remove(pref[i]);
                ++i;
            }
            keyVal = ":0 ";
        }
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            String element = (String)iter.next();
            key.append(element);
            key.append(keyVal);
        }
    }

    private void createSortAndFilterList(List sort, List filter, EClassifier base) {
        ArrayList list = new ArrayList(30);
        EList metaObj = CBEPackage.eINSTANCE.getEClassifiers();
        int size = metaObj.size();
        int i = 0;
        while (i < size) {
            EClassifier elem = (EClassifier)metaObj.get(i);
            this.getEObjectAttributes((EClass)elem, list);
            int listSize = list.size();
            boolean isSort = ((EClass)elem).getEAllSuperTypes().contains((Object)base) || elem == base;
            int j = 0;
            while (j < listSize) {
                String element = (String)list.get(j);
                if (isSort && !sort.contains(element)) {
                    sort.add(element);
                }
                if (!filter.contains(element)) {
                    filter.add(element);
                }
                ++j;
            }
            list.clear();
            ++i;
        }
    }

    private void getEObjectAttributes(EClass eClass, List list) {
        EList attributes = eClass.getEAttributes();
        boolean isArrayOfObj = false;
        int k = 0;
        while (k < attributes.size()) {
            EAttribute attribute = (EAttribute)attributes.get(k);
            boolean bl = attribute.isMany() && attribute.getEType().getInstanceClass() != (class$java$lang$String == null ? LogUIPlugin.class$("java.lang.String") : class$java$lang$String) && !attribute.getEType().getInstanceClassName().equals("byte") && !attribute.getEType().getInstanceClassName().equals("short") ? true : (isArrayOfObj = false);
            if (!isArrayOfObj) {
                list.add(attribute.getName());
            }
            ++k;
        }
    }

    public void addRecordPaneViewerListener(IRecordPaneViewerListener listener) {
        if (this.recordChangeListeners == null) {
            this.recordChangeListeners = new ArrayList();
        }
        if (!this.recordChangeListeners.contains(listener)) {
            this.recordChangeListeners.add(listener);
        }
    }

    public void removeRecordPaneViewerListener(IRecordPaneViewerListener listener) {
        if (this.recordChangeListeners != null) {
            this.recordChangeListeners.remove(listener);
        }
    }

    public void fireRecordChangeNotification(RecordChangeEvent e) {
        if (this.recordChangeListeners != null) {
            int i = 0;
            while (i < this.recordChangeListeners.size()) {
                ((IRecordPaneViewerListener)this.recordChangeListeners.get(i)).handleRecordChangeEvent(e);
                ++i;
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        aResourceBundle = null;
    }
}

