/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.log.ui.internal.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.hyades.log.ui.internal.util.FilterListContentProvider;
import org.eclipse.hyades.log.ui.internal.util.FilterTableElement;
import org.eclipse.jface.viewers.IBasicPropertyConstants;
import org.eclipse.jface.viewers.TableViewer;

public class FilterList
implements IBasicPropertyConstants {
    ArrayList filters = new ArrayList();
    TableViewer fViewer;
    private List listeners;

    public FilterList(TableViewer viewer) {
        this.fViewer = viewer;
    }

    public void add(FilterTableElement element) {
        this.add(element, -1);
    }

    public void add(FilterTableElement element, int index) {
        if (index < 0) {
            this.filters.add(element);
        } else {
            this.filters.add(index, element);
        }
    }

    public void addElementChangedListener(FilterListContentProvider newListener) {
        if (newListener == null) {
            return;
        }
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        if (!this.listeners.contains(newListener)) {
            this.listeners.add(newListener);
        }
    }

    public Object[] elements() {
        return this.filters.toArray();
    }

    public void fireElementChanged(FilterTableElement changedElement, String changedProperty) {
        if (this.listeners != null) {
            Iterator e = this.listeners.iterator();
            while (e.hasNext()) {
                FilterListContentProvider l = (FilterListContentProvider)e.next();
                l.elementChanged(changedElement, changedProperty);
            }
        }
    }

    public Object getElementAt(int index) {
        return this.filters.get(index);
    }

    public ArrayList getFilters() {
        return (ArrayList)this.filters.clone();
    }

    public int getSize() {
        return this.filters.size();
    }

    public void removeAll() {
        this.filters.clear();
    }

    public void removeElements(int[] idx) {
        if (idx == null) {
            return;
        }
        Vector removeList = new Vector();
        int i = 0;
        while (i < idx.length) {
            if (idx[i] != -1) {
                Object element = this.filters.get(idx[i]);
                removeList.add(element);
            }
            ++i;
        }
        this.filters.removeAll(removeList);
    }

    public Object removeElementAt(int idx) {
        Object element = this.filters.get(idx);
        if (element == null) {
            return null;
        }
        this.filters.remove(element);
        return element;
    }

    public void removeElementChangedListener(FilterListContentProvider listener) {
        if (this.listeners != null) {
            this.listeners.remove(listener);
        }
    }

    public Object[] uiElements() {
        return this.filters.toArray();
    }
}

