/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.log.ui.internal.util;

import java.util.ArrayList;
import org.eclipse.hyades.log.ui.internal.util.CBEAdvFilterUI;
import org.eclipse.hyades.log.ui.internal.util.FilterList;
import org.eclipse.jface.preference.IPreferenceStore;

public class FilterTableElement {
    public static final String P_OPERATOR = "operator_combo";
    public static final String P_ATTRIBUTE = "attribute_combo";
    public static final String P_VALUE = "value_string";
    private String fAttribute;
    private String fOperator;
    private String fValue;
    private FilterList fParent;

    public FilterTableElement(String attribute, String operator, String value) {
        this.fAttribute = attribute;
        this.fOperator = operator;
        this.fValue = value;
    }

    public void setParent(FilterList parent) {
        this.fParent = parent;
    }

    public String getAtrribute() {
        return this.fAttribute;
    }

    public String getOperator() {
        return this.fOperator;
    }

    public String getValue() {
        return this.fValue;
    }

    public int getAttributeState() {
        int idx = 0;
        while (idx < CBEAdvFilterUI.fAttributeValues.length) {
            if (CBEAdvFilterUI.fAttributeValues[idx].equals(this.fAttribute)) {
                return idx;
            }
            ++idx;
        }
        return -1;
    }

    public int getOperatorState() {
        int idx = 0;
        while (idx < CBEAdvFilterUI.fOperatorValues.length) {
            if (CBEAdvFilterUI.fOperatorValues[idx].equals(this.fOperator)) {
                return idx;
            }
            ++idx;
        }
        return -1;
    }

    public void setValue(String value) {
        this.fValue = value;
        this.fParent.fireElementChanged(this, P_VALUE);
    }

    public void setOperator(String value) {
        this.fOperator = value;
        this.fParent.fireElementChanged(this, P_OPERATOR);
    }

    public void setOperator(int value) {
        this.fOperator = CBEAdvFilterUI.fOperatorValues[value];
        this.fParent.fireElementChanged(this, P_OPERATOR);
    }

    public void setAttribute(String value) {
        this.fAttribute = value;
        this.fParent.fireElementChanged(this, P_ATTRIBUTE);
    }

    public void setAttribute(int value) {
        this.fAttribute = CBEAdvFilterUI.fAttributeValues[value];
        this.fParent.fireElementChanged(this, P_ATTRIBUTE);
    }

    public String toString() {
        return this.fAttribute + "," + this.fOperator + "," + this.fValue;
    }

    public static ArrayList createFilterTableElementFromString(String preferenceColumns) {
        ArrayList filterTableElemList = null;
        if (preferenceColumns != null && !preferenceColumns.equals("")) {
            int count = 0;
            int i = preferenceColumns.indexOf("!");
            while (i != -1) {
                ++count;
                i = preferenceColumns.indexOf("!", i + 1);
            }
            filterTableElemList = new ArrayList(count);
            int idx = 0;
            while (idx != -1) {
                idx = preferenceColumns.indexOf("!");
                if (idx == -1) continue;
                String filterDataTemplate = preferenceColumns.substring(0, idx);
                preferenceColumns = preferenceColumns.substring(idx + 1);
                FilterTableElement.addFilterData(filterDataTemplate, filterTableElemList);
            }
        }
        return filterTableElemList;
    }

    private static void addFilterData(String filterTemplate, ArrayList list) {
        String filterAttribute = "";
        String filterOperator = "";
        String filterValue = "";
        int idx = filterTemplate.indexOf(";");
        if (idx != -1) {
            filterAttribute = filterTemplate.substring(0, idx);
            if ((idx = (filterTemplate = filterTemplate.substring(idx + 1)).indexOf(";")) != -1) {
                filterOperator = filterTemplate.substring(0, idx);
                filterValue = filterTemplate.substring(idx + 1);
            }
        }
        list.add(new FilterTableElement(filterAttribute, filterOperator, filterValue));
    }

    public static boolean saveFilters(ArrayList currentList, String preferenceKey, IPreferenceStore store) {
        String filterAttribute = "";
        String filterOperator = "";
        String filterValue = "";
        String filtersString = "";
        int i = 0;
        while (i < currentList.size()) {
            FilterTableElement filterData = (FilterTableElement)currentList.get(i);
            filterAttribute = filterData.getAtrribute();
            filterOperator = filterData.getOperator();
            filterValue = filterData.getValue();
            filtersString = filtersString + filterAttribute + ";" + filterOperator + ";" + filterValue + "!";
            ++i;
        }
        if (filtersString != "") {
            filtersString.substring(0, filtersString.length() - 1);
        }
        boolean filterChanged = !store.getString(preferenceKey).equals(filtersString);
        store.setValue(preferenceKey, filtersString);
        return filterChanged;
    }
}

