/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.log.ui.internal.util;

import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.hyades.loaders.util.HyadesResourceExtensions;
import org.eclipse.hyades.loaders.util.IHyadesResourceFactory;
import org.eclipse.hyades.log.ui.internal.LogUIPlugin;
import org.eclipse.hyades.models.hierarchy.plugin.HierarchyPlugin;
import org.eclipse.hyades.ui.internal.util.GridDataUtil;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class LargeResourceSupportUI
implements SelectionListener {
    protected Text username;
    protected Text password;
    protected Text cacheSize;
    protected Composite container;
    protected Combo storeType;

    public Control createControl(Composite parent) {
        this.container = new Composite(parent, 0);
        this.container.setLayoutData((Object)GridDataUtil.createFill());
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 5;
        layout.numColumns = 2;
        this.container.setLayout((Layout)layout);
        Label lDBType = new Label(this.container, 0);
        lDBType.setText(LogUIPlugin.getResourceString("LRSP_STORE_TYPE"));
        this.storeType = new Combo(this.container, 2056);
        this.storeType.setLayoutData((Object)GridDataUtil.createHorizontalFill());
        this.initPossibleDBType();
        Label lUsername = new Label(this.container, 0);
        lUsername.setText(LogUIPlugin.getResourceString("LRSP_DB_USERNAME"));
        this.username = new Text(this.container, 2048);
        this.username.setLayoutData((Object)GridDataUtil.createHorizontalFill());
        Label lPassword = new Label(this.container, 0);
        lPassword.setText(LogUIPlugin.getResourceString("LRSP_DB_PASSWORD"));
        this.password = new Text(this.container, 2048);
        this.password.setEchoChar('*');
        this.password.setLayoutData((Object)GridDataUtil.createHorizontalFill());
        Label lCacheSize = new Label(this.container, 0);
        lCacheSize.setText(LogUIPlugin.getResourceString("LRSP_CACHE_SIZE"));
        this.cacheSize = new Text(this.container, 2048);
        this.cacheSize.setLayoutData((Object)GridDataUtil.createHorizontalFill());
        Button createTables = new Button(this.container, 0);
        createTables.setText(LogUIPlugin.getResourceString("LRSP_CREATE_TABLES"));
        createTables.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseUp(MouseEvent e) {
                IHyadesResourceFactory hyadesResourceFactory = (IHyadesResourceFactory)HyadesResourceExtensions.getInstance().get((Object)("__" + LargeResourceSupportUI.this.storeType.getText() + ".trcadb"));
                if (hyadesResourceFactory != null) {
                    hyadesResourceFactory.createTables(LargeResourceSupportUI.this.storeType.getText(), HyadesResourceExtensions.getInstance().getProperties());
                }
            }
        });
        Button dropTables = new Button(this.container, 0);
        dropTables.setText(LogUIPlugin.getResourceString("LRSP_DROP_TABLES"));
        dropTables.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseUp(MouseEvent e) {
                IHyadesResourceFactory hyadesResourceFactory = (IHyadesResourceFactory)HyadesResourceExtensions.getInstance().get((Object)("__" + LargeResourceSupportUI.this.storeType.getText() + ".trcadb"));
                if (hyadesResourceFactory != null) {
                    hyadesResourceFactory.dropTables(LargeResourceSupportUI.this.storeType.getText(), HyadesResourceExtensions.getInstance().getProperties());
                }
            }
        });
        this.initializeValues(false);
        return this.container;
    }

    private void initPossibleDBType() {
        String defaultDBType = LogUIPlugin.getDefault().getPreferenceStore().getString("largeResourceSupportDBType");
        int index = -1;
        int i = 0;
        Iterator iter = HyadesResourceExtensions.getInstance().entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = (Map.Entry)iter.next();
            String postfix = (String)entry.getKey();
            IHyadesResourceFactory hyadesResourceFactory = (IHyadesResourceFactory)entry.getValue();
            if (hyadesResourceFactory == null || !hyadesResourceFactory.isEnabledFor(postfix)) continue;
            this.storeType.add(hyadesResourceFactory.getStoreType(postfix));
            if (hyadesResourceFactory.getStoreType(postfix).equals(defaultDBType)) {
                index = i;
            }
            ++i;
        }
        if (index != -1) {
            this.storeType.select(index);
        }
    }

    public void initializeValues(boolean defaultValue) {
        String s;
        Preferences store = HierarchyPlugin.getPlugin().getPluginPreferences();
        String string = s = defaultValue ? store.getDefaultString("largeResourceSupportUsername") : store.getString("largeResourceSupportUsername");
        if (s != null) {
            this.username.setText(s);
        }
        String string2 = s = defaultValue ? store.getDefaultString("largeResourceSupportPassword") : store.getString("largeResourceSupportPassword");
        if (s != null) {
            this.password.setText(s);
        }
        String string3 = s = defaultValue ? store.getDefaultString("largeResourceSupportDBType") : store.getString("largeResourceSupportDBType");
        if (s != null) {
            this.storeType.setText(s);
        }
    }

    public boolean storeValues() {
        Preferences newStore = HierarchyPlugin.getPlugin().getPluginPreferences();
        newStore.setValue("largeResourceSupportDBType", this.storeType.getText());
        newStore.setValue("largeResourceSupportUsername", this.username.getText());
        newStore.setValue("largeResourceSupportPassword", this.password.getText());
        newStore.setValue("largeResourceSupportCacheSize", this.cacheSize.getText());
        return true;
    }

    public Composite getControl() {
        return this.container;
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
    }
}

