/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.log.ui.internal.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.hyades.log.ui.internal.LogUIPlugin;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCMonitor;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.models.hierarchy.plugin.HierarchyPlugin;
import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.hyades.trace.internal.ui.PDLabelProvider;
import org.eclipse.hyades.trace.ui.HyadesUtil;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.help.WorkbenchHelp;

public class TraceMergeUI {
    private Button _chkMerge;
    private Button _chkLargeLogSupport;
    private TreeViewer _viewer;
    private Label _description;
    protected List _monitorsList = new ArrayList();

    public Composite createControl(Composite parent) {
        Composite result = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        result.setLayout((Layout)layout);
        GridData data = GridUtil.createFill();
        data.heightHint = 200;
        result.setLayoutData((Object)data);
        this.createSpace(result);
        if (HierarchyPlugin.getPlugin().getPluginPreferences().contains("largeResourceSupportDBType")) {
            this.createLargeLogSupport(result);
        }
        this.createMergeGroup(result);
        this.createDescription(result);
        this.createTreeViewer(result);
        WorkbenchHelp.setHelp((Control)this._chkMerge, (String)(LogUIPlugin.getPluginId() + ".tmlo0001"));
        WorkbenchHelp.setHelp((Control)this._viewer.getControl(), (String)(LogUIPlugin.getPluginId() + ".tmlo0002"));
        return result;
    }

    private void createLargeLogSupport(Composite result) {
        Composite grpLargeLogSupport = new Composite(result, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        grpLargeLogSupport.setLayout((Layout)layout);
        this._chkLargeLogSupport = new Button(grpLargeLogSupport, 32);
        this._chkLargeLogSupport.setText(LogUIPlugin.getResourceString("STR_LARGE_LOG_SUPPORT_LBL_"));
        GridData data = new GridData();
        data.horizontalIndent = 15;
        this._chkLargeLogSupport.setLayoutData((Object)data);
    }

    private void createMergeGroup(Composite result) {
        Composite grpMerge = new Composite(result, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        grpMerge.setLayout((Layout)layout);
        this._chkMerge = new Button(grpMerge, 32);
        this._chkMerge.setText(LogUIPlugin.getResourceString("STR_MERGE_LBL_"));
        GridData data = new GridData();
        data.horizontalIndent = 15;
        this._chkMerge.setLayoutData((Object)data);
    }

    private void createSpace(Composite parent) {
        Label space = new Label(parent, 0);
        GridData data = new GridData(768);
        space.setLayoutData((Object)data);
    }

    private void createDescription(Composite parent) {
        this._description = new Label(parent, 0);
        GridData data = new GridData();
        data.horizontalIndent = 15;
        this._description.setLayoutData((Object)data);
        this._description.setText(LogUIPlugin.getResourceString("STR_MERGETREE_DESC"));
    }

    private void createTreeViewer(Composite result) {
        this._viewer = new TreeViewer(result);
        this._viewer.setContentProvider((IContentProvider)new TraceMergeUIContentProvider());
        this._viewer.setLabelProvider((IBaseLabelProvider)new PDLabelProvider());
        this._viewer.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        GridData tree = GridUtil.createFill();
        tree.widthHint = 200;
        tree.horizontalIndent = 15;
        this._viewer.getTree().setLayoutData((Object)tree);
        this._viewer.getTree().setEnabled(false);
    }

    public Tree getTree() {
        return this._viewer.getTree();
    }

    public Button getMergeButton() {
        return this._chkMerge;
    }

    public Label getDescription() {
        return this._description;
    }

    public void selectMergedAgent(TRCAgentProxy mergedAgent) {
        this._viewer.setExpandedState((Object)mergedAgent.getProcessProxy(), true);
        this._viewer.setSelection((ISelection)new StructuredSelection((Object)mergedAgent));
    }

    public boolean getLargeLogSupport() {
        if (this._chkLargeLogSupport != null) {
            return this._chkLargeLogSupport.getSelection();
        }
        return false;
    }

    public void setUseLargeLogSupport(boolean b) {
        if (this._chkLargeLogSupport != null) {
            this._chkLargeLogSupport.setSelection(b);
        }
    }

    class TraceMergeUIContentProvider
    implements IStructuredContentProvider,
    ITreeContentProvider {
        public Object[] getElements(Object inputElement) {
            ArrayList list = new ArrayList();
            if (inputElement instanceof IWorkspaceRoot) {
                this.getProcessesFromMemory(list);
                this.getProcessesFromWorkspace(list, inputElement);
            } else if (inputElement instanceof TRCProcessProxy) {
                list.addAll(HyadesUtil.getLogAgents((EObject)((TRCProcessProxy)inputElement)));
            }
            return list.toArray();
        }

        private void getProcessesFromMemory(List list) {
            EList resources = UIPlugin.getDefault().getResourceSet().getResources();
            int size = resources.size();
            int i = 0;
            while (i < size) {
                Resource res = (Resource)resources.get(i);
                EList ext = res.getContents();
                Iterator iter = ext.iterator();
                while (iter.hasNext()) {
                    Object obj = iter.next();
                    if (!(obj instanceof TRCMonitor)) continue;
                    TraceMergeUI.this._monitorsList.add(obj);
                    list.addAll(HyadesUtil.getProcesses((TRCMonitor)((TRCMonitor)obj)));
                }
                ++i;
            }
        }

        private void getProcessesFromWorkspace(List list, Object inputElement) {
            IProject[] projects = ((IWorkspaceRoot)inputElement).getProjects();
            ResourceSet resourceSet = UIPlugin.getDefault().getResourceSet();
            int idx = 0;
            while (idx < projects.length) {
                List resources = HyadesUtil.getResources((IProject)projects[idx]);
                int j = 0;
                while (j < resources.size()) {
                    IResource resource = (IResource)resources.get(j);
                    if (resource != null) {
                        List monitors = HyadesUtil.getMonitors((IResource)resource, (ResourceSet)resourceSet);
                        int monitors_size = monitors.size();
                        int k = 0;
                        while (k < monitors_size) {
                            TRCMonitor monitor = (TRCMonitor)monitors.get(k);
                            if (monitor != null && !TraceMergeUI.this._monitorsList.contains(monitor)) {
                                list.addAll(HyadesUtil.getProcesses((TRCMonitor)monitor));
                            }
                            ++k;
                        }
                    }
                    ++j;
                }
                ++idx;
            }
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getChildren(Object parentElement) {
            return this.getElements(parentElement);
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return !(element instanceof TRCAgentProxy);
        }
    }
}

