/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.log.ui.internal.views;

import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.hyades.analysis.engine.IAnalysisMonitor;
import org.eclipse.hyades.analysis.engine.ILogAnalyzer;
import org.eclipse.hyades.log.ui.internal.LogUIPlugin;
import org.eclipse.hyades.log.ui.internal.util.ContextIds;
import org.eclipse.hyades.log.ui.internal.util.ProgressMonitorAdapter;
import org.eclipse.hyades.log.ui.internal.util.SymptomDBDialog;
import org.eclipse.hyades.log.ui.internal.views.ExtensionPointHandler;
import org.eclipse.hyades.log.ui.internal.views.LogContentProvider;
import org.eclipse.hyades.log.ui.internal.views.LogViewerUI;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.help.WorkbenchHelp;

public class LogPaneTreeViewer
extends TreeViewer {
    private LogViewerUI _logViewUI = null;
    private ExtensionPointHandler eph = ExtensionPointHandler.getExtensionPointHandler();
    protected Action _updateAction;

    public LogPaneTreeViewer(LogViewerUI logViewUI, Composite parent, String role) {
        super(parent);
        this._logViewUI = logViewUI;
        this._updateAction = new UpdateAction(LogUIPlugin.getResourceString("REFRESH_VIEWS"));
    }

    public void setMenuListener(IMenuListener menuListener) {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(menuListener);
        Menu menu = menuMgr.createContextMenu(this.getControl());
        this.getControl().setMenu(menu);
    }

    public void addSelectionListener(SelectionListener listener) {
        ((Tree)this.getControl()).addSelectionListener(listener);
    }

    public void fillContextMenu(IMenuManager menu) {
        ISelection sel = this.getSelection();
        if (sel instanceof IStructuredSelection && !sel.isEmpty()) {
            this.updateMenu(menu, ((IStructuredSelection)sel).getFirstElement());
        }
        menu.add((IContributionItem)new Separator());
        menu.add((IAction)this._updateAction);
        menu.add((IContributionItem)new Separator());
        menu.add((IContributionItem)new Separator("additions"));
    }

    public void updateMenu(IMenuManager menu, Object logObject) {
        ISelection sel = this.getSelection();
        if (sel instanceof IStructuredSelection) {
            MenuManager manager = new MenuManager(LogUIPlugin.getResourceString("STR_ANALYZE_ACT"));
            menu.add((IContributionItem)manager);
            this.fillMenu((IContributionManager)manager, logObject);
            menu.add((IContributionItem)new Separator());
            manager = new MenuManager(LogUIPlugin.getResourceString("STR_ANALYZE_ALL_ACT"));
            menu.add((IContributionItem)manager);
            this.fillMenu((IContributionManager)manager);
        }
    }

    public void dispose() {
        List logAnalyzers = this.eph.getLogAnalyzers();
        Iterator iter = logAnalyzers.iterator();
        while (iter.hasNext()) {
            ILogAnalyzer element = ((ExtensionPointHandler.ConfigurationElement)iter.next()).getAnalyzer();
            element.unloadDatabase();
        }
    }

    private void fillMenu(IContributionManager innerMgr) {
        innerMgr.removeAll();
        List logAnalyzers = this.eph.getLogAnalyzers();
        if (logAnalyzers != null) {
            Iterator iter = logAnalyzers.iterator();
            while (iter.hasNext()) {
                ExtensionPointHandler.ConfigurationElement config = (ExtensionPointHandler.ConfigurationElement)iter.next();
                AnalyzeAction analyzeAction = new AnalyzeAction(config.getName(), config.getAnalyzer(), true);
                innerMgr.add((IAction)analyzeAction);
            }
        }
    }

    private void fillMenu(IContributionManager innerMgr, Object logObject) {
        innerMgr.removeAll();
        List logAnalyzers = this.eph.getLogAnalyzer(logObject);
        if (logAnalyzers != null) {
            Iterator iter = logAnalyzers.iterator();
            while (iter.hasNext()) {
                ExtensionPointHandler.ConfigurationElement config = (ExtensionPointHandler.ConfigurationElement)iter.next();
                AnalyzeAction analyzeAction = new AnalyzeAction(config.getName(), config.getAnalyzer(), false);
                innerMgr.add((IAction)analyzeAction);
            }
        }
    }

    class AnalyzeAction
    extends LoadAction {
        boolean analyzeAll = false;
        private IStructuredSelection sel;
        private ILogAnalyzer aLogAnalyzer;

        public AnalyzeAction(String label, ILogAnalyzer logAnalyzer) {
            super(label, logAnalyzer);
        }

        public AnalyzeAction(String label, ILogAnalyzer logAnalyzer, boolean analyzeAll) {
            super(label, logAnalyzer);
            this.analyzeAll = analyzeAll;
        }

        public IStructuredSelection getSelection() {
            Display.getDefault().syncExec(new Runnable(this){
                private final /* synthetic */ AnalyzeAction this$1;
                {
                    this.this$1 = this$1;
                }

                public void run() {
                    if (this.this$1.analyzeAll) {
                        AnalyzeAction.access$302(this.this$1, (IStructuredSelection)new StructuredSelection(((LogContentProvider)AnalyzeAction.access$400(this.this$1).getContentProvider()).getChildren(AnalyzeAction.access$400(this.this$1).getInput())));
                    } else {
                        AnalyzeAction.access$302(this.this$1, (IStructuredSelection)AnalyzeAction.access$400(this.this$1).getSelection());
                    }
                }
            });
            return this.sel;
        }

        public void run() {
            IRunnableWithProgress analyze = new IRunnableWithProgress(this){
                private final /* synthetic */ AnalyzeAction this$1;
                {
                    this.this$1 = this$1;
                }

                public void run(IProgressMonitor m) {
                    ProgressMonitorAdapter monitor = new ProgressMonitorAdapter(m);
                    monitor.beginTask(LogUIPlugin.getResourceString("STR_ANALYZE_PROGRESS"), this.this$1.getSelection().size());
                    monitor.subTask(LogUIPlugin.getResourceString("STR_ANALYZE_LOAD_DB"));
                    this.this$1.getLogAnalyzer().loadDatabase();
                    if (this.this$1.getLogAnalyzer().errorMsg() == null) {
                        this.this$1.getLogAnalyzer().analyze((Object)this.this$1.getSelection(), (IAnalysisMonitor)monitor);
                    }
                    monitor.done();
                }
            };
            try {
                LogUIPlugin.getActiveWorkbenchWindow().run(true, true, analyze);
            }
            catch (Exception e) {
                LogUIPlugin.log(e);
            }
            if (this.getLogAnalyzer().errorMsg() != null && this.getLogAnalyzer().errorMsg().equals(LogUIPlugin.getResourceString("STR_NO_SYMPTOM_DB_ERROR"))) {
                if (MessageDialog.openQuestion((Shell)LogPaneTreeViewer.this.getControl().getShell(), (String)LogUIPlugin.getResourceString("STR_LOG_MSG"), (String)this.getLogAnalyzer().errorMsg())) {
                    super.run();
                    if (this.getReload()) {
                        try {
                            LogUIPlugin.getActiveWorkbenchWindow().run(true, true, analyze);
                        }
                        catch (Exception e) {
                            LogUIPlugin.log(e);
                        }
                    }
                } else {
                    return;
                }
            }
            LogPaneTreeViewer.this.refresh();
            Event event = new Event();
            event.item = ((Tree)LogPaneTreeViewer.this.getControl()).getSelection()[0];
            LogPaneTreeViewer.this.getControl().notifyListeners(13, event);
        }

        static /* synthetic */ IStructuredSelection access$302(AnalyzeAction x0, IStructuredSelection x1) {
            x0.sel = x1;
            return x0.sel;
        }

        static /* synthetic */ LogPaneTreeViewer access$400(AnalyzeAction x0) {
            return x0.LogPaneTreeViewer.this;
        }
    }

    class LoadAction
    extends BasicLoadAction {
        public LoadAction(String label, ILogAnalyzer logAnalyzer) {
            super(label, logAnalyzer);
        }

        public void run() {
            SymptomDBDialog dialog = new SymptomDBDialog(LogPaneTreeViewer.this.getControl().getShell(), LogUIPlugin.getResourceString("STR_SYMPTOM_DB_DLG_TITLE"), null);
            this.setReload(false);
            dialog.open();
            if (dialog.getReturnCode() == 0) {
                this.setReload(true);
            }
        }
    }

    class BasicLoadAction
    extends Action {
        private ILogAnalyzer logAnalyzer = null;
        private boolean reload = false;

        public BasicLoadAction(String label, ILogAnalyzer logAnalyzer) {
            super(label);
            this.logAnalyzer = logAnalyzer;
        }

        public ILogAnalyzer getLogAnalyzer() {
            return this.logAnalyzer;
        }

        public boolean getReload() {
            return this.reload;
        }

        public void setReload(boolean newVal) {
            this.reload = newVal;
        }

        public void run() {
            BusyIndicator.showWhile(null, (Runnable)new Runnable(this){
                private final /* synthetic */ BasicLoadAction this$1;
                {
                    this.this$1 = this$1;
                }

                public void run() {
                    BasicLoadAction.access$100(this.this$1).loadDatabase();
                    if (BasicLoadAction.access$100(this.this$1).errorMsg() != null) {
                        MessageDialog.openError((Shell)BasicLoadAction.access$200(this.this$1).getControl().getShell(), (String)LogUIPlugin.getResourceString("STR_LOG_MSG"), (String)BasicLoadAction.access$100(this.this$1).errorMsg());
                        return;
                    }
                }
            });
        }

        public boolean isEnabled() {
            return true;
        }

        static /* synthetic */ ILogAnalyzer access$100(BasicLoadAction x0) {
            return x0.logAnalyzer;
        }

        static /* synthetic */ LogPaneTreeViewer access$200(BasicLoadAction x0) {
            return x0.LogPaneTreeViewer.this;
        }
    }

    class UpdateAction
    extends Action {
        public UpdateAction(String name) {
            super(name);
            WorkbenchHelp.setHelp((IAction)this, (String)ContextIds.ACTLOG_VIEW_POPUP_REFRESH);
        }

        public void run() {
            LogPaneTreeViewer.this._logViewUI.update();
        }
    }
}

