/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.adapter.outputters;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Hashtable;
import org.eclipse.hyades.logging.adapter.AdapterInvalidConfig;
import org.eclipse.hyades.logging.adapter.IOutputter;
import org.eclipse.hyades.logging.adapter.impl.Outputter;
import org.eclipse.hyades.logging.adapter.util.Messages;
import org.eclipse.hyades.logging.events.cbe.CommonBaseEvent;
import org.eclipse.hyades.logging.events.cbe.util.EventFormatter;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class CBEFileOutputter
extends Outputter
implements IOutputter {
    private String directory = null;
    private String fileName = null;
    protected String rawLogFileName = null;
    private File outputFile = null;
    protected FileWriter fw = null;

    public Object[] processEventItems(Object[] msgs) {
        if (msgs == null) {
            return null;
        }
        return this.processCBEs((CommonBaseEvent[])msgs);
    }

    protected void writeToFile(String event) throws IOException {
        this.fw.write(event);
        this.fw.write("\n");
        this.fw.flush();
    }

    private CommonBaseEvent[] processCBEs(CommonBaseEvent[] events) {
        if (events == null) {
            return events;
        }
        int i = 0;
        while (i < events.length) {
            if (events[i] != null) {
                try {
                    String outstr = EventFormatter.toCanonicalXMLString((CommonBaseEvent)events[i], (boolean)false);
                    if (outstr != null) {
                        this.writeToFile(outstr);
                    }
                }
                catch (IOException ioe) {
                    CommonBaseEvent event = this.getEventFactory().createCommonBaseEvent();
                    event.getMsgDataElement().setMsgCatalogId("HyadesGA_CBE_File_Outputter_Write_ERROR_");
                    event.getMsgDataElement().setMsgCatalogTokensAsStrings(new String[]{this.getUniqueID(), this.rawLogFileName});
                    event.setSeverity((short)60);
                    this.log(event);
                }
                catch (NullPointerException npe) {
                    CommonBaseEvent event = this.getEventFactory().createCommonBaseEvent();
                    event.getMsgDataElement().setMsgCatalogId("HyadesGA_CBE_File_Outputter_Write_ERROR_");
                    event.getMsgDataElement().setMsgCatalogTokensAsStrings(new String[]{this.getUniqueID(), this.rawLogFileName});
                    event.setSeverity((short)60);
                    this.log(event);
                }
            }
            ++i;
        }
        return events;
    }

    public Object[] testProcessEventItems(Object[] msgs) throws AdapterInvalidConfig {
        if (!(msgs instanceof CommonBaseEvent[])) {
            throw new AdapterInvalidConfig("This outputter will only accept arrays of CommonBaseEvent");
        }
        return this.testProcessCBEs((CommonBaseEvent[])msgs);
    }

    private CommonBaseEvent[] testProcessCBEs(CommonBaseEvent[] events) {
        return events;
    }

    public final String getDirectory() {
        return this.directory;
    }

    public final String getFileName() {
        return this.fileName;
    }

    public final void setDirectory(String directory) {
        this.directory = directory;
    }

    public final void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public void update() throws AdapterInvalidConfig {
        super.update();
        String directory = null;
        String fileName = null;
        Element element = this.getConfiguration();
        Element outputterTypeInstance = null;
        Hashtable outputterProperties = this.getProperties();
        if (outputterProperties != null && !outputterProperties.isEmpty()) {
            directory = (String)outputterProperties.get(Messages.getString("HyadesGAdirectoryAttributeName"));
            fileName = (String)outputterProperties.get(Messages.getString("HyadesGAfileNameAttributeName"));
        } else {
            NodeList outputterNodes = element.getChildNodes();
            int i = 0;
            while (i < outputterNodes.getLength()) {
                Element outputterNode;
                if (outputterNodes.item(i).getNodeType() == 1 && (outputterNode = (Element)outputterNodes.item(i)).getTagName().equals(Messages.getString("HyadesGASingleFileOutputterTypeTagName"))) {
                    outputterTypeInstance = outputterNode;
                    if (outputterTypeInstance.hasAttribute(Messages.getString("HyadesGAdirectoryAttributeName"))) {
                        directory = outputterTypeInstance.getAttribute(Messages.getString("HyadesGAdirectoryAttributeName"));
                    }
                    if (outputterTypeInstance.hasAttribute(Messages.getString("HyadesGAfileNameAttributeName"))) {
                        fileName = outputterTypeInstance.getAttribute(Messages.getString("HyadesGAfileNameAttributeName"));
                    }
                }
                ++i;
            }
        }
        if (directory == null || directory.length() == 0 || fileName == null || fileName.length() == 0) {
            throw new AdapterInvalidConfig(Messages.getString("HyadesGA_CBE_SingleFileOutputter_Invalid_Config_File_ERROR_"));
        }
        this.setDirectory(directory);
        this.setFileName(fileName);
        String pathSeparator = System.getProperty("file.separator");
        this.rawLogFileName = this.getDirectory().endsWith(pathSeparator) ? this.getDirectory() + this.getFileName() : this.getDirectory() + pathSeparator + this.getFileName();
        try {
            this.fw = new FileWriter(this.rawLogFileName);
        }
        catch (IOException ioe) {
            CommonBaseEvent event = this.getEventFactory().createCommonBaseEvent();
            event.getMsgDataElement().setMsgCatalogId("HyadesGA_CBE_File_Outputter_Create_ERROR_");
            event.getMsgDataElement().setMsgCatalogTokensAsStrings(new String[]{this.getUniqueID(), this.rawLogFileName});
            event.setSeverity((short)60);
            this.log(event);
            throw new AdapterInvalidConfig(Messages.getString("HyadesGA_CBE_File_Outputter_Create_ERROR_"));
        }
    }
}

