/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.security.util;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.Security;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPluginRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.hyades.execution.security.ISecureClientParameters;
import org.eclipse.hyades.execution.security.KeystoreHelper;
import org.eclipse.hyades.internal.execution.local.control.AgentControllerUnavailableException;
import org.eclipse.hyades.internal.execution.local.control.Application;
import org.eclipse.hyades.internal.execution.local.control.Node;
import org.eclipse.hyades.internal.execution.local.control.NodeFactory;
import org.eclipse.hyades.internal.execution.security.DuplicateUserException;
import org.eclipse.hyades.internal.execution.security.LoginFailedException;
import org.eclipse.hyades.internal.execution.security.SecureConnectionRequiredException;
import org.eclipse.hyades.internal.execution.security.UntrustedAgentControllerException;
import org.eclipse.hyades.internal.execution.security.User;
import org.eclipse.hyades.internal.execution.security.UserFactory;
import org.eclipse.hyades.security.SecurityPlugin;
import org.eclipse.hyades.security.util.ConnectivityDialog;
import org.eclipse.hyades.security.util.TString;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;

public class ConnectUtil {
    public static final int CONNECTION_SUCCESS = 0;
    public static final int CONNECTION_CONTROLLER_ERROR = 1;
    public static final int CONNECTION_HOST_ERROR = 2;
    public static final int CONNECTION_PORT_ERROR = 3;
    public static final int CONNECTION_SECURITY_NOT_SUPPORTED = 4;
    private Application _app;
    private String _port;
    private String _hostName;
    private InetAddress _hostAddr;
    private String _userId;
    private Node _node;
    private ISecureClientParameters _parameters;
    private ConnectivityDialog dlg;
    private boolean okPressed = false;

    public ConnectUtil(String hostName, String port, Application app) {
        this(hostName, port, null, app);
    }

    public ConnectUtil(String hostName, String port, String userId, Application app) {
        this._hostName = hostName;
        this._port = port;
        this._userId = userId;
        this._app = app;
    }

    public ConnectUtil(InetAddress hostAddr, String port, Application app) {
        this(hostAddr, port, null, app);
    }

    public ConnectUtil(InetAddress hostAddr, String port, String userId, Application app) {
        this._hostAddr = hostAddr;
        this._hostName = this._hostAddr.getHostName();
        this._port = port;
        this._userId = userId;
        this._app = app;
    }

    private ISecureClientParameters getClientParms() {
        IPluginRegistry reg = Platform.getPluginRegistry();
        IConfigurationElement[] config = Platform.getPluginRegistry().getConfigurationElementsFor(SecurityPlugin.getPluginId(), "JSSESecurityProviders");
        int idx = 0;
        while (idx < config.length) {
            IConfigurationElement elem = config[idx];
            String typeAttr = elem.getAttribute("name");
            String classAttr = elem.getAttribute("class");
            if (classAttr != null) {
                try {
                    Object realization = elem.createExecutableExtension("class");
                    if (realization instanceof ISecureClientParameters) {
                        ISecureClientParameters parms = (ISecureClientParameters)realization;
                        Security.addProvider(parms.getSecurityProvider());
                        parms.getKeystoreManager().setProvider(parms.getSecurityProvider());
                        return (ISecureClientParameters)realization;
                    }
                }
                catch (CoreException e) {
                    // empty catch block
                }
            }
            ++idx;
        }
        return null;
    }

    public final int connect() {
        try {
            if (this._hostAddr == null) {
                this._hostAddr = InetAddress.getByName(this._hostName);
            }
        }
        catch (UnknownHostException exc) {
            this.resetConnection();
            String text = SecurityPlugin.getResourceString("TIMEOUT_NODE_ERROR_");
            text = TString.change(text, "%1", this._hostName);
            String msg = SecurityPlugin.getResourceString("CONNECTION_FAIL_TEXT");
            msg = TString.change(msg, "%1", this._hostName);
            Status err = new Status(2, "org.eclipse.core.resources", 2, text, (Throwable)exc);
            this.openErrorDialog(SecurityPlugin.getResourceString("SEC_MSG"), msg, err);
            return 2;
        }
        try {
            if (this.checkConnectionExists()) {
                return 0;
            }
            if (this._node == null) {
                this._node = NodeFactory.createNode((InetAddress)this._hostAddr, (Principal)this._app);
            }
            this._node.connect(Integer.parseInt(this._port));
        }
        catch (UnknownHostException exc) {
            this.resetConnection();
            String text = SecurityPlugin.getResourceString("TIMEOUT_NODE_ERROR_");
            text = TString.change(text, "%1", this._hostName);
            String msg = SecurityPlugin.getResourceString("CONNECTION_FAIL_TEXT");
            msg = TString.change(msg, "%1", this._hostName);
            Status err = new Status(2, "org.eclipse.core.resources", 2, text, (Throwable)exc);
            this.openErrorDialog(SecurityPlugin.getResourceString("SEC_MSG"), msg, err);
            return 2;
        }
        catch (SecureConnectionRequiredException exc) {
            return this.connectUnderException((AgentControllerUnavailableException)((Object)exc));
        }
        catch (LoginFailedException exc) {
            return this.connectUnderException((AgentControllerUnavailableException)((Object)exc));
        }
        catch (UntrustedAgentControllerException exc) {
            String text = SecurityPlugin.getResourceString("STR_CERTIF_UNAV_ERROR_");
            text = TString.change(text, "%1", this._hostName);
            String txt = TString.change(SecurityPlugin.getResourceString("STR_UNTRUSTED_AGENT_CONTROLLER"), "%1", this._hostName);
            boolean ok = this.openQuestionDialog(SecurityPlugin.getResourceString("SEC_MSG"), txt);
            if (!ok) {
                this.resetConnection();
                String msg = SecurityPlugin.getResourceString("CONNECTION_FAIL_TEXT");
                msg = TString.change(msg, "%1", this._hostName);
                Status err = new Status(2, "org.eclipse.core.resources", 2, text, (Throwable)exc);
                this.openErrorDialog(SecurityPlugin.getResourceString("SEC_MSG"), msg, err);
                return 1;
            }
            ISecureClientParameters params = this._node.getSecurityParameters();
            if (params != null) {
                params.disableServerAuthentication();
            }
            return this.connect();
        }
        catch (AgentControllerUnavailableException exc) {
            String text = SecurityPlugin.getResourceString("STR_AGENT_CONTROLLER_UNAV_ERROR_");
            text = TString.change(text, "%1", this._hostName);
            this.resetConnection();
            String msg = SecurityPlugin.getResourceString("CONNECTION_FAIL_TEXT");
            msg = TString.change(msg, "%1", this._hostName);
            Status err = new Status(2, "org.eclipse.core.resources", 2, text, (Throwable)exc);
            this.openErrorDialog(SecurityPlugin.getResourceString("SEC_MSG"), msg, err);
            return 1;
        }
        catch (NumberFormatException exc) {
            this.resetConnection();
            String text = SecurityPlugin.getResourceString("INVALID_PORT_ERROR_");
            text = TString.change(text, "%1", String.valueOf(this._port));
            String msg = SecurityPlugin.getResourceString("CONNECTION_FAIL_TEXT");
            msg = TString.change(msg, "%1", this._hostName);
            Status err = new Status(2, "org.eclipse.core.resources", 2, text, (Throwable)exc);
            this.openErrorDialog(SecurityPlugin.getResourceString("SEC_MSG"), msg, err);
            return 3;
        }
        return 0;
    }

    public String getUserId() {
        return this._userId;
    }

    public Node getNode() {
        return this._node;
    }

    private void resetConnection() {
        if (this._userId != null) {
            UserFactory.removeUser((Application)this._app, (String)this._userId);
        }
        if (this._node != null) {
            this._node.setSecurityParameters(null);
        }
    }

    private int connectUnderException(AgentControllerUnavailableException exc) {
        try {
            User user = null;
            if (this._userId != null && !this._userId.equals("")) {
                user = UserFactory.getUser((Application)this._app, (String)this._userId);
            }
            if (user == null) {
                if (exc instanceof SecureConnectionRequiredException && ((SecureConnectionRequiredException)((Object)exc)).isPasswordProtected()) {
                    Display.getDefault().syncExec(new Runnable(){

                        public void run() {
                            ConnectUtil.this.dlg = new ConnectivityDialog(ConnectUtil.getValidShell(), ConnectUtil.this._hostName, ConnectUtil.this._userId, ConnectUtil.this._userId == null || ConnectUtil.this._userId.equals(""));
                            ConnectUtil.this.dlg.setDescription(SecurityPlugin.getResourceString("STR_PWD_REQ_INFO_"));
                            ConnectUtil.this.openDialog(ConnectUtil.this.dlg);
                        }
                    });
                    if (this.dlg.getReturnCode() != 0) {
                        this.resetConnection();
                        String text = SecurityPlugin.getResourceString("STR_PWD_REQ_INFO_");
                        String msg = SecurityPlugin.getResourceString("CONNECTION_FAIL_TEXT");
                        msg = TString.change(msg, "%1", this._hostName);
                        Status err = new Status(2, "org.eclipse.core.resources", 2, text, null);
                        this.openErrorDialog(SecurityPlugin.getResourceString("SEC_MSG"), msg, err);
                        return 2;
                    }
                    this._userId = this.dlg.getUserId();
                    if (UserFactory.getUser((Application)this._app, (String)this._userId) != null) {
                        UserFactory.removeUser((Application)this._app, (String)this._userId);
                    }
                    user = UserFactory.createUser((Application)this._app, (String)this._userId, (String)this.dlg.getPassword());
                } else {
                    this._userId = "ignoredUserId";
                    user = UserFactory.createUser((Application)this._app, (String)this._userId, (String)"dummyPass");
                }
            } else if (exc instanceof LoginFailedException) {
                Display.getDefault().syncExec(new Runnable(){

                    public void run() {
                        ConnectUtil.this.dlg = new ConnectivityDialog(ConnectUtil.getValidShell(), ConnectUtil.this._hostName, ConnectUtil.this._userId);
                        ConnectUtil.this.dlg.setDescription(SecurityPlugin.getResourceString("STR_LOGIN_FAILED_INFO_"));
                        ConnectUtil.this.openDialog(ConnectUtil.this.dlg);
                    }
                });
                if (this.dlg.getReturnCode() != 0) {
                    this.resetConnection();
                    String text = SecurityPlugin.getResourceString("STR_PWD_REQ_INFO_");
                    String msg = SecurityPlugin.getResourceString("CONNECTION_FAIL_TEXT");
                    msg = TString.change(msg, "%1", this._hostName);
                    Status err = new Status(2, "org.eclipse.core.resources", 2, text, null);
                    this.openErrorDialog(SecurityPlugin.getResourceString("SEC_MSG"), msg, err);
                    return 2;
                }
                this._userId = this.dlg.getUserId();
                user = UserFactory.getUser((Application)this._app, (String)this._userId);
                if (user != null) {
                    user.setPassword(this.dlg.getPassword());
                } else {
                    try {
                        user = UserFactory.createUser((Application)this._app, (String)this._userId, (String)this.dlg.getPassword());
                    }
                    catch (DuplicateUserException e) {
                        // empty catch block
                    }
                }
            }
            if (exc instanceof SecureConnectionRequiredException) {
                this._port = new Long(((SecureConnectionRequiredException)((Object)exc)).getSecurePort()).toString();
            } else if (exc instanceof LoginFailedException) {
                this._port = new Long(((LoginFailedException)((Object)exc)).getSecurePort()).toString();
            }
            if (this._node.getSecurityParameters() == null) {
                ISecureClientParameters parms = this.getClientParms();
                if (parms == null) {
                    this.resetConnection();
                    String text = SecurityPlugin.getResourceString("STR_CLIENT_CANNOT_USE_SECURITY_ERROR_");
                    text = TString.change(text, "%1", this._hostName);
                    String msg = SecurityPlugin.getResourceString("CONNECTION_FAIL_TEXT");
                    msg = TString.change(msg, "%1", this._hostName);
                    Status err = new Status(2, "org.eclipse.core.resources", 2, text, null);
                    this.openErrorDialog(SecurityPlugin.getResourceString("SEC_MSG"), msg, err);
                    return 4;
                }
                this._node.setSecurityParameters(this.getClientParms());
                this._node.getSecurityParameters().getKeystoreManager().loadKeystore(this._node.getSecurityParameters().getKeystoreFileName(), this._node.getSecurityParameters().getKeystoreFilepassword());
            }
            this._node.setUser(user);
            return this.connect();
        }
        catch (DuplicateUserException e) {
            this.resetConnection();
        }
        catch (IOException e) {
            try {
                if (this._node.getSecurityParameters() == null) {
                    this.resetConnection();
                    String text = SecurityPlugin.getResourceString("STR_CLIENT_CANNOT_USE_SECURITY_ERROR_");
                    text = TString.change(text, "%1", this._hostName);
                    String msg = SecurityPlugin.getResourceString("CONNECTION_FAIL_TEXT");
                    msg = TString.change(msg, "%1", this._hostName);
                    Status err = new Status(2, "org.eclipse.core.resources", 2, text, (Throwable)e);
                    this.openErrorDialog(SecurityPlugin.getResourceString("SEC_MSG"), msg, err);
                    return 4;
                }
                KeystoreHelper.createKeyStore((String)SecurityPlugin.getKeyStoreLocation(), (String)SecurityPlugin.getWorkspaceName());
                this._node.setSecurityParameters(this.getClientParms());
                this._node.getSecurityParameters().getKeystoreManager().loadKeystore(this._node.getSecurityParameters().getKeystoreFileName(), this._node.getSecurityParameters().getKeystoreFilepassword());
                this._node.setUser(UserFactory.getUser((Application)this._app, (String)this._userId));
                return this.connect();
            }
            catch (Exception e1) {
                this.resetConnection();
                String text = SecurityPlugin.getResourceString("STR_KEY_NOT_FOUND_ERROR_");
                text = TString.change(text, "%1", SecurityPlugin.getKeyStoreLocation());
                String msg = SecurityPlugin.getResourceString("CONNECTION_FAIL_TEXT");
                msg = TString.change(msg, "%1", this._hostName);
                Status err = new Status(2, "org.eclipse.core.resources", 2, text, (Throwable)e);
                this.openErrorDialog(SecurityPlugin.getResourceString("SEC_MSG"), msg, err);
                return 2;
            }
        }
        catch (CertificateException e) {
            this.resetConnection();
            String text = SecurityPlugin.getResourceString("STR_KEY_LOAD_ERROR_");
            text = TString.change(text, "%1", SecurityPlugin.getKeyStoreLocation());
            String msg = SecurityPlugin.getResourceString("CONNECTION_FAIL_TEXT");
            msg = TString.change(msg, "%1", this._hostName);
            Status err = new Status(2, "org.eclipse.core.resources", 2, text, (Throwable)e);
            this.openErrorDialog(SecurityPlugin.getResourceString("SEC_MSG"), msg, err);
            return 2;
        }
        catch (KeyManagementException e) {
            this.resetConnection();
            String text = SecurityPlugin.getResourceString("STR_KEY_MANAG_ERROR_");
            text = TString.change(text, "%1", SecurityPlugin.getKeyStoreLocation());
            String msg = SecurityPlugin.getResourceString("CONNECTION_FAIL_TEXT");
            msg = TString.change(msg, "%1", this._hostName);
            Status err = new Status(2, "org.eclipse.core.resources", 2, text, (Throwable)e);
            this.openErrorDialog(SecurityPlugin.getResourceString("SEC_MSG"), msg, err);
            return 2;
        }
        catch (KeyStoreException e) {
            this.resetConnection();
            String text = SecurityPlugin.getResourceString("STR_KEY_STORE_ERROR_");
            text = TString.change(text, "%1", SecurityPlugin.getKeyStoreLocation());
            String msg = SecurityPlugin.getResourceString("CONNECTION_FAIL_TEXT");
            msg = TString.change(msg, "%1", this._hostName);
            Status err = new Status(2, "org.eclipse.core.resources", 2, text, (Throwable)e);
            this.openErrorDialog(SecurityPlugin.getResourceString("SEC_MSG"), msg, err);
            return 2;
        }
        catch (NoSuchAlgorithmException e) {
            this.resetConnection();
            String text = SecurityPlugin.getResourceString("STR_ALGORITHM_ERROR_");
            text = TString.change(text, "%1", SecurityPlugin.getKeyStoreLocation());
            String msg = SecurityPlugin.getResourceString("CONNECTION_FAIL_TEXT");
            msg = TString.change(msg, "%1", this._hostName);
            Status err = new Status(2, "org.eclipse.core.resources", 2, text, (Throwable)e);
            this.openErrorDialog(SecurityPlugin.getResourceString("SEC_MSG"), msg, err);
            return 2;
        }
        catch (UnrecoverableKeyException e) {
            this.resetConnection();
            String text = SecurityPlugin.getResourceString("STR_UNREC_KEY_ERROR_");
            text = TString.change(text, "%1", SecurityPlugin.getKeyStoreLocation());
            String msg = SecurityPlugin.getResourceString("CONNECTION_FAIL_TEXT");
            msg = TString.change(msg, "%1", this._hostName);
            Status err = new Status(2, "org.eclipse.core.resources", 2, text, (Throwable)e);
            this.openErrorDialog(SecurityPlugin.getResourceString("SEC_MSG"), msg, err);
            return 2;
        }
        return 0;
    }

    private boolean checkConnectionExists() {
        Node node = NodeFactory.getNode((InetAddress)this._hostAddr, (Principal)this._app);
        if (node != null && node.isConnected()) {
            this._node = node;
            return true;
        }
        return false;
    }

    private void openErrorDialog(final String title, final String msg, final Status err) {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                ErrorDialog.openError((Shell)ConnectUtil.getValidShell(), (String)title, (String)msg, (IStatus)err);
            }
        });
    }

    private void openDialog(final Dialog dialog) {
        dialog.getShell().getDisplay().syncExec(new Runnable(){

            public void run() {
                dialog.open();
            }
        });
    }

    private static Shell getValidShell() {
        Shell shell = null;
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench != null) {
            if (workbench.getActiveWorkbenchWindow() != null && (shell = workbench.getActiveWorkbenchWindow().getShell()) != null && !shell.isDisposed()) {
                return shell;
            }
            if (workbench.getWorkbenchWindows().length > 0 && (shell = workbench.getWorkbenchWindows()[0].getShell()) != null && !shell.isDisposed()) {
                return shell;
            }
        }
        return null;
    }

    private boolean openQuestionDialog(final String title, final String msg) {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                ConnectUtil.this.okPressed = MessageDialog.openQuestion((Shell)ConnectUtil.getValidShell(), (String)title, (String)msg);
            }
        });
        return this.okPressed;
    }
}

