/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.parsers;

import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.eclipse.hyades.logging.core.Guid;
import org.eclipse.hyades.logging.events.cbe.CommonBaseEvent;
import org.eclipse.hyades.logging.events.cbe.ComponentIdentification;
import org.eclipse.hyades.logging.events.cbe.ReportSituation;
import org.eclipse.hyades.logging.events.cbe.Situation;
import org.eclipse.hyades.logging.events.cbe.SituationType;
import org.eclipse.hyades.logging.parsers.LogParserException;
import org.eclipse.hyades.logging.parsers.Parser;
import org.eclipse.hyades.logging.parsers.ParserConstants;
import org.eclipse.hyades.logging.parsers.ParserUtilities;

public abstract class AbstractAccessLogParser
extends Parser {
    protected String clientIP = null;
    protected String method = null;
    protected String fileName = null;
    protected String returnCode = null;
    protected String fileSize = null;
    protected String userID = null;
    protected String message = null;
    protected StringBuffer currentTimeStamp = null;
    protected StringBuffer cgiDebuggingOutput = new StringBuffer();
    protected String productVersion = null;
    protected String sourceID = null;
    private String previousTimeStamp = "";
    private long duplicateTimeStampCounter = 0L;

    public void preParse() throws LogParserException {
        super.preParse();
    }

    public void postParse() throws LogParserException {
        super.postParse();
    }

    public CommonBaseEvent[] parseNext() throws LogParserException {
        CommonBaseEvent[] temp = null;
        this.curLine = this.readLine();
        this.arrayIndex = 0;
        try {
            while (this.curLine != null) {
                this.curLine = this.curLine.trim();
                if (this.curLine.length() > 0) {
                    if (this.parseLogRecord()) {
                        if (this.cgiDebuggingOutput.length() > 0) {
                            this.createCGIDebuggingOutputCBE();
                            ++this.arrayIndex;
                            if (this.arrayIndex == this.MessageArraySize) {
                                this.increaseMsgArraySize();
                            }
                            ++this.recordCount;
                        }
                        this.reinitializeCBE();
                        if (this.previousTimeStamp.equals(this.currentTimeStamp.toString())) {
                            this.messages[this.arrayIndex].setSequenceNumber(++this.duplicateTimeStampCounter);
                        } else {
                            this.previousTimeStamp = this.currentTimeStamp.toString();
                            this.duplicateTimeStampCounter = 0L;
                        }
                        this.messages[this.arrayIndex].setCreationTime(this.currentTimeStamp.toString());
                        this.messages[this.arrayIndex].setMsg(this.message);
                        this.messages[this.arrayIndex].setSeverity((short)10);
                        if (this.method != null) {
                            this.messages[this.arrayIndex].addExtendedDataElement(Parser.createStringEDE("method", this.method));
                        }
                        if (this.clientIP != null) {
                            this.messages[this.arrayIndex].addExtendedDataElement(Parser.createStringEDE("client", this.clientIP));
                        }
                        if (this.fileName != null) {
                            this.messages[this.arrayIndex].addExtendedDataElement(Parser.createStringEDE("file", this.fileName));
                        }
                        if (this.returnCode != null) {
                            this.messages[this.arrayIndex].addExtendedDataElement(Parser.createStringEDE("return_code", this.returnCode));
                        }
                        if (this.fileSize != null) {
                            this.messages[this.arrayIndex].addExtendedDataElement(Parser.createStringEDE("file_size", this.fileSize));
                        }
                        if (this.userID != null) {
                            this.messages[this.arrayIndex].addExtendedDataElement(Parser.createStringEDE("userid", this.userID));
                        }
                        ++this.arrayIndex;
                        if (this.arrayIndex == this.MessageArraySize) {
                            this.arrayIndex = 0;
                            ++this.recordCount;
                            this.reset();
                            return this.messages;
                        }
                        ++this.recordCount;
                        this.reset();
                    } else {
                        this.cgiDebuggingOutput.append(this.curLine);
                        this.cgiDebuggingOutput.append(ParserConstants.LINE_SEPARATOR);
                    }
                }
                this.curLine = this.readLine();
            }
            if (this.cgiDebuggingOutput.length() > 0) {
                if (this.recordCount == 0) {
                    throw new LogParserException(ParserUtilities.getResourceString("INVALID_ACCESS_LOG_ERROR_", this.file_path));
                }
                this.createCGIDebuggingOutputCBE();
                ++this.arrayIndex;
                if (this.arrayIndex == this.MessageArraySize) {
                    this.arrayIndex = 0;
                    ++this.recordCount;
                    this.reset();
                    return this.messages;
                }
                ++this.recordCount;
            }
            if (this.arrayIndex == 0) {
                temp = null;
            } else {
                int i = this.arrayIndex;
                while (i < this.MessageArraySize) {
                    this.messages[i] = null;
                    ++i;
                }
                temp = this.messages;
            }
            if (this.recordCount == 0) {
                throw new LogParserException(ParserUtilities.getResourceString("NO_LOG_RECORDS_ERROR_", this.file_path));
            }
        }
        catch (LogParserException l) {
            throw l;
        }
        catch (Throwable t) {
            ParserUtilities.exceptionHandler(t, this.curLineNumber, this.curLine, ParserUtilities.getResourceString("ACCESS_LOG_PARSER_ERROR_"));
        }
        return temp;
    }

    private void reinitializeCBE() {
        this.messages[this.arrayIndex].init();
        this.messages[this.arrayIndex].setGlobalInstanceId(Guid.generate());
        ComponentIdentification sourceComponentID = Parser.eventFactory.createComponentIdentification();
        sourceComponentID.setLocation(this.localHostId);
        sourceComponentID.setLocationType(this.localHostIdFormat);
        sourceComponentID.setComponent(this.sourceID);
        sourceComponentID.setSubComponent("Unknown");
        sourceComponentID.setComponentType("ApacheHTTPServer");
        sourceComponentID.setComponentIdType("ProductName");
        this.messages[this.arrayIndex].setSourceComponentId(sourceComponentID);
        this.messages[this.arrayIndex].setSituation(this.createSituation());
    }

    private Situation createSituation() {
        Situation cbeSituation = Parser.eventFactory.createSituation();
        ReportSituation cbeReportSituation = Parser.eventFactory.createReportSituation();
        cbeReportSituation.setReasoningScope("INTERNAL");
        cbeReportSituation.setReportCategory("LOG");
        cbeSituation.setCategoryName("ReportSituation");
        cbeSituation.setSituationType((SituationType)cbeReportSituation);
        return cbeSituation;
    }

    protected boolean parseDate(int startIndex, int endIndex) {
        if (this.curLine.charAt(startIndex) == '[' && this.curLine.charAt(endIndex) == ']') {
            int timeZoneIndex = this.curLine.indexOf(45, startIndex);
            if (!(timeZoneIndex != -1 && timeZoneIndex <= endIndex || (timeZoneIndex = this.curLine.indexOf(43, startIndex)) != -1 && timeZoneIndex <= endIndex)) {
                return false;
            }
            SimpleDateFormat formatter = new SimpleDateFormat("dd/MMM/yyyy:HH:mm:ss", Locale.US);
            Date creationDate = formatter.parse(this.curLine.substring(startIndex + 1, timeZoneIndex).trim(), new ParsePosition(0));
            if (creationDate != null) {
                formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                this.currentTimeStamp = new StringBuffer(formatter.format(creationDate).trim());
                this.currentTimeStamp.replace(10, 11, "T");
                this.currentTimeStamp.append(".000000");
                this.currentTimeStamp.append(this.curLine.charAt(timeZoneIndex));
                this.currentTimeStamp.append(this.curLine.substring(timeZoneIndex + 1, timeZoneIndex + 3));
                this.currentTimeStamp.append(":");
                this.currentTimeStamp.append(this.curLine.substring(timeZoneIndex + 3, timeZoneIndex + 5));
                return true;
            }
        }
        return false;
    }

    protected boolean parseLogRecord() {
        int previousIndex = 0;
        int currentIndex = this.curLine.indexOf(" ");
        if (currentIndex == -1) {
            return false;
        }
        this.clientIP = this.curLine.substring(previousIndex, currentIndex).trim();
        if (!ParserUtilities.isValidIPAddress(this.clientIP)) {
            return false;
        }
        previousIndex = currentIndex;
        if ((currentIndex = this.curLine.indexOf(" ", previousIndex + 1)) == -1) {
            return false;
        }
        previousIndex = currentIndex;
        if ((currentIndex = this.curLine.indexOf(" ", previousIndex + 1)) == -1) {
            return false;
        }
        this.userID = this.curLine.substring(previousIndex, currentIndex).trim();
        if (this.userID.equals("-")) {
            this.userID = null;
        }
        if ((currentIndex = this.curLine.indexOf("[", previousIndex = currentIndex)) == -1) {
            return false;
        }
        previousIndex = currentIndex;
        if ((currentIndex = this.curLine.indexOf("]", previousIndex)) == -1) {
            return false;
        }
        if (!this.parseDate(previousIndex, currentIndex)) {
            return false;
        }
        previousIndex = currentIndex;
        if ((currentIndex = this.curLine.indexOf("\"", previousIndex)) == -1) {
            return false;
        }
        previousIndex = currentIndex;
        if ((currentIndex = this.curLine.indexOf(" ", previousIndex)) == -1) {
            return false;
        }
        this.method = this.curLine.substring(previousIndex + 1, currentIndex).trim();
        this.message = this.curLine.substring(previousIndex).trim();
        int secondQuoteIndex = this.curLine.lastIndexOf("\"");
        if (secondQuoteIndex == -1 || secondQuoteIndex == previousIndex) {
            return false;
        }
        previousIndex = currentIndex;
        currentIndex = this.curLine.lastIndexOf(" ", secondQuoteIndex);
        if (currentIndex == previousIndex) {
            this.fileName = this.curLine.substring(previousIndex, secondQuoteIndex).trim();
            previousIndex = secondQuoteIndex;
        } else {
            this.fileName = this.curLine.substring(previousIndex, currentIndex).trim();
            previousIndex = currentIndex;
        }
        currentIndex = this.curLine.indexOf(" ", previousIndex + 1);
        if (currentIndex == -1) {
            return false;
        }
        previousIndex = currentIndex;
        if ((currentIndex = this.curLine.indexOf(" ", previousIndex + 1)) == -1) {
            return false;
        }
        this.returnCode = this.curLine.substring(previousIndex, currentIndex).trim();
        this.fileSize = this.curLine.substring(currentIndex).trim();
        return true;
    }

    private void createCGIDebuggingOutputCBE() {
        this.reinitializeCBE();
        this.messages[this.arrayIndex].setSequenceNumber(++this.duplicateTimeStampCounter);
        this.messages[this.arrayIndex].setCreationTime(this.previousTimeStamp);
        this.messages[this.arrayIndex].setMsg(this.cgiDebuggingOutput.toString().trim());
        this.messages[this.arrayIndex].setSeverity((short)10);
        this.messages[this.arrayIndex].addExtendedDataElement(Parser.createStringEDE("CGI_debugging_output", this.cgiDebuggingOutput.toString().trim()));
    }

    protected void reset() {
        this.userID = null;
        this.method = null;
        this.returnCode = null;
        this.clientIP = null;
        this.fileName = null;
        this.fileSize = null;
        this.message = null;
        this.currentTimeStamp = null;
        this.cgiDebuggingOutput = new StringBuffer();
    }
}

