/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.ui.internal.editor;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.hyades.ui.HyadesUIPlugin;
import org.eclipse.hyades.ui.adapter.ISynchronizedEditorAdapter;
import org.eclipse.hyades.ui.util.IDisposable;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;

public class EditorSynchronizer
implements IDisposable {
    private AllInOneListener listener;
    private IEditorPart editorPart;
    private ISynchronizedEditorAdapter synchronizedEditorAdapter;
    private FileEditorInput editorFile;
    private OSFile editorOSFile;
    static /* synthetic */ Class class$org$eclipse$hyades$ui$adapter$ISynchronizedEditorAdapter;

    public static boolean isReadOnly(FileEditorInput workspaceFile) {
        if (workspaceFile == null) {
            return false;
        }
        IPath path = workspaceFile.getPath();
        if (path == null) {
            path = workspaceFile.getFile().getFullPath();
        }
        if (path == null) {
            return workspaceFile.exists();
        }
        File file = new File(path.toString());
        if (file.exists()) {
            return !file.canWrite();
        }
        return false;
    }

    public static boolean exists(FileEditorInput workspaceFile) {
        if (workspaceFile == null) {
            return false;
        }
        IPath path = workspaceFile.getPath();
        if (path == null) {
            path = workspaceFile.getFile().getFullPath();
        }
        if (path == null) {
            return workspaceFile.exists();
        }
        return new File(path.toString()).exists();
    }

    public static FileEditorInput getEditorFile(IEditorInput editorInput) {
        if (editorInput != null && editorInput instanceof IFileEditorInput) {
            return new FileEditorInput(((IFileEditorInput)editorInput).getFile());
        }
        return null;
    }

    public EditorSynchronizer(IEditorPart editorPart) throws IllegalArgumentException {
        this.editorPart = editorPart;
        if (editorPart == null || editorPart.getSite() == null) {
            throw new IllegalArgumentException(HyadesUIPlugin.getString("_ERROR_ARG_INV"));
        }
        this.synchronizedEditorAdapter = (ISynchronizedEditorAdapter)editorPart.getAdapter(class$org$eclipse$hyades$ui$adapter$ISynchronizedEditorAdapter == null ? (class$org$eclipse$hyades$ui$adapter$ISynchronizedEditorAdapter = EditorSynchronizer.class$("org.eclipse.hyades.ui.adapter.ISynchronizedEditorAdapter")) : class$org$eclipse$hyades$ui$adapter$ISynchronizedEditorAdapter);
        this.listener = new AllInOneListener();
        this.editorFile = EditorSynchronizer.getEditorFile(editorPart.getEditorInput());
        if (this.editorFile != null) {
            this.editorFile.getFile().getWorkspace().addResourceChangeListener((IResourceChangeListener)this.listener, 1);
            this.editorOSFile = new OSFile(this.editorFile);
        }
        PlatformUI.getWorkbench().addWindowListener((IWindowListener)this.listener);
        editorPart.getSite().getPage().addPartListener((IPartListener2)this.listener);
    }

    public void dispose() {
        if (this.listener == null) {
            return;
        }
        if (this.editorFile != null) {
            this.editorFile.getFile().getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.listener);
            this.editorFile = null;
        }
        PlatformUI.getWorkbench().removeWindowListener((IWindowListener)this.listener);
        this.editorPart.getSite().getPage().removePartListener((IPartListener2)this.listener);
        this.listener = null;
        this.editorPart = null;
        this.synchronizedEditorAdapter = null;
        this.editorOSFile = null;
    }

    public FileEditorInput getEditorFile() {
        return this.editorFile;
    }

    protected OSFile getEditorOSFile() {
        return this.editorOSFile;
    }

    protected IEditorPart getEditorPart() {
        return this.editorPart;
    }

    protected ISynchronizedEditorAdapter getSynchronizedEditorAdapter() {
        return this.synchronizedEditorAdapter;
    }

    public void setResourceChangeListenerEnabled(boolean enabled) {
        this.listener.setResourceChangeListenerEnabled(enabled);
    }

    public boolean isResourceChangeListenerEnabled() {
        return this.listener.isResourceChangeListenerEnabled();
    }

    public synchronized void editorSaved() {
        if (this.getEditorOSFile() != null) {
            this.getEditorOSFile().wasChanged();
        }
    }

    public boolean validateEdit() {
        IStatus status;
        return this.editorFile == null || !EditorSynchronizer.isReadOnly(this.editorFile) || (status = ResourcesPlugin.getWorkspace().validateEdit(new IFile[]{this.editorFile.getFile()}, (Object)this.editorPart.getSite().getShell())).getCode() == 0;
    }

    public boolean validateEdit(IFile[] files) {
        IStatus status;
        return this.editorFile == null || !EditorSynchronizer.isReadOnly(this.editorFile) || (status = ResourcesPlugin.getWorkspace().validateEdit(files, (Object)this.editorPart.getSite().getShell())).getCode() == 0;
    }

    protected void checkOSFiles() {
        if (this.getEditorOSFile() != null && (this.getEditorOSFile().wasDeleted() ? this.editorFileDeleted() : (this.getEditorOSFile().wasChanged() ? this.editorFileChanged() : this.getEditorOSFile().writeAccessChanged() && this.editorFileWriteAccessChanged(this.getEditorOSFile().isReadOnly())))) {
            return;
        }
    }

    protected boolean editorFileDeleted() {
        Runnable runnable = new Runnable(){

            public void run() {
                boolean close;
                if (EditorSynchronizer.this.getSynchronizedEditorAdapter() != null && EditorSynchronizer.this.getSynchronizedEditorAdapter().editorFileDeleted()) {
                    return;
                }
                boolean bl = close = !EditorSynchronizer.this.getEditorPart().isDirty();
                if (EditorSynchronizer.this.getEditorPart().isDirty()) {
                    if (EditorSynchronizer.this.isActiveEditor(EditorSynchronizer.this.getEditorPart())) {
                        MessageDialog messageDialog = new MessageDialog(EditorSynchronizer.this.getEditorPart().getSite().getShell(), HyadesUIPlugin.getString("Q_FILE_DELETED_TTL"), null, HyadesUIPlugin.getString("Q_FILE_DELETED"), 3, new String[]{HyadesUIPlugin.getString("LBL_SAVE"), HyadesUIPlugin.getString("LBL_CLOSE")}, 0);
                        close = messageDialog.open() == 1;
                    } else if (EditorSynchronizer.this.getEditorOSFile() != null) {
                        EditorSynchronizer.this.getEditorOSFile().setIsDeleted();
                    }
                }
                if (close) {
                    EditorSynchronizer.this.getEditorPart().getSite().getPage().closeEditor(EditorSynchronizer.this.getEditorPart(), false);
                } else if (EditorSynchronizer.this.getSynchronizedEditorAdapter() != null) {
                    EditorSynchronizer.this.getSynchronizedEditorAdapter().doSaveEditorFile(true);
                }
            }
        };
        return this.execute(runnable);
    }

    protected boolean editorFileChanged() {
        Runnable runnable = new Runnable(){

            public void run() {
                if (EditorSynchronizer.this.getSynchronizedEditorAdapter() != null && EditorSynchronizer.this.getSynchronizedEditorAdapter().editorFileChanged()) {
                    return;
                }
                if (EditorSynchronizer.this.getEditorFile() == null) {
                    return;
                }
                try {
                    EditorSynchronizer.this.getEditorFile().getFile().refreshLocal(1, null);
                }
                catch (CoreException e) {
                    HyadesUIPlugin.logError(e);
                }
                if (EditorSynchronizer.this.isActiveEditor(EditorSynchronizer.this.getEditorPart())) {
                    if (MessageDialog.openQuestion((Shell)EditorSynchronizer.this.getEditorPart().getSite().getShell(), (String)HyadesUIPlugin.getString("Q_FILE_CHANGED_TTL"), (String)HyadesUIPlugin.getString("Q_FILE_CHANGED")) && EditorSynchronizer.this.getSynchronizedEditorAdapter() != null) {
                        EditorSynchronizer.this.getSynchronizedEditorAdapter().reload();
                    }
                } else if (EditorSynchronizer.this.getEditorOSFile() != null) {
                    EditorSynchronizer.this.getEditorOSFile().setIsChanged();
                }
            }
        };
        return this.execute(runnable);
    }

    protected boolean editorFileWriteAccessChanged(final boolean isReadOnly) {
        final AllInOneListener finalListener = this.listener;
        Runnable runnable = new Runnable(){

            public void run() {
                if (finalListener.isResourceChangeListenerEnabled()) {
                    return;
                }
                if (EditorSynchronizer.this.getSynchronizedEditorAdapter() != null) {
                    EditorSynchronizer.this.getSynchronizedEditorAdapter().editorFileWriteAccessChanged(isReadOnly);
                }
            }
        };
        return this.execute(runnable);
    }

    protected void handle(final List changedFiles, final List removedFiles) {
        Runnable runnable = new Runnable(){

            public void run() {
                if (EditorSynchronizer.this.getSynchronizedEditorAdapter() != null) {
                    EditorSynchronizer.this.getSynchronizedEditorAdapter().handle(changedFiles, removedFiles);
                }
            }
        };
        this.execute(runnable);
    }

    protected boolean execute(Runnable runnable) {
        this.getEditorPart().getSite().getShell().getDisplay().asyncExec((Runnable)new SynchronizedRunnable(this.listener, runnable));
        return false;
    }

    protected boolean isActiveEditor(IEditorPart editorPart) {
        try {
            return editorPart.getSite().getPage().getActiveEditor() == editorPart;
        }
        catch (RuntimeException re) {
            return false;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class AllInOneListener
    implements IPartListener,
    IPartListener2,
    IWindowListener,
    IResourceChangeListener {
        private boolean resourceChangeListenerEnabled = true;

        private AllInOneListener() {
        }

        public void setResourceChangeListenerEnabled(boolean enabled) {
            this.resourceChangeListenerEnabled = enabled;
        }

        public boolean isResourceChangeListenerEnabled() {
            return this.resourceChangeListenerEnabled;
        }

        public void partActivated(IWorkbenchPart part) {
            if (!this.resourceChangeListenerEnabled) {
                return;
            }
            if (part == EditorSynchronizer.this.getEditorPart()) {
                EditorSynchronizer.this.checkOSFiles();
            }
        }

        public void partBroughtToTop(IWorkbenchPart part) {
        }

        public void partClosed(IWorkbenchPart part) {
        }

        public void partDeactivated(IWorkbenchPart part) {
        }

        public void partOpened(IWorkbenchPart part) {
        }

        public void partActivated(IWorkbenchPartReference ref) {
            if (!this.resourceChangeListenerEnabled) {
                return;
            }
            if (ref.getPart(false) == EditorSynchronizer.this.getEditorPart()) {
                EditorSynchronizer.this.checkOSFiles();
            }
        }

        public void partBroughtToTop(IWorkbenchPartReference ref) {
        }

        public void partClosed(IWorkbenchPartReference ref) {
        }

        public void partDeactivated(IWorkbenchPartReference ref) {
        }

        public void partOpened(IWorkbenchPartReference ref) {
        }

        public void partHidden(IWorkbenchPartReference ref) {
        }

        public void partVisible(IWorkbenchPartReference ref) {
        }

        public void partInputChanged(IWorkbenchPartReference ref) {
        }

        public void windowActivated(IWorkbenchWindow window) {
            if (!this.resourceChangeListenerEnabled) {
                return;
            }
            if (window == PlatformUI.getWorkbench().getActiveWorkbenchWindow() && window.getActivePage() != null && window.getActivePage().getActivePart() == EditorSynchronizer.this.getEditorPart()) {
                EditorSynchronizer.this.checkOSFiles();
            }
        }

        public void windowDeactivated(IWorkbenchWindow window) {
        }

        public void windowClosed(IWorkbenchWindow window) {
        }

        public void windowOpened(IWorkbenchWindow window) {
        }

        public void resourceChanged(IResourceChangeEvent event) {
            if (!this.resourceChangeListenerEnabled) {
                return;
            }
            IResourceDelta delta = event.getDelta();
            ResourceDeltaVisitor visitor = new ResourceDeltaVisitor();
            try {
                delta.accept((IResourceDeltaVisitor)visitor);
                if (!visitor.getChangedFiles().isEmpty() && !visitor.getRemovedFiles().isEmpty()) {
                    EditorSynchronizer.this.handle(visitor.getChangedFiles(), visitor.getRemovedFiles());
                    visitor.dispose();
                }
            }
            catch (CoreException e) {
                HyadesUIPlugin.logError(e);
            }
        }
    }

    private class ResourceDeltaVisitor
    implements IDisposable,
    IResourceDeltaVisitor {
        private List changedFiles = new ArrayList();
        private List removedFiles = new ArrayList();

        private ResourceDeltaVisitor() {
        }

        public void dispose() {
            this.changedFiles.clear();
            this.removedFiles.clear();
        }

        public boolean visit(IResourceDelta delta) {
            if (delta.getResource().getType() == 1 && (delta.getKind() & 6) != 0) {
                IFile file = (IFile)delta.getResource();
                if ((delta.getKind() & 2) != 0) {
                    if (file.equals((Object)EditorSynchronizer.this.getEditorFile())) {
                        if (EditorSynchronizer.this.getEditorOSFile() != null) {
                            EditorSynchronizer.this.getEditorOSFile().wasDeleted();
                        }
                        if (EditorSynchronizer.this.editorFileDeleted()) {
                            this.dispose();
                            return false;
                        }
                    }
                } else if (file.equals((Object)EditorSynchronizer.this.getEditorFile().getFile())) {
                    if (EditorSynchronizer.this.getEditorOSFile() != null) {
                        EditorSynchronizer.this.getEditorOSFile().wasChanged();
                    }
                    if (EditorSynchronizer.this.editorFileChanged()) {
                        this.dispose();
                        return false;
                    }
                }
            }
            return true;
        }

        public List getChangedFiles() {
            return this.changedFiles;
        }

        public List getRemovedFiles() {
            return this.removedFiles;
        }
    }

    private static class OSFile {
        private File file;
        private long lastModified;
        private boolean writable = false;
        private boolean exists = false;

        public OSFile(FileEditorInput workspaceFile) {
            IPath path = workspaceFile.getPath();
            if (path == null) {
                return;
            }
            this.file = new File(path.toOSString());
            if (this.file.exists()) {
                this.lastModified = this.file.lastModified();
                this.writable = this.file.canWrite();
                this.exists = this.file.exists();
            }
        }

        public boolean writeAccessChanged() {
            if (this.file != null) {
                if (!this.file.exists()) {
                    return false;
                }
                boolean canWrite = this.file.canWrite();
                if (canWrite != this.writable) {
                    this.writable = canWrite;
                    return true;
                }
            }
            return false;
        }

        public boolean wasDeleted() {
            if (this.file != null && this.exists && !this.file.exists()) {
                this.exists = false;
                return true;
            }
            return false;
        }

        public boolean wasChanged() {
            if (this.file != null) {
                if (!this.file.exists()) {
                    return false;
                }
                long newLastModified = this.file.lastModified();
                if (newLastModified != this.lastModified) {
                    this.lastModified = newLastModified;
                    return true;
                }
            }
            return false;
        }

        public void setIsChanged() {
            --this.lastModified;
        }

        public void setIsDeleted() {
            this.exists = true;
        }

        public boolean isReadOnly() {
            if (this.file != null && this.file.exists()) {
                return !this.file.canWrite();
            }
            return false;
        }

        public boolean exists() {
            if (this.file != null) {
                return this.file.exists();
            }
            return true;
        }
    }

    private static class SynchronizedRunnable
    implements Runnable {
        private AllInOneListener listener;
        private Runnable runnable;

        public SynchronizedRunnable(AllInOneListener listener, Runnable runnable) {
            this.listener = listener;
            this.runnable = runnable;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            AllInOneListener allInOneListener = this.listener;
            synchronized (allInOneListener) {
                boolean initialState = this.listener.isResourceChangeListenerEnabled();
                try {
                    this.listener.setResourceChangeListenerEnabled(false);
                    this.runnable.run();
                    Object var4_3 = null;
                    if (this.listener != null) {
                        this.listener.setResourceChangeListenerEnabled(initialState);
                    }
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    if (this.listener != null) {
                        this.listener.setResourceChangeListenerEnabled(initialState);
                    }
                    throw throwable;
                }
                this.listener = null;
                this.runnable = null;
            }
        }
    }
}

