/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.events.cbe.util.tests;

import java.util.Iterator;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.logging.events.cbe.AssociatedEvent;
import org.eclipse.hyades.logging.events.cbe.AssociationEngine;
import org.eclipse.hyades.logging.events.cbe.AvailableSituation;
import org.eclipse.hyades.logging.events.cbe.CommonBaseEvent;
import org.eclipse.hyades.logging.events.cbe.ComponentIdentification;
import org.eclipse.hyades.logging.events.cbe.ContextDataElement;
import org.eclipse.hyades.logging.events.cbe.EventFactory;
import org.eclipse.hyades.logging.events.cbe.EventPackage;
import org.eclipse.hyades.logging.events.cbe.ExtendedDataElement;
import org.eclipse.hyades.logging.events.cbe.MsgDataElement;
import org.eclipse.hyades.logging.events.cbe.Situation;
import org.eclipse.hyades.logging.events.cbe.impl.tests.Util;
import org.eclipse.hyades.logging.events.cbe.util.EventHelpers;

public class EventHelpersTest
extends TestCase {
    public EventHelpersTest(String string) {
        super(string);
    }

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testCompareEvent() {
        CommonBaseEvent commonBaseEvent = this.createReferenceEvent();
        Assert.assertTrue((boolean)commonBaseEvent.equals(commonBaseEvent));
        CommonBaseEvent commonBaseEvent2 = (CommonBaseEvent)Util.clone(commonBaseEvent);
        Assert.assertTrue((boolean)commonBaseEvent.equals(commonBaseEvent2));
    }

    public void testCompareExtendedDataElementValues() {
        EventFactory eventFactory = EventFactory.eINSTANCE;
        ExtendedDataElement extendedDataElement = eventFactory.createExtendedDataElement();
        extendedDataElement.getValues().add("A");
        extendedDataElement.getValues().add("B");
        ExtendedDataElement extendedDataElement2 = eventFactory.createExtendedDataElement();
        extendedDataElement2.getValues().add("A");
        extendedDataElement2.getValues().add("B");
        Assert.assertEquals((Object)extendedDataElement, (Object)extendedDataElement2);
        extendedDataElement.getValues().clear();
        extendedDataElement.getValues().add("A");
        extendedDataElement.getValues().add("B");
        extendedDataElement2.getValues().clear();
        extendedDataElement2.getValues().add("B");
        extendedDataElement2.getValues().add("A");
        Assert.assertTrue((!extendedDataElement.equals(extendedDataElement2) ? 1 : 0) != 0);
    }

    public void testCompareMsgDataElementMsgCatalogTokens() {
        EventFactory eventFactory = EventFactory.eINSTANCE;
        MsgDataElement msgDataElement = eventFactory.createMsgDataElement();
        msgDataElement.addMsgCatalogTokenAsString("A");
        msgDataElement.addMsgCatalogTokenAsString("B");
        MsgDataElement msgDataElement2 = eventFactory.createMsgDataElement();
        msgDataElement2.addMsgCatalogTokenAsString("A");
        msgDataElement2.addMsgCatalogTokenAsString("B");
        Assert.assertEquals((Object)msgDataElement, (Object)msgDataElement2);
        msgDataElement.getMsgCatalogTokens().clear();
        msgDataElement.addMsgCatalogTokenAsString("A");
        msgDataElement.addMsgCatalogTokenAsString("B");
        msgDataElement2.getMsgCatalogTokens().clear();
        msgDataElement2.addMsgCatalogTokenAsString("B");
        msgDataElement2.addMsgCatalogTokenAsString("A");
        Assert.assertTrue((!msgDataElement.equals(msgDataElement2) ? 1 : 0) != 0);
    }

    public void testCompareEObjectDuplicateListElements() {
        CommonBaseEvent commonBaseEvent = this.createReferenceEvent();
        CommonBaseEvent commonBaseEvent2 = this.createReferenceEvent();
        int n = 0;
        while (n < 4) {
            ContextDataElement contextDataElement = EventFactory.eINSTANCE.createContextDataElement();
            String string = "A";
            if (n >= 2) {
                string = "B";
            }
            contextDataElement.setContextId(string);
            commonBaseEvent.getContextDataElements().add(contextDataElement);
            if (n == 2) {
                string = "A";
            }
            ContextDataElement contextDataElement2 = EventFactory.eINSTANCE.createContextDataElement();
            contextDataElement2.setContextId(string);
            commonBaseEvent2.getContextDataElements().add(contextDataElement2);
            ++n;
        }
        Assert.assertFalse((boolean)commonBaseEvent.equals(commonBaseEvent2));
    }

    public void testCompareEObjectDifferentListOrder() {
        CommonBaseEvent commonBaseEvent = this.createReferenceEvent();
        CommonBaseEvent commonBaseEvent2 = this.createReferenceEvent();
        int n = 0;
        while (n < 5) {
            ContextDataElement contextDataElement = EventFactory.eINSTANCE.createContextDataElement();
            contextDataElement.setContextId(Integer.toString(n));
            commonBaseEvent.getContextDataElements().add(contextDataElement);
            ContextDataElement contextDataElement2 = EventFactory.eINSTANCE.createContextDataElement();
            contextDataElement2.setContextId(Integer.toString(5 - n - 1));
            commonBaseEvent2.getContextDataElements().add(contextDataElement2);
            ++n;
        }
        Assert.assertTrue((boolean)commonBaseEvent.equals(commonBaseEvent2));
    }

    public void testCompareEObjectDifferentAttribute() {
        CommonBaseEvent commonBaseEvent = this.createReferenceEvent();
        CommonBaseEvent commonBaseEvent2 = this.createReferenceEvent();
        ComponentIdentification componentIdentification = EventFactory.eINSTANCE.createComponentIdentification();
        commonBaseEvent2.setSourceComponentId(null);
        Assert.assertFalse((boolean)commonBaseEvent.equals(commonBaseEvent2));
    }

    public void testCompareEObjectDifferentContainment() {
        EventPackage eventPackage = EventPackage.eINSTANCE;
        CommonBaseEvent commonBaseEvent = this.createReferenceEvent();
        CommonBaseEvent commonBaseEvent2 = this.createReferenceEvent();
        commonBaseEvent.getSourceComponentId().setApplication("something");
        commonBaseEvent2.getSourceComponentId().setApplication("something different");
        Assert.assertFalse((boolean)commonBaseEvent.equals(commonBaseEvent2));
        commonBaseEvent.getSourceComponentId().setApplication(null);
        commonBaseEvent2.getSourceComponentId().setApplication("something different");
        Assert.assertFalse((boolean)commonBaseEvent.equals(commonBaseEvent2));
        commonBaseEvent.getSourceComponentId().setApplication("same");
        commonBaseEvent2.getSourceComponentId().setApplication("same");
        commonBaseEvent.getSourceComponentId().setThreadId("id");
        commonBaseEvent2.getSourceComponentId().setThreadId("id2");
        Assert.assertFalse((boolean)commonBaseEvent.equals(commonBaseEvent2));
    }

    public void testCompareNotEObjects() {
        Assert.assertFalse((boolean)EventHelpers.compareEObject(new String(), new String()));
        CommonBaseEvent commonBaseEvent = this.createReferenceEvent();
        Assert.assertFalse((boolean)commonBaseEvent.equals(new String()));
        Assert.assertFalse((boolean)EventHelpers.compareEObject(new String(), commonBaseEvent));
        String string = "AAA";
        Assert.assertFalse((boolean)EventHelpers.compareEObject(string, string));
    }

    public void testCompareEObjectsNull() {
        CommonBaseEvent commonBaseEvent = this.createReferenceEvent();
        Assert.assertFalse((boolean)EventHelpers.compareEObject(commonBaseEvent, null));
        Assert.assertFalse((boolean)EventHelpers.compareEObject(null, commonBaseEvent));
    }

    public void testCompareEObjectsNotSet() {
        CommonBaseEvent commonBaseEvent = this.createReferenceEvent();
        CommonBaseEvent commonBaseEvent2 = this.createReferenceEvent();
        commonBaseEvent.unsetRepeatCount();
        commonBaseEvent2.setRepeatCount((short)0);
        Assert.assertFalse((boolean)EventHelpers.compareEObject(commonBaseEvent, commonBaseEvent2));
        Assert.assertFalse((boolean)EventHelpers.compareEObject(commonBaseEvent2, commonBaseEvent));
    }

    public void testCompareSituationTypes() {
        EventPackage eventPackage = EventPackage.eINSTANCE;
        EClass eClass = eventPackage.getSituationType();
        EFactory eFactory = eventPackage.getEFactoryInstance();
        EList eList = eventPackage.eContents();
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            EClass eClass2 = (EClass)iterator.next();
            if (!eClass2.isInstance((Object)eClass)) continue;
            EObject eObject = eFactory.create(eClass2);
            EObject eObject2 = eFactory.create(eClass2);
            Assert.assertTrue((String)(eObject.eClass().getName() + ".equals failed"), (boolean)eObject.equals(eObject2));
        }
    }

    public void testDifferentClasses() {
        EventFactory eventFactory = EventFactory.eINSTANCE;
        CommonBaseEvent commonBaseEvent = eventFactory.createCommonBaseEvent();
        ExtendedDataElement extendedDataElement = eventFactory.createExtendedDataElement();
        EventHelpers.compareEObject(commonBaseEvent, extendedDataElement);
    }

    private CommonBaseEvent createReferenceEvent() {
        EObject eObject;
        EObject eObject2;
        CommonBaseEvent commonBaseEvent = EventFactory.eINSTANCE.createCommonBaseEvent();
        commonBaseEvent.setCreationTime("1999-05-31T13:20:00-05:00");
        commonBaseEvent.setGlobalInstanceId("AAA");
        commonBaseEvent.setElapsedTime(65L);
        commonBaseEvent.setExtensionName("Event_class");
        commonBaseEvent.setLocalInstanceId("id");
        commonBaseEvent.setMsg("msg");
        commonBaseEvent.setPriority((short)32);
        commonBaseEvent.setRepeatCount((short)12);
        commonBaseEvent.setSequenceNumber(88L);
        commonBaseEvent.setSeverity((short)67);
        commonBaseEvent.setVersion("1.0.1");
        MsgDataElement msgDataElement = EventFactory.eINSTANCE.createMsgDataElement();
        msgDataElement.setMsgCatalog("cat");
        msgDataElement.setMsgCatalogId("msgCatId");
        msgDataElement.setMsgCatalogType("type");
        msgDataElement.setMsgId("abc");
        msgDataElement.setMsgIdType("idType");
        msgDataElement.setMsgLocale("locale");
        msgDataElement.addMsgCatalogTokenAsString("token1");
        commonBaseEvent.setMsgDataElement(msgDataElement);
        ComponentIdentification componentIdentification = EventFactory.eINSTANCE.createComponentIdentification();
        componentIdentification.setApplication("App");
        componentIdentification.setComponent("comp");
        componentIdentification.setComponentIdType("idType");
        componentIdentification.setComponentType("comp");
        componentIdentification.setExecutionEnvironment("env");
        componentIdentification.setInstanceId("instId");
        componentIdentification.setLocation("location");
        componentIdentification.setLocationType("type");
        componentIdentification.setProcessId("process");
        componentIdentification.setSubComponent("sub");
        componentIdentification.setThreadId("threadid");
        commonBaseEvent.setReporterComponentId(componentIdentification);
        ComponentIdentification componentIdentification2 = EventFactory.eINSTANCE.createComponentIdentification();
        componentIdentification2.setApplication("App2");
        componentIdentification2.setComponent("comp2");
        componentIdentification2.setComponentIdType("idType2");
        componentIdentification2.setComponentType("comp2");
        componentIdentification2.setExecutionEnvironment("env2");
        componentIdentification2.setInstanceId("instId2");
        componentIdentification2.setLocation("location2");
        componentIdentification2.setLocationType("type2");
        componentIdentification2.setProcessId("process2");
        componentIdentification2.setSubComponent("sub2");
        componentIdentification2.setThreadId("threadid2");
        commonBaseEvent.setSourceComponentId(componentIdentification2);
        commonBaseEvent.getAny().add("BSD1");
        commonBaseEvent.getAny().add("BSD2");
        int n = 0;
        while (n < 5) {
            AssociatedEvent associatedEvent = EventFactory.eINSTANCE.createAssociatedEvent();
            associatedEvent.setAssociationEngine("ABC" + n);
            eObject2 = EventFactory.eINSTANCE.createAssociationEngine();
            eObject2.setId("A" + n);
            eObject2.setName("B" + n);
            eObject2.setType("CFG" + n);
            associatedEvent.setAssociationEngineInfo((AssociationEngine)eObject2);
            associatedEvent.setResolvedEvents("tr YU IO" + n);
            commonBaseEvent.getAssociatedEvents().add(associatedEvent);
            ++n;
        }
        int n2 = 0;
        while (n2 < 5) {
            eObject2 = EventFactory.eINSTANCE.createContextDataElement();
            eObject2.setContextId("id" + n2);
            eObject2.setContextValue("bfg" + n2);
            eObject2.setName("rew" + n2);
            eObject2.setType("tr4" + n2);
            commonBaseEvent.getContextDataElements().add(eObject2);
            ++n2;
        }
        int n3 = 0;
        while (n3 < 5) {
            eObject = EventFactory.eINSTANCE.createExtendedDataElement();
            eObject.setName("tre" + n3);
            eObject.setType("string" + n3);
            eObject.getValues().add("text" + n3);
            commonBaseEvent.getExtendedDataElements().add(eObject);
            ++n3;
        }
        eObject = EventFactory.eINSTANCE.createSituation();
        AvailableSituation availableSituation = EventFactory.eINSTANCE.createAvailableSituation();
        availableSituation.setAvailabilityDisposition("av");
        availableSituation.setOperationDisposition("op");
        availableSituation.setProcessingDisposition("pro");
        availableSituation.setReasoningScope("reason");
        eObject.setCategoryName("cat");
        eObject.setSituationType(availableSituation);
        commonBaseEvent.setSituation((Situation)eObject);
        return commonBaseEvent;
    }

    public void testCompareExtendedDataElementHexValue() {
        ExtendedDataElement extendedDataElement = EventFactory.eINSTANCE.createExtendedDataElement();
        extendedDataElement.setHexValue("ABc123");
        ExtendedDataElement extendedDataElement2 = EventFactory.eINSTANCE.createExtendedDataElement();
        extendedDataElement2.setHexValue("abC123");
        Assert.assertEquals((Object)extendedDataElement, (Object)extendedDataElement2);
    }
}

