/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.uml2sd.ui.actions.widgets;

import java.text.MessageFormat;
import org.eclipse.hyades.uml2sd.ui.SDViewerPlugin;
import org.eclipse.hyades.uml2sd.ui.actions.provider.ISDAdvancedPagingProvider;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.help.WorkbenchHelp;

public class PagesDialog
extends Dialog {
    private IViewPart viewer = null;
    private ISDAdvancedPagingProvider provider = null;
    private TextArea currentPage;
    private Label totalPageComment;

    private void updateComments() {
        int pages = Math.max(0, this.provider.pagesCount());
        String totalPageCommentText = SDViewerPlugin.getResourceString("PAGES_TOTAL") + pages + " ";
        totalPageCommentText = pages == 0 ? totalPageCommentText + SDViewerPlugin.getResourceString("PAGES_NO_PAGES") : (pages == 1 ? totalPageCommentText + SDViewerPlugin.getResourceString("PAGES_ONE_PAGE") : totalPageCommentText + SDViewerPlugin.getResourceString("PAGES_SEVERAL_PAGES"));
        this.totalPageComment.setText(totalPageCommentText);
    }

    public Control createDialogArea(Composite parent) {
        Group ret = new Group(parent, 0);
        WorkbenchHelp.setHelp((Control)ret, (String)(SDViewerPlugin.getId() + ".UML2SDPAGE"));
        GridData data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        ret.setLayoutData((Object)data);
        ret.setText(SDViewerPlugin.getResourceString("PAGES_GROUP_TITLE"));
        FillLayout fillLayout = new FillLayout(512);
        ret.setLayout((Layout)fillLayout);
        Label label = new Label((Composite)ret, 0);
        label.setText(SDViewerPlugin.getResourceString("PAGES_CURRENT_PAGE"));
        this.currentPage = new TextArea((Composite)ret);
        this.currentPage.setBounds(1, this.provider.pagesCount());
        this.currentPage.setValue(this.provider.currentPage() + 1);
        this.totalPageComment = new Label((Composite)ret, 0);
        this.totalPageComment.setAlignment(131072);
        this.updateComments();
        this.getShell().setText(SDViewerPlugin.getResourceString("PAGES_TITLE"));
        return ret;
    }

    public PagesDialog(IViewPart view_, ISDAdvancedPagingProvider loader_) {
        super(view_.getSite().getShell());
        this.viewer = view_;
        this.provider = loader_;
        this.setShellStyle(67680);
    }

    public int open() {
        this.create();
        this.getShell().pack();
        this.getShell().setLocation(this.getShell().getDisplay().getCursorLocation());
        return super.open();
    }

    public void okPressed() {
        int currentPageValue = this.currentPage.getValue() - 1;
        super.close();
        this.provider.pageNumberChanged(currentPageValue);
    }

    private class TextArea {
        private Text text;
        int min;
        int max;

        public TextArea(Composite parent) {
            this.text = new Text(parent, 133124);
            this.text.setTextLimit(10);
            GridData data = new GridData();
            data.widthHint = PagesDialog.this.convertWidthInCharsToPixels(10);
            this.text.setLayoutData((Object)data);
        }

        public void setValue(int v) {
            int value = Math.max(this.min, Math.min(this.max, v));
            this.text.setText(Integer.toString(value));
        }

        public int getValue() {
            int res;
            try {
                res = Integer.parseInt(this.text.getText());
            }
            catch (Exception e) {
                res = 0;
            }
            return Math.max(this.min, Math.min(this.max, res));
        }

        public void setBounds(int min_, int max_) {
            this.min = Math.max(0, min_);
            this.max = Math.max(this.min, max_);
            Object[] tab = new Integer[]{new Integer(this.min), new Integer(this.max)};
            this.text.setToolTipText(MessageFormat.format(SDViewerPlugin.getResourceString("PAGES_BOUNDS"), tab));
        }
    }
}

