/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.log.ui.internal.preferences;

import org.eclipse.hyades.log.ui.internal.LogUIPlugin;
import org.eclipse.hyades.log.ui.internal.util.ContextIds;
import org.eclipse.hyades.log.ui.internal.util.LogUIConstants;
import org.eclipse.hyades.log.ui.internal.util.RecordChangeEvent;
import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.help.WorkbenchHelp;

public class LogAnalyzerFormatPrefPage {
    private Combo dateFormatCombo;
    private Combo timeFormatCombo;
    private IPreferenceStore _preferenceStore;

    public LogAnalyzerFormatPrefPage(IPreferenceStore preferenceStore) {
        this._preferenceStore = preferenceStore;
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)GridUtil.createHorizontalFill());
        Label description = new Label(composite, 0);
        description.setText(LogUIPlugin.getResourceString("LOG_ANALYZER_FORMAT_PREF_PAGE_DESCRIPTION"));
        Composite comboComposite = this.createComboGroup(composite);
        this.createFormatComboBoxes(comboComposite);
        return composite;
    }

    private Composite createComboGroup(Composite composite) {
        GridLayout layout = new GridLayout();
        layout.horizontalSpacing = 20;
        layout.verticalSpacing = 10;
        layout.numColumns = 2;
        Composite comboComposite = new Composite(composite, 16384);
        comboComposite.setLayout((Layout)layout);
        comboComposite.setLayoutData((Object)GridUtil.createHorizontalFill());
        return comboComposite;
    }

    private void createFormatComboBoxes(Composite composite) {
        Label dateFormatLabel = new Label(composite, 0);
        dateFormatLabel.setText(LogUIPlugin.getResourceString("LOG_ANALYZER_FORMAT_PREF_PAGE_DATE_FORMAT_LABEL"));
        this.dateFormatCombo = new Combo(composite, 8);
        this.dateFormatCombo.setItems(LogUIConstants.LOG_ANALYZER_FORMAT_DATE_LIST);
        this.dateFormatCombo.setLayoutData((Object)GridUtil.createHorizontalFill());
        Label timeFormatLabel = new Label(composite, 0);
        timeFormatLabel.setText(LogUIPlugin.getResourceString("LOG_ANALYZER_FORMAT_PREF_PAGE_TIME_FORMAT_LABEL"));
        this.timeFormatCombo = new Combo(composite, 8);
        this.timeFormatCombo.setItems(LogUIConstants.LOG_ANALYZER_FORMAT_TIME_LIST);
        this.timeFormatCombo.setLayoutData((Object)GridUtil.createHorizontalFill());
        int index = -1;
        String dateFormat = this._preferenceStore.getString("LogAnalyzer.DateFormat");
        for (int i = 0; i < LogUIConstants.DATE_FORMAT_LIST.length; ++i) {
            if (!dateFormat.equals(LogUIConstants.DATE_FORMAT_LIST[i])) continue;
            index = i;
            break;
        }
        if (index > -1) {
            this.dateFormatCombo.select(index);
        } else {
            this.dateFormatCombo.select(0);
        }
        String timeFormat = this._preferenceStore.getString("LogAnalyzer.TimeFormat");
        index = -1;
        for (int i = 0; i < LogUIConstants.TIME_FORMAT_LIST.length; ++i) {
            if (!timeFormat.equals(LogUIConstants.TIME_FORMAT_LIST[i])) continue;
            index = i;
            break;
        }
        if (index > -1) {
            this.timeFormatCombo.select(index);
        } else {
            this.timeFormatCombo.select(0);
        }
        WorkbenchHelp.setHelp((Control)this.dateFormatCombo, (String)ContextIds.ACTLOG_PREF_FORMAT_DATE);
        WorkbenchHelp.setHelp((Control)this.timeFormatCombo, (String)ContextIds.ACTLOG_PREF_FORMAT_TIME);
    }

    public void init(IWorkbench workbench) {
    }

    protected void performDefaults() {
        this.dateFormatCombo.select(this._preferenceStore.getDefaultInt("LogAnalyzer.DateFormat"));
        this.timeFormatCombo.select(this._preferenceStore.getDefaultInt("LogAnalyzer.TimeFormat"));
    }

    public boolean performOk() {
        String selectedDateFormat = LogUIConstants.DATE_FORMAT_LIST[this.dateFormatCombo.getSelectionIndex()];
        boolean dateFmtChanged = false;
        if (!this._preferenceStore.getString("LogAnalyzer.DateFormat").equals(selectedDateFormat)) {
            dateFmtChanged = true;
        }
        this._preferenceStore.setValue("LogAnalyzer.DateFormat", selectedDateFormat);
        String selectedTimeFormat = LogUIConstants.TIME_FORMAT_LIST[this.timeFormatCombo.getSelectionIndex()];
        boolean timeFmtChanged = false;
        if (!this._preferenceStore.getString("LogAnalyzer.TimeFormat").equals(selectedTimeFormat)) {
            timeFmtChanged = true;
        }
        this._preferenceStore.setValue("LogAnalyzer.TimeFormat", selectedTimeFormat);
        LogUIPlugin.getDefault().savePluginPreferences();
        if (dateFmtChanged || timeFmtChanged) {
            LogUIPlugin.getDefault().fireRecordChangeNotification(new RecordChangeEvent(3, this));
        }
        return true;
    }
}

