/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.log.ui.internal.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.eclipse.hyades.log.ui.internal.LogUIPlugin;
import org.eclipse.hyades.log.ui.internal.util.StringSorter;
import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class CList {
    protected Label _label;
    protected org.eclipse.swt.widgets.List _list;
    protected Button _order;
    protected Composite groupWidget;
    private ArrayList listeners = new ArrayList();

    public CList(Composite parent, String text) {
        this(parent, text, null);
    }

    public CList(Composite parent, String text, List items) {
        this.groupWidget = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        this.groupWidget.setLayout((Layout)layout);
        this.groupWidget.setLayoutData((Object)GridUtil.createFill());
        if (text != null && !text.equals("")) {
            this._label = new Label(this.groupWidget, 0);
            this._label.setText(text);
        }
        this._list = new org.eclipse.swt.widgets.List(this.groupWidget, 2818);
        this._list.setLayoutData((Object)GridUtil.createFill());
        this._order = new Button(this.groupWidget, 8);
        this._order.setText(LogUIPlugin.getResourceString("SORT_BUTTON"));
        if (items != null) {
            for (int i = 0; i < items.size(); ++i) {
                this._list.add(items.get(i).toString(), i);
            }
        }
        this._order.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                CList.this.sortList();
                e.data = CList.this;
                CList.this.fireSelectionNotification(e);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    public void add(Object item) {
        this._list.add(item.toString());
    }

    public void add(Object item, int position) {
        this._list.add(item.toString(), position);
    }

    public void clearSelection() {
        this._list.deselectAll();
    }

    public boolean contains(Object item) {
        return this._list.indexOf(item.toString()) != -1;
    }

    public void deselect(int index) {
        this._list.deselect(index);
    }

    public void disableCList() {
        this._order.setEnabled(false);
    }

    public void enable(boolean enable) {
        this._list.setEnabled(enable);
        this._order.setEnabled(enable);
        if (this._label != null) {
            this._label.setEnabled(enable);
        }
    }

    public Object getItem(int position) {
        return this._list.getItem(position);
    }

    public int getItemCount() {
        return this._list.getItemCount();
    }

    public org.eclipse.swt.widgets.List getList() {
        return this._list;
    }

    public int getSelectedIndex() {
        return this._list.getSelectionIndex();
    }

    public int[] getSelectedIndices() {
        return this._list.getSelectionIndices();
    }

    public Object getSelectedItem() {
        String[] sel = this._list.getSelection();
        if (sel.length > 0) {
            return sel[0];
        }
        return null;
    }

    public String[] getSelectedItems() {
        return this._list.getSelection();
    }

    public Composite getWidget() {
        return this.groupWidget;
    }

    public boolean isSelectedIndex(int index) {
        return this._list.isSelected(index);
    }

    public void refreshList(Vector list) {
        this._list.removeAll();
        for (int idx = 0; idx < list.size(); ++idx) {
            this.add(list.elementAt(idx));
        }
    }

    public void remove(int index) {
        this._list.remove(index);
    }

    public void remove(Object item) {
        this._list.remove(item.toString());
    }

    public void select(Object item) {
        int index = this._list.indexOf(item.toString());
        if (index != -1) {
            this._list.select(index);
        }
    }

    public void selectAll(int[] indexlist) {
        this._list.select(indexlist);
    }

    public void setFocus() {
        this._list.setFocus();
    }

    public void setSelectedIndex(int index) {
        this._list.setSelection(index);
    }

    public void setSelectionInterval(int anchor, int lead) {
        this._list.setSelection(anchor, lead);
    }

    public void setToolTipText(String text) {
    }

    public void setVisible(boolean b) {
        this.groupWidget.setVisible(b);
    }

    public synchronized void sortList() {
        String[] _v = this._list.getItems();
        if (_v == null) {
            return;
        }
        String[] items = this._list.getSelection();
        Vector<String> v = new Vector<String>(_v.length);
        for (int idx = 0; idx < _v.length; ++idx) {
            v.addElement(_v[idx]);
        }
        new StringSorter().qsortNoCaseStringVector(v);
        this.refreshList(v);
        Vector<String> indexList = new Vector<String>();
        for (int idx = 0; idx < this._list.getItemCount(); ++idx) {
            boolean contains = false;
            int i = 0;
            while (!contains && i < items.length) {
                if (items[i].equals(this.getItem(idx))) {
                    contains = true;
                    indexList.addElement(String.valueOf(idx));
                    continue;
                }
                ++i;
            }
        }
        int[] idxList = new int[indexList.size()];
        for (int i = 0; i < indexList.size(); ++i) {
            idxList[i] = Integer.parseInt(indexList.elementAt(i).toString());
        }
        this._list.setSelection(idxList);
    }

    public void addSelectionListener(SelectionListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
            this._list.addSelectionListener(listener);
        }
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.listeners.remove(listener);
        this._list.removeSelectionListener(listener);
    }

    public void fireSelectionNotification(SelectionEvent e) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((SelectionListener)this.listeners.get(i)).widgetSelected(e);
        }
    }
}

