/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.log.ui.internal.views;

import java.util.StringTokenizer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.log.ui.internal.LogUIPlugin;
import org.eclipse.hyades.log.ui.internal.util.RecordTableElement;
import org.eclipse.hyades.models.cbe.CBEDefaultEvent;
import org.eclipse.hyades.models.internal.sdb.SDBDirective;
import org.eclipse.hyades.models.internal.sdb.SDBMatchPattern;
import org.eclipse.hyades.models.internal.sdb.SDBSolution;
import org.eclipse.hyades.models.internal.sdb.SDBSymptom;
import org.eclipse.hyades.trace.ui.internal.util.HyperlinkText;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.part.PageBook;

public class LogAnalysisPageBook
extends PageBook
implements ISelectionChangedListener {
    private CTabFolder tabFolder;
    private CTabItem detailsTabItem;
    private CTabItem analysisTabItem;
    private HyperlinkText detailsTabText;
    private HyperlinkText analysisTabText;
    private String resultString = "";
    private String detailsString = "";
    private final String LINESEPARATOR = System.getProperty("line.separator");
    private final String DELIMITER = "--------------------------------------------------------------------";

    public LogAnalysisPageBook(Composite parent, int style) {
        super(parent, style);
        this.populateUI();
    }

    public void populateUI() {
        this.tabFolder = new CTabFolder((Composite)this, 128);
        this.detailsTabText = new HyperlinkText((Composite)this.tabFolder, 842);
        this.detailsTabItem = new CTabItem(this.tabFolder, 0);
        this.detailsTabItem.setText(LogUIPlugin.getResourceString("STR_SYMPTOM_TAB"));
        this.detailsTabItem.setControl((Control)this.detailsTabText);
        this.analysisTabText = new HyperlinkText((Composite)this.tabFolder, 842);
        this.analysisTabItem = new CTabItem(this.tabFolder, 0);
        this.analysisTabItem.setText(LogUIPlugin.getResourceString("STR_ANALYSIS_TAB"));
        this.analysisTabItem.setControl((Control)this.analysisTabText);
        this.tabFolder.setSelection(this.detailsTabItem);
        this.showPage((Control)this.tabFolder);
    }

    public void setInputNull() {
        this.analysisTabText.setText("");
        this.analysisTabItem.setControl((Control)this.analysisTabText);
        this.detailsTabText.setText("");
        this.detailsTabItem.setControl((Control)this.detailsTabText);
        this.tabFolder.setSelection(this.detailsTabItem);
        this.showPage((Control)this.tabFolder);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        Object singleSelection = null;
        ISelection selection = event.getSelection();
        if (!(selection instanceof IStructuredSelection)) {
            return;
        }
        singleSelection = ((IStructuredSelection)selection).getFirstElement();
        if (singleSelection != null) {
            if (singleSelection instanceof CBEDefaultEvent) {
                EList directivesList = ((CBEDefaultEvent)singleSelection).getSymptoms();
                this.resultString = directivesList.isEmpty() ? (((CBEDefaultEvent)singleSelection).isAnalyzed() ? LogUIPlugin.getResourceString("STR_NO_MATCH") : "") : this.formatDirectivesList(directivesList);
            } else if (singleSelection instanceof RecordTableElement) {
                this.detailsString = this.replaceNewLineChars(((RecordTableElement)singleSelection).getValue());
                this.detailsTabItem.setText(LogUIPlugin.getResourceString("STR_SYMPTOM_TAB") + " " + ((RecordTableElement)singleSelection).getName());
            } else if (singleSelection instanceof EObject) {
                this.resultString = "";
            } else if (singleSelection instanceof Object[]) {
                this.detailsString = "";
                this.detailsTabItem.setText(LogUIPlugin.getResourceString("STR_SYMPTOM_TAB"));
                this.resultString = "";
            }
        }
        this.analysisTabItem.setControl((Control)this.analysisTabText);
        this.analysisTabText.setText(this.resultString);
        this.detailsTabText.setText(this.detailsString);
        this.detailsTabItem.setControl((Control)this.detailsTabText);
        this.showPage((Control)this.tabFolder);
    }

    private String formatDirectivesList(EList directivesList) {
        StringBuffer analysisBuffer = new StringBuffer();
        for (int idx = 0; idx < directivesList.size(); ++idx) {
            int i;
            analysisBuffer.append(this.LINESEPARATOR);
            analysisBuffer.append("--------------------------------------------------------------------");
            analysisBuffer.append(this.LINESEPARATOR);
            SDBSymptom directive = (SDBSymptom)directivesList.get(idx);
            analysisBuffer.append(directive.getDescription()).append(this.LINESEPARATOR);
            EList list = directive.getPatterns();
            for (i = 0; i < list.size(); ++i) {
                analysisBuffer.append(((SDBMatchPattern)list.get(i)).getValue()).append(this.LINESEPARATOR);
            }
            list = directive.getSolutions();
            for (i = 0; i < list.size(); ++i) {
                SDBSolution sol = (SDBSolution)list.get(i);
                analysisBuffer.append(((SDBSolution)list.get(i)).getDescription()).append(this.LINESEPARATOR);
                EList directives = sol.getDirectives();
                for (int j = 0; j < directives.size(); ++j) {
                    analysisBuffer.append(((SDBDirective)directives.get(j)).getDescription()).append(this.LINESEPARATOR);
                }
            }
        }
        return analysisBuffer.toString().trim();
    }

    private String replaceNewLineChars(String input) {
        StringBuffer analysisBuffer = new StringBuffer();
        StringTokenizer tokens = new StringTokenizer(input, "\r\n\f");
        while (tokens.hasMoreTokens()) {
            analysisBuffer.append(tokens.nextToken().trim());
            analysisBuffer.append(this.LINESEPARATOR);
        }
        return analysisBuffer.toString();
    }

    public void dispose() {
        if (this.analysisTabText != null) {
            this.analysisTabText.dispose();
        }
        if (this.detailsTabText != null) {
            this.detailsTabText.dispose();
        }
    }
}

