/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.statistical.ui.editor.internal;

import java.util.ArrayList;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLConfigUtil {
    public static DocumentBuilder getDocumentBuilder() throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        DocumentBuilder builder = factory.newDocumentBuilder();
        return builder;
    }

    public static void getXmlHead(StringBuffer sb, Element e) {
        sb.append("<");
        sb.append(e.getTagName());
        sb.append(" ");
        NamedNodeMap attrs = e.getAttributes();
        for (int i = 0; i < attrs.getLength(); ++i) {
            Node node = attrs.item(i);
            sb.append(node.getNodeName());
            sb.append("=\"");
            sb.append(XMLConfigUtil.toRawXML(node.getNodeValue()));
            sb.append("\" ");
        }
        sb.append(">\n");
    }

    public static void getXmlTail(StringBuffer sb, Element e) {
        sb.append("</");
        sb.append(e.getTagName());
        sb.append(">\n");
    }

    public static String toRawXML(Node n) {
        StringBuffer sb = new StringBuffer();
        XMLConfigUtil.toRawXML(sb, n);
        return sb.toString();
    }

    public static String toRawXML(String val) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < val.length(); ++i) {
            char c = val.charAt(i);
            if (c == '>') {
                sb.append("&gt;");
                continue;
            }
            if (c == '<') {
                sb.append("&lt;");
                continue;
            }
            if (c == '\"') {
                sb.append("&quot;");
                continue;
            }
            if (c == '\'') {
                sb.append("&apos;");
                continue;
            }
            if (c == '&') {
                sb.append("&amp;");
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private static void toRawXML(StringBuffer sb, Node n) {
        if (n.getNodeType() == 1) {
            XMLConfigUtil.toXML(sb, (Element)n);
        } else if (n.getNodeType() == 3) {
            String val = n.getNodeValue();
            sb.append(XMLConfigUtil.toRawXML(val));
        }
    }

    public static String toXML(Element e) {
        StringBuffer sb = new StringBuffer();
        XMLConfigUtil.toXML(sb, e);
        return sb.toString();
    }

    private static void toXML(StringBuffer sb, Element e) {
        sb.append("<");
        sb.append(e.getTagName());
        sb.append(" ");
        NamedNodeMap attrs = e.getAttributes();
        for (int i = 0; i < attrs.getLength(); ++i) {
            Node node = attrs.item(i);
            sb.append(node.getNodeName());
            sb.append("=\"");
            sb.append(XMLConfigUtil.toRawXML(node.getNodeValue()));
            sb.append("\" ");
        }
        sb.append(">\n");
        ArrayList list = XMLConfigUtil.getAllElements(e.getChildNodes(), null);
        for (int i = 0; i < list.size(); ++i) {
            Element x = (Element)list.get(i);
            XMLConfigUtil.toXML(sb, x);
        }
        sb.append("</");
        sb.append(e.getTagName());
        sb.append(">\n");
    }

    public static Element getFirstElement(NodeList list, String name) {
        for (int i = 0; i < list.getLength(); ++i) {
            Node o = list.item(i);
            if (!(o instanceof Element)) continue;
            Element e = (Element)o;
            if (name != null) {
                if (!e.getTagName().equals(name)) continue;
                return e;
            }
            return e;
        }
        return null;
    }

    public static ArrayList getAllElements(NodeList list, String name) {
        ArrayList<Node> elements = new ArrayList<Node>();
        for (int i = 0; i < list.getLength(); ++i) {
            Node o = list.item(i);
            if (!(o instanceof Element)) continue;
            Element e = (Element)o;
            if (name != null) {
                if (!e.getTagName().equals(name)) continue;
                elements.add(o);
                continue;
            }
            elements.add(o);
        }
        return elements;
    }

    public static void getElementAttributeMap(NodeList list, String name, String attribute, HashMap map) {
        for (int i = 0; i < list.getLength(); ++i) {
            String attr;
            Node o = list.item(i);
            if (!(o instanceof Element)) continue;
            Element e = (Element)o;
            if (name != null) {
                if (!e.getTagName().equals(name) || (attr = e.getAttribute(attribute)) == null) continue;
                map.put(attr, e);
                continue;
            }
            attr = e.getAttribute(attribute);
            if (attr == null) continue;
            map.put(attr, e);
        }
    }

    public static HashMap getElementAttributeMap(NodeList list, String name, String attribute) {
        HashMap map = new HashMap();
        XMLConfigUtil.getElementAttributeMap(list, name, attribute, map);
        return map;
    }

    public static double parseDouble(String doub, double def) {
        try {
            return Double.parseDouble(doub);
        }
        catch (Exception e) {
            return def;
        }
    }

    public static boolean parseBoolean(String bool, boolean def) {
        if (bool.equals("true")) {
            return true;
        }
        if (bool.equals("false")) {
            return false;
        }
        return def;
    }

    public static int parseLineStyle(String style, int def) {
        if (style.equals("SOLID")) {
            return 1;
        }
        if (style.equals("DOT")) {
            return 3;
        }
        if (style.equals("DASH")) {
            return 2;
        }
        if (style.equals("DASHDOT")) {
            return 4;
        }
        if (style.equals("DASHDOTDOT")) {
            return 5;
        }
        return def;
    }

    public static RGB parseColor(String col, RGB def) {
        try {
            if (!col.startsWith("#")) {
                throw new Exception();
            }
            if (col.length() != 7) {
                throw new Exception();
            }
            String sr = col.substring(1, 3);
            String sg = col.substring(3, 5);
            String sb = col.substring(5, 7);
            int r = Integer.parseInt(sr, 16);
            int g = Integer.parseInt(sg, 16);
            int b = Integer.parseInt(sb, 16);
            return new RGB(r, g, b);
        }
        catch (Exception e) {
            return def;
        }
    }

    public static String colorToString(Color c) {
        RGB rgb = c.getRGB();
        String s = "#";
        if (rgb.red < 16) {
            s = s + "0";
        }
        s = s + Integer.toString(rgb.red, 16);
        if (rgb.green < 16) {
            s = s + "0";
        }
        s = s + Integer.toString(rgb.green, 16);
        if (rgb.blue < 16) {
            s = s + "0";
        }
        s = s + Integer.toString(rgb.blue, 16);
        return s;
    }

    public static String lineStyleToString(int style) {
        if (style == 1) {
            return "SOLID";
        }
        if (style == 3) {
            return "DOT";
        }
        if (style == 2) {
            return "DASH";
        }
        if (style == 4) {
            return "DASHDOT";
        }
        if (style == 5) {
            return "DASHDOTDOT";
        }
        return "SOLID";
    }
}

