/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.events.cbe.impl.tests;

import junit.framework.Assert;
import junit.framework.TestCase;
import org.eclipse.hyades.logging.events.cbe.EventFactory;
import org.eclipse.hyades.logging.events.cbe.OtherSituation;
import org.eclipse.hyades.logging.events.cbe.SituationType;
import org.eclipse.hyades.logging.events.cbe.ValidationException;
import org.eclipse.hyades.logging.events.cbe.impl.tests.Util;

public class OtherSituationImplTest
extends TestCase {
    private OtherSituation sit;

    public OtherSituationImplTest(String string) {
        super(string);
    }

    public void testToString() {
        Assert.assertNotNull((Object)this.sit.toString());
    }

    public void testInterface() {
        this.sit.getAny();
        this.sit.getReasoningScope();
        Assert.assertTrue((boolean)(this.sit instanceof SituationType));
    }

    public void testSerialization() {
        Util.testEObjectSerialization(this.sit);
    }

    public void testEquals() {
        OtherSituation otherSituation = (OtherSituation)Util.clone(this.sit);
        Assert.assertEquals((Object)this.sit, (Object)otherSituation);
        this.sit.setAny("f");
        this.sit.setReasoningScope("r");
        otherSituation = (OtherSituation)Util.clone(this.sit);
        Assert.assertEquals((Object)this.sit, (Object)otherSituation);
        otherSituation.setAny("difference");
        Assert.assertFalse((boolean)this.sit.equals(otherSituation));
    }

    public void testValidationMissingAttributes() throws ValidationException {
        Util.assertMissingAttributes(this.sit, "all");
        this.sit.setAny("a");
        this.sit.setReasoningScope("r");
        this.sit.validate();
        this.sit.setAny(null);
        Util.assertMissingAttributes(this.sit, "any");
        this.sit.setAny("f");
        this.sit.setReasoningScope(null);
        Util.assertMissingAttributes(this.sit, "reasoningScope");
    }

    public void testValidationInvalidLengths() {
        this.sit.setAny(Util.getPaddedString(1024));
        this.sit.setReasoningScope(Util.getPaddedString(64));
        try {
            this.sit.validate();
        }
        catch (ValidationException validationException) {
            Assert.fail((String)"Strings have correct length");
        }
        this.sit.setReasoningScope(Util.getPaddedString(65));
        Util.assertInvalidBoundaries(this.sit, "reasoningScope");
    }

    public void testAdapter() {
        Util.assertAdapterNotification(this.sit);
    }

    public void testUnsupportedFeature() {
        Util.assertUnsupportedFeature(this.sit);
    }

    protected void setUp() throws Exception {
        super.setUp();
        EventFactory eventFactory = EventFactory.eINSTANCE;
        this.sit = eventFactory.createOtherSituation();
    }
}

