/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.events.cbe.impl.tests;

import java.text.ParseException;
import java.util.Arrays;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.hyades.logging.events.cbe.EventFactory;
import org.eclipse.hyades.logging.events.cbe.EventPackage;
import org.eclipse.hyades.logging.events.cbe.ExtendedDataElement;
import org.eclipse.hyades.logging.events.cbe.ValidationException;
import org.eclipse.hyades.logging.events.cbe.impl.ExtendedDataElementImpl;
import org.eclipse.hyades.logging.events.cbe.impl.tests.Util;
import org.eclipse.hyades.logging.events.cbe.util.EventHelpers;

public class ExtendedDataElementImplTest
extends TestCase {
    private ExtendedDataElement ede = null;

    public ExtendedDataElementImplTest(String string) {
        super(string);
    }

    public void testSerialization() {
        Util.testEObjectSerialization(this.ede);
    }

    public void testEMF() {
        this.ede.getValues().add(null);
    }

    public void testGetChildrenByName() {
        Object object;
        int n;
        int n2 = 10;
        int n3 = 0;
        while (n3 < n2) {
            n = 0;
            while (n < n3) {
                object = this.ede.addChild("name" + n3);
                object.getValues().add("value" + n3 + " " + n);
                ++n;
            }
            ++n3;
        }
        n = 0;
        while (n < n2) {
            object = this.ede.getChildren("name" + n);
            Assert.assertEquals((int)n, (int)object.size());
            int n4 = 0;
            while (n4 < object.size()) {
                ExtendedDataElement extendedDataElement = (ExtendedDataElement)object.get(n4);
                Assert.assertEquals((Object)("value" + n + " " + n4), extendedDataElement.getValues().get(0));
                ++n4;
            }
            ++n;
        }
    }

    public void testGetSetHexValue() {
        Assert.assertNull((Object)this.ede.getHexValue());
        String string = "Testing setHexValue()";
        this.ede.setHexValue(string);
        Assert.assertEquals((String)string, (String)this.ede.getHexValue());
        string = "setting another string";
        this.ede.setHexValue(string);
        Assert.assertEquals((String)string, (String)this.ede.getHexValue());
        this.ede.setHexValue(null);
        Assert.assertNull((Object)this.ede.getHexValue());
    }

    public void testInvalidHexValue() {
        try {
            this.ede.setHexValue("ZZZ123");
            this.ede.setType("hexBinary");
            this.ede.getHexValueAsByteArray();
            Assert.fail((String)"String is not a valid hexValue");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        StringBuffer stringBuffer = new StringBuffer("A");
        int n = 0;
        while (n < 100) {
            try {
                this.ede.setHexValue(stringBuffer.toString());
                this.ede.getHexValueAsByteArray();
                Assert.fail((String)("String (" + stringBuffer.length() + ") is not a valid hexValue"));
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            ++n;
        }
    }

    public void testGetName() {
        Assert.assertTrue((this.ede.getName() == null ? 1 : 0) != 0);
        String string = new String("Testing getName()");
        this.ede.setName(string);
        Assert.assertTrue((boolean)this.ede.getName().equals(string));
    }

    public void testSetName() {
        String string = new String("Testing setName()");
        this.ede.setName(string);
        Assert.assertTrue((boolean)this.ede.getName().equals(string));
        string = new String("setting another name");
        this.ede.setName(string);
        Assert.assertTrue((boolean)this.ede.getName().equals(string));
    }

    public void testGetType() {
        Assert.assertTrue((this.ede.getType() == null ? 1 : 0) != 0);
        this.ede.setType("long");
        Assert.assertTrue((boolean)this.ede.getType().equals("long"));
    }

    public void testSetType() {
        this.ede.setType("stringArray");
        Assert.assertTrue((boolean)this.ede.getType().equals("stringArray"));
        String string = "MyType";
        this.ede.setType(string);
        Assert.assertTrue((boolean)this.ede.getType().equals(string));
    }

    public void testGetTypeAsInt() {
        Assert.assertTrue((this.ede.getTypeAsInt() == 0 ? 1 : 0) != 0);
        this.ede.setTypeAsInt(19);
        Assert.assertTrue((this.ede.getTypeAsInt() == 19 ? 1 : 0) != 0);
    }

    public void testSetTypeAsInt() {
        this.ede.setTypeAsInt(17);
        Assert.assertTrue((this.ede.getTypeAsInt() == 17 ? 1 : 0) != 0);
        this.ede.setTypeAsInt(123);
        Assert.assertTrue((this.ede.getTypeAsInt() == 0 ? 1 : 0) != 0);
    }

    public void testGetValues() {
        Assert.assertTrue((boolean)this.ede.getValues().isEmpty());
        this.ede.setValuesAsString("testing getValues()");
        Assert.assertTrue((this.ede.getValues().size() == 1 ? 1 : 0) != 0);
    }

    public void testGetChildren() {
        Assert.assertTrue((boolean)this.ede.getValues().isEmpty());
        this.ede.addChild("child 1");
        this.ede.addChild("child 2");
        Assert.assertTrue((this.ede.getChildren().size() == 2 ? 1 : 0) != 0);
    }

    public void testGetValuesAsBoolean() {
        this.ede.setTypeAsInt(9);
        try {
            this.ede.getValuesAsBoolean();
            Assert.fail((String)"cannot get int value from uninitialized object");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        boolean bl = false;
        this.ede.setValuesAsBoolean(bl);
        boolean bl2 = this.ede.getValuesAsBoolean();
        Assert.assertTrue((bl2 == bl ? 1 : 0) != 0);
        try {
            this.ede.setType("int");
            this.ede.getValuesAsBoolean();
            Assert.fail((String)"cannot get boolean value from int type");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testGetValuesAsBooleans() {
        this.ede.setTypeAsInt(18);
        this.ede.getValuesAsBooleanArray();
        boolean[] blArray = new boolean[]{false, true, true};
        this.ede.setValuesAsBooleanArray(blArray);
        boolean[] blArray2 = this.ede.getValuesAsBooleanArray();
        Assert.assertTrue((blArray.length == blArray2.length ? 1 : 0) != 0);
        int n = 0;
        while (n < blArray.length) {
            Assert.assertTrue((blArray2[n] == blArray[n] ? 1 : 0) != 0);
            ++n;
        }
        try {
            this.ede.setType("int");
            this.ede.getValuesAsBooleanArray();
            Assert.fail((String)"cannot get boolean[] value from int type");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testGetValuesAsByte() {
        this.ede.setTypeAsInt(1);
        try {
            this.ede.getValuesAsByte();
            Assert.fail((String)"cannot get byte value from uninitialized object");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        byte by = 127;
        this.ede.setValuesAsByte(by);
        byte by2 = this.ede.getValuesAsByte();
        Assert.assertTrue((by2 == by ? 1 : 0) != 0);
        try {
            this.ede.setType("int");
            this.ede.getValuesAsByte();
            Assert.fail((String)"cannot get byte value from int type");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testGetValuesAsBytes() {
        this.ede.setTypeAsInt(10);
        this.ede.getValuesAsByteArray();
        byte[] byArray = new byte[]{35, 84, 120};
        this.ede.setValuesAsByteArray(byArray);
        byte[] byArray2 = this.ede.getValuesAsByteArray();
        Assert.assertTrue((byArray.length == byArray2.length ? 1 : 0) != 0);
        int n = 0;
        while (n < byArray.length) {
            Assert.assertTrue((byArray2[n] == byArray[n] ? 1 : 0) != 0);
            ++n;
        }
        try {
            this.ede.setType("int");
            this.ede.getValuesAsByteArray();
            Assert.fail((String)"cannot get byte[] value from int type");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testGetValuesAsDate() {
        this.ede.setTypeAsInt(8);
        try {
            this.ede.getValuesAsDate();
            Assert.fail((String)"cannot get Date value from uninitialized object");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        String string = "2003-02-18T14:30:09.000Z";
        this.ede.setValuesAsDate(string);
        String string2 = this.ede.getValuesAsDate();
        Assert.assertTrue((boolean)string.equals(string2));
        try {
            this.ede.setType("int");
            this.ede.getValuesAsDate();
            Assert.fail((String)"cannot get Date value from int type");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testGetValuesAsDates() {
        this.ede.setTypeAsInt(17);
        this.ede.getValuesAsDateArray();
        String[] stringArray = new String[]{"1997-01-01T12:00:00.000Z", "2003-02-18T14:30:09.000Z"};
        this.ede.setValuesAsDateArray(stringArray);
        String[] stringArray2 = this.ede.getValuesAsDateArray();
        Assert.assertTrue((boolean)Arrays.asList(stringArray2).containsAll(Arrays.asList(stringArray)));
        try {
            this.ede.setType("int");
            this.ede.getValuesAsDateArray();
            Assert.fail((String)"cannot get Date[] value from int type");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testGetValuesAsDateAsLong() {
        this.ede.setTypeAsInt(8);
        try {
            this.ede.getValuesAsDateAsLong();
            Assert.fail((String)"cannot get Date value from uninitialized object");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        long l = System.currentTimeMillis();
        String string = EventHelpers.longToDate(l);
        this.ede.setValuesAsDateAsLong(l);
        long l2 = this.ede.getValuesAsDateAsLong();
        Assert.assertTrue((l == l2 ? 1 : 0) != 0);
        try {
            this.ede.setType("int");
            this.ede.getValuesAsDateAsLong();
            Assert.fail((String)"cannot get DateAsLong value from int type");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testGetValuesAsDatesAsLongWithBadDate() {
        this.ede.setTypeAsInt(17);
        this.ede.setValuesAsDateArray(new String[]{"awinga"});
        try {
            this.ede.getValuesAsDateAsLongArray();
            Assert.fail((String)"The date is not a valid xsd:dateTime");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testGetValuesAsDatesAsLong() {
        this.ede.setTypeAsInt(17);
        this.ede.getValuesAsDateAsLongArray();
        long[] lArray = new long[]{System.currentTimeMillis(), System.currentTimeMillis() + 10000L};
        this.ede.setValuesAsDateAsLongArray(lArray);
        long[] lArray2 = this.ede.getValuesAsDateAsLongArray();
        Assert.assertEquals((int)lArray.length, (int)lArray2.length);
        int n = 0;
        while (n < lArray.length) {
            Assert.assertEquals((String)("Index: " + n), (long)lArray[n], (long)lArray2[n]);
            ++n;
        }
        try {
            this.ede.setType("int");
            this.ede.getValuesAsDateAsLongArray();
            Assert.fail((String)"cannot get DateAsLong[] value from int type");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testGetValuesAsDouble() {
        this.ede.setTypeAsInt(6);
        try {
            this.ede.getValuesAsDouble();
            Assert.fail((String)"cannot get double value from uninitialized object");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        double d = Double.MIN_VALUE;
        this.ede.setValuesAsDouble(d);
        double d2 = this.ede.getValuesAsDouble();
        Assert.assertTrue((d2 == d ? 1 : 0) != 0);
        try {
            this.ede.setType("int");
            this.ede.getValuesAsDouble();
            Assert.fail((String)"cannot get double value from int type");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testGetValuesAsDoubles() {
        this.ede.setTypeAsInt(15);
        this.ede.getValuesAsDoubleArray();
        double[] dArray = new double[]{1.25, 1.33};
        this.ede.setValuesAsDoubleArray(dArray);
        double[] dArray2 = this.ede.getValuesAsDoubleArray();
        Assert.assertTrue((dArray.length == dArray2.length ? 1 : 0) != 0);
        int n = 0;
        while (n < dArray.length) {
            Assert.assertTrue((dArray2[n] == dArray[n] ? 1 : 0) != 0);
            ++n;
        }
        try {
            this.ede.setType("int");
            this.ede.getValuesAsDoubleArray();
            Assert.fail((String)"cannot get double[] value from int type");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testGetValuesAsFloat() {
        this.ede.setTypeAsInt(5);
        try {
            this.ede.getValuesAsFloat();
            Assert.fail((String)"cannot get float value from uninitialized object");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        float f = Float.MAX_VALUE;
        this.ede.setValuesAsFloat(f);
        float f2 = this.ede.getValuesAsFloat();
        Assert.assertTrue((f2 == f ? 1 : 0) != 0);
        try {
            this.ede.setType("int");
            this.ede.getValuesAsFloat();
            Assert.fail((String)"cannot get float value from int type");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testGetValuesAsFloats() {
        this.ede.setTypeAsInt(14);
        this.ede.getValuesAsFloatArray();
        float[] fArray = new float[]{1000.0f, 2000.0f, 3000.0f, 1000.0f};
        this.ede.setValuesAsFloatArray(fArray);
        float[] fArray2 = this.ede.getValuesAsFloatArray();
        Assert.assertTrue((fArray.length == fArray2.length ? 1 : 0) != 0);
        int n = 0;
        while (n < fArray.length) {
            Assert.assertTrue((fArray2[n] == fArray[n] ? 1 : 0) != 0);
            ++n;
        }
        try {
            this.ede.setType("int");
            this.ede.getValuesAsFloatArray();
            Assert.fail((String)"cannot get float[] value from int type");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testGetValuesAsInt() {
        this.ede.setTypeAsInt(3);
        try {
            this.ede.getValuesAsInt();
            Assert.fail((String)"cannot get int value from uninitialized object");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        int n = Integer.MIN_VALUE;
        this.ede.setValuesAsInt(n);
        int n2 = this.ede.getValuesAsInt();
        Assert.assertTrue((n2 == n ? 1 : 0) != 0);
        try {
            this.ede.setType("string");
            this.ede.getValuesAsInt();
            Assert.fail((String)"cannot get int value from String type");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testGetValuesAsInts() {
        this.ede.setTypeAsInt(12);
        this.ede.getValuesAsIntArray();
        int[] nArray = new int[]{9, 7, 5};
        this.ede.setValuesAsIntArray(nArray);
        int[] nArray2 = this.ede.getValuesAsIntArray();
        Assert.assertTrue((nArray.length == nArray2.length ? 1 : 0) != 0);
        int n = 0;
        while (n < nArray.length) {
            Assert.assertTrue((nArray2[n] == nArray[n] ? 1 : 0) != 0);
            ++n;
        }
        try {
            this.ede.setType("int");
            this.ede.getValuesAsIntArray();
            Assert.fail((String)"cannot get int[] value from int type");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testGetValuesAsLong() {
        this.ede.setTypeAsInt(4);
        try {
            this.ede.getValuesAsLong();
            Assert.fail((String)"cannot get long value from uninitialized object");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        long l = Long.MAX_VALUE;
        this.ede.setValuesAsLong(l);
        long l2 = this.ede.getValuesAsLong();
        Assert.assertTrue((l2 == l ? 1 : 0) != 0);
        try {
            this.ede.setType("int");
            this.ede.getValuesAsLong();
            Assert.fail((String)"cannot get long value from int type");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testGetValuesAsLongs() {
        this.ede.setTypeAsInt(13);
        this.ede.getValuesAsLongArray();
        long[] lArray = new long[]{9999999L, 7777777L, 5555555L};
        this.ede.setValuesAsLongArray(lArray);
        long[] lArray2 = this.ede.getValuesAsLongArray();
        Assert.assertTrue((lArray.length == lArray2.length ? 1 : 0) != 0);
        int n = 0;
        while (n < lArray.length) {
            Assert.assertTrue((lArray2[n] == lArray[n] ? 1 : 0) != 0);
            ++n;
        }
        try {
            this.ede.setType("long");
            this.ede.getValuesAsLongArray();
            Assert.fail((String)"cannot get long[] value from long type");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testGetValuesAsShort() {
        this.ede.setTypeAsInt(2);
        try {
            this.ede.getValuesAsShort();
            Assert.fail((String)"cannot get short value from uninitialized object");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        short s = Short.MIN_VALUE;
        this.ede.setValuesAsShort(s);
        short s2 = this.ede.getValuesAsShort();
        Assert.assertTrue((s2 == s ? 1 : 0) != 0);
        try {
            this.ede.setType("int");
            this.ede.getValuesAsShort();
            Assert.fail((String)"cannot get short value from int type");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testGetValuesAsShorts() {
        this.ede.setTypeAsInt(11);
        this.ede.getValuesAsShortArray();
        short[] sArray = new short[]{0, 1, 2};
        this.ede.setValuesAsShortArray(sArray);
        short[] sArray2 = this.ede.getValuesAsShortArray();
        Assert.assertTrue((sArray.length == sArray2.length ? 1 : 0) != 0);
        int n = 0;
        while (n < sArray.length) {
            Assert.assertTrue((sArray2[n] == sArray[n] ? 1 : 0) != 0);
            ++n;
        }
        try {
            this.ede.setType("int");
            this.ede.getValuesAsShortArray();
            Assert.fail((String)"cannot get short[] value from int type");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testGetValuesAsString() {
        this.ede.setTypeAsInt(7);
        try {
            this.ede.getValuesAsString();
            Assert.fail((String)"cannot get String value from uninitialized object");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        String string = "test1";
        this.ede.setValuesAsString(string);
        String string2 = this.ede.getValuesAsString();
        Assert.assertTrue((boolean)string2.equals(string));
        try {
            this.ede.setType("int");
            this.ede.getValuesAsString();
            Assert.fail((String)"cannot get String value from int type");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testGetValuesAsStrings() {
        this.ede.setTypeAsInt(16);
        this.ede.getValuesAsStringArray();
        String[] stringArray = new String[]{"test1", "test2", "test3", "test4"};
        this.ede.setValuesAsStringArray(stringArray);
        String[] stringArray2 = this.ede.getValuesAsStringArray();
        Assert.assertTrue((boolean)Arrays.asList(stringArray2).containsAll(Arrays.asList(stringArray)));
        try {
            this.ede.setType("int");
            this.ede.getValuesAsStringArray();
            Assert.fail((String)"cannot get String[] value from int type");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testSetValuesAsBoolean() {
        this.ede.setTypeAsInt(9);
        boolean bl = true;
        this.ede.setValuesAsBoolean(bl);
        boolean bl2 = this.ede.getValuesAsBoolean();
        Assert.assertTrue((bl2 == bl ? 1 : 0) != 0);
        bl = false;
        this.ede.setValuesAsBoolean(bl);
        bl2 = this.ede.getValuesAsBoolean();
        Assert.assertTrue((bl2 == bl ? 1 : 0) != 0);
        this.ede.setType("int");
        this.ede.setValuesAsBoolean(bl);
    }

    public void testSetValuesAsBooleans() {
        this.ede.setTypeAsInt(18);
        boolean[] blArray = new boolean[]{true, false};
        this.ede.setValuesAsBooleanArray(blArray);
        boolean[] blArray2 = this.ede.getValuesAsBooleanArray();
        Assert.assertTrue((blArray.length == blArray2.length ? 1 : 0) != 0);
        int n = 0;
        while (n < blArray.length) {
            Assert.assertTrue((blArray2[n] == blArray[n] ? 1 : 0) != 0);
            ++n;
        }
        boolean[] blArray3 = new boolean[]{false};
        this.ede.setValuesAsBooleanArray(blArray3);
        blArray2 = this.ede.getValuesAsBooleanArray();
        Assert.assertTrue((blArray3.length == blArray2.length ? 1 : 0) != 0);
        int n2 = 0;
        while (n2 < blArray3.length) {
            Assert.assertTrue((blArray2[n2] == blArray3[n2] ? 1 : 0) != 0);
            ++n2;
        }
        this.ede.setType("int");
        this.ede.setValuesAsBooleanArray(blArray);
    }

    public void testSetValuesAsByte() {
        this.ede.setTypeAsInt(1);
        byte by = -128;
        this.ede.setValuesAsByte(by);
        byte by2 = this.ede.getValuesAsByte();
        Assert.assertTrue((by2 == by ? 1 : 0) != 0);
        by = 127;
        this.ede.setValuesAsByte(by);
        by2 = this.ede.getValuesAsByte();
        Assert.assertTrue((by2 == by ? 1 : 0) != 0);
        this.ede.setType("int");
        this.ede.setValuesAsByte(by);
    }

    public void testSetValuesAsBytes() {
        this.ede.setTypeAsInt(10);
        byte[] byArray = new byte[]{35, 84, 120};
        this.ede.setValuesAsByteArray(byArray);
        byte[] byArray2 = this.ede.getValuesAsByteArray();
        Assert.assertTrue((byArray.length == byArray2.length ? 1 : 0) != 0);
        int n = 0;
        while (n < byArray.length) {
            Assert.assertTrue((byArray2[n] == byArray[n] ? 1 : 0) != 0);
            ++n;
        }
        byte[] byArray3 = new byte[]{97, 9};
        this.ede.setValuesAsByteArray(byArray3);
        byArray2 = this.ede.getValuesAsByteArray();
        Assert.assertTrue((byArray3.length == byArray2.length ? 1 : 0) != 0);
        int n2 = 0;
        while (n2 < byArray3.length) {
            Assert.assertTrue((byArray2[n2] == byArray3[n2] ? 1 : 0) != 0);
            ++n2;
        }
        this.ede.setType("int");
        this.ede.setValuesAsByteArray(byArray);
    }

    public void testSetValuesAsDate() {
        this.ede.setTypeAsInt(8);
        String string = "2000-12-25T09:45:05.000Z";
        this.ede.setValuesAsDate(string);
        String string2 = this.ede.getValuesAsDate();
        Assert.assertTrue((boolean)string2.equals(string));
        string = "2001-02-05T19:5:35.000Z";
        this.ede.setValuesAsDate(string);
        string2 = this.ede.getValuesAsDate();
        Assert.assertTrue((boolean)string2.equals(string));
        this.ede.setType("int");
        this.ede.setValuesAsDate(string);
    }

    public void testSetValuesAsDates() {
        this.ede.setTypeAsInt(17);
        String[] stringArray = new String[]{"2000-12-25T09:45:05.000Z", "2001-12-31T11:59:59.000Z"};
        this.ede.setValuesAsDateArray(stringArray);
        String[] stringArray2 = this.ede.getValuesAsDateArray();
        Assert.assertTrue((boolean)Arrays.asList(stringArray2).containsAll(Arrays.asList(stringArray)));
        String[] stringArray3 = new String[]{"1998-02-15T19:35:55.000Z", "1999-12-31T11:00:00.000Z", "1996-10-11T08:30:00.000Z"};
        this.ede.setValuesAsDateArray(stringArray);
        stringArray2 = this.ede.getValuesAsDateArray();
        Assert.assertTrue((boolean)Arrays.asList(stringArray2).containsAll(Arrays.asList(stringArray)));
        this.ede.setType("int");
        this.ede.setValuesAsDateArray(stringArray);
    }

    public void testGetValuesAsDateAsLongWithBadDate() {
        this.ede.setTypeAsInt(8);
        this.ede.setValuesAsDate("awinga");
        try {
            this.ede.getValuesAsDateAsLong();
            Assert.fail((String)"The date is not a valid xsd:dateTime");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testSetValuesAsDateAsLong() throws ParseException {
        this.ede.setTypeAsInt(8);
        String string = "1993-12-10T13:55:19.000Z";
        long l = EventHelpers.dateToLong(string);
        this.ede.setValuesAsDateAsLong(l);
        long l2 = this.ede.getValuesAsDateAsLong();
        Assert.assertTrue((l2 == l ? 1 : 0) != 0);
        String string2 = this.ede.getValuesAsDate();
        Assert.assertTrue((boolean)string.equals(string2));
        l = System.currentTimeMillis() + 10000L;
        this.ede.setValuesAsDateAsLong(l);
        l2 = this.ede.getValuesAsDateAsLong();
        Assert.assertTrue((l2 == l ? 1 : 0) != 0);
        this.ede.setType("int");
        this.ede.setValuesAsDateAsLong(l);
    }

    public void testSetValuesAsDatesAsLong() {
        this.ede.setTypeAsInt(17);
        long[] lArray = new long[]{System.currentTimeMillis(), System.currentTimeMillis() + 10000L};
        this.ede.setValuesAsDateAsLongArray(lArray);
        long[] lArray2 = this.ede.getValuesAsDateAsLongArray();
        Assert.assertTrue((lArray.length == lArray2.length ? 1 : 0) != 0);
        int n = 0;
        while (n < lArray.length) {
            Assert.assertTrue((lArray2[n] == lArray[n] ? 1 : 0) != 0);
            ++n;
        }
        long[] lArray3 = new long[]{System.currentTimeMillis() + 20000L, System.currentTimeMillis() + 30000L, System.currentTimeMillis() + 40000L};
        this.ede.setValuesAsDateAsLongArray(lArray3);
        lArray2 = this.ede.getValuesAsDateAsLongArray();
        Assert.assertTrue((lArray3.length == lArray2.length ? 1 : 0) != 0);
        int n2 = 0;
        while (n2 < lArray3.length) {
            Assert.assertTrue((lArray2[n2] == lArray3[n2] ? 1 : 0) != 0);
            ++n2;
        }
        this.ede.setType("int");
        this.ede.setValuesAsDateAsLongArray(lArray);
    }

    public void testSetValuesAsDouble() {
        this.ede.setTypeAsInt(6);
        double d = Double.MIN_VALUE;
        this.ede.setValuesAsDouble(d);
        double d2 = this.ede.getValuesAsDouble();
        Assert.assertTrue((d2 == d ? 1 : 0) != 0);
        d = Double.MAX_VALUE;
        this.ede.setValuesAsDouble(d);
        d2 = this.ede.getValuesAsDouble();
        Assert.assertTrue((d2 == d ? 1 : 0) != 0);
        this.ede.setType("int");
        this.ede.setValuesAsDouble(d);
    }

    public void testSetValuesAsDoubles() {
        this.ede.setTypeAsInt(15);
        double[] dArray = new double[]{2.6, 1.4, 9.8};
        this.ede.setValuesAsDoubleArray(dArray);
        double[] dArray2 = this.ede.getValuesAsDoubleArray();
        Assert.assertTrue((dArray.length == dArray2.length ? 1 : 0) != 0);
        int n = 0;
        while (n < dArray.length) {
            Assert.assertTrue((dArray2[n] == dArray[n] ? 1 : 0) != 0);
            ++n;
        }
        double[] dArray3 = new double[]{3.7, 0.5};
        this.ede.setValuesAsDoubleArray(dArray3);
        dArray2 = this.ede.getValuesAsDoubleArray();
        Assert.assertTrue((dArray3.length == dArray2.length ? 1 : 0) != 0);
        int n2 = 0;
        while (n2 < dArray3.length) {
            Assert.assertTrue((dArray2[n2] == dArray3[n2] ? 1 : 0) != 0);
            ++n2;
        }
        this.ede.setType("int");
        this.ede.setValuesAsDoubleArray(dArray);
    }

    public void testSetValuesAsFloat() {
        this.ede.setTypeAsInt(5);
        float f = Float.MIN_VALUE;
        this.ede.setValuesAsFloat(f);
        float f2 = this.ede.getValuesAsFloat();
        Assert.assertTrue((f2 == f ? 1 : 0) != 0);
        f = Float.MAX_VALUE;
        this.ede.setValuesAsFloat(f);
        f2 = this.ede.getValuesAsFloat();
        Assert.assertTrue((f2 == f ? 1 : 0) != 0);
        this.ede.setType("int");
        this.ede.setValuesAsFloat(f);
    }

    public void testSetValuesAsFloats() {
        this.ede.setTypeAsInt(14);
        float[] fArray = new float[]{1000.0f, 2000.0f, 3000.0f};
        this.ede.setValuesAsFloatArray(fArray);
        float[] fArray2 = this.ede.getValuesAsFloatArray();
        Assert.assertTrue((fArray.length == fArray2.length ? 1 : 0) != 0);
        int n = 0;
        while (n < fArray.length) {
            Assert.assertTrue((fArray2[n] == fArray[n] ? 1 : 0) != 0);
            ++n;
        }
        float[] fArray3 = new float[]{1.0f, 22.0f, 333.0f, 4444.0f, 55555.0f};
        this.ede.setValuesAsFloatArray(fArray3);
        fArray2 = this.ede.getValuesAsFloatArray();
        Assert.assertTrue((fArray3.length == fArray2.length ? 1 : 0) != 0);
        int n2 = 0;
        while (n2 < fArray3.length) {
            Assert.assertTrue((fArray2[n2] == fArray3[n2] ? 1 : 0) != 0);
            ++n2;
        }
        this.ede.setType("int");
        this.ede.setValuesAsFloatArray(fArray);
    }

    public void testSetValuesAsInt() {
        this.ede.setTypeAsInt(3);
        int n = Integer.MIN_VALUE;
        this.ede.setValuesAsInt(n);
        int n2 = this.ede.getValuesAsInt();
        Assert.assertTrue((n2 == n ? 1 : 0) != 0);
        n = Integer.MAX_VALUE;
        this.ede.setValuesAsInt(n);
        n2 = this.ede.getValuesAsInt();
        Assert.assertTrue((n2 == n ? 1 : 0) != 0);
        this.ede.setType("string");
        this.ede.setValuesAsInt(n);
    }

    public void testSetValuesAsInts() {
        this.ede.setTypeAsInt(12);
        int[] nArray = new int[]{12, 25, 37, 41, 59, 68};
        this.ede.setValuesAsIntArray(nArray);
        int[] nArray2 = this.ede.getValuesAsIntArray();
        Assert.assertTrue((nArray.length == nArray2.length ? 1 : 0) != 0);
        int n = 0;
        while (n < nArray.length) {
            Assert.assertTrue((nArray2[n] == nArray[n] ? 1 : 0) != 0);
            ++n;
        }
        int[] nArray3 = new int[]{9, 21};
        this.ede.setValuesAsIntArray(nArray3);
        nArray2 = this.ede.getValuesAsIntArray();
        Assert.assertTrue((nArray3.length == nArray2.length ? 1 : 0) != 0);
        int n2 = 0;
        while (n2 < nArray3.length) {
            Assert.assertTrue((nArray2[n2] == nArray3[n2] ? 1 : 0) != 0);
            ++n2;
        }
        this.ede.setType("int");
        this.ede.setValuesAsIntArray(nArray);
    }

    public void testSetValuesAsLong() {
        this.ede.setTypeAsInt(4);
        long l = Long.MIN_VALUE;
        this.ede.setValuesAsLong(l);
        long l2 = this.ede.getValuesAsLong();
        Assert.assertTrue((l2 == l ? 1 : 0) != 0);
        l = Long.MAX_VALUE;
        this.ede.setValuesAsLong(l);
        l2 = this.ede.getValuesAsLong();
        Assert.assertTrue((l2 == l ? 1 : 0) != 0);
        this.ede.setType("int");
        this.ede.setValuesAsLong(l);
    }

    public void testSetValuesAsLongs() {
        this.ede.setTypeAsInt(13);
        long[] lArray = new long[]{1234567890L, 234567890L, 345678900L};
        this.ede.setValuesAsLongArray(lArray);
        long[] lArray2 = this.ede.getValuesAsLongArray();
        Assert.assertTrue((lArray.length == lArray2.length ? 1 : 0) != 0);
        int n = 0;
        while (n < lArray.length) {
            Assert.assertTrue((lArray2[n] == lArray[n] ? 1 : 0) != 0);
            ++n;
        }
        long[] lArray3 = new long[]{12345L, 23456L};
        this.ede.setValuesAsLongArray(lArray3);
        lArray2 = this.ede.getValuesAsLongArray();
        Assert.assertTrue((lArray3.length == lArray2.length ? 1 : 0) != 0);
        int n2 = 0;
        while (n2 < lArray3.length) {
            Assert.assertTrue((lArray2[n2] == lArray3[n2] ? 1 : 0) != 0);
            ++n2;
        }
        this.ede.setType("int");
        this.ede.setValuesAsLongArray(lArray);
    }

    public void testSetValuesAsShort() {
        this.ede.setTypeAsInt(2);
        short s = Short.MIN_VALUE;
        this.ede.setValuesAsShort(s);
        short s2 = this.ede.getValuesAsShort();
        Assert.assertTrue((s2 == s ? 1 : 0) != 0);
        s = Short.MAX_VALUE;
        this.ede.setValuesAsShort(s);
        s2 = this.ede.getValuesAsShort();
        Assert.assertTrue((s2 == s ? 1 : 0) != 0);
        this.ede.setType("int");
        this.ede.setValuesAsShort(s);
    }

    public void testSetValuesAsShorts() {
        this.ede.setTypeAsInt(11);
        short[] sArray = new short[]{1, 2, 3};
        this.ede.setValuesAsShortArray(sArray);
        short[] sArray2 = this.ede.getValuesAsShortArray();
        Assert.assertTrue((sArray.length == sArray2.length ? 1 : 0) != 0);
        int n = 0;
        while (n < sArray.length) {
            Assert.assertTrue((sArray2[n] == sArray[n] ? 1 : 0) != 0);
            ++n;
        }
        short[] sArray3 = new short[]{4, 5, 6};
        this.ede.setValuesAsShortArray(sArray3);
        sArray2 = this.ede.getValuesAsShortArray();
        Assert.assertTrue((sArray3.length == sArray2.length ? 1 : 0) != 0);
        int n2 = 0;
        while (n2 < sArray3.length) {
            Assert.assertTrue((sArray2[n2] == sArray3[n2] ? 1 : 0) != 0);
            ++n2;
        }
        this.ede.setType("int");
        this.ede.setValuesAsShortArray(sArray);
    }

    public void testSetValuesAsString() {
        this.ede.setTypeAsInt(7);
        String string = "test1";
        this.ede.setValuesAsString(string);
        String string2 = this.ede.getValuesAsString();
        Assert.assertTrue((boolean)string.equals(string2));
        string = "test2";
        this.ede.setValuesAsString(string);
        string2 = this.ede.getValuesAsString();
        Assert.assertTrue((boolean)string.equals(string2));
        this.ede.setType("int");
        this.ede.setValuesAsString(string);
    }

    public void testSetValuesAsStrings() {
        this.ede.setTypeAsInt(16);
        String[] stringArray = new String[]{"test1", "test2", "test3"};
        this.ede.setValuesAsStringArray(stringArray);
        String[] stringArray2 = this.ede.getValuesAsStringArray();
        Assert.assertTrue((boolean)Arrays.asList(stringArray2).containsAll(Arrays.asList(stringArray)));
        String[] stringArray3 = new String[]{"test4", "test5"};
        this.ede.setValuesAsStringArray(stringArray);
        stringArray2 = this.ede.getValuesAsStringArray();
        Assert.assertTrue((boolean)Arrays.asList(stringArray2).containsAll(Arrays.asList(stringArray)));
        this.ede.setType("int");
        this.ede.setValuesAsStringArray(stringArray);
    }

    public void testHexValueStringCase() {
        this.ede.setTypeAsInt(19);
        this.ede.setHexValue("abcdef");
        byte[] byArray = this.ede.getHexValueAsByteArray();
        this.ede.setHexValue("ABCDEF");
        byte[] byArray2 = this.ede.getHexValueAsByteArray();
        Assert.assertEquals((int)3, (int)byArray.length);
        Assert.assertEquals((int)byArray.length, (int)byArray2.length);
        int n = 0;
        while (n < byArray.length) {
            Assert.assertEquals((String)("Mismatch on " + n), (byte)byArray[n], (byte)byArray2[n]);
            ++n;
        }
    }

    public void testHexValueStringConversionWithBadHex() throws ValidationException {
        this.ede.setType("hexBinary");
        this.ede.setName("Name");
        this.ede.setHexValue("abcZ1234");
        try {
            this.ede.getValuesAsByteArray();
            Assert.fail((String)"The hex value is not valid");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testHexValueStringConversion() {
        int n;
        this.ede.setTypeAsInt(19);
        Assert.assertNull((Object)this.ede.getHexValueAsByteArray());
        StringBuffer stringBuffer = new StringBuffer();
        byte[] byArray = new byte[600000];
        int n2 = Character.getNumericValue('0');
        int n3 = Character.getNumericValue('A');
        int n4 = 0;
        while (n4 < 600000) {
            byArray[n4] = (byte)n4;
            int n5 = (n4 & 0xF0) >> 4;
            int n6 = n5 < 10 ? n2 + n5 : n3 + n5 - 10;
            stringBuffer.append(Character.forDigit(n6, 16));
            n = n4 & 0xF;
            int n7 = n < 10 ? n2 + n : n3 + n - 10;
            stringBuffer.append(Character.forDigit(n7, 16));
            ++n4;
        }
        String string = stringBuffer.toString().toUpperCase();
        this.ede.setHexValueAsByteArray(byArray);
        Assert.assertEquals((String)string, (String)this.ede.getHexValue());
        byte[] byArray2 = this.ede.getHexValueAsByteArray();
        Assert.assertEquals((String)"Wrong length", (int)byArray.length, (int)byArray2.length);
        n = 0;
        while (n < byArray.length) {
            Assert.assertEquals((String)("Mismatch on index: " + n), (byte)byArray[n], (byte)byArray2[n]);
            ++n;
        }
        try {
            this.ede.setType("int");
            this.ede.getHexValueAsByteArray();
            Assert.fail((String)"cannot get byte[] hexValue from int type");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testSetHexValueAsBytes() {
        this.ede.setTypeAsInt(19);
        byte[] byArray = new byte[]{35, 84, 120};
        this.ede.setHexValueAsByteArray(byArray);
        byte[] byArray2 = this.ede.getHexValueAsByteArray();
        String string = this.ede.getHexValue();
        Assert.assertEquals((int)byArray.length, (int)byArray2.length);
        int n = 0;
        while (n < byArray.length) {
            Assert.assertEquals((String)"Wrong value", (byte)byArray[n], (byte)byArray2[n]);
            ++n;
        }
        byte[] byArray3 = new byte[]{97, 9};
        this.ede.setHexValueAsByteArray(byArray3);
        byArray2 = this.ede.getHexValueAsByteArray();
        string = this.ede.getHexValue();
        Assert.assertTrue((byArray3.length == byArray2.length ? 1 : 0) != 0);
        int n2 = 0;
        while (n2 < byArray3.length) {
            Assert.assertEquals((String)"Wrong value", (byte)byArray3[n2], (byte)byArray2[n2]);
            ++n2;
        }
        this.ede.setType("int");
        this.ede.setHexValueAsByteArray(byArray);
    }

    public void testAddChild(String string) {
        ExtendedDataElement extendedDataElement = this.ede.addChild("child 1");
        ExtendedDataElement extendedDataElement2 = this.ede.addChild("child 2");
        EList eList = this.ede.getChildren();
        Assert.assertTrue((eList.size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)eList.contains(extendedDataElement2));
        Assert.assertTrue((boolean)((ExtendedDataElement)eList.get(1)).getName().equals("child 2"));
        Assert.assertTrue((boolean)eList.contains(extendedDataElement));
    }

    public void testAddChild1() {
        ExtendedDataElement extendedDataElement = this.ede.addChild("child 1", 9, "true");
        EList eList = this.ede.getChildren();
        Assert.assertTrue((eList.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)eList.contains(extendedDataElement));
        ExtendedDataElement extendedDataElement2 = (ExtendedDataElement)eList.get(0);
        Assert.assertTrue((extendedDataElement2.getTypeAsInt() == 9 ? 1 : 0) != 0);
        Assert.assertTrue((extendedDataElement2.getValuesAsBoolean() ? 1 : 0) != 0);
    }

    public void testAddChild2() {
        String[] stringArray = new String[]{"test1", "test2"};
        this.ede.addChild("child 1", 16, stringArray);
        this.ede.addChild("child 2", 4, "123");
        EList eList = this.ede.getChildren();
        Assert.assertTrue((eList.size() == 2 ? 1 : 0) != 0);
        ExtendedDataElement extendedDataElement = (ExtendedDataElement)eList.get(0);
        Assert.assertTrue((extendedDataElement.getTypeAsInt() == 16 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)Arrays.asList(extendedDataElement.getValuesAsStringArray()).containsAll(Arrays.asList(stringArray)));
        extendedDataElement = (ExtendedDataElement)eList.get(1);
        Assert.assertTrue((extendedDataElement.getTypeAsInt() == 4 ? 1 : 0) != 0);
        Assert.assertTrue((extendedDataElement.getValuesAsLong() == 123L ? 1 : 0) != 0);
    }

    public void testAddChild3() {
        String string = "test 1";
        this.ede.addChild("child 1", string);
        EList eList = this.ede.getChildren();
        Assert.assertTrue((eList.size() == 1 ? 1 : 0) != 0);
        ExtendedDataElement extendedDataElement = (ExtendedDataElement)eList.get(0);
        Assert.assertTrue((extendedDataElement.getTypeAsInt() == 7 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)extendedDataElement.getValuesAsString().equals(string));
    }

    public void testAddChild4() {
        String[] stringArray = new String[]{"test 1", "test 2"};
        this.ede.addChild("child 1", stringArray);
        EList eList = this.ede.getChildren();
        Assert.assertTrue((eList.size() == 1 ? 1 : 0) != 0);
        ExtendedDataElement extendedDataElement = (ExtendedDataElement)eList.get(0);
        Assert.assertTrue((extendedDataElement.getTypeAsInt() == 16 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)Arrays.asList(extendedDataElement.getValuesAsStringArray()).containsAll(Arrays.asList(stringArray)));
    }

    public void testAddChildWithBooleanrrayValue() {
        boolean[] blArray = new boolean[]{false, true};
        this.ede.addChildWithBooleanArrayValue("child 1", blArray);
        EList eList = this.ede.getChildren();
        Assert.assertTrue((eList.size() == 1 ? 1 : 0) != 0);
        ExtendedDataElement extendedDataElement = (ExtendedDataElement)eList.get(0);
        Assert.assertTrue((extendedDataElement.getTypeAsInt() == 18 ? 1 : 0) != 0);
        boolean[] blArray2 = extendedDataElement.getValuesAsBooleanArray();
        Assert.assertTrue((blArray.length == blArray2.length ? 1 : 0) != 0);
        int n = 0;
        while (n < blArray.length) {
            Assert.assertTrue((blArray2[n] == blArray[n] ? 1 : 0) != 0);
            ++n;
        }
    }

    public void testAddChildWithBooleanValue() {
        boolean bl = true;
        this.ede.addChildWithBooleanValue("child 1", bl);
        EList eList = this.ede.getChildren();
        Assert.assertTrue((eList.size() == 1 ? 1 : 0) != 0);
        ExtendedDataElement extendedDataElement = (ExtendedDataElement)eList.get(0);
        Assert.assertTrue((extendedDataElement.getTypeAsInt() == 9 ? 1 : 0) != 0);
        Assert.assertTrue((extendedDataElement.getValuesAsBoolean() == bl ? 1 : 0) != 0);
    }

    public void testAddChildWithByteArrayValue() {
        byte[] byArray = new byte[]{97, 98};
        this.ede.addChildWithByteArrayValue("child 1", byArray);
        EList eList = this.ede.getChildren();
        Assert.assertTrue((eList.size() == 1 ? 1 : 0) != 0);
        ExtendedDataElement extendedDataElement = (ExtendedDataElement)eList.get(0);
        Assert.assertTrue((extendedDataElement.getTypeAsInt() == 10 ? 1 : 0) != 0);
        byte[] byArray2 = extendedDataElement.getValuesAsByteArray();
        Assert.assertTrue((byArray.length == byArray2.length ? 1 : 0) != 0);
        int n = 0;
        while (n < byArray.length) {
            Assert.assertTrue((byArray2[n] == byArray[n] ? 1 : 0) != 0);
            ++n;
        }
    }

    public void testAddChildWithByteValue() {
        byte by = 97;
        this.ede.addChildWithByteValue("child 1", by);
        EList eList = this.ede.getChildren();
        Assert.assertTrue((eList.size() == 1 ? 1 : 0) != 0);
        ExtendedDataElement extendedDataElement = (ExtendedDataElement)eList.get(0);
        Assert.assertTrue((extendedDataElement.getTypeAsInt() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((extendedDataElement.getValuesAsByte() == by ? 1 : 0) != 0);
    }

    public void testAddChildWithDateArrayValue() {
        String[] stringArray = new String[]{"2000-12-31T11:00:00.000Z", "2001-12-31T11:00:00.000Z", "2002-12-31T11:00:00.000Z"};
        this.ede.addChildWithDateArrayValue("child 1", stringArray);
        EList eList = this.ede.getChildren();
        Assert.assertTrue((eList.size() == 1 ? 1 : 0) != 0);
        ExtendedDataElement extendedDataElement = (ExtendedDataElement)eList.get(0);
        Assert.assertTrue((extendedDataElement.getTypeAsInt() == 17 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)Arrays.asList(extendedDataElement.getValuesAsDateArray()).containsAll(Arrays.asList(stringArray)));
    }

    public void testAddChildWithDateAsLongValue() {
        long l = System.currentTimeMillis();
        this.ede.addChildWithDateAsLongValue("child 1", l);
        EList eList = this.ede.getChildren();
        Assert.assertTrue((eList.size() == 1 ? 1 : 0) != 0);
        ExtendedDataElement extendedDataElement = (ExtendedDataElement)eList.get(0);
        Assert.assertTrue((extendedDataElement.getTypeAsInt() == 8 ? 1 : 0) != 0);
        Assert.assertTrue((extendedDataElement.getValuesAsDateAsLong() == l ? 1 : 0) != 0);
    }

    public void testAddChildWithDatesAsLongValue() {
        long[] lArray = new long[]{System.currentTimeMillis(), System.currentTimeMillis() + 10000L};
        this.ede.addChildWithDatesAsLongValue("child 1", lArray);
        EList eList = this.ede.getChildren();
        Assert.assertTrue((eList.size() == 1 ? 1 : 0) != 0);
        ExtendedDataElement extendedDataElement = (ExtendedDataElement)eList.get(0);
        Assert.assertTrue((extendedDataElement.getTypeAsInt() == 17 ? 1 : 0) != 0);
        long[] lArray2 = extendedDataElement.getValuesAsDateAsLongArray();
        Assert.assertTrue((lArray.length == lArray2.length ? 1 : 0) != 0);
        int n = 0;
        while (n < lArray.length) {
            Assert.assertTrue((lArray2[n] == lArray[n] ? 1 : 0) != 0);
            ++n;
        }
    }

    public void testAddChildWithDateValue() {
        String string = "2003-11-10T12:00:00.000Z";
        this.ede.addChildWithDateValue("child 1", string);
        EList eList = this.ede.getChildren();
        Assert.assertTrue((eList.size() == 1 ? 1 : 0) != 0);
        ExtendedDataElement extendedDataElement = (ExtendedDataElement)eList.get(0);
        Assert.assertTrue((extendedDataElement.getTypeAsInt() == 8 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)extendedDataElement.getValuesAsDate().equals(string));
    }

    public void testAddChildWithDoubleArrayValue() {
        double[] dArray = new double[]{34.7, 65.8};
        this.ede.addChildWithDoubleArrayValue("child 1", dArray);
        EList eList = this.ede.getChildren();
        Assert.assertTrue((eList.size() == 1 ? 1 : 0) != 0);
        ExtendedDataElement extendedDataElement = (ExtendedDataElement)eList.get(0);
        Assert.assertTrue((extendedDataElement.getTypeAsInt() == 15 ? 1 : 0) != 0);
        double[] dArray2 = extendedDataElement.getValuesAsDoubleArray();
        Assert.assertTrue((dArray.length == dArray2.length ? 1 : 0) != 0);
        int n = 0;
        while (n < dArray.length) {
            Assert.assertTrue((dArray2[n] == dArray[n] ? 1 : 0) != 0);
            ++n;
        }
    }

    public void testAddChildWithDoubleValue() {
        double d = 12.5;
        this.ede.addChildWithDoubleValue("child 1", d);
        EList eList = this.ede.getChildren();
        Assert.assertTrue((eList.size() == 1 ? 1 : 0) != 0);
        ExtendedDataElement extendedDataElement = (ExtendedDataElement)eList.get(0);
        Assert.assertTrue((extendedDataElement.getTypeAsInt() == 6 ? 1 : 0) != 0);
        Assert.assertTrue((extendedDataElement.getValuesAsDouble() == d ? 1 : 0) != 0);
    }

    public void testAddChildWithFloatArrayValue() {
        float[] fArray = new float[]{2.1321312E8f, 1.2312414E8f};
        this.ede.addChildWithFloatArrayValue("child 1", fArray);
        EList eList = this.ede.getChildren();
        Assert.assertTrue((eList.size() == 1 ? 1 : 0) != 0);
        ExtendedDataElement extendedDataElement = (ExtendedDataElement)eList.get(0);
        Assert.assertTrue((extendedDataElement.getTypeAsInt() == 14 ? 1 : 0) != 0);
        float[] fArray2 = extendedDataElement.getValuesAsFloatArray();
        Assert.assertTrue((fArray.length == fArray2.length ? 1 : 0) != 0);
        int n = 0;
        while (n < fArray.length) {
            Assert.assertTrue((fArray2[n] == fArray[n] ? 1 : 0) != 0);
            ++n;
        }
    }

    public void testAddChildWithFloatValue() {
        float f = 97.0f;
        this.ede.addChildWithFloatValue("child 1", f);
        EList eList = this.ede.getChildren();
        Assert.assertTrue((eList.size() == 1 ? 1 : 0) != 0);
        ExtendedDataElement extendedDataElement = (ExtendedDataElement)eList.get(0);
        Assert.assertTrue((extendedDataElement.getTypeAsInt() == 5 ? 1 : 0) != 0);
        Assert.assertTrue((extendedDataElement.getValuesAsFloat() == f ? 1 : 0) != 0);
    }

    public void testAddChildWithIntArrayValue() {
        int[] nArray = new int[]{10, 12};
        this.ede.addChildWithIntArrayValue("child 1", nArray);
        EList eList = this.ede.getChildren();
        Assert.assertTrue((eList.size() == 1 ? 1 : 0) != 0);
        ExtendedDataElement extendedDataElement = (ExtendedDataElement)eList.get(0);
        Assert.assertTrue((extendedDataElement.getTypeAsInt() == 12 ? 1 : 0) != 0);
        int[] nArray2 = extendedDataElement.getValuesAsIntArray();
        Assert.assertTrue((nArray.length == nArray2.length ? 1 : 0) != 0);
        int n = 0;
        while (n < nArray.length) {
            Assert.assertTrue((nArray2[n] == nArray[n] ? 1 : 0) != 0);
            ++n;
        }
    }

    public void testAddChildWithIntValue() {
        int n = 123;
        this.ede.addChildWithIntValue("child 1", n);
        EList eList = this.ede.getChildren();
        Assert.assertTrue((eList.size() == 1 ? 1 : 0) != 0);
        ExtendedDataElement extendedDataElement = (ExtendedDataElement)eList.get(0);
        Assert.assertTrue((extendedDataElement.getTypeAsInt() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((extendedDataElement.getValuesAsInt() == n ? 1 : 0) != 0);
    }

    public void testAddChildWithLongArrayValue() {
        long[] lArray = new long[]{10121416L, 12100806L};
        this.ede.addChildWithLongArrayValue("child 1", lArray);
        EList eList = this.ede.getChildren();
        Assert.assertTrue((eList.size() == 1 ? 1 : 0) != 0);
        ExtendedDataElement extendedDataElement = (ExtendedDataElement)eList.get(0);
        Assert.assertTrue((extendedDataElement.getTypeAsInt() == 13 ? 1 : 0) != 0);
        long[] lArray2 = extendedDataElement.getValuesAsLongArray();
        Assert.assertTrue((lArray.length == lArray2.length ? 1 : 0) != 0);
        int n = 0;
        while (n < lArray.length) {
            Assert.assertTrue((lArray2[n] == lArray[n] ? 1 : 0) != 0);
            ++n;
        }
    }

    public void testAddChildWithLongValue() {
        long l = 123456789L;
        this.ede.addChildWithLongValue("child 1", l);
        EList eList = this.ede.getChildren();
        Assert.assertTrue((eList.size() == 1 ? 1 : 0) != 0);
        ExtendedDataElement extendedDataElement = (ExtendedDataElement)eList.get(0);
        Assert.assertTrue((extendedDataElement.getTypeAsInt() == 4 ? 1 : 0) != 0);
        Assert.assertTrue((extendedDataElement.getValuesAsLong() == l ? 1 : 0) != 0);
    }

    public void testAddChildWithShortArrayValue() {
        short[] sArray = new short[]{10, 12};
        this.ede.addChildWithShortArrayValue("child 1", sArray);
        EList eList = this.ede.getChildren();
        Assert.assertTrue((eList.size() == 1 ? 1 : 0) != 0);
        ExtendedDataElement extendedDataElement = (ExtendedDataElement)eList.get(0);
        Assert.assertTrue((extendedDataElement.getTypeAsInt() == 11 ? 1 : 0) != 0);
        short[] sArray2 = extendedDataElement.getValuesAsShortArray();
        Assert.assertTrue((sArray.length == sArray2.length ? 1 : 0) != 0);
        int n = 0;
        while (n < sArray.length) {
            Assert.assertTrue((sArray2[n] == sArray[n] ? 1 : 0) != 0);
            ++n;
        }
    }

    public void testAddChildWithShortValue() {
        short s = 4;
        this.ede.addChildWithShortValue("child 1", s);
        EList eList = this.ede.getChildren();
        Assert.assertTrue((eList.size() == 1 ? 1 : 0) != 0);
        ExtendedDataElement extendedDataElement = (ExtendedDataElement)eList.get(0);
        Assert.assertTrue((extendedDataElement.getTypeAsInt() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((extendedDataElement.getValuesAsShort() == s ? 1 : 0) != 0);
    }

    public void testAddExtendedDataElementGenericWithHexBinary() throws ValidationException {
        String string = "abc123";
        ExtendedDataElement extendedDataElement = this.ede.addChild("AA", 19, string);
        Assert.assertEquals((int)1, (int)this.ede.getChildren().size());
        ExtendedDataElement extendedDataElement2 = (ExtendedDataElement)this.ede.getChildren().get(0);
        Assert.assertEquals((String)"hexBinary", (String)extendedDataElement2.getType());
        Assert.assertEquals((Object)extendedDataElement, (Object)extendedDataElement2);
        Assert.assertEquals((String)string, (String)extendedDataElement.getHexValue());
    }

    public void testAddChildWithHexValue() {
        String string = "hexValue";
        this.ede.addChildWithHexValue("child 1", string);
        EList eList = this.ede.getChildren();
        Assert.assertTrue((eList.size() == 1 ? 1 : 0) != 0);
        ExtendedDataElement extendedDataElement = (ExtendedDataElement)eList.get(0);
        Assert.assertTrue((extendedDataElement.getTypeAsInt() == 19 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)extendedDataElement.getHexValue().equals(string));
    }

    public void testAddChildWithHexValueAsByteArray() {
        byte[] byArray = new byte[]{98, 84};
        this.ede.addChildWithHexValueAsByteArray("child 1", byArray);
        EList eList = this.ede.getChildren();
        Assert.assertEquals((String)"Wrong size", (int)eList.size(), (int)1);
        ExtendedDataElement extendedDataElement = (ExtendedDataElement)eList.get(0);
        Assert.assertEquals((int)extendedDataElement.getTypeAsInt(), (int)19);
        byte[] byArray2 = extendedDataElement.getHexValueAsByteArray();
        Assert.assertEquals((String)"Wrong length", (int)byArray.length, (int)byArray2.length);
        int n = 0;
        while (n < byArray.length) {
            Assert.assertEquals((String)"Wrong value", (byte)byArray[n], (byte)byArray2[n]);
            ++n;
        }
    }

    public void testDuplicateValues() {
        EventFactory eventFactory = EventFactory.eINSTANCE;
        ExtendedDataElement extendedDataElement = eventFactory.createExtendedDataElement();
        extendedDataElement.getValues().add("1");
        extendedDataElement.getValues().add("1");
        Assert.assertEquals((int)extendedDataElement.getValues().size(), (int)2);
    }

    public void testEDE_TYPE_VALUES() {
        Assert.assertEquals((String)"noValue", (String)ExtendedDataElementImpl.EDE_TYPES[0]);
        Assert.assertEquals((String)"byte", (String)ExtendedDataElementImpl.EDE_TYPES[1]);
        Assert.assertEquals((String)"short", (String)ExtendedDataElementImpl.EDE_TYPES[2]);
        Assert.assertEquals((String)"int", (String)ExtendedDataElementImpl.EDE_TYPES[3]);
        Assert.assertEquals((String)"long", (String)ExtendedDataElementImpl.EDE_TYPES[4]);
        Assert.assertEquals((String)"float", (String)ExtendedDataElementImpl.EDE_TYPES[5]);
        Assert.assertEquals((String)"double", (String)ExtendedDataElementImpl.EDE_TYPES[6]);
        Assert.assertEquals((String)"string", (String)ExtendedDataElementImpl.EDE_TYPES[7]);
        Assert.assertEquals((String)"dateTime", (String)ExtendedDataElementImpl.EDE_TYPES[8]);
        Assert.assertEquals((String)"boolean", (String)ExtendedDataElementImpl.EDE_TYPES[9]);
        Assert.assertEquals((String)"byteArray", (String)ExtendedDataElementImpl.EDE_TYPES[10]);
        Assert.assertEquals((String)"shortArray", (String)ExtendedDataElementImpl.EDE_TYPES[11]);
        Assert.assertEquals((String)"intArray", (String)ExtendedDataElementImpl.EDE_TYPES[12]);
        Assert.assertEquals((String)"longArray", (String)ExtendedDataElementImpl.EDE_TYPES[13]);
        Assert.assertEquals((String)"floatArray", (String)ExtendedDataElementImpl.EDE_TYPES[14]);
        Assert.assertEquals((String)"doubleArray", (String)ExtendedDataElementImpl.EDE_TYPES[15]);
        Assert.assertEquals((String)"stringArray", (String)ExtendedDataElementImpl.EDE_TYPES[16]);
        Assert.assertEquals((String)"dateTimeArray", (String)ExtendedDataElementImpl.EDE_TYPES[17]);
        Assert.assertEquals((String)"booleanArray", (String)ExtendedDataElementImpl.EDE_TYPES[18]);
        Assert.assertEquals((String)"hexBinary", (String)ExtendedDataElementImpl.EDE_TYPES[19]);
        Assert.assertEquals((String)"noValue", (String)"noValue");
        Assert.assertEquals((String)"byte", (String)"byte");
        Assert.assertEquals((String)"short", (String)"short");
        Assert.assertEquals((String)"int", (String)"int");
        Assert.assertEquals((String)"long", (String)"long");
        Assert.assertEquals((String)"float", (String)"float");
        Assert.assertEquals((String)"double", (String)"double");
        Assert.assertEquals((String)"string", (String)"string");
        Assert.assertEquals((String)"dateTime", (String)"dateTime");
        Assert.assertEquals((String)"boolean", (String)"boolean");
        Assert.assertEquals((String)"byteArray", (String)"byteArray");
        Assert.assertEquals((String)"shortArray", (String)"shortArray");
        Assert.assertEquals((String)"intArray", (String)"intArray");
        Assert.assertEquals((String)"longArray", (String)"longArray");
        Assert.assertEquals((String)"floatArray", (String)"floatArray");
        Assert.assertEquals((String)"doubleArray", (String)"doubleArray");
        Assert.assertEquals((String)"stringArray", (String)"stringArray");
        Assert.assertEquals((String)"dateTimeArray", (String)"dateTimeArray");
        Assert.assertEquals((String)"booleanArray", (String)"booleanArray");
        Assert.assertEquals((String)"hexBinary", (String)"hexBinary");
    }

    public void testToString() {
        Assert.assertNotNull((String)"ede with soma data filled in", (Object)this.ede.toString());
        this.ede = EventFactory.eINSTANCE.createExtendedDataElement();
        Assert.assertNotNull((String)"empty ede", (Object)this.ede.toString());
    }

    public void testEDETypeConversion() throws ValidationException {
        this.ede.setName("test me");
        this.ede.setType("noValue");
        this.ede.validate();
        byte by = 99;
        this.ede.setValuesAsByte(by);
        this.ede.setType("byte");
        this.ede.validate();
        this.ede.setValuesAsString("c");
        this.ede.setType("byte");
        try {
            this.ede.validate();
            Assert.fail((String)(this.ede.getValues() + " is not a valid " + this.ede.getType()));
        }
        catch (ValidationException validationException) {
            Util.assertExceptionId("IWAT0192E", validationException);
        }
        int[] nArray = new int[]{99, 100, 101};
        this.ede.setValuesAsIntArray(nArray);
        this.ede.setType("boolean");
        try {
            this.ede.validate();
            Assert.fail((String)(this.ede.getType() + " requires a single value : " + this.ede.getValues()));
        }
        catch (ValidationException validationException) {
            Util.assertExceptionId("IWAT0191E", validationException);
        }
        this.ede.setValuesAsDouble(5.5);
        this.ede.setType("int");
        try {
            this.ede.validate();
            Assert.fail((String)(this.ede.getValues() + " is not a valid " + this.ede.getType()));
        }
        catch (ValidationException validationException) {
            Util.assertExceptionId("IWAT0192E", validationException);
        }
        this.ede.setValuesAsString("123");
        this.ede.setType("short");
        this.ede.validate();
        this.ede.setValuesAsString("xyz");
        this.ede.setType("short");
        try {
            this.ede.validate();
            Assert.fail((String)(this.ede.getValues() + " is not a valid " + this.ede.getType()));
        }
        catch (ValidationException validationException) {
            Util.assertExceptionId("IWAT0192E", validationException);
        }
        this.ede.setValuesAsString("987654321");
        this.ede.setType("short");
        try {
            this.ede.validate();
            Assert.fail((String)(this.ede.getValues() + " is not a valid " + this.ede.getType()));
        }
        catch (ValidationException validationException) {
            Util.assertExceptionId("IWAT0192E", validationException);
        }
        short[] sArray = new short[]{567, 123, 3};
        this.ede.setValuesAsShortArray(sArray);
        this.ede.setType("short");
        try {
            this.ede.validate();
            Assert.fail((String)(this.ede.getType() + " requires a single value : " + this.ede.getValues()));
        }
        catch (ValidationException validationException) {
            Util.assertExceptionId("IWAT0191E", validationException);
        }
        this.ede.setValuesAsString("123");
        this.ede.setType("int");
        this.ede.validate();
        this.ede.setValuesAsString("xyz");
        this.ede.setType("int");
        try {
            this.ede.validate();
            Assert.fail((String)(this.ede.getValues() + " is not a valid " + this.ede.getType()));
        }
        catch (ValidationException validationException) {
            Util.assertExceptionId("IWAT0192E", validationException);
        }
        int[] nArray2 = new int[]{567, 123, 3};
        this.ede.setValuesAsIntArray(nArray2);
        this.ede.setType("int");
        try {
            this.ede.validate();
            Assert.fail((String)(this.ede.getType() + " requires a single value : " + this.ede.getValues()));
        }
        catch (ValidationException validationException) {
            Util.assertExceptionId("IWAT0191E", validationException);
        }
        long l = new Long("1067528539452");
        String string = Long.toString(l);
        this.ede.setValuesAsString(string);
        this.ede.setType("long");
        this.ede.validate();
        this.ede.setValuesAsLong(l);
        this.ede.setType("long");
        this.ede.validate();
        this.ede.setValuesAsString("xyz");
        this.ede.setType("long");
        try {
            this.ede.validate();
            Assert.fail((String)(this.ede.getValues() + " is not a valid " + this.ede.getType()));
        }
        catch (ValidationException validationException) {
            Util.assertExceptionId("IWAT0192E", validationException);
        }
        long[] lArray = new long[]{123L, 456L};
        this.ede.setValuesAsLongArray(lArray);
        this.ede.setType("long");
        try {
            this.ede.validate();
            Assert.fail((String)(this.ede.getType() + " requires a single value : " + this.ede.getValues()));
        }
        catch (ValidationException validationException) {
            Util.assertExceptionId("IWAT0191E", validationException);
        }
        float f = Float.intBitsToFloat(0x7F7FFFFF);
        String string2 = Float.toString(f);
        this.ede.setValuesAsString(string2);
        this.ede.setType("float");
        this.ede.validate();
        this.ede.setValuesAsFloat(f);
        this.ede.setType("float");
        this.ede.validate();
        this.ede.setValuesAsString("xyz");
        this.ede.setType("float");
        try {
            this.ede.validate();
            Assert.fail((String)(this.ede.getValues() + " is not a valid " + this.ede.getType()));
        }
        catch (ValidationException validationException) {
            Util.assertExceptionId("IWAT0192E", validationException);
        }
        float[] fArray = new float[]{567.0f, 123.0f};
        this.ede.setValuesAsFloatArray(fArray);
        this.ede.setType("float");
        try {
            this.ede.validate();
            Assert.fail((String)(this.ede.getType() + " requires a single value : " + this.ede.getValues()));
        }
        catch (ValidationException validationException) {
            Util.assertExceptionId("IWAT0191E", validationException);
        }
        double d = Double.longBitsToDouble(0x7FEFFFFFFFFFFFFFL);
        String string3 = Double.toString(d);
        this.ede.setValuesAsString(string3);
        this.ede.setType("double");
        this.ede.validate();
        this.ede.setValuesAsDouble(d);
        this.ede.setType("double");
        this.ede.validate();
        this.ede.setValuesAsString("xyz");
        this.ede.setType("double");
        try {
            this.ede.validate();
            Assert.fail((String)(this.ede.getValues() + " is not a valid " + this.ede.getType()));
        }
        catch (ValidationException validationException) {
            Util.assertExceptionId("IWAT0192E", validationException);
        }
        double[] dArray = new double[]{567.0, 123.0};
        this.ede.setValuesAsDoubleArray(dArray);
        this.ede.setType("double");
        try {
            this.ede.validate();
            Assert.fail((String)(this.ede.getType() + " requires a single value : " + this.ede.getValues()));
        }
        catch (ValidationException validationException) {
            Util.assertExceptionId("IWAT0191E", validationException);
        }
        this.ede.setValuesAsString("my string");
        this.ede.setType("string");
        this.ede.validate();
        String string4 = Util.getPaddedString(1025);
        this.ede.setValuesAsString(string4);
        this.ede.setType("string");
        try {
            this.ede.validate();
            Assert.fail((String)(this.ede.getValues() + " elements exceed the maximum length"));
        }
        catch (ValidationException validationException) {
            Util.assertExceptionId("IWAT0201E", validationException);
        }
        this.ede.setValuesAsString(null);
        this.ede.setType("string");
        try {
            this.ede.validate();
            Assert.fail((String)(this.ede.getType() + " cannot has a null value"));
        }
        catch (ValidationException validationException) {
            Util.assertExceptionId("IWAT0194E", validationException);
        }
        String[] stringArray = new String[]{"aaa", "bbb"};
        this.ede.setValuesAsStringArray(stringArray);
        this.ede.setType("string");
        try {
            this.ede.validate();
            Assert.fail((String)(this.ede.getType() + " requires a single value : " + this.ede.getValues()));
        }
        catch (ValidationException validationException) {
            Util.assertExceptionId("IWAT0191E", validationException);
        }
        long l2 = new Long("1067528539452");
        this.ede.setValuesAsDateAsLong(l2);
        this.ede.setType("dateTime");
        this.ede.validate();
        this.ede.setValuesAsString("2003-10-30T10:42:19.452-05:00");
        this.ede.setType("dateTime");
        this.ede.validate();
        this.ede.setValuesAsString("xyz");
        this.ede.setType("dateTime");
        try {
            this.ede.validate();
            Assert.fail((String)(this.ede.getValues() + " is not a valid " + this.ede.getType()));
        }
        catch (ValidationException validationException) {
            Util.assertExceptionId("IWAT0196E", validationException);
        }
        long[] lArray2 = new long[]{987654321L, 998877665L};
        this.ede.setValuesAsDateAsLongArray(lArray2);
        this.ede.setType("dateTime");
        try {
            this.ede.validate();
            Assert.fail((String)(this.ede.getType() + " requires a single value : " + this.ede.getValues()));
        }
        catch (ValidationException validationException) {
            Util.assertExceptionId("IWAT0191E", validationException);
        }
        boolean bl = true;
        this.ede.setValuesAsBoolean(bl);
        this.ede.setType("boolean");
        this.ede.validate();
        this.ede.setValuesAsBoolean(false);
        this.ede.setType("boolean");
        this.ede.validate();
        this.ede.setValuesAsString("true");
        this.ede.setType("boolean");
        this.ede.validate();
        this.ede.setValuesAsString("false");
        this.ede.setType("boolean");
        this.ede.validate();
        this.ede.setValuesAsString("0");
        this.ede.setType("boolean");
        this.ede.validate();
        this.ede.setValuesAsString("1");
        this.ede.setType("boolean");
        this.ede.validate();
        this.ede.setValuesAsString("TRUE");
        this.ede.setType("boolean");
        try {
            this.ede.validate();
            Assert.fail((String)(this.ede.getValues() + " is not a valid " + this.ede.getType()));
        }
        catch (ValidationException validationException) {
            Util.assertExceptionId("IWAT0195E", validationException);
        }
        boolean[] blArray = new boolean[]{true, false};
        this.ede.setValuesAsBooleanArray(blArray);
        this.ede.setType("boolean");
        try {
            this.ede.validate();
            Assert.fail((String)(this.ede.getType() + " requires a single value : " + this.ede.getValues()));
        }
        catch (ValidationException validationException) {
            Util.assertExceptionId("IWAT0191E", validationException);
        }
        byte[] byArray = new byte[]{1, 99, 3};
        String[] stringArray2 = new String[]{"1", "2", "3"};
        String[] stringArray3 = new String[]{"1", "2", "z"};
        this.ede.setValuesAsByteArray(byArray);
        this.ede.setType("byteArray");
        this.ede.validate();
        this.ede.setValuesAsStringArray(stringArray2);
        this.ede.setType("byteArray");
        this.ede.validate();
        this.ede.setValuesAsStringArray(stringArray3);
        this.ede.setType("byteArray");
        try {
            this.ede.validate();
            Assert.fail((String)(this.ede.getValues() + " is not a valid " + this.ede.getType()));
        }
        catch (ValidationException validationException) {
            Util.assertExceptionId("IWAT0192E", validationException);
        }
        short[] sArray2 = new short[]{1, 2, 3};
        String[] stringArray4 = new String[]{"1", "2", "3"};
        String[] stringArray5 = new String[]{"z", "2", "3"};
        this.ede.setValuesAsShortArray(sArray2);
        this.ede.setType("shortArray");
        this.ede.validate();
        this.ede.setValuesAsStringArray(stringArray4);
        this.ede.setType("shortArray");
        this.ede.validate();
        this.ede.setValuesAsStringArray(stringArray5);
        this.ede.setType("shortArray");
        try {
            this.ede.validate();
            Assert.fail((String)(this.ede.getValues() + " is not a valid " + this.ede.getType()));
        }
        catch (ValidationException validationException) {
            Util.assertExceptionId("IWAT0192E", validationException);
        }
        int[] nArray3 = new int[]{1, 2, 3};
        String[] stringArray6 = new String[]{"1", "2", "3"};
        String[] stringArray7 = new String[]{"1", "2", "z"};
        this.ede.setValuesAsIntArray(nArray3);
        this.ede.setType("intArray");
        this.ede.validate();
        this.ede.setValuesAsStringArray(stringArray6);
        this.ede.setType("intArray");
        this.ede.validate();
        this.ede.setValuesAsStringArray(stringArray7);
        this.ede.setType("intArray");
        try {
            this.ede.validate();
            Assert.fail((String)(this.ede.getValues() + " is not a valid " + this.ede.getType()));
        }
        catch (ValidationException validationException) {
            Util.assertExceptionId("IWAT0192E", validationException);
        }
        long[] lArray3 = new long[]{1L, 2L, 3L};
        String[] stringArray8 = new String[]{"1", "2", "3"};
        String[] stringArray9 = new String[]{"1", "2", "z"};
        this.ede.setValuesAsLongArray(lArray3);
        this.ede.setType("longArray");
        this.ede.validate();
        this.ede.setValuesAsStringArray(stringArray8);
        this.ede.setType("longArray");
        this.ede.validate();
        this.ede.setValuesAsStringArray(stringArray9);
        this.ede.setType("longArray");
        try {
            this.ede.validate();
            Assert.fail((String)(this.ede.getValues() + " is not a valid " + this.ede.getType()));
        }
        catch (ValidationException validationException) {
            Util.assertExceptionId("IWAT0192E", validationException);
        }
        float[] fArray2 = new float[]{1.0f, 2.0f, 3.0f};
        String[] stringArray10 = new String[]{"1", "2", "3"};
        String[] stringArray11 = new String[]{"1", "2", "z"};
        this.ede.setValuesAsFloatArray(fArray2);
        this.ede.setType("floatArray");
        this.ede.validate();
        this.ede.setValuesAsStringArray(stringArray10);
        this.ede.setType("floatArray");
        this.ede.validate();
        this.ede.setValuesAsStringArray(stringArray11);
        this.ede.setType("floatArray");
        try {
            this.ede.validate();
            Assert.fail((String)(this.ede.getValues() + " is not a valid " + this.ede.getType()));
        }
        catch (ValidationException validationException) {
            Util.assertExceptionId("IWAT0192E", validationException);
        }
        double[] dArray2 = new double[]{1.0, 2.0, 3.0};
        String[] stringArray12 = new String[]{"1", "2", "3"};
        String[] stringArray13 = new String[]{"1", "2", "z"};
        this.ede.setValuesAsDoubleArray(dArray2);
        this.ede.setType("doubleArray");
        this.ede.validate();
        this.ede.setValuesAsStringArray(stringArray12);
        this.ede.setType("doubleArray");
        this.ede.validate();
        this.ede.setValuesAsStringArray(stringArray13);
        this.ede.setType("doubleArray");
        try {
            this.ede.validate();
            Assert.fail((String)(this.ede.getValues() + " is not a valid " + this.ede.getType()));
        }
        catch (ValidationException validationException) {
            Util.assertExceptionId("IWAT0192E", validationException);
        }
        String[] stringArray14 = new String[]{"1", "2", "3"};
        this.ede.setValuesAsStringArray(stringArray14);
        this.ede.setType("stringArray");
        this.ede.validate();
        String string5 = Util.getAlphaString(1025);
        String[] stringArray15 = new String[]{"1", string5, "3"};
        this.ede.setValuesAsStringArray(stringArray15);
        this.ede.setType("stringArray");
        try {
            this.ede.validate();
            Assert.fail((String)(this.ede.getValues() + " elements exceed the maximum length"));
        }
        catch (ValidationException validationException) {
            Util.assertExceptionId("IWAT0201E", validationException);
        }
        long[] lArray4 = new long[]{987654321L, 12345678L, 33333333L};
        String[] stringArray16 = new String[]{"2003-10-30T10:42:19.452-05:00", "2003-10-30T10:42:19.452-05:00"};
        String[] stringArray17 = new String[]{"2003-10-30T10:42:19.452-05:00", "xxx"};
        this.ede.setValuesAsDateAsLongArray(lArray4);
        this.ede.setType("dateTimeArray");
        this.ede.validate();
        this.ede.setValuesAsStringArray(stringArray16);
        this.ede.setType("dateTimeArray");
        this.ede.validate();
        this.ede.setValuesAsStringArray(stringArray17);
        this.ede.setType("dateTimeArray");
        try {
            this.ede.validate();
            Assert.fail((String)(this.ede.getValues() + " is not a valid " + this.ede.getType()));
        }
        catch (ValidationException validationException) {
            Util.assertExceptionId("IWAT0196E", validationException);
        }
        boolean[] blArray2 = new boolean[]{true, false, false};
        String[] stringArray18 = new String[]{"1", "0", "false"};
        String[] stringArray19 = new String[]{"true", "x", "false"};
        this.ede.setValuesAsBooleanArray(blArray2);
        this.ede.setType("booleanArray");
        this.ede.validate();
        this.ede.setValuesAsStringArray(stringArray18);
        this.ede.setType("booleanArray");
        this.ede.validate();
        this.ede.setValuesAsStringArray(stringArray19);
        this.ede.setType("booleanArray");
        try {
            this.ede.validate();
            Assert.fail((String)(this.ede.getValues() + " is not a valid " + this.ede.getType()));
        }
        catch (ValidationException validationException) {
            Util.assertExceptionId("IWAT0195E", validationException);
        }
    }

    public void testEquals() {
        ExtendedDataElement extendedDataElement = (ExtendedDataElement)Util.clone(this.ede);
        Assert.assertEquals((Object)this.ede, (Object)extendedDataElement);
        extendedDataElement.setType("difference");
        Assert.assertFalse((boolean)this.ede.equals(extendedDataElement));
    }

    public void testEquals1() {
        ExtendedDataElement extendedDataElement = (ExtendedDataElement)Util.clone(this.ede);
        Assert.assertEquals((Object)this.ede, (Object)extendedDataElement);
        this.ede.addChild("Megan");
        extendedDataElement.addChild("Alex");
        Assert.assertFalse((boolean)this.ede.equals(extendedDataElement));
    }

    public void testEquals2() {
        ExtendedDataElement extendedDataElement = (ExtendedDataElement)Util.clone(this.ede);
        ExtendedDataElement extendedDataElement2 = this.ede.addChild("Megan");
        ExtendedDataElement extendedDataElement3 = (ExtendedDataElement)Util.clone(extendedDataElement2);
        extendedDataElement2.addChild("Wendy");
        extendedDataElement3.addChild("Alex");
        Assert.assertFalse((boolean)this.ede.equals(extendedDataElement));
    }

    public void testValidationMissingAttributes() throws ValidationException {
        this.ede = EventFactory.eINSTANCE.createExtendedDataElement();
        this.ede.setName(Util.getPaddedString(64));
        this.ede.setType("noValue");
        this.ede.validate();
        this.ede = EventFactory.eINSTANCE.createExtendedDataElement();
        this.ede.setType("noValue");
        Util.assertMissingAttributes(this.ede, "name");
        this.ede = EventFactory.eINSTANCE.createExtendedDataElement();
        this.ede.setName(Util.getPaddedString(64));
        Util.assertMissingAttributes(this.ede, "type");
        this.ede = EventFactory.eINSTANCE.createExtendedDataElement();
        this.ede.setName(Util.getPaddedString(64));
        this.ede.setType("string");
        Util.assertMissingAttributes(this.ede, "value");
        this.ede = EventFactory.eINSTANCE.createExtendedDataElement();
        this.ede.setName(Util.getPaddedString(64));
        this.ede.setType("hexBinary");
        Util.assertMissingAttributes(this.ede, "hexValue");
        this.ede = EventFactory.eINSTANCE.createExtendedDataElement();
        this.ede.setName(Util.getPaddedString(64));
        boolean bl = false;
        this.ede.setValuesAsBoolean(bl);
        this.ede.setType("hexBinary");
        Util.assertMissingAttributes(this.ede, "hexValue");
        this.ede = EventFactory.eINSTANCE.createExtendedDataElement();
        this.ede.setName(Util.getPaddedString(64));
        byte[] byArray = new byte[]{35, 84, 120};
        this.ede.setHexValueAsByteArray(byArray);
        this.ede.setType("int");
        Util.assertMissingAttributes(this.ede, "value");
        this.ede = EventFactory.eINSTANCE.createExtendedDataElement();
        this.ede.setName(Util.getPaddedString(64));
        byte[] byArray2 = new byte[]{35, 84, 120};
        this.ede.setHexValueAsByteArray(byArray2);
        this.ede.validate();
        this.ede = EventFactory.eINSTANCE.createExtendedDataElement();
        this.ede.setName(Util.getPaddedString(64));
        boolean bl2 = false;
        this.ede.setValuesAsBoolean(bl2);
        this.ede.validate();
    }

    public void testValidationInvalidLengths() throws ValidationException {
        this.ede.setName(Util.getPaddedString(64));
        this.ede.setType("noValue");
        this.ede.validate();
        this.ede.setName(Util.getPaddedString(65));
        Util.assertInvalidBoundaries(this.ede, "name");
        this.ede.setName(Util.getPaddedString(64));
        Util.assertValidBoundaries(this.ede);
        this.ede.setType("string");
        String string = Util.getPaddedString(1024);
        String string2 = Util.getPaddedString(1024);
        String string3 = Util.getPaddedString(1024);
        String[] stringArray = new String[]{string, string2, string3};
        this.ede.setValuesAsStringArray(stringArray);
        Util.assertValidBoundaries(this.ede);
        String string4 = Util.getPaddedString(1025);
        String[] stringArray2 = new String[]{string, string4, string3};
        this.ede.setValuesAsStringArray(stringArray2);
        try {
            this.ede.validate();
            Assert.fail((String)"fourth value too long");
        }
        catch (ValidationException validationException) {
            Util.assertExceptionId("IWAT0201E", validationException);
        }
    }

    public void testValidationTypeAndValues() throws ValidationException {
        this.ede.setName(Util.getPaddedString(64));
        this.ede.setType("noValue");
        this.ede.validate();
        this.ede.setTypeAsInt(123);
        this.ede.validate();
        Assert.assertEquals((String)this.ede.getType(), (String)"noValue");
        this.ede.setType("My Type");
        try {
            this.ede.validate();
            Assert.fail((String)"invalid type");
        }
        catch (ValidationException validationException) {
            Util.assertExceptionId("IWAT0193E", validationException);
        }
        this.ede.setType("hexBinary");
        this.ede.setHexValue("1A234");
        try {
            this.ede.validate();
            Assert.fail((String)"invalid hexValue - odd number of characters");
        }
        catch (ValidationException validationException) {
            Util.assertExceptionId("IWAT0197E", validationException);
        }
        this.ede.setHexValue("ABCDEFGH");
        try {
            this.ede.validate();
            Assert.fail((String)"invalid hexValue - invalid hexadecimal character");
        }
        catch (ValidationException validationException) {
            Util.assertExceptionId("IWAT0198E", validationException);
        }
        this.ede.setType("boolean");
        try {
            this.ede.validate();
            Assert.fail((String)"missing value attribute for type boolean ");
        }
        catch (ValidationException validationException) {
            Util.assertExceptionId("IWAT0203E", validationException);
        }
        this.ede.eUnset((EStructuralFeature)EventPackage.eINSTANCE.getExtendedDataElement_HexValue());
        this.ede.setValuesAsStringArray(new String[]{"abc", "def"});
        this.ede.setType("string");
        try {
            this.ede.validate();
            Assert.fail((String)"value mismatch for type string");
        }
        catch (ValidationException validationException) {
            Util.assertExceptionId("IWAT0191E", validationException);
        }
    }

    public void testValidationMutuallyExclusive() throws ValidationException {
        this.ede = EventFactory.eINSTANCE.createExtendedDataElement();
        this.ede.setName(Util.getPaddedString(64));
        byte[] byArray = new byte[]{35, 84, 120};
        boolean bl = false;
        this.ede.setValuesAsBoolean(bl);
        this.ede.setHexValueAsByteArray(byArray);
        try {
            this.ede.validate();
            Assert.fail((String)"can't have both value and hexValue");
        }
        catch (ValidationException validationException) {
            Util.assertExceptionId("IWAT0204E", validationException);
        }
    }

    public void testValidateGoodDateTime() throws ValidationException {
        this.ede.setType("dateTime");
        this.ede.setName("name");
        this.ede.setValuesAsDateAsLong(System.currentTimeMillis());
        this.ede.validate();
    }

    public void testValidateGoodBoolean() throws ValidationException {
        this.ede.setType("boolean");
        this.ede.setName("name");
        this.ede.setValuesAsBoolean(false);
        this.ede.validate();
    }

    public void testValidationChildren() throws ValidationException {
        this.ede = EventFactory.eINSTANCE.createExtendedDataElement();
        this.ede.setName(Util.getPaddedString(64));
        this.ede.setType("noValue");
        this.ede.validate();
        ExtendedDataElement extendedDataElement = this.ede.addChild("Megan");
        extendedDataElement.setType("noValue");
        String[] stringArray = new String[]{"test1", "test2"};
        ExtendedDataElement extendedDataElement2 = this.ede.addChild("Alex", 16, stringArray);
        ExtendedDataElement extendedDataElement3 = this.ede.addChild("Wendy", 4, "123");
        this.ede.validate();
        extendedDataElement3.setValuesAsString("xyz");
        extendedDataElement3.setType("int");
        try {
            this.ede.validate();
            Assert.fail((String)"child 3 should be invalid");
        }
        catch (ValidationException validationException) {
            Util.assertExceptionId("IWAT0192E", validationException);
        }
        extendedDataElement3.setValuesAsInt(123);
        ExtendedDataElement extendedDataElement4 = extendedDataElement2.addChild("my first grandchild", 5, "123");
        ExtendedDataElement extendedDataElement5 = extendedDataElement2.addChild("my second grandchild", 9, "false");
        this.ede.validate();
        extendedDataElement5.setValuesAsString("xyz");
        extendedDataElement5.setType("float");
        try {
            this.ede.validate();
            Assert.fail((String)"grandchild should be invalid");
        }
        catch (ValidationException validationException) {
            Util.assertExceptionId("IWAT0192E", validationException);
        }
    }

    public void testAdapter() {
        Util.assertAdapterNotification(this.ede);
    }

    public void testUnsupportedFeature() {
        Util.assertUnsupportedFeature(this.ede);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.ede = EventFactory.eINSTANCE.createExtendedDataElement();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }
}

