/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.resources.database.internal.extensions;

import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.hyades.resources.database.internal.DBMap;
import org.eclipse.hyades.resources.database.internal.dbmodel.Table;
import org.eclipse.hyades.resources.database.internal.extensions.DBCommandFactory;
import org.eclipse.hyades.resources.database.internal.extensions.DatabaseType;
import org.eclipse.hyades.resources.database.internal.extensions.JDBCHelper;
import org.eclipse.hyades.resources.database.internal.impl.DBCommand;

public class DeleteResourceCommand
extends DBCommand {
    protected URI uri;
    protected List topLevel;
    protected DatabaseType type;

    public DeleteResourceCommand(JDBCHelper helper, DBMap map, DatabaseType type, URI uri) {
        super(helper, map);
        this.type = type;
        this.uri = uri;
    }

    public Object execute() throws Exception {
        try {
            DBCommand getTopLevelObjects = DBCommandFactory.INSTANCE.createGetTopLevelObjects(this.helper, this.dbMap, this.uri);
            this.topLevel = (List)getTopLevelObjects.execute();
            this.clearResourceTable();
            this.deleteObjects();
            this.helper.commitTransaction();
        }
        catch (Exception e) {
            this.helper.rollbackTransaction();
            throw e;
        }
        return null;
    }

    protected void clearResourceTable() throws Exception {
        String delete = this.createStatement();
        this.helper.executeUpdateStatement(delete);
    }

    protected String createStatement() {
        StringBuffer s = new StringBuffer();
        Table table = this.dbMap.getResourceTable();
        s.append("DELETE FROM ");
        s.append(this.addQuotes(table.getName()));
        s.append(" WHERE ");
        s.append(this.addQuotes("URI"));
        s.append(" = '");
        s.append(this.uri.toString());
        s.append("'");
        return s.toString();
    }

    protected void deleteObjects() throws Exception {
        DBCommand delete = DBCommandFactory.INSTANCE.createDeleteObjects(this.helper, this.dbMap, this.topLevel);
        delete.execute();
    }
}

