/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.resources.database.internal.impl;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.hyades.resources.database.internal.DBMap;
import org.eclipse.hyades.resources.database.internal.extensions.DatabaseType;
import org.eclipse.hyades.resources.database.internal.impl.QueryStatement;

public class AttributeQuery
extends QueryStatement {
    protected int[] ids;
    protected String id;
    protected String value;
    protected String order;

    public AttributeQuery(int[] ids, EAttribute attribute, DBMap map, DatabaseType dbType) {
        super(dbType, map, (EModelElement)attribute);
        this.ids = ids;
        DBMap.AttributeData data = (DBMap.AttributeData)this.dbMap.getDBRepresentation((EModelElement)attribute);
        this.id = data.getIdColumn().getName();
        this.value = data.getValueColumn().getName();
        this.order = data.getOrderColumn().getName();
    }

    protected void createSelectFrom() {
        this.statement.append("SELECT ");
        this.statement.append(this.addQuotes(this.id));
        this.statement.append(", ");
        this.statement.append(this.addQuotes(this.value));
        if (this.dbType.isOrderRequired()) {
            this.statement.append(", ");
            this.statement.append(this.addQuotes(this.order));
        }
        this.statement.append(" FROM ");
        this.statement.append(this.addQuotes(this.table.getName()));
    }

    protected void createWhereClause(int begin) {
        this.statement.append(" WHERE ");
        this.statement.append(this.addQuotes(this.id));
        this.statement.append(" IN (");
        boolean first = true;
        for (int i = begin; i < this.ids.length; ++i) {
            if (this.ids[i] == 0) continue;
            String id = "" + this.ids[i];
            if (this.statement.length() + id.length() > this.dbType.getMaximumSQLLength()) {
                this.initial = i;
                break;
            }
            if (first) {
                first = false;
            } else {
                this.statement.append(", ");
            }
            this.statement.append(this.ids[i]);
        }
        this.statement.append(")");
    }

    protected void createOrderClause() {
        this.statement.append(" ORDER BY ");
        this.statement.append(this.addQuotes(this.id));
        this.statement.append(", ");
        this.statement.append(this.addQuotes(this.order));
    }
}

