/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.statistical.ui;

import java.lang.reflect.Method;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Platform;
import org.eclipse.hyades.model.statistical.impl.StatisticalPackageImpl;
import org.eclipse.hyades.statistical.ui.Debugger;
import org.eclipse.hyades.statistical.ui.ImageManager;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;

public class EditorPlugin
extends AbstractUIPlugin {
    public static final String PACKAGE_DEBUGGER = "org.eclipse.hyades.statistical.ui";
    public static final String PACKAGE_STATCON_MODULE = "org.eclipse.hyades.statistical.ui.StatConModule";
    public static final String PACKAGE_STATCON_FILE = "org.eclipse.hyades.statistical.ui.StatConFile";
    private static EditorPlugin plugin;
    public static Debugger DBG;
    private ResourceBundle resourceBundle;
    public static ImageManager img;
    private String infopops_id = null;

    public static void disposeObject(Object o) throws Throwable {
        Throwable error = null;
        for (Class<?> c = o.getClass(); c != null; c = c.getSuperclass()) {
            try {
                Method o_dispose = c.getDeclaredMethod("dispose", new Class[0]);
                o_dispose.setAccessible(true);
                o_dispose.invoke(o, new Object[0]);
                error = null;
                break;
            }
            catch (Throwable e) {
                error = e;
                continue;
            }
        }
        if (error != null) {
            throw error;
        }
    }

    public EditorPlugin() {
        plugin = this;
        DBG.setPlugin(this);
        DBG.info("StatCon Plugin Constructor");
        DBG.info("calling StatisticalPackageImpl.init() to fix bugs");
        StatisticalPackageImpl.init();
        img.initialize("icons/full/", this, PACKAGE_DEBUGGER);
    }

    protected void initializeImageRegistry(ImageRegistry reg) {
    }

    public String getInfopopsId() {
        if (this.infopops_id == null) {
            try {
                this.infopops_id = this.getBundle().getSymbolicName();
                DBG.info("Infopops Plugin ID = " + this.infopops_id);
            }
            catch (Throwable t) {
                DBG.logVisibleError(t, EditorPlugin.getString("ERROR_NO_INFOPOPS_ID"), false);
                this.infopops_id = PACKAGE_DEBUGGER;
            }
        }
        return this.infopops_id;
    }

    public static EditorPlugin getDefault() {
        return plugin;
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public static String getString(String key) {
        try {
            if (EditorPlugin.getDefault().resourceBundle == null) {
                EditorPlugin.getDefault().resourceBundle = Platform.getResourceBundle((Bundle)EditorPlugin.getDefault().getBundle());
            }
            return EditorPlugin.getDefault().resourceBundle.getString(key);
        }
        catch (NullPointerException e) {
            return key;
        }
        catch (MissingResourceException e) {
            return key;
        }
    }

    public static Shell getActiveWorkbenchShell() {
        return EditorPlugin.getActiveWorkbenchWindow().getShell();
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        return EditorPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
    }

    static {
        DBG = new Debugger(PACKAGE_DEBUGGER);
        img = new ImageManager();
    }
}

