/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.launcher;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.core.TraceFileUI;
import org.eclipse.hyades.trace.ui.internal.core.TraceLocationUI;
import org.eclipse.hyades.trace.ui.internal.launcher.IProfileLaunchConfigurationConstants;
import org.eclipse.hyades.trace.ui.internal.launcher.ProfileTab;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class ProfileDestinationTab {
    private TraceLocationUI _destinationUI = new TraceLocationUI();
    private TraceFileUI _fileUI = new TraceFileUI();
    private ProfileTab parentTab;

    public ProfileDestinationTab(ProfileTab pt) {
        this.parentTab = pt;
    }

    public Composite createControl(Composite parent) {
        Composite content = new Composite(parent, 0);
        content.setLayout((Layout)new GridLayout());
        content.setLayoutData((Object)GridUtil.createFill());
        this._destinationUI.createControl(content);
        this._fileUI.createControl(content);
        if (!UIPlugin.getDefault().getPreferenceStore().getBoolean("prof_option")) {
            this._fileUI.setVisible(false);
        }
        return content;
    }

    public void addListener(Listener _listener) {
        this._destinationUI.addListener(_listener);
        this._fileUI.addListener(_listener);
    }

    public void activated(ILaunchConfigurationWorkingCopy conf) {
    }

    public void initializeFrom(ILaunchConfiguration conf) {
        try {
            IPreferenceStore store = UIPlugin.getDefault().getPreferenceStore();
            String location = conf.getAttribute(IProfileLaunchConfigurationConstants.ATTR_DESTINATION_PROJECT, "");
            String monitor = conf.getAttribute(IProfileLaunchConfigurationConstants.ATTR_DESTINATION_MONITOR, "");
            String file = conf.getAttribute(IProfileLaunchConfigurationConstants.ATTR_DESTINATION_FILE, "");
            boolean profileToFile = conf.getAttribute(IProfileLaunchConfigurationConstants.ATTR_PROFILE_TO_FILE, false);
            if (location.length() == 0) {
                location = store.getString("prj_name");
            }
            if (monitor.length() == 0) {
                monitor = store.getString("mon_name");
            }
            this._destinationUI.setLocation(location);
            this._destinationUI.setMonitor(monitor);
            this._fileUI.setFile(file);
            this._fileUI.setEnabled(profileToFile);
            this._fileUI.getExternalBox().setSelection(profileToFile);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy wc) {
        wc.setAttribute(IProfileLaunchConfigurationConstants.ATTR_DESTINATION_PROJECT, this._destinationUI.getLocation().getText().trim());
        wc.setAttribute(IProfileLaunchConfigurationConstants.ATTR_DESTINATION_MONITOR, this._destinationUI.getMonitor().getText().trim());
        wc.setAttribute(IProfileLaunchConfigurationConstants.ATTR_PROFILE_TO_FILE, this._fileUI.getExternalBox().getSelection());
        wc.setAttribute(IProfileLaunchConfigurationConstants.ATTR_DESTINATION_FILE, this._fileUI.getFile());
    }

    public boolean isValid(ILaunchConfiguration conf) {
        this.parentTab.setErrorMessage(null);
        this.parentTab.setMessage(null);
        if (this._destinationUI.getLocation().getText().trim().length() == 0) {
            this.parentTab.setErrorMessage(UIPlugin.getResourceString("TAB_ERROR_DESTINATION_PROJECT"));
            return false;
        }
        if (this._destinationUI.getMonitor().getText().trim().length() == 0) {
            this.parentTab.setErrorMessage(UIPlugin.getResourceString("TAB_ERROR_DESTINATION_MONITOR"));
            return false;
        }
        if (this._fileUI.getSelection() && this._fileUI.getFile().trim().length() == 0) {
            this.parentTab.setErrorMessage(UIPlugin.getResourceString("TAB_ERROR_DESTINATION_FILE"));
            return false;
        }
        return true;
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy wc) {
        IPreferenceStore store = UIPlugin.getDefault().getPreferenceStore();
        wc.setAttribute(IProfileLaunchConfigurationConstants.ATTR_DESTINATION_PROJECT, store.getString("prj_name"));
        wc.setAttribute(IProfileLaunchConfigurationConstants.ATTR_DESTINATION_MONITOR, store.getString("mon_name"));
        wc.setAttribute(IProfileLaunchConfigurationConstants.ATTR_DESTINATION_FILE, (String)null);
        wc.setAttribute(IProfileLaunchConfigurationConstants.ATTR_PROFILE_TO_FILE, false);
    }
}

