/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.collection.threadanalyzer.dumpparser;

import org.eclipse.hyades.collection.threadanalyzer.DumpData;
import org.eclipse.hyades.collection.threadanalyzer.Monitor;
import org.eclipse.hyades.collection.threadanalyzer.StkEntry;
import org.eclipse.hyades.collection.threadanalyzer.StkEntryNative;
import org.eclipse.hyades.collection.threadanalyzer.TAUtils;
import org.eclipse.hyades.collection.threadanalyzer.TaException;
import org.eclipse.hyades.collection.threadanalyzer.Thd;
import org.eclipse.hyades.collection.threadanalyzer.dumpparser.DumpParser;

public class DumpParser_ca1411_20031011
extends DumpParser {
    public DumpParser_ca1411_20031011() {
        this.newDump = true;
    }

    public void parse(DumpData d) throws Exception {
        DumpParser_ca1411_20031011.logDebug("parse thread dump compatible with ca1411_20031011");
        try {
            if (this._r.ready()) {
                if (!DumpParser_ca1411_20031011.getArg("dumpInType").equalsIgnoreCase("serverOut")) {
                    this._r.readLine();
                }
                this.getThreadData(d);
                this.resetFileReader();
                this.getMonitorPoolStats(d);
                this.getMonitors(d);
                this.getHeapLockWaiters(d);
                while (this.getLine(d) != null) {
                }
            }
        }
        catch (Exception e) {
            DumpParser_ca1411_20031011.logErr(TAUtils.getNLSValue("ta.errmsg.ExceptionWhileParsing", "exception while parsing line") + ": " + this._lineNo + " -- " + _dumpInName);
            throw new TaException("" + this._lineNo, e);
        }
    }

    private void getHeapLockWaiters(DumpData d) throws Exception {
        String line = this.getLine(d);
        if (line == null) {
            return;
        }
        while (line.indexOf("Heap lock") < 0) {
            line = this.getLine(d);
            DumpParser_ca1411_20031011.logInfo("examiningA: " + line);
            if (line != null) continue;
            return;
        }
        line = this.getLine(d);
        DumpParser_ca1411_20031011.logInfo("examiningB: " + line);
        if (line.indexOf("Waiting to be notified:") >= 0) {
            Monitor m = d.addMonitor("HEAP_LOCK", 1);
            line = this.getLine(d);
            DumpParser_ca1411_20031011.logDebug(TAUtils.getNLSValue("ta.msg.HeapLockWaiters", "Heap lock waiters") + ": ");
            while (line.charAt(0) == '\t') {
                DumpParser_ca1411_20031011.logDebug(" -- " + line);
                String thdId = null;
                int idx1 = line.indexOf(40);
                thdId = line.substring(idx1 + 1, line.indexOf(41));
                Thd t = d.getThd(thdId);
                m.addWaiter(t);
                DumpParser_ca1411_20031011.logDebug("  *" + thdId + "*");
                line = this.getLine(d);
            }
        }
    }

    private void getMonitorPoolStats(DumpData d) throws Exception {
        String line = null;
        line = this.getLine(d);
        while (line.indexOf("Monitor pool info:") == -1) {
            line = this.getLine(d);
        }
        while (line != null && line.indexOf("Monitor Pool Dump") == -1) {
            line = this.getLine(d);
        }
    }

    private void getMonitors(DumpData d) throws Exception {
        boolean done = false;
        String line = null;
        line = this.getLine(d);
        if (line == null) {
            return;
        }
        while (!done) {
            line = this.getLine(d);
            int idx1 = line.indexOf(58);
            String monitor = line.substring(0, idx1);
            monitor.trim();
            Monitor m = d.addMonitor(monitor, 1);
            if (m == null) {
                DumpParser_ca1411_20031011.logInfo("#1 monitor m is null !!! ");
            }
            DumpParser_ca1411_20031011.logDebug(" -" + TAUtils.getNLSValue("ta.string.monitor", "monitor") + " " + monitor);
            line = this.getLine(d);
            if (line.indexOf("Waiting to be notified") != -1 || line.indexOf("Waiting to enter:") != -1) {
                line = this.getLine(d);
            }
            while (line.trim().length() > 0 && line.trim().charAt(0) == '\"') {
                if (line.length() > 0 && line.charAt(0) == ' ') {
                    DumpParser_ca1411_20031011.logDebug(" -- " + TAUtils.getNLSValue("ta.string.waiter", "waiter") + " " + line);
                    String thdId = null;
                    idx1 = line.lastIndexOf(40);
                    thdId = line.substring(idx1 + 1, line.lastIndexOf(41));
                    DumpParser_ca1411_20031011.logDebug("\ttid=" + thdId);
                    Thd t = d.getThd(thdId);
                    if (t == null) {
                        DumpParser_ca1411_20031011.logInfo("Thd t is null !!! ");
                    }
                    m.addWaiter(t);
                    line = this.getLine(d);
                }
                if (line.trim().length() != 0) continue;
            }
            if (!line.trim().equals("")) continue;
            done = true;
        }
    }

    private void getThreadData(DumpData d) throws Exception {
        this.recordLineFlag = false;
        String line = null;
        boolean firstChar = false;
        line = this.getLine(d);
        Thd thd = null;
        while (line.indexOf("Full thread dump Classic VM") == -1) {
            line = this.getLine(d);
        }
        while (line.indexOf("\"") == -1) {
            line = this.getLine(d);
        }
        while (line != null && line.indexOf("CL subcomponent") == -1) {
            while (line != null && line.indexOf("\"") == -1 && line.indexOf("CL subcomponent") == -1) {
                line = this.getLine(d);
            }
            if (line != null && line.indexOf("CL subcomponent") != -1) break;
            while (line != null && line.length() > 0 && line.indexOf("Native Stack") == -1) {
                if (line.trim().length() > 0 && line.trim().charAt(0) == '\"') {
                    int idx1 = line.indexOf(34);
                    int idx2 = line.indexOf(34, idx1 + 1);
                    String thdNm = line.substring(idx1 + 1, idx2);
                    idx1 = line.indexOf("sys_thread_t:");
                    String line2 = line.substring(idx1);
                    idx2 = line2.indexOf(44);
                    String threadId = line2.substring(13, idx2);
                    idx1 = line.indexOf("state:") + 6;
                    idx2 = line.indexOf(44, idx1);
                    String state = line.substring(idx1, idx2);
                    idx1 = line.indexOf("prio=");
                    String priority = line.substring(idx1 + 5);
                    DumpParser_ca1411_20031011.logDebug(thdNm + " - " + threadId + " - " + state + " - " + priority);
                    thd = d.addThd(thdNm, threadId, state, priority);
                } else if (line.trim().length() > 3 && line.trim().substring(0, 3).equals("at ")) {
                    DumpParser_ca1411_20031011.logDebug("Operating on: " + line);
                    String line2 = line.trim().substring(3);
                    boolean isNative = false;
                    String moduleName = null;
                    String lineno = null;
                    int idx1 = line2.indexOf("(Native Method)");
                    if (idx1 > 0) {
                        isNative = true;
                        line2 = line2.substring(0, idx1);
                    } else {
                        idx1 = line2.indexOf("(");
                        String moduleInfo = line2.substring(++idx1);
                        line2 = line2.substring(0, idx1 - 1);
                        int idx2 = moduleInfo.indexOf(58);
                        if (idx2 > 0) {
                            lineno = moduleInfo.substring(idx2 + 1, moduleInfo.indexOf(41, idx2) - 1);
                            moduleName = moduleInfo.substring(0, idx2);
                        } else {
                            idx2 = moduleInfo.indexOf(40);
                            if (idx2 == -1) {
                                idx2 = moduleInfo.indexOf(41);
                            }
                            moduleName = moduleInfo.substring(0, idx2);
                        }
                    }
                    String method = line2.substring(line2.lastIndexOf(46) + 1);
                    String pkg = line2.substring(0, line2.lastIndexOf(46));
                    int iLineNo = -1;
                    if (lineno != null) {
                        iLineNo = Integer.parseInt(lineno);
                    }
                    StkEntry se = new StkEntry(method, pkg, moduleName, iLineNo, isNative);
                    DumpParser_ca1411_20031011.logDebug("  -- " + pkg + " . " + method + " - " + " - " + moduleName + " - " + lineno + " - " + isNative);
                    thd.addStackEntry(se);
                }
                line = this.getLine(d);
            }
            line = this.getLine(d);
            line = this.getLine(d);
            while (line.trim().length() > 0) {
                StkEntryNative sen = new StkEntryNative(null, line.trim());
                DumpParser_ca1411_20031011.logDebug("  -- " + line);
                thd.addStackEntryNative(sen);
                line = this.getLine(d);
            }
        }
        this.recordLineFlag = true;
    }
}

