/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.adapter.ui.internal.presentation;

import java.io.File;
import java.math.BigInteger;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.StringTokenizer;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.ExtendedMetaData;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.hyades.logging.adapter.model.internal.adapter.AdapterFactory;
import org.eclipse.hyades.logging.adapter.model.internal.adapter.AdapterPackage;
import org.eclipse.hyades.logging.adapter.model.internal.adapter.AdapterType;
import org.eclipse.hyades.logging.adapter.model.internal.configuration.ConfigurationFactory;
import org.eclipse.hyades.logging.adapter.model.internal.configuration.ConfigurationType;
import org.eclipse.hyades.logging.adapter.model.internal.configuration.ContextInstanceType;
import org.eclipse.hyades.logging.adapter.model.internal.context.Component;
import org.eclipse.hyades.logging.adapter.model.internal.context.ContextFactory;
import org.eclipse.hyades.logging.adapter.model.internal.context.ContextRoleNames;
import org.eclipse.hyades.logging.adapter.model.internal.context.ContextType;
import org.eclipse.hyades.logging.adapter.model.internal.context.ContextsType;
import org.eclipse.hyades.logging.adapter.model.internal.context.RoleNames;
import org.eclipse.hyades.logging.adapter.model.internal.extractor.ExtractorFactory;
import org.eclipse.hyades.logging.adapter.model.internal.extractor.ExtractorType;
import org.eclipse.hyades.logging.adapter.model.internal.formatter.FormatterFactory;
import org.eclipse.hyades.logging.adapter.model.internal.formatter.FormatterType;
import org.eclipse.hyades.logging.adapter.model.internal.outputter.OutputterConfigType;
import org.eclipse.hyades.logging.adapter.model.internal.outputter.OutputterFactory;
import org.eclipse.hyades.logging.adapter.model.internal.outputter.OutputterType;
import org.eclipse.hyades.logging.adapter.model.internal.parser.ParserConfigType;
import org.eclipse.hyades.logging.adapter.model.internal.parser.ParserFactory;
import org.eclipse.hyades.logging.adapter.model.internal.parser.RuleAttributeType;
import org.eclipse.hyades.logging.adapter.model.internal.parser.RuleElementType;
import org.eclipse.hyades.logging.adapter.model.internal.parser.SubstitutionRuleType;
import org.eclipse.hyades.logging.adapter.model.internal.sensor.SensorConfigType;
import org.eclipse.hyades.logging.adapter.model.internal.sensor.SensorFactory;
import org.eclipse.hyades.logging.adapter.model.internal.sensor.SensorType;
import org.eclipse.hyades.logging.adapter.model.internal.unit.PropertyType;
import org.eclipse.hyades.logging.adapter.model.internal.unit.UnitFactory;
import org.eclipse.hyades.logging.adapter.ui.AcadEditorPlugin;
import org.eclipse.hyades.logging.adapter.ui.ContextIds;
import org.eclipse.hyades.logging.adapter.ui.internal.presentation.MigrationUtil;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.ISetSelectionTarget;
import org.eclipse.xsd.XSDAttributeUse;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDTypeDefinition;

public class AdaptorModelWizard
extends Wizard
implements INewWizard {
    private ConfigLogTemplatePage logPage;
    private final String FILE_EXTENSTION = "adapter";
    protected AdapterPackage adaptorPackage = AdapterPackage.eINSTANCE;
    protected AdapterFactory adaptorFactory = this.adaptorPackage.getAdapterFactory();
    protected AdaptorModelWizardNewFileCreationPage newFileCreationPage;
    protected IStructuredSelection selection;
    protected IWorkbench workbench;
    static /* synthetic */ Class class$org$eclipse$hyades$logging$adapter$impl$BasicContext;
    static /* synthetic */ Class class$org$eclipse$hyades$logging$adapter$formatters$CBEFormatter;
    static /* synthetic */ Class class$org$eclipse$hyades$logging$adapter$sensors$SingleOSFileSensor;
    static /* synthetic */ Class class$org$eclipse$hyades$logging$adapter$extractors$RegularExpressionExtractor;
    static /* synthetic */ Class class$org$eclipse$hyades$logging$adapter$outputters$CBELogOutputter;
    static /* synthetic */ Class class$org$eclipse$hyades$logging$adapter$parsers$Parser;

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.workbench = workbench;
        this.selection = selection;
        this.setWindowTitle(AcadEditorPlugin.INSTANCE.getString("_UI_Wizard_label"));
        this.setDefaultPageImageDescriptor(ExtendedImageRegistry.INSTANCE.getImageDescriptor(AcadEditorPlugin.INSTANCE.getImage("full/wizban/NewAdaptor")));
    }

    EObject createInitialModel(String templateFile) {
        XSDElementDeclaration elem;
        XSDTypeDefinition type;
        EClass eClass = ExtendedMetaData.INSTANCE.getDocumentRoot((EPackage)this.adaptorPackage);
        EStructuralFeature eStructuralFeature = eClass.getEStructuralFeature("adapter");
        EObject rootObject = this.adaptorFactory.create(eClass);
        AdapterType adaptor = (AdapterType)this.adaptorFactory.create((EClass)eStructuralFeature.getEType());
        rootObject.eSet(eStructuralFeature, (Object)adaptor);
        ContextsType ctype = ContextFactory.eINSTANCE.createContextsType();
        adaptor.setContexts(ctype);
        ConfigurationType config = ConfigurationFactory.eINSTANCE.createConfigurationType();
        config.setDescription("The component level configurations for this Adaptor");
        adaptor.setConfiguration(config);
        ContextInstanceType context = ConfigurationFactory.eINSTANCE.createContextInstanceType();
        context.setContinuousOperation(true);
        context.setMaximumIdleTime("20000");
        context.setPauseInterval("10");
        context.setDescription("Context Instance for the current component");
        context.setIsoCountryCode("US");
        context.setIsoLanguageCode("en");
        context.setCharset("UTF-8");
        config.getContextInstance().add((Object)context);
        ContextType mcontext = this.createContext(context);
        ctype.getContext().add((Object)mcontext);
        Path path = new Path(templateFile);
        SensorConfigType sensor = SensorFactory.eINSTANCE.createSensorConfigType();
        PropertyType property = UnitFactory.eINSTANCE.createPropertyType();
        property.setPropertyName("directory");
        property.setPropertyValue(path.removeLastSegments(1).toOSString());
        sensor.getProperty().add((Object)property);
        property = UnitFactory.eINSTANCE.createPropertyType();
        property.setPropertyName("fileName");
        property.setPropertyValue(path.lastSegment());
        sensor.getProperty().add((Object)property);
        sensor.setDescription("A single file sensor");
        sensor.setMaximumBlocking("5");
        sensor.setConfidenceBufferSize(new BigInteger("1024"));
        sensor.setFileFooterSize(new BigInteger("90"));
        context.setSensor(sensor);
        sensor.setType(SensorType.SINGLE_FILE_SENSOR_LITERAL);
        mcontext.getComponent().add((Object)this.createComponentFileSensor(sensor));
        ExtractorType extractor = ExtractorFactory.eINSTANCE.createExtractorType();
        extractor.setDescription("This extractor uses regular expression  patterns to identify record delimiters");
        extractor.setContainsLineBreaks(true);
        extractor.setIncludeEndPattern(true);
        extractor.setIncludeStartPattern(true);
        extractor.setReplaceLineBreaks(true);
        extractor.setReplaceLineBreaks(false);
        extractor.setStartPattern("^");
        extractor.setEndPattern("$");
        context.setExtractor(extractor);
        mcontext.getComponent().add((Object)this.createComponentExtractor(extractor));
        ParserConfigType parser = ParserFactory.eINSTANCE.createParserConfigType();
        RuleElementType element = ParserFactory.eINSTANCE.createRuleElementType();
        element.setName("CommonBaseEvent");
        element.setIsRequiredByParent(false);
        element.setIsChildChoice(false);
        parser.getRuleElement().add((Object)element);
        context.setParser(parser);
        Object cbeObject = AcadEditorPlugin.INSTANCE.getElementDefinitionForType(element);
        if (cbeObject != null && cbeObject instanceof XSDElementDeclaration && (type = (elem = (XSDElementDeclaration)cbeObject).getTypeDefinition()) instanceof XSDComplexTypeDefinition) {
            XSDComplexTypeDefinition complexType = (XSDComplexTypeDefinition)type;
            EList attrs = complexType.getAttributeUses();
            int idx = 0;
            while (idx < attrs.size()) {
                XSDAttributeUse attr = (XSDAttributeUse)attrs.get(idx);
                if (attr.isRequired()) {
                    RuleAttributeType ruleAtribute = ParserFactory.eINSTANCE.createRuleAttributeType();
                    ruleAtribute.setUsePreviousMatchSubstitutionAsDefault(true);
                    ruleAtribute.setUsePreviousMatchSubstitutionAsDefault(false);
                    ruleAtribute.setName(attr.getAttributeDeclaration().getName());
                    ruleAtribute.setIsRequiredByParent(false);
                    element.getRuleAttribute().add((Object)ruleAtribute);
                    SubstitutionRuleType subs = ParserFactory.eINSTANCE.createSubstitutionRuleType();
                    subs.setMatch("^(.*)");
                    subs.setSubstitute("replace with our message text");
                    subs.setUseBuiltInFunction(true);
                    subs.setUseBuiltInFunction(false);
                    ruleAtribute.getSubstitutionRule().add((Object)subs);
                }
                ++idx;
            }
        }
        mcontext.getComponent().add((Object)this.createComponentParser(parser));
        FormatterType formatter = FormatterFactory.eINSTANCE.createFormatterType();
        formatter.setDescription("CBE Formatter");
        context.getFormatter().add((Object)formatter);
        mcontext.getComponent().add((Object)this.createComponentFormatter(formatter));
        OutputterConfigType outputter = OutputterFactory.eINSTANCE.createOutputterConfigType();
        property = UnitFactory.eINSTANCE.createPropertyType();
        property.setPropertyName("agentName");
        property.setPropertyValue("Default Logging Agent");
        outputter.getProperty().add((Object)property);
        outputter.setDescription("Logging Agent Outputter");
        outputter.setType(OutputterType.LOGGING_AGENT_OUTPUTTER_LITERAL);
        context.getOutputter().add((Object)outputter);
        mcontext.getComponent().add((Object)this.createComponentOutputter(outputter));
        return rootObject;
    }

    protected ContextType createContext(ContextInstanceType context) {
        String date = this.createDateTime();
        ContextType mcontext = ContextFactory.eINSTANCE.createContextType();
        mcontext.setDescription(context.getDescription());
        mcontext.setUniqueID(context.getUniqueID());
        mcontext.setExecutableClass((class$org$eclipse$hyades$logging$adapter$impl$BasicContext == null ? (class$org$eclipse$hyades$logging$adapter$impl$BasicContext = AdaptorModelWizard.class$("org.eclipse.hyades.logging.adapter.impl.BasicContext")) : class$org$eclipse$hyades$logging$adapter$impl$BasicContext).getName());
        mcontext.setImplementationCreationDate((Object)date);
        mcontext.setLoggingLevel("30");
        mcontext.setRole(ContextRoleNames.CONTEXT_LITERAL);
        mcontext.setRoleCreationDate((Object)date);
        mcontext.setName("Basic Context Implementation");
        return mcontext;
    }

    protected Component createComponentFormatter(FormatterType formatter) {
        String date = this.createDateTime();
        Component mcontext = ContextFactory.eINSTANCE.createComponent();
        mcontext.setDescription(formatter.getDescription());
        mcontext.setUniqueID(formatter.getUniqueID());
        mcontext.setExecutableClass((class$org$eclipse$hyades$logging$adapter$formatters$CBEFormatter == null ? (class$org$eclipse$hyades$logging$adapter$formatters$CBEFormatter = AdaptorModelWizard.class$("org.eclipse.hyades.logging.adapter.formatters.CBEFormatter")) : class$org$eclipse$hyades$logging$adapter$formatters$CBEFormatter).getName());
        mcontext.setImplementationCreationDate((Object)date);
        mcontext.setLoggingLevel("30");
        mcontext.setRole(RoleNames.FORMATTER_LITERAL);
        mcontext.setRoleCreationDate((Object)date);
        mcontext.setName(mcontext.getDescription());
        return mcontext;
    }

    protected Component createComponentFileSensor(SensorConfigType sensor) {
        String date = this.createDateTime();
        Component mcontext = ContextFactory.eINSTANCE.createComponent();
        mcontext.setUniqueID(sensor.getUniqueID());
        mcontext.setExecutableClass((class$org$eclipse$hyades$logging$adapter$sensors$SingleOSFileSensor == null ? (class$org$eclipse$hyades$logging$adapter$sensors$SingleOSFileSensor = AdaptorModelWizard.class$("org.eclipse.hyades.logging.adapter.sensors.SingleOSFileSensor")) : class$org$eclipse$hyades$logging$adapter$sensors$SingleOSFileSensor).getName());
        mcontext.setImplementationCreationDate((Object)date);
        mcontext.setLoggingLevel("30");
        mcontext.setRole(RoleNames.CONTEXT_LITERAL);
        mcontext.setRole(RoleNames.SENSOR_LITERAL);
        mcontext.setRoleCreationDate((Object)date);
        mcontext.setName("OS File Sensor");
        mcontext.setDescription("Operating System file sensor");
        return mcontext;
    }

    private String createDateTime() {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        Date today = new Date();
        String result = formatter.format(today);
        return result;
    }

    protected Component createComponentExtractor(ExtractorType extractor) {
        String date = this.createDateTime();
        Component mcontext = ContextFactory.eINSTANCE.createComponent();
        mcontext.setDescription(extractor.getDescription());
        mcontext.setUniqueID(extractor.getUniqueID());
        mcontext.setExecutableClass((class$org$eclipse$hyades$logging$adapter$extractors$RegularExpressionExtractor == null ? (class$org$eclipse$hyades$logging$adapter$extractors$RegularExpressionExtractor = AdaptorModelWizard.class$("org.eclipse.hyades.logging.adapter.extractors.RegularExpressionExtractor")) : class$org$eclipse$hyades$logging$adapter$extractors$RegularExpressionExtractor).getName());
        mcontext.setImplementationCreationDate((Object)date);
        mcontext.setLoggingLevel("30");
        mcontext.setRole(RoleNames.MESSAGE_EXTRACTOR_LITERAL);
        mcontext.setRoleCreationDate((Object)date);
        mcontext.setName("Regular Expression Extractor");
        return mcontext;
    }

    protected Component createComponentOutputter(OutputterConfigType outputter) {
        String date = this.createDateTime();
        Component mcontext = ContextFactory.eINSTANCE.createComponent();
        mcontext.setDescription(outputter.getDescription());
        mcontext.setUniqueID(outputter.getUniqueID());
        mcontext.setExecutableClass((class$org$eclipse$hyades$logging$adapter$outputters$CBELogOutputter == null ? (class$org$eclipse$hyades$logging$adapter$outputters$CBELogOutputter = AdaptorModelWizard.class$("org.eclipse.hyades.logging.adapter.outputters.CBELogOutputter")) : class$org$eclipse$hyades$logging$adapter$outputters$CBELogOutputter).getName());
        mcontext.setImplementationCreationDate((Object)date);
        mcontext.setLoggingLevel("30");
        mcontext.setRole(RoleNames.OUTPUTTER_LITERAL);
        mcontext.setRoleCreationDate((Object)date);
        mcontext.setName("Hyades Logging Agent Outputter");
        return mcontext;
    }

    protected Component createComponentParser(ParserConfigType parser) {
        String date = this.createDateTime();
        Component mcontext = ContextFactory.eINSTANCE.createComponent();
        mcontext.setDescription("Regular expression parser");
        mcontext.setUniqueID(parser.getUniqueID());
        mcontext.setExecutableClass((class$org$eclipse$hyades$logging$adapter$parsers$Parser == null ? (class$org$eclipse$hyades$logging$adapter$parsers$Parser = AdaptorModelWizard.class$("org.eclipse.hyades.logging.adapter.parsers.Parser")) : class$org$eclipse$hyades$logging$adapter$parsers$Parser).getName());
        mcontext.setImplementationCreationDate((Object)date);
        mcontext.setLoggingLevel("30");
        mcontext.setRole(RoleNames.PARSER_LITERAL);
        mcontext.setRoleCreationDate((Object)date);
        mcontext.setName("Generic Parser");
        return mcontext;
    }

    public boolean performFinish() {
        try {
            final IFile modelFile = this.getModelFile();
            this.logPage.performFinish();
            final String templateFile = this.logPage.getTemplateLogName();
            WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                protected void execute(IProgressMonitor progressMonitor) {
                    try {
                        try {
                            ResourceSetImpl resourceSet = new ResourceSetImpl();
                            URI fileURI = URI.createPlatformResourceURI((String)modelFile.getFullPath().toString());
                            Resource resource = resourceSet.createResource(fileURI);
                            EObject rootObject = AdaptorModelWizard.this.createInitialModel(templateFile);
                            if (rootObject != null) {
                                resource.getContents().add((Object)rootObject);
                            }
                            HashMap<String, String> options = new HashMap<String, String>();
                            options.put("ENCODING", AdaptorModelWizard.this.newFileCreationPage.getEncoding());
                            try {
                                EClass eClass = ExtendedMetaData.INSTANCE.getDocumentRoot((EPackage)AdapterPackage.eINSTANCE);
                                EStructuralFeature eStructuralFeature = eClass.getEStructuralFeature("adapter");
                                AdapterType adapter = (AdapterType)rootObject.eGet(eStructuralFeature);
                                MigrationUtil.migrateSave(adapter);
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                            resource.save(options);
                        }
                        catch (Exception exception) {
                            AcadEditorPlugin.INSTANCE.log(exception);
                            Object var11_13 = null;
                            progressMonitor.done();
                            return;
                        }
                        Object var11_12 = null;
                    }
                    catch (Throwable throwable) {
                        Object var11_14 = null;
                        progressMonitor.done();
                        throw throwable;
                    }
                    progressMonitor.done();
                }
            };
            this.getContainer().run(false, false, (IRunnableWithProgress)operation);
            IWorkbenchWindow workbenchWindow = this.workbench.getActiveWorkbenchWindow();
            IWorkbenchPage page = workbenchWindow.getActivePage();
            final IWorkbenchPart activePart = page.getActivePart();
            if (activePart instanceof ISetSelectionTarget) {
                StructuredSelection targetSelection = new StructuredSelection((Object)modelFile);
                this.getShell().getDisplay().asyncExec(new Runnable((ISelection)targetSelection){
                    private final /* synthetic */ ISelection val$targetSelection;
                    {
                        this.val$targetSelection = val$targetSelection;
                    }

                    public void run() {
                        ((ISetSelectionTarget)activePart).selectReveal(this.val$targetSelection);
                    }
                });
            }
            try {
                IDE.openEditor((IWorkbenchPage)page, (IFile)modelFile, (boolean)true);
            }
            catch (PartInitException exception) {
                MessageDialog.openError((Shell)workbenchWindow.getShell(), (String)AcadEditorPlugin.INSTANCE.getString("_UI_OpenEditorError_label"), (String)exception.getMessage());
                return false;
            }
            IProjectDescription desc = modelFile.getProject().getDescription();
            ICommand[] commands = desc.getBuildSpec();
            boolean found = false;
            int i = 0;
            while (i < commands.length) {
                if (commands[i].getBuilderName().equals("org.eclipse.hyades.logging.adapter.ui.glaBuilder")) {
                    found = true;
                    break;
                }
                ++i;
            }
            if (!found) {
                ICommand command = desc.newCommand();
                command.setBuilderName("org.eclipse.hyades.logging.adapter.ui.glaBuilder");
                ICommand[] newCommands = new ICommand[commands.length + 1];
                System.arraycopy(commands, 0, newCommands, 1, commands.length);
                newCommands[0] = command;
                desc.setBuildSpec(newCommands);
                modelFile.getProject().setDescription(desc, null);
            }
            return true;
        }
        catch (Exception exception) {
            AcadEditorPlugin.INSTANCE.log(exception);
            return false;
        }
    }

    public void addPages() {
        Object selectedElement;
        this.newFileCreationPage = new AdaptorModelWizardNewFileCreationPage("Whatever", this.selection);
        this.newFileCreationPage.setTitle(AcadEditorPlugin.INSTANCE.getString("_UI_AdaptorModelWizard_label"));
        this.newFileCreationPage.setDescription(AcadEditorPlugin.INSTANCE.getString("_UI_AdaptorModelWizard_description"));
        this.newFileCreationPage.setFileName(AcadEditorPlugin.INSTANCE.getString("_UI_AdaptorEditorFilenameDefaultBase") + "." + "adapter");
        this.addPage((IWizardPage)this.newFileCreationPage);
        this.logPage = new ConfigLogTemplatePage("logPage");
        this.logPage.setDescription(AcadEditorPlugin.INSTANCE.getString("TEMPLATE_LOG_FILE_PAGE_DESC"));
        this.logPage.setTitle(AcadEditorPlugin.INSTANCE.getString("TEMPLATE_LOG_FILE_PAGE_TITLE"));
        this.addPage((IWizardPage)this.logPage);
        if (this.selection != null && !this.selection.isEmpty() && (selectedElement = this.selection.iterator().next()) instanceof IResource) {
            IResource selectedResource = (IResource)selectedElement;
            if (selectedResource.getType() == 1) {
                selectedResource = selectedResource.getParent();
            }
            if (selectedResource instanceof IFolder || selectedResource instanceof IProject) {
                String currentDirectory = selectedResource.getLocation().toOSString();
                this.newFileCreationPage.setContainerFullPath(selectedResource.getFullPath());
                String defaultModelBaseFilename = AcadEditorPlugin.INSTANCE.getString("_UI_AdaptorEditorFilenameDefaultBase");
                String defaultModelFilenameExtension = "adapter";
                String modelFilename = defaultModelBaseFilename + "." + defaultModelFilenameExtension;
                int i = 1;
                while (((IContainer)selectedResource).findMember(modelFilename) != null) {
                    modelFilename = defaultModelBaseFilename + i + "." + defaultModelFilenameExtension;
                    ++i;
                }
                this.newFileCreationPage.setFileName(modelFilename);
            }
        }
    }

    public IFile getModelFile() {
        return this.newFileCreationPage.getModelFile();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public class ConfigLogTemplatePage
    extends WizardPage
    implements SelectionListener,
    ModifyListener {
        String templateLogName;
        Button browseBtn;
        protected Text templateLog;

        public ConfigLogTemplatePage(String pageId) {
            super(pageId);
        }

        public void createControl(Composite parent) {
            Composite composite = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.numColumns = 2;
            layout.verticalSpacing = 12;
            composite.setLayout((Layout)layout);
            GridData data = new GridData();
            data.verticalAlignment = 4;
            data.grabExcessVerticalSpace = true;
            data.horizontalAlignment = 4;
            composite.setLayoutData((Object)data);
            Label containerLabel = new Label(composite, 16384);
            containerLabel.setText(AcadEditorPlugin.getDefault().getString("LOG_NAME_LABEL"));
            data = new GridData();
            data.horizontalAlignment = 4;
            data.horizontalSpan = 2;
            containerLabel.setLayoutData((Object)data);
            this.templateLog = new Text(composite, 2048);
            data = new GridData();
            data.horizontalAlignment = 4;
            data.grabExcessHorizontalSpace = true;
            this.templateLog.setLayoutData((Object)data);
            this.browseBtn = new Button(composite, 8);
            this.browseBtn.setText(AcadEditorPlugin.getDefault().getString("BROWSE"));
            this.browseBtn.addSelectionListener((SelectionListener)this);
            this.templateLog.addModifyListener((ModifyListener)this);
            this.setControl((Control)composite);
            this.setPageComplete(this.isPageComplete());
            WorkbenchHelp.setHelp((Control)parent, (String)ContextIds.ACAD_EDITOR_WIZARDPAGE_LOG_FILE);
        }

        public boolean isPageComplete() {
            this.setErrorMessage(null);
            String name = this.getTemplateLogName();
            File templateFile = new File(name);
            if (name == null || name.length() == 0) {
                return false;
            }
            if (!templateFile.exists() || !templateFile.isFile()) {
                String message = AcadEditorPlugin.getDefault().getString("ERROR_TEMPLATE_LOG_FILE_NOT_EXISTS", new Object[]{name});
                this.setErrorMessage(message);
                return false;
            }
            return true;
        }

        public boolean performFinish() {
            this.templateLogName = this.getTemplateLogName();
            return true;
        }

        public void widgetSelected(SelectionEvent e) {
            IWorkspaceRoot input = ResourcesPlugin.getWorkspace().getRoot();
            FileDialog dialog = new FileDialog(Display.getCurrent().getActiveShell());
            dialog.setFileName(this.templateLog.getText().concat(File.separator).concat("*"));
            String selectedFile = dialog.open();
            if (selectedFile != null) {
                this.templateLog.setText(selectedFile);
                this.setPageComplete(this.isPageComplete());
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void modifyText(ModifyEvent e) {
            this.templateLogName = this.templateLog.getText();
            this.setPageComplete(this.isPageComplete());
        }

        public String getTemplateLogName() {
            return this.templateLogName == null ? this.templateLog.getText() : this.templateLogName;
        }

        public Text getTemplateLog() {
            return this.templateLog;
        }

        public void setTemplateLog(Text templateLog) {
            this.templateLog = templateLog;
        }
    }

    public class AdaptorModelWizardNewFileCreationPage
    extends WizardNewFileCreationPage {
        protected IFile modelFile;
        protected String encoding;
        protected CCombo encodingField;

        public AdaptorModelWizardNewFileCreationPage(String pageId, IStructuredSelection selection) {
            super(pageId, selection);
        }

        protected void createAdvancedControls(Composite parent) {
            super.createAdvancedControls(parent);
            Composite encoding = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.numColumns = 2;
            encoding.setLayout((Layout)layout);
            GridData gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.grabExcessHorizontalSpace = true;
            encoding.setLayoutData((Object)gd);
            Label encodingLabel = new Label(encoding, 16384);
            encodingLabel.setText(AcadEditorPlugin.INSTANCE.getString("_UI_XMLEncoding"));
            GridData data = new GridData();
            data.horizontalAlignment = 4;
            encodingLabel.setLayoutData((Object)data);
            this.encodingField = new CCombo(encoding, 2048);
            data = new GridData();
            data.horizontalAlignment = 4;
            data.grabExcessHorizontalSpace = true;
            this.encodingField.setLayoutData((Object)data);
            StringTokenizer stringTokenizer = new StringTokenizer(AcadEditorPlugin.INSTANCE.getString("_UI_XMLEncodingChoices"));
            while (stringTokenizer.hasMoreTokens()) {
                this.encodingField.add(stringTokenizer.nextToken());
            }
            if (this.encodingField.getItemCount() > 1) {
                this.encodingField.select(1);
            } else {
                this.encodingField.select(0);
            }
        }

        public String getEncoding() {
            return this.encoding == null ? this.encodingField.getText() : this.encoding;
        }

        protected boolean validatePage() {
            if (super.validatePage()) {
                String requiredExt = "adapter";
                String enteredExt = new Path(this.getFileName()).getFileExtension();
                if (enteredExt == null || !enteredExt.equals(requiredExt)) {
                    this.setErrorMessage(AcadEditorPlugin.INSTANCE.getString("_WARN_FilenameExtension", new Object[]{requiredExt}));
                    return false;
                }
                return true;
            }
            return false;
        }

        public boolean performFinish() {
            this.modelFile = this.getModelFile();
            this.encoding = this.getEncoding();
            return true;
        }

        public IFile getModelFile() {
            return this.modelFile == null ? ResourcesPlugin.getWorkspace().getRoot().getFile(this.getContainerFullPath().append(this.getFileName())) : this.modelFile;
        }
    }
}

