/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.adapter.ui.internal.views;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.hyades.logging.adapter.model.internal.sensor.SensorConfigType;
import org.eclipse.hyades.logging.adapter.ui.AcadEditorPlugin;
import org.eclipse.hyades.logging.adapter.ui.ContextIds;
import org.eclipse.hyades.logging.adapter.ui.internal.actions.ActionHandlerListener;
import org.eclipse.hyades.logging.adapter.ui.internal.views.AcadGuiModel;
import org.eclipse.hyades.logging.adapter.ui.internal.views.AcadGuiModelManager;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.part.ViewPart;

public class ResultView
extends ViewPart {
    private final String RESULT_TITLE = AcadEditorPlugin.getPlugin().getString("RESULT_VIEW");
    TextViewer resultViewer;

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        this.init(site);
        this.enableEditActions();
    }

    public void createPartControl(Composite parent) {
        this.resultViewer = new TextViewer(parent, 2882);
        this.resultViewer.setEditable(false);
        this.createActions();
        this.createMenu();
        this.createToolbar();
        this.createContextMenu();
        this.set_Title();
        WorkbenchHelp.setHelp((Control)parent, (String)ContextIds.ACAD_EDITOR_RESULT_VIEW);
    }

    public void setFocus() {
        if (this.resultViewer != null && this.resultViewer.getControl().isDisposed()) {
            this.resultViewer.getControl().setFocus();
        }
    }

    public void createActions() {
    }

    private ImageDescriptor getImageDescriptor(String relativePath) {
        String iconPath = "icons/full/elcl16/";
        try {
            URL installURL = AcadEditorPlugin.getPlugin().getBaseURL();
            URL url = new URL(installURL, iconPath + relativePath);
            return ImageDescriptor.createFromURL((URL)url);
        }
        catch (MalformedURLException e) {
            return ImageDescriptor.getMissingImageDescriptor();
        }
    }

    private void createMenu() {
        IMenuManager iMenuManager = this.getViewSite().getActionBars().getMenuManager();
    }

    private void createToolbar() {
        IToolBarManager iToolBarManager = this.getViewSite().getActionBars().getToolBarManager();
    }

    private void createContextMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                ResultView.this.fillContextMenu(mgr);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.resultViewer.getControl());
        this.resultViewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.resultViewer);
    }

    private void hookGlobalActions() {
        IActionBars iActionBars = this.getViewSite().getActionBars();
    }

    private void fillContextMenu(IMenuManager mgr) {
        mgr.add((IContributionItem)new GroupMarker("additions"));
    }

    private void updateActionEnablement() {
    }

    public void set_Title() {
        AcadGuiModel model = AcadGuiModelManager.getCurrentModel();
        StringBuffer title = new StringBuffer(this.RESULT_TITLE).append(" ");
        if (model != null) {
            long currentEvent = model.getCurrentCount();
            currentEvent = currentEvent >= 0L ? ++currentEvent : 0L;
            if (model.getContextInstance() == null || model.getContextInstance().eContainer() == null) {
                title.append(AcadEditorPlugin.getPlugin().getString("STR_NO_EXTRACTOR"));
            } else {
                SensorConfigType sensor = AcadGuiModelManager.getLogForConfiguration(model);
                if (sensor != null) {
                    title.append(" ").append(AcadEditorPlugin.getPlugin().getString("STR_RESULT_TITLE", new Object[]{String.valueOf(currentEvent)}));
                } else {
                    title.append(AcadEditorPlugin.getPlugin().getString("STR_NO_SENSOR"));
                }
            }
        }
        super.setTitle(title.toString());
    }

    public void dispose() {
        super.dispose();
    }

    public String getText() {
        return ((StyledText)this.resultViewer.getControl()).getText();
    }

    public static final ResultView getResultView(boolean show) {
        try {
            IWorkbenchPage page = AcadEditorPlugin.getDefault().getActivePage();
            if (page == null) {
                return null;
            }
            IViewPart view = page.findView("org.eclipse.hyades.logging.adapter.ui.views.resultview");
            if (view != null && view instanceof ResultView) {
                return (ResultView)view;
            }
            if (show && (view = page.showView("org.eclipse.hyades.logging.adapter.ui.views.resultview")) != null && view instanceof ResultView) {
                return (ResultView)view;
            }
        }
        catch (Exception exc) {
            return null;
        }
        return null;
    }

    public void reset() {
        this.setResult("");
    }

    public void setResult(String text) {
        if (this.resultViewer != null && text != null) {
            this.resultViewer.setDocument((IDocument)new Document(text));
        }
    }

    public void enableActions() {
    }

    protected void enableEditActions() {
        ActionHandlerListener.DEFAULT.connectPart((IWorkbenchPart)this);
    }
}

