/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.views.internal;

import org.eclipse.hyades.loaders.trace.IDelta;
import org.eclipse.hyades.models.trace.TRCClass;
import org.eclipse.hyades.models.trace.TRCMethod;
import org.eclipse.hyades.models.trace.TRCMethodInvocation;
import org.eclipse.hyades.models.trace.TRCObject;
import org.eclipse.hyades.models.trace.impl.TRCClassImpl;
import org.eclipse.hyades.models.trace.impl.TRCMethodImpl;
import org.eclipse.hyades.trace.ui.ITraceSelection;
import org.eclipse.hyades.trace.ui.TraceViewerPage;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.ViewSelectionChangedEvent;
import org.eclipse.hyades.trace.ui.internal.util.TString;
import org.eclipse.hyades.trace.views.adapter.internal.ClassStatisticPage;
import org.eclipse.hyades.trace.views.internal.StatisticView;
import org.eclipse.hyades.trace.views.internal.TracePluginImages;
import org.eclipse.hyades.trace.views.internal.TraceUIPlugin;
import org.eclipse.hyades.trace.views.util.internal.PerftraceUtil;
import org.eclipse.hyades.trace.views.util.internal.StatisticTableColumnInfo;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableTreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.TableTree;
import org.eclipse.swt.custom.TableTreeItem;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;

public class ClassStatistic
extends StatisticView {
    private final TRCClassImpl.TRCClassSnapshot cdelta1 = new TRCClassImpl.TRCClassSnapshot();
    private final TRCClassImpl.TRCClassSnapshot cdelta2 = new TRCClassImpl.TRCClassSnapshot();
    private final TRCMethodImpl.TRCMethodSnapshot mdelta1 = new TRCMethodImpl.TRCMethodSnapshot();
    private final TRCMethodImpl.TRCMethodSnapshot mdelta2 = new TRCMethodImpl.TRCMethodSnapshot();

    protected Composite createTable(Composite parent, int options) {
        return new TableTree(parent, options);
    }

    public ClassStatistic(Composite parent, TraceViewerPage page) {
        super(parent, page);
        this._viewerFilter = new ClassStatisticFilter();
    }

    public String getColumnsPreferencesKey() {
        return "Class60";
    }

    public String getDefaultColumnsTemplate() {
        String classColumn = TraceUIPlugin.getString("STR_ST_CLASS_NAME") + ":0:" + String.valueOf(7) + ":200," + TraceUIPlugin.getString("STR_ST_PACKAGE") + ":1:" + String.valueOf(1) + ":left:100," + TraceUIPlugin.getString("STR_ST_INSTANCES") + ":2:" + String.valueOf(17) + ":right:100," + TraceUIPlugin.getString("STR_ST_LIVE_INSTANCES") + ":3:" + String.valueOf(17) + ":right:100," + TraceUIPlugin.getString("STR_ST_COLLECTED") + ":4:" + String.valueOf(17) + ":right:100," + TraceUIPlugin.getString("STR_ST_SIZE") + ":5:" + String.valueOf(17) + ":right:100," + TraceUIPlugin.getString("STR_ST_LIVE_STORAGE") + ":6:" + String.valueOf(17) + ":right:100," + TraceUIPlugin.getString("STR_ST_CPU_TIME") + ":7:" + String.valueOf(16) + ":right:100," + TraceUIPlugin.getString("STR_ST_CPU_INHTIME") + ":8:" + String.valueOf(16) + ":right:100," + TraceUIPlugin.getString("STR_ST_STACK_TIME") + ":9:" + String.valueOf(16) + ":right:100," + TraceUIPlugin.getString("STR_ST_STACK_INHTIME") + ":10:" + String.valueOf(16) + ":right:100," + TraceUIPlugin.getString("STR_ST_CALLS") + ":11:" + String.valueOf(16) + ":right:50," + TraceUIPlugin.getString("STR_ST_INHCALLS") + ":12:" + String.valueOf(16) + ":right:100";
        return classColumn;
    }

    public Table getTable() {
        return ((TableTree)this.getTableViewer().getControl()).getTable();
    }

    protected TableTreeViewer getTableTreeViewer(TableTree table) {
        return new ClassTreeViewer(table);
    }

    protected void handleSelectionEvent() {
        ((ClassStatisticPage)this.getTraceViewerPage()).openSource().setEnabled(false);
        ITraceSelection model = UIPlugin.getDefault().getSelectionModel(this._page.getMOFObject());
        if (model.size() > 0) {
            ((ClassStatisticPage)this.getTraceViewerPage()).openSource().setEnabled(true);
            Object sel = model.getFirstElement();
            if (sel instanceof TRCObject) {
                sel = PerftraceUtil.getClass((TRCObject)sel);
            } else if (sel instanceof TRCClass) {
                this.select((TRCClass)sel);
            } else if (sel instanceof TRCMethod) {
                this.select((TRCMethod)sel);
            } else if (sel instanceof TRCMethodInvocation) {
                this.select(((TRCMethodInvocation)sel).getMethod());
            }
        }
    }

    public void menuAboutToShow(IMenuManager menu) {
        menu.add((IContributionItem)this.fSeparator);
        menu.add((IAction)this.getUpdateAction());
        menu.add((IContributionItem)this.fSeparator);
        menu.add((IAction)this.getChooseColumnsAction(this.getColumnDataList(), this.getColumnsPreferencesKey()));
    }

    private void select(TRCMethod obj) {
        TRCClass cls = obj.getDefiningClass();
        TableTree table = ((TableTreeViewer)this.getTableViewer()).getTableTree();
        TableTreeItem[] items = table.getItems();
        int idx = 0;
        while (idx < items.length) {
            TableTreeItem item = items[idx];
            if (item.getData() == cls) {
                ((ClassTreeViewer)this.getTableViewer()).expandItem(item);
                TableTreeItem[] childItems = item.getItems();
                int i = 0;
                while (i < childItems.length) {
                    TableTreeItem childItem = childItems[i];
                    if (obj == childItem.getData()) {
                        ((ClassTreeViewer)this.getTableViewer()).expandItem(item);
                        table.setSelection(new TableTreeItem[]{childItem});
                        return;
                    }
                    ++i;
                }
            }
            ++idx;
        }
        table.deselectAll();
    }

    private void select(TRCClass obj) {
        TableTree table = ((TableTreeViewer)this.getTableViewer()).getTableTree();
        TableTreeItem[] items = table.getItems();
        int idx = 0;
        while (idx < items.length) {
            Object data = items[idx].getData();
            if (data != null && data == obj) {
                table.setSelection(new TableTreeItem[]{items[idx]});
                return;
            }
            ++idx;
        }
        table.deselectAll();
    }

    public void updateButtons() {
        ((ClassStatisticPage)this.getTraceViewerPage()).openSource().setEnabled(this.canOpenSourceOnThisObject());
        ((ClassStatisticPage)this.getTraceViewerPage()).percentMode().setChecked(this.isShowPercent());
        ((ClassStatisticPage)this.getTraceViewerPage()).deltaColumns().setChecked(this.showingDeltaColumns());
    }

    private boolean canOpenSourceOnThisObject() {
        ITraceSelection model = UIPlugin.getDefault().getSelectionModel(this._page.getMOFObject());
        if (model.size() == 0 || model.getFirstElement() == null) {
            return false;
        }
        Object sel = model.getFirstElement();
        return sel instanceof TRCClass || sel instanceof TRCMethod;
    }

    protected void updateDetailsPane() {
        int selIndex = this.getTable().getSelectionIndex();
        if (selIndex < 0) {
            return;
        }
        TableItem item = this.getTable().getItem(selIndex);
        Object itemData = item.getData();
        if (itemData == null) {
            return;
        }
        if (itemData != null && itemData instanceof TableTreeItem) {
            Object object = ((TableTreeItem)itemData).getData();
        }
    }

    public void updateModelSelection() {
        ISelection selection = this.getTableViewer().getSelection();
        if (selection != null && !selection.isEmpty()) {
            Object sel = ((IStructuredSelection)selection).getFirstElement();
            this.notifyViewSelectionChanged(this, sel);
        }
    }

    public IContentProvider getContentProvider() {
        return new ClassStatisticContentProvider();
    }

    public LabelProvider getTableLabelProvider() {
        return new ClassStatisticLabelProvider(this);
    }

    protected StatisticView.StatisticSorter getViewerSorterInstance() {
        return new ClassStatisticSorter();
    }

    protected void showPercentUpdate() {
        if (this.isShowPercent()) {
            this._totalCalls = PerftraceUtil.getTotalCalls(this._page.getMOFObject());
            this._totalInst = PerftraceUtil.getTotalInstances(this._page.getMOFObject());
            this._activeInst = PerftraceUtil.getActiveInstances(this._page.getMOFObject());
            this._totalSize = PerftraceUtil.getTotalSize(this._page.getMOFObject());
            this._activeSize = PerftraceUtil.getActiveSize(this._page.getMOFObject());
            this._maxTime = PerftraceUtil.getMaximumTime(this._page.getMOFObject());
        }
    }

    public void handleViewSelectionChangedEvent(ViewSelectionChangedEvent event) {
        Object source = event.getSource();
        if (source != this) {
            this.handleSelectionEvent();
        }
    }

    public boolean isEmpty() {
        return PerftraceUtil.getAllClasses(this._page.getMOFObject()).length <= 0;
    }

    protected String getViewTypeStr() {
        return "viewoption.class";
    }

    class ClassTreeViewer
    extends TableTreeViewer {
        public ClassTreeViewer(Composite parent) {
            super(parent);
        }

        public ClassTreeViewer(TableTree table) {
            super(table);
        }

        public void expandItem(TableTreeItem item) {
            item.setExpanded(true);
            this.createChildren((Widget)item);
        }
    }

    public class ClassStatisticLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        protected StatisticView _viewer;

        public ClassStatisticLabelProvider(StatisticView viewer) {
            this._viewer = viewer;
        }

        public Image getColumnImage(Object obj, int col) {
            StatisticTableColumnInfo info = StatisticTableColumnInfo.getStatisticTableColumnInfo(this._viewer.getTable().getColumn(col));
            int pos = info.getColumnData().getInitalPos();
            if (info.isDeltaColumn()) {
                return null;
            }
            int state = 0;
            double d = 0.0;
            if (obj instanceof TRCClass) {
                TRCClass clas = (TRCClass)obj;
                if (((TRCClass)obj).computeDelta((IDelta)ClassStatistic.this.cdelta1, 14) < 0) {
                    if (col == 1) {
                        return TracePluginImages.getImage("newentry_obj.gif");
                    }
                    return null;
                }
                switch (pos) {
                    case 2: {
                        clas.computeDelta((IDelta)ClassStatistic.this.cdelta1, 14);
                        state = ClassStatistic.this.cdelta1.getTotalInstances();
                        break;
                    }
                    case 3: {
                        clas.computeDelta((IDelta)ClassStatistic.this.cdelta1, 14);
                        clas.computeDelta((IDelta)ClassStatistic.this.cdelta1, 16);
                        state = ClassStatistic.this.cdelta1.getTotalInstances() - ClassStatistic.this.cdelta1.getCollectedInstances();
                        break;
                    }
                    case 4: {
                        clas.computeDelta((IDelta)ClassStatistic.this.cdelta1, 16);
                        state = ClassStatistic.this.cdelta1.getCollectedInstances();
                        break;
                    }
                    case 5: {
                        clas.computeDelta((IDelta)ClassStatistic.this.cdelta1, 13);
                        state = ClassStatistic.this.cdelta1.getTotalSize();
                        break;
                    }
                    case 6: {
                        clas.computeDelta((IDelta)ClassStatistic.this.cdelta1, 13);
                        clas.computeDelta((IDelta)ClassStatistic.this.cdelta1, 15);
                        state = ClassStatistic.this.cdelta1.getTotalSize() - ClassStatistic.this.cdelta1.getCollectedSize();
                        break;
                    }
                    case 7: {
                        clas.computeDelta((IDelta)ClassStatistic.this.cdelta1, 7);
                        d = ClassStatistic.this.cdelta1.getBaseTime();
                        if (d < 0.0) {
                            state = -1;
                            break;
                        }
                        if (!(d > 0.0)) break;
                        state = 1;
                        break;
                    }
                    case 8: {
                        clas.computeDelta((IDelta)ClassStatistic.this.cdelta1, 11);
                        d = ClassStatistic.this.cdelta1.getInheritedBaseTime();
                        if (d < 0.0) {
                            state = -1;
                            break;
                        }
                        if (!(d > 0.0)) break;
                        state = 1;
                        break;
                    }
                    case 9: {
                        clas.computeDelta((IDelta)ClassStatistic.this.cdelta1, 8);
                        d = ClassStatistic.this.cdelta1.getCumulativeTime();
                        if (d < 0.0) {
                            state = -1;
                            break;
                        }
                        if (!(d > 0.0)) break;
                        state = 1;
                        break;
                    }
                    case 10: {
                        clas.computeDelta((IDelta)ClassStatistic.this.cdelta1, 12);
                        d = ClassStatistic.this.cdelta1.getInheritedCumulativeTime();
                        if (d < 0.0) {
                            state = -1;
                            break;
                        }
                        if (!(d > 0.0)) break;
                        state = 1;
                        break;
                    }
                    case 11: {
                        clas.computeDelta((IDelta)ClassStatistic.this.cdelta1, 9);
                        state = ClassStatistic.this.cdelta1.getCalls();
                        break;
                    }
                    case 12: {
                        clas.computeDelta((IDelta)ClassStatistic.this.cdelta1, 10);
                        state = ClassStatistic.this.cdelta1.getInheritedCalls();
                    }
                }
            } else {
                TRCMethod m = (TRCMethod)obj;
                if (m.computeDelta((IDelta)ClassStatistic.this.mdelta1, 6) < 0) {
                    if (col == 1) {
                        return TracePluginImages.getImage("newentry_obj.gif");
                    }
                    return null;
                }
                switch (pos) {
                    case 7: {
                        m.computeDelta((IDelta)ClassStatistic.this.mdelta1, 6);
                        d = ClassStatistic.this.mdelta1.getBaseTime();
                        if (d < 0.0) {
                            state = -1;
                            break;
                        }
                        if (!(d > 0.0)) break;
                        state = 1;
                        break;
                    }
                    case 9: {
                        m.computeDelta((IDelta)ClassStatistic.this.mdelta1, 7);
                        d = ClassStatistic.this.mdelta1.getCumulativeTime();
                        if (d < 0.0) {
                            state = -1;
                            break;
                        }
                        if (!(d > 0.0)) break;
                        state = 1;
                        break;
                    }
                    case 11: {
                        m.computeDelta((IDelta)ClassStatistic.this.mdelta1, 8);
                        state = ClassStatistic.this.mdelta1.getCalls();
                    }
                }
            }
            if (state < 0) {
                return TracePluginImages.getImage("decreasedvalue_obj.gif");
            }
            if (state > 0) {
                return TracePluginImages.getImage("increasedvalue_obj.gif");
            }
            return null;
        }

        public String getColumnText(Object obj, int col) {
            StatisticTableColumnInfo info = StatisticTableColumnInfo.getStatisticTableColumnInfo(this._viewer.getTable().getColumn(col));
            int pos = info.getColumnData().getInitalPos();
            if (obj instanceof TRCClass) {
                TRCClass clas = (TRCClass)obj;
                TRCClassImpl.TRCClassSnapshot cs = (TRCClassImpl.TRCClassSnapshot)clas.retrieveSnapshot();
                switch (pos) {
                    case 0: {
                        return ((TRCClass)obj).getName();
                    }
                    case 1: {
                        return PerftraceUtil.getPackageName(clas.getPackage(), ClassStatistic.this._page.getMOFObject()).toString();
                    }
                    case 2: {
                        if (!info.isDeltaColumn()) {
                            if (ClassStatistic.this.isShowPercent()) {
                                return PerftraceUtil.formatAsPercentage((double)cs.getTotalInstances() / (double)ClassStatistic.this._totalInst);
                            }
                            return String.valueOf(cs.getTotalInstances());
                        }
                        clas.computeDelta((IDelta)ClassStatistic.this.cdelta1, 14);
                        return String.valueOf(ClassStatistic.this.cdelta1.getTotalInstances());
                    }
                    case 3: {
                        if (!info.isDeltaColumn()) {
                            if (ClassStatistic.this.isShowPercent()) {
                                return TString.formatAsPercentage((double)((double)(cs.getTotalInstances() - cs.getCollectedInstances()) / (double)ClassStatistic.this._totalInst));
                            }
                            return String.valueOf(cs.getTotalInstances() - cs.getCollectedInstances());
                        }
                        clas.computeDelta((IDelta)ClassStatistic.this.cdelta1, 14);
                        clas.computeDelta((IDelta)ClassStatistic.this.cdelta1, 16);
                        return String.valueOf(ClassStatistic.this.cdelta1.getTotalInstances() - ClassStatistic.this.cdelta1.getCollectedInstances());
                    }
                    case 4: {
                        if (!info.isDeltaColumn()) {
                            if (ClassStatistic.this.isShowPercent()) {
                                int size = cs.getTotalInstances();
                                if (size == 0) {
                                    size = 1;
                                }
                                return TString.formatAsPercentage((double)((double)cs.getCollectedInstances() / (double)size));
                            }
                            return String.valueOf(cs.getCollectedInstances());
                        }
                        clas.computeDelta((IDelta)ClassStatistic.this.cdelta1, 16);
                        return String.valueOf(ClassStatistic.this.cdelta1.getCollectedInstances());
                    }
                    case 5: {
                        if (!info.isDeltaColumn()) {
                            if (ClassStatistic.this.isShowPercent()) {
                                return TString.formatAsPercentage((double)((double)cs.getTotalSize() / (double)ClassStatistic.this._totalSize));
                            }
                            return String.valueOf(cs.getTotalSize());
                        }
                        clas.computeDelta((IDelta)ClassStatistic.this.cdelta1, 13);
                        return String.valueOf(ClassStatistic.this.cdelta1.getTotalSize());
                    }
                    case 6: {
                        if (!info.isDeltaColumn()) {
                            long size = cs.getTotalSize() - cs.getCollectedSize();
                            if (ClassStatistic.this.isShowPercent()) {
                                return TString.formatAsPercentage((double)((double)size / (double)ClassStatistic.this._activeSize));
                            }
                            return String.valueOf(size);
                        }
                        clas.computeDelta((IDelta)ClassStatistic.this.cdelta1, 13);
                        clas.computeDelta((IDelta)ClassStatistic.this.cdelta1, 15);
                        return String.valueOf(ClassStatistic.this.cdelta1.getTotalSize() - ClassStatistic.this.cdelta1.getCollectedSize());
                    }
                    case 7: {
                        if (!info.isDeltaColumn()) {
                            if (ClassStatistic.this.isShowPercent()) {
                                return TString.formatAsPercentage((double)(cs.getBaseTime() / ClassStatistic.this._maxTime));
                            }
                            return TString.formatTimeValue((double)cs.getBaseTime());
                        }
                        clas.computeDelta((IDelta)ClassStatistic.this.cdelta1, 7);
                        return TString.formatTimeValue((double)ClassStatistic.this.cdelta1.getBaseTime());
                    }
                    case 8: {
                        if (!info.isDeltaColumn()) {
                            if (ClassStatistic.this.isShowPercent()) {
                                return TString.formatAsPercentage((double)(cs.getInheritedBaseTime() / ClassStatistic.this._maxTime));
                            }
                            return TString.formatTimeValue((double)cs.getInheritedBaseTime());
                        }
                        clas.computeDelta((IDelta)ClassStatistic.this.cdelta1, 11);
                        return TString.formatTimeValue((double)ClassStatistic.this.cdelta1.getInheritedBaseTime());
                    }
                    case 9: {
                        if (!info.isDeltaColumn()) {
                            if (ClassStatistic.this.isShowPercent()) {
                                return TString.formatAsPercentage((double)(cs.getCumulativeTime() / ClassStatistic.this._maxTime));
                            }
                            return TString.formatTimeValue((double)cs.getCumulativeTime());
                        }
                        clas.computeDelta((IDelta)ClassStatistic.this.cdelta1, 8);
                        return TString.formatTimeValue((double)ClassStatistic.this.cdelta1.getCumulativeTime());
                    }
                    case 10: {
                        if (!info.isDeltaColumn()) {
                            if (ClassStatistic.this.isShowPercent()) {
                                return TString.formatAsPercentage((double)(cs.getInheritedCumulativeTime() / ClassStatistic.this._maxTime));
                            }
                            return TString.formatTimeValue((double)cs.getInheritedCumulativeTime());
                        }
                        clas.computeDelta((IDelta)ClassStatistic.this.cdelta1, 12);
                        return TString.formatTimeValue((double)ClassStatistic.this.cdelta1.getInheritedCumulativeTime());
                    }
                    case 11: {
                        if (!info.isDeltaColumn()) {
                            if (ClassStatistic.this.isShowPercent()) {
                                return TString.formatAsPercentage((double)((double)cs.getCalls() / (double)ClassStatistic.this._totalCalls));
                            }
                            return String.valueOf(cs.getCalls());
                        }
                        clas.computeDelta((IDelta)ClassStatistic.this.cdelta1, 9);
                        return String.valueOf(ClassStatistic.this.cdelta1.getCalls());
                    }
                    case 12: {
                        if (!info.isDeltaColumn()) {
                            if (ClassStatistic.this.isShowPercent()) {
                                return TString.formatAsPercentage((double)((double)cs.getInheritedCalls() / (double)ClassStatistic.this._totalCalls));
                            }
                            return String.valueOf(cs.getInheritedCalls());
                        }
                        clas.computeDelta((IDelta)ClassStatistic.this.cdelta1, 10);
                        return String.valueOf(ClassStatistic.this.cdelta1.getInheritedCalls());
                    }
                }
            } else {
                TRCMethod m = (TRCMethod)obj;
                TRCMethodImpl.TRCMethodSnapshot ms = (TRCMethodImpl.TRCMethodSnapshot)m.retrieveSnapshot();
                switch (pos) {
                    case 0: {
                        StringBuffer buf = new StringBuffer();
                        return buf.append(m.getName()).append(m.getSignature()).toString();
                    }
                    case 7: {
                        if (!info.isDeltaColumn()) {
                            if (ClassStatistic.this.isShowPercent()) {
                                return TString.formatAsPercentage((double)(ms.getBaseTime() / ClassStatistic.this._maxTime));
                            }
                            return TString.formatTimeValue((double)ms.getBaseTime());
                        }
                        m.computeDelta((IDelta)ClassStatistic.this.mdelta1, 6);
                        return TString.formatTimeValue((double)ClassStatistic.this.mdelta1.getBaseTime());
                    }
                    case 9: {
                        if (!info.isDeltaColumn()) {
                            if (ClassStatistic.this.isShowPercent()) {
                                return TString.formatAsPercentage((double)(ms.getCumulativeTime() / ClassStatistic.this._maxTime));
                            }
                            return TString.formatTimeValue((double)ms.getCumulativeTime());
                        }
                        m.computeDelta((IDelta)ClassStatistic.this.mdelta1, 7);
                        return TString.formatTimeValue((double)ClassStatistic.this.mdelta1.getCumulativeTime());
                    }
                    case 11: {
                        if (!info.isDeltaColumn()) {
                            if (ClassStatistic.this.isShowPercent()) {
                                return TString.formatAsPercentage((double)((double)ms.getCalls() / (double)ClassStatistic.this._totalCalls));
                            }
                            return String.valueOf(ms.getCalls());
                        }
                        m.computeDelta((IDelta)ClassStatistic.this.mdelta1, 8);
                        return String.valueOf(ClassStatistic.this.mdelta1.getCalls());
                    }
                }
            }
            return "";
        }
    }

    public class ClassStatisticContentProvider
    implements ITreeContentProvider {
        public void dispose() {
        }

        public Object getParent(Object element) {
            if (element instanceof TRCMethod) {
                return ((TRCMethod)element).getDefiningClass();
            }
            return null;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            return PerftraceUtil.getAllClasses(ClassStatistic.this._page.getMOFObject());
        }

        public Object[] getChildren(Object element) {
            ClassStatistic.this.tmpList.clear();
            if (element instanceof TRCClass) {
                return ((TRCClass)element).getMethods().toArray();
            }
            return ClassStatistic.this.tmpList.toArray();
        }

        public boolean hasChildren(Object element) {
            if (element instanceof TRCClass) {
                return ((TRCClass)element).getMethods().size() > 0;
            }
            return false;
        }
    }

    public class ClassStatisticSorter
    extends StatisticView.StatisticSorter {
        public ClassStatisticSorter() {
            super(ClassStatistic.this);
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            double d = 0.0;
            if (e1 instanceof TRCClass) {
                TRCClass c1 = (TRCClass)e1;
                TRCClass c2 = (TRCClass)e2;
                TRCClassImpl.TRCClassSnapshot cs1 = (TRCClassImpl.TRCClassSnapshot)c1.retrieveSnapshot();
                TRCClassImpl.TRCClassSnapshot cs2 = (TRCClassImpl.TRCClassSnapshot)c2.retrieveSnapshot();
                switch (this._pos) {
                    case 0: {
                        return this._sortSequence * c1.getName().compareToIgnoreCase(c2.getName());
                    }
                    case 1: {
                        return this._sortSequence * c1.getPackage().getName().compareToIgnoreCase(c2.getPackage().getName());
                    }
                    case 2: {
                        if (!this._info.isDeltaColumn()) {
                            return this._sortSequence * (cs1.getTotalInstances() - cs2.getTotalInstances());
                        }
                        c1.computeDelta((IDelta)ClassStatistic.this.cdelta1, 14);
                        c2.computeDelta((IDelta)ClassStatistic.this.cdelta2, 14);
                        return this._sortSequence * (ClassStatistic.this.cdelta1.getTotalInstances() - ClassStatistic.this.cdelta2.getTotalInstances());
                    }
                    case 3: {
                        if (!this._info.isDeltaColumn()) {
                            return this._sortSequence * (cs1.getTotalInstances() - cs1.getCollectedInstances() - cs2.getTotalInstances() + cs2.getCollectedInstances());
                        }
                        c1.computeDelta((IDelta)ClassStatistic.this.cdelta1, 14);
                        c2.computeDelta((IDelta)ClassStatistic.this.cdelta2, 14);
                        c1.computeDelta((IDelta)ClassStatistic.this.cdelta1, 16);
                        c2.computeDelta((IDelta)ClassStatistic.this.cdelta2, 16);
                        return this._sortSequence * (ClassStatistic.this.cdelta1.getTotalInstances() - ClassStatistic.this.cdelta1.getCollectedInstances() - (ClassStatistic.this.cdelta2.getTotalInstances() - ClassStatistic.this.cdelta2.getCollectedInstances()));
                    }
                    case 4: {
                        if (!this._info.isDeltaColumn()) {
                            if (ClassStatistic.this.isShowPercent()) {
                                int inst = cs1.getTotalInstances();
                                if (inst == 0) {
                                    inst = 1;
                                }
                                double size = (double)cs1.getCollectedInstances() / (double)inst;
                                inst = cs2.getTotalInstances();
                                if (inst == 0) {
                                    inst = 1;
                                }
                                return this._sortSequence * (int)((size -= (double)cs2.getCollectedInstances() / (double)inst) * 10000.0);
                            }
                            return this._sortSequence * (cs1.getCollectedInstances() - cs2.getCollectedInstances());
                        }
                        c1.computeDelta((IDelta)ClassStatistic.this.cdelta1, 16);
                        c2.computeDelta((IDelta)ClassStatistic.this.cdelta2, 16);
                        return this._sortSequence * (ClassStatistic.this.cdelta1.getCollectedInstances() - ClassStatistic.this.cdelta2.getCollectedInstances());
                    }
                    case 5: {
                        if (!this._info.isDeltaColumn()) {
                            return this._sortSequence * (cs1.getTotalSize() - cs2.getTotalSize());
                        }
                        c1.computeDelta((IDelta)ClassStatistic.this.cdelta1, 13);
                        c2.computeDelta((IDelta)ClassStatistic.this.cdelta2, 13);
                        return this._sortSequence * (ClassStatistic.this.cdelta1.getTotalSize() - ClassStatistic.this.cdelta2.getTotalSize());
                    }
                    case 6: {
                        if (!this._info.isDeltaColumn()) {
                            return this._sortSequence * (cs1.getTotalSize() - cs1.getCollectedSize() - cs2.getTotalSize() + cs2.getCollectedSize());
                        }
                        c1.computeDelta((IDelta)ClassStatistic.this.cdelta1, 13);
                        c2.computeDelta((IDelta)ClassStatistic.this.cdelta2, 13);
                        c1.computeDelta((IDelta)ClassStatistic.this.cdelta1, 15);
                        c2.computeDelta((IDelta)ClassStatistic.this.cdelta2, 15);
                        return this._sortSequence * (ClassStatistic.this.cdelta1.getTotalSize() - ClassStatistic.this.cdelta1.getCollectedSize() - (ClassStatistic.this.cdelta2.getTotalSize() - ClassStatistic.this.cdelta2.getCollectedSize()));
                    }
                    case 7: {
                        if (!this._info.isDeltaColumn()) {
                            d = cs1.getBaseTime() - cs2.getBaseTime();
                        } else {
                            c1.computeDelta((IDelta)ClassStatistic.this.cdelta1, 7);
                            c2.computeDelta((IDelta)ClassStatistic.this.cdelta2, 7);
                            d = ClassStatistic.this.cdelta1.getBaseTime() - ClassStatistic.this.cdelta2.getBaseTime();
                        }
                        if (d < 0.0) {
                            return -1 * this._sortSequence;
                        }
                        if (d > 0.0) {
                            return this._sortSequence;
                        }
                        return 0;
                    }
                    case 8: {
                        if (!this._info.isDeltaColumn()) {
                            d = cs1.getInheritedBaseTime() - cs2.getInheritedBaseTime();
                        } else {
                            c1.computeDelta((IDelta)ClassStatistic.this.cdelta1, 11);
                            c2.computeDelta((IDelta)ClassStatistic.this.cdelta2, 11);
                            d = ClassStatistic.this.cdelta1.getInheritedBaseTime() - ClassStatistic.this.cdelta2.getInheritedBaseTime();
                        }
                        if (d < 0.0) {
                            return -1 * this._sortSequence;
                        }
                        if (d > 0.0) {
                            return this._sortSequence;
                        }
                        return 0;
                    }
                    case 9: {
                        if (!this._info.isDeltaColumn()) {
                            d = cs1.getCumulativeTime() - cs2.getCumulativeTime();
                        } else {
                            c1.computeDelta((IDelta)ClassStatistic.this.cdelta1, 8);
                            c2.computeDelta((IDelta)ClassStatistic.this.cdelta2, 8);
                            d = ClassStatistic.this.cdelta1.getCumulativeTime() - ClassStatistic.this.cdelta2.getCumulativeTime();
                        }
                        if (d < 0.0) {
                            return -1 * this._sortSequence;
                        }
                        if (d > 0.0) {
                            return this._sortSequence;
                        }
                        return 0;
                    }
                    case 10: {
                        if (!this._info.isDeltaColumn()) {
                            d = cs1.getInheritedCumulativeTime() - cs2.getInheritedCumulativeTime();
                        } else {
                            c1.computeDelta((IDelta)ClassStatistic.this.cdelta1, 12);
                            c2.computeDelta((IDelta)ClassStatistic.this.cdelta2, 12);
                            d = ClassStatistic.this.cdelta1.getInheritedCumulativeTime() - ClassStatistic.this.cdelta2.getInheritedCumulativeTime();
                        }
                        if (d < 0.0) {
                            return -1 * this._sortSequence;
                        }
                        if (d > 0.0) {
                            return this._sortSequence;
                        }
                        return 0;
                    }
                    case 11: {
                        if (!this._info.isDeltaColumn()) {
                            return this._sortSequence * (cs1.getCalls() - cs2.getCalls());
                        }
                        c1.computeDelta((IDelta)ClassStatistic.this.cdelta1, 9);
                        c2.computeDelta((IDelta)ClassStatistic.this.cdelta2, 9);
                        return this._sortSequence * (ClassStatistic.this.cdelta1.getCalls() - ClassStatistic.this.cdelta2.getCalls());
                    }
                    case 12: {
                        if (!this._info.isDeltaColumn()) {
                            return this._sortSequence * (cs1.getInheritedCalls() - cs2.getInheritedCalls());
                        }
                        c1.computeDelta((IDelta)ClassStatistic.this.cdelta1, 10);
                        c2.computeDelta((IDelta)ClassStatistic.this.cdelta2, 10);
                        return this._sortSequence * (ClassStatistic.this.cdelta1.getInheritedCalls() - ClassStatistic.this.cdelta2.getInheritedCalls());
                    }
                }
            } else {
                TRCMethod m1 = (TRCMethod)e1;
                TRCMethod m2 = (TRCMethod)e2;
                TRCMethodImpl.TRCMethodSnapshot ms1 = (TRCMethodImpl.TRCMethodSnapshot)m1.retrieveSnapshot();
                TRCMethodImpl.TRCMethodSnapshot ms2 = (TRCMethodImpl.TRCMethodSnapshot)m2.retrieveSnapshot();
                switch (this._pos) {
                    case 0: {
                        StringBuffer buf1 = new StringBuffer();
                        StringBuffer buf2 = new StringBuffer();
                        return this._sortSequence * buf1.append(m1.getName()).append(m1.getSignature()).toString().compareToIgnoreCase(buf2.append(m2.getName()).append(m2.getSignature()).toString());
                    }
                    case 7: {
                        if (!this._info.isDeltaColumn()) {
                            d = ms1.getBaseTime() - ms2.getBaseTime();
                        } else {
                            m1.computeDelta((IDelta)ClassStatistic.this.mdelta1, 6);
                            m2.computeDelta((IDelta)ClassStatistic.this.mdelta2, 6);
                            d = ClassStatistic.this.mdelta1.getBaseTime() - ClassStatistic.this.mdelta2.getBaseTime();
                        }
                        if (d < 0.0) {
                            return -1 * this._sortSequence;
                        }
                        if (d > 0.0) {
                            return this._sortSequence;
                        }
                        return 0;
                    }
                    case 9: {
                        if (!this._info.isDeltaColumn()) {
                            d = ms1.getCumulativeTime() - ms2.getCumulativeTime();
                        } else {
                            m1.computeDelta((IDelta)ClassStatistic.this.mdelta1, 7);
                            m2.computeDelta((IDelta)ClassStatistic.this.mdelta2, 7);
                            d = ClassStatistic.this.mdelta1.getCumulativeTime() - ClassStatistic.this.mdelta2.getCumulativeTime();
                        }
                        if (d < 0.0) {
                            return -1 * this._sortSequence;
                        }
                        if (d > 0.0) {
                            return this._sortSequence;
                        }
                        return 0;
                    }
                    case 11: {
                        if (!this._info.isDeltaColumn()) {
                            return this._sortSequence * (ms1.getCalls() - ms2.getCalls());
                        }
                        m1.computeDelta((IDelta)ClassStatistic.this.mdelta1, 8);
                        m2.computeDelta((IDelta)ClassStatistic.this.mdelta2, 8);
                        return this._sortSequence * (ClassStatistic.this.mdelta1.getCalls() - ClassStatistic.this.mdelta2.getCalls());
                    }
                }
            }
            return 0;
        }
    }

    public class ClassStatisticFilter
    extends StatisticView.StatisticFilter {
        public ClassStatisticFilter() {
            super(ClassStatistic.this);
        }

        public boolean select(Viewer viewer, Object parent, Object element) {
            boolean flag = true;
            if (!(element instanceof TRCClass)) {
                return true;
            }
            String compareText = "";
            if (this._noPattern) {
                return true;
            }
            if (element instanceof TRCClass) {
                compareText = ((TRCClass)element).getName();
            }
            if (!this._caseSensitive) {
                compareText = compareText.toLowerCase();
            }
            if (this._exactMatch) {
                return compareText.compareTo(this._prefix) == 0;
            }
            if (this._prefix != "") {
                flag = compareText.startsWith(this._prefix);
            }
            if (flag && this._suffix != "") {
                flag = compareText.endsWith(this._suffix);
            }
            if (flag) {
                int k = 0;
                while (k < this._textList.size()) {
                    String str1 = (String)this._textList.get(k);
                    int index = compareText.lastIndexOf(str1);
                    if (index == -1) {
                        flag = false;
                        break;
                    }
                    compareText = compareText.substring(index + str1.length());
                    ++k;
                }
            }
            return flag;
        }
    }
}

