/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.views.internal;

import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.trace.TRCClass;
import org.eclipse.hyades.models.trace.TRCMethod;
import org.eclipse.hyades.models.trace.TRCPackage;
import org.eclipse.hyades.trace.ui.ITraceSelection;
import org.eclipse.hyades.trace.ui.TraceViewerPage;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.ViewSelectionChangedEvent;
import org.eclipse.hyades.trace.ui.internal.util.TString;
import org.eclipse.hyades.trace.views.adapter.internal.CoveragePage;
import org.eclipse.hyades.trace.views.adapter.internal.CoverageViewer;
import org.eclipse.hyades.trace.views.internal.StatisticView;
import org.eclipse.hyades.trace.views.internal.TracePluginImages;
import org.eclipse.hyades.trace.views.internal.TraceUIPlugin;
import org.eclipse.hyades.trace.views.util.internal.ColumnData;
import org.eclipse.hyades.trace.views.util.internal.ColumnExtensionValue;
import org.eclipse.hyades.trace.views.util.internal.Coverage;
import org.eclipse.hyades.trace.views.util.internal.CoverageAnalysis;
import org.eclipse.hyades.trace.views.util.internal.IColumnExtension;
import org.eclipse.hyades.trace.views.util.internal.StatisticTableColumnInfo;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableTreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.custom.TableTree;
import org.eclipse.swt.custom.TableTreeItem;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;

public class CoverageStatistic
extends StatisticView {
    public static final int DEFAULT_LEVEL = 1;
    protected int _level = _saved_level;
    protected static int _saved_level = 1;
    private final int _numberOfColumns = 7;

    public CoverageStatistic(Composite parent, TraceViewerPage page) {
        super(parent, page);
        this._viewerFilter = new CoverageStatisticFilter();
    }

    public String getColumnsPreferencesKey() {
        return TraceUIPlugin.getString("PREFERENCE_KEY");
    }

    public String getDefaultColumnsTemplate() {
        this._level = _saved_level;
        String columns = "";
        if (this._level == 0 || this._level == 1) {
            columns = TraceUIPlugin.getString("STR_COL_ITEM_NAMES") + ":0:" + String.valueOf(7) + ":221," + TraceUIPlugin.getString("STR_COL_CLASS_NAME") + ":1:0" + ":100," + TraceUIPlugin.getString("STR_COL_PACKAGE") + ":2:0" + ":100," + TraceUIPlugin.getString("STR_COL_CALLS") + ":3:" + String.valueOf(1) + ":right:120," + TraceUIPlugin.getString("STR_COL_METHOD_MISSED") + ":4:" + String.valueOf(1) + ":right:120," + TraceUIPlugin.getString("STR_COL_METHOD_HIT") + ":5:" + String.valueOf(1) + ":right:120," + TraceUIPlugin.getString("STR_COL_RATE") + ":6:" + String.valueOf(1) + ":right:120";
        } else if (this._level == 2) {
            columns = TraceUIPlugin.getString("STR_COL_ITEM_NAMES") + ":0:" + String.valueOf(7) + ":200," + TraceUIPlugin.getString("STR_COL_CLASS_NAME") + ":1:0" + ":100," + TraceUIPlugin.getString("STR_COL_PACKAGE") + ":2:" + String.valueOf(1) + ":150," + TraceUIPlugin.getString("STR_COL_CALLS") + ":3:" + String.valueOf(1) + ":right:60," + TraceUIPlugin.getString("STR_COL_METHOD_MISSED") + ":4:" + String.valueOf(1) + ":right:100," + TraceUIPlugin.getString("STR_COL_METHOD_HIT") + ":5:" + String.valueOf(1) + ":right:100," + TraceUIPlugin.getString("STR_COL_RATE") + ":6:" + String.valueOf(1) + ":right:100";
        } else if (this._level == 3) {
            columns = TraceUIPlugin.getString("STR_COL_ITEM_NAMES") + ":0:" + String.valueOf(7) + ":200," + TraceUIPlugin.getString("STR_COL_CLASS_NAME") + ":1:" + String.valueOf(1) + ":100," + TraceUIPlugin.getString("STR_COL_PACKAGE") + ":2:" + String.valueOf(1) + ":100," + TraceUIPlugin.getString("STR_COL_CALLS") + ":3:" + String.valueOf(1) + ":right:45," + TraceUIPlugin.getString("STR_COL_METHOD_MISSED") + ":4:" + String.valueOf(1) + ":right:90," + TraceUIPlugin.getString("STR_COL_METHOD_HIT") + ":5:" + String.valueOf(1) + ":right:90," + TraceUIPlugin.getString("STR_COL_RATE") + ":6:" + String.valueOf(1) + ":right:90";
        }
        return columns + this.getColumnsTemplateExtensions();
    }

    protected Composite createTable(Composite parent, int options) {
        return new TableTree(parent, options);
    }

    protected TableTreeViewer getTableTreeViewer(TableTree table) {
        return new CoverageTreeViewer(table);
    }

    protected void openSourceForSelection(ISelection selection) {
        CoverageViewer viewer;
        TraceViewerPage page;
        if (selection != null && (page = this.getTraceViewerPage()) != null && (viewer = (CoverageViewer)page.getTraceViewer()) != null) {
            BusyIndicator.showWhile((Display)Display.getDefault(), (Runnable)new Runnable(){

                public void run() {
                    viewer.openSource().run();
                }
            });
        }
    }

    public Table getTable() {
        return ((TableTree)this.getTableViewer().getControl()).getTable();
    }

    public LabelProvider getTableLabelProvider() {
        return new CoverageLabelProvider(this);
    }

    protected StatisticView.StatisticSorter getViewerSorterInstance() {
        return new CoverageStatisticSorter();
    }

    protected boolean canOpenSourceOnThisObject() {
        ITraceSelection _model = UIPlugin.getDefault().getSelectionModel(this._page.getMOFObject());
        if (_model.size() == 0 || _model.getFirstElement() == null) {
            return false;
        }
        Object firstElement = _model.getFirstElement();
        if (firstElement instanceof TRCClass && ((TRCClass)firstElement).getSourceInfo() != null && ((TRCClass)firstElement).getSourceInfo().getLocation().length() > 0) {
            return true;
        }
        return firstElement instanceof TRCMethod;
    }

    public void updateButtons() {
        switch (this._level) {
            case 1: {
                ((CoveragePage)this.getTraceViewerPage()).getPackageLevel().setChecked(true);
                ((CoveragePage)this.getTraceViewerPage()).getClassLevel().setChecked(false);
                ((CoveragePage)this.getTraceViewerPage()).getMethodLevel().setChecked(false);
                break;
            }
            case 2: {
                ((CoveragePage)this.getTraceViewerPage()).getPackageLevel().setChecked(false);
                ((CoveragePage)this.getTraceViewerPage()).getClassLevel().setChecked(true);
                ((CoveragePage)this.getTraceViewerPage()).getMethodLevel().setChecked(false);
                break;
            }
            case 3: {
                ((CoveragePage)this.getTraceViewerPage()).getPackageLevel().setChecked(false);
                ((CoveragePage)this.getTraceViewerPage()).getClassLevel().setChecked(false);
                ((CoveragePage)this.getTraceViewerPage()).getMethodLevel().setChecked(true);
            }
        }
        ((CoveragePage)this.getTraceViewerPage()).openSource().setEnabled(this.canOpenSourceOnThisObject());
    }

    protected void handleSelectionEvent() {
        Object sel;
        ITraceSelection model = UIPlugin.getDefault().getSelectionModel(this._page.getMOFObject());
        if (model.size() > 0 && (sel = model.getFirstElement()) != null) {
            this.select(sel);
        }
    }

    private void select(Object obj) {
        TRCClass cls = null;
        TRCPackage pack = null;
        TRCMethod meth = null;
        String parentClsName = null;
        TableTree table = (TableTree)this.getTableViewer().getControl();
        TableTreeItem[] items = table.getItems();
        if (items.length != 0) {
            ((CoverageTreeViewer)this.getTableViewer()).expandItem(items[0]);
            if (obj instanceof TRCPackage) {
                pack = (TRCPackage)obj;
            } else if (obj instanceof TRCClass) {
                cls = (TRCClass)obj;
                pack = cls.getPackage();
            } else if (obj instanceof TRCMethod) {
                meth = (TRCMethod)obj;
                cls = meth.getDefiningClass();
                pack = cls.getPackage();
            }
            switch (this._level) {
                case 1: {
                    this.searchInPackageLevel(table, items[0], pack, cls, parentClsName, meth);
                    break;
                }
                case 2: {
                    if (cls == null) break;
                    this.searchInClassLevel(table, items[0], cls, parentClsName, meth);
                    break;
                }
                case 3: {
                    if (meth == null) break;
                    this.searchInMethodLevel(table, items[0], meth);
                }
            }
        }
    }

    private void searchInPackageLevel(TableTree table, TableTreeItem item, TRCPackage pack, TRCClass cls, String parentClsName, TRCMethod meth) {
        TableTreeItem pacItem = null;
        TableTreeItem[] pacItems = item.getItems();
        pacItem = this.searchItem(pacItems, pack);
        if (pacItem != null) {
            if (cls == null) {
                table.setSelection(new TableTreeItem[]{pacItem});
                return;
            }
            ((CoverageTreeViewer)this.getTableViewer()).expandItem(pacItem);
            this.searchInClassLevel(table, pacItem, cls, parentClsName, meth);
            return;
        }
        table.deselectAll();
    }

    private void searchInClassLevel(TableTree table, TableTreeItem item, TRCClass cls, String parentClsName, TRCMethod meth) {
        TableTreeItem[] classItems = item.getItems();
        TableTreeItem classItemBis = null;
        classItemBis = this.searchItem(classItems, cls);
        if (classItemBis != null) {
            if (meth == null) {
                table.setSelection(new TableTreeItem[]{classItemBis});
                return;
            }
            ((CoverageTreeViewer)this.getTableViewer()).expandItem(classItemBis);
            this.searchInMethodLevel(table, classItemBis, meth);
            return;
        }
        table.deselectAll();
    }

    private void searchInMethodLevel(TableTree table, TableTreeItem item, TRCMethod meth) {
        TableTreeItem[] methodItems = item.getItems();
        TableTreeItem methodItem = this.searchItem(methodItems, meth);
        if (methodItem != null) {
            table.setSelection(new TableTreeItem[]{methodItem});
            return;
        }
        table.deselectAll();
    }

    private TableTreeItem searchItem(TableTreeItem[] items, Object obj) {
        int j = 0;
        while (j < items.length) {
            TableTreeItem item = items[j];
            Coverage cov = (Coverage)item.getData();
            if (cov.getTraceObjects().contains(obj)) {
                return item;
            }
            ++j;
        }
        return null;
    }

    public IContentProvider getContentProvider() {
        return new CoverageContentProvider();
    }

    public void updateModelSelection() {
        ISelection selection = this.getTableViewer().getSelection();
        if (selection != null && !selection.isEmpty()) {
            Object sel = ((IStructuredSelection)selection).getFirstElement();
            EObject obj = ((Coverage)sel).getTraceObj();
            this.notifyViewSelectionChanged(this, obj);
        }
    }

    public void handleViewSelectionChangedEvent(ViewSelectionChangedEvent event) {
        Object source = event.getSource();
        if (source != this) {
            this.handleSelectionEvent();
        }
    }

    protected void expandFirstElement() {
        TableTree table = ((TableTreeViewer)this.getTableViewer()).getTableTree();
        TableTreeItem[] items = table.getItems();
        if (items.length != 0) {
            ((CoverageTreeViewer)this.getTableViewer()).expandItem(items[0]);
        }
    }

    public void menuAboutToShow(IMenuManager menu) {
        menu.add((IAction)this.getUpdateAction());
        menu.add((IContributionItem)this.fSeparator);
        this.resetChooseColumnsAction();
        menu.add((IAction)this.getChooseColumnsAction(this.getColumnDataList(), this.getColumnsPreferencesKey()));
        if (this.canOpenSourceOnThisObject()) {
            menu.add((IAction)((CoverageViewer)this.getTraceViewerPage().getTraceViewer()).openSource());
        }
    }

    public int getLevel() {
        return this._level;
    }

    public void setLevel(int i) {
        _saved_level = this._level = i;
    }

    public void redrawTable() {
        this.getTable().setRedraw(false);
        String template = this.getDefaultColumnsTemplate();
        ArrayList list = ColumnData.createColumnDataFromString(template);
        this.resetColumns(list);
        this._currentColumns = list;
        this.getTable().setRedraw(true);
    }

    public void widgetSelected(SelectionEvent arg0) {
        super.widgetSelected(arg0);
        if (arg0.widget instanceof TableColumn) {
            this.expandFirstElement();
            this.handleSelectionEvent();
        }
    }

    protected void filterNames() {
        super.filterNames();
        this.expandFirstElement();
        this.handleSelectionEvent();
    }

    protected void resetColumns(ArrayList list) {
        super.resetColumns(list);
        this.expandFirstElement();
        this.handleSelectionEvent();
    }

    protected void resetChooseColumnsAction() {
        this._chooseColumnAction = null;
    }

    public String getColumnsTemplateExtensions() {
        IConfigurationElement[] members;
        String columnName = "";
        String pos = "";
        String style = "";
        String width = "";
        String align = "";
        int colNumber = 7;
        this._templateOfColumExtension = "";
        this._listOfColumExtension.clear();
        IExtensionPoint extPoint = Platform.getPluginRegistry().getExtensionPoint("org.eclipse.hyades.trace.views.columnExtension");
        if (extPoint != null && (members = extPoint.getConfigurationElements()).length != 0) {
            int i = 0;
            while (i < members.length) {
                columnName = members[i].getAttribute("name");
                pos = members[i].getAttribute("pos");
                style = members[i].getAttribute("style");
                width = members[i].getAttribute("width");
                align = members[i].getAttribute("align");
                this._templateOfColumExtension = this._templateOfColumExtension + "," + columnName + ":" + colNumber + ":" + style + ":" + align + ":" + width;
                ++colNumber;
                try {
                    ColumnExtensionValue columnVal = new ColumnExtensionValue();
                    columnVal.setClassOfColumnExtension((IColumnExtension)members[i].createExecutableExtension("class"));
                    columnVal.setInitialColumnPos(new Integer(pos));
                    this._listOfColumExtension.add(columnVal);
                }
                catch (CoreException e) {
                    System.err.println((Object)e);
                }
                ++i;
            }
        }
        return this._templateOfColumExtension;
    }

    public boolean isEmpty() {
        CoverageAnalysis covAnalysis = ((CoveragePage)this._page).getCovAnalysis();
        return covAnalysis.getRoot() == null || covAnalysis.getRoot().getMethods() == 0;
    }

    public void dispose() {
        super.dispose();
        _saved_level = this._level;
    }

    protected String getViewTypeStr() {
        return "viewoption.coverage";
    }

    class CoverageTreeViewer
    extends TableTreeViewer {
        public CoverageTreeViewer(Composite parent) {
            super(parent);
        }

        public CoverageTreeViewer(TableTree table) {
            super(table);
        }

        public void expandItem(TableTreeItem item) {
            item.setExpanded(true);
            this.createChildren((Widget)item);
        }
    }

    public class CoverageLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        protected StatisticView _viewer;

        public CoverageLabelProvider(StatisticView viewer) {
            this._viewer = viewer;
        }

        public Image getColumnImage(Object obj, int col) {
            StatisticTableColumnInfo info = StatisticTableColumnInfo.getStatisticTableColumnInfo(this._viewer.getTable().getColumn(col));
            int pos = info.getColumnData().getInitalPos();
            Coverage cov = (Coverage)obj;
            switch (pos) {
                case 1: {
                    if (cov.getTraceObj() instanceof TRCMethod) {
                        return TracePluginImages.getImage("class.gif");
                    }
                    return null;
                }
                case 2: {
                    if (cov.getTraceObj() instanceof TRCMethod) {
                        if (CoverageStatistic.this._level == 1 || CoverageStatistic.this._level == 2) {
                            return null;
                        }
                        return TracePluginImages.getImage("package_obj.gif");
                    }
                    if (cov.getTraceObj() instanceof TRCClass) {
                        return TracePluginImages.getImage("package_obj.gif");
                    }
                    return null;
                }
            }
            return null;
        }

        public String getColumnText(Object obj, int col) {
            StatisticTableColumnInfo info = StatisticTableColumnInfo.getStatisticTableColumnInfo(this._viewer.getTable().getColumn(col));
            int pos = info.getColumnData().getInitalPos();
            Coverage cov = (Coverage)obj;
            switch (pos) {
                case 0: {
                    if (cov.getTraceObj() instanceof TRCPackage) {
                        if (((TRCPackage)cov.getTraceObj()).getName().equals("")) {
                            return TraceUIPlugin.getString("DEFAULT_PACKAGE");
                        }
                        return ((TRCPackage)cov.getTraceObj()).getName();
                    }
                    if (cov.getTraceObj() instanceof TRCClass) {
                        return ((TRCClass)cov.getTraceObj()).getName();
                    }
                    if (cov.getTraceObj() instanceof TRCMethod) {
                        TRCMethod m = (TRCMethod)cov.getTraceObj();
                        return m.getName() + m.getSignature();
                    }
                    return TraceUIPlugin.getString("ST_SUMMARY");
                }
                case 1: {
                    if (cov.getTraceObj() instanceof TRCMethod) {
                        return ((TRCMethod)cov.getTraceObj()).getDefiningClass().getName();
                    }
                    return "";
                }
                case 2: {
                    if (cov.getTraceObj() instanceof TRCMethod) {
                        if (CoverageStatistic.this._level == 1 || CoverageStatistic.this._level == 2) {
                            return "";
                        }
                        if (((TRCMethod)cov.getTraceObj()).getDefiningClass().getPackage().getName().equals("")) {
                            return TraceUIPlugin.getString("DEFAULT_PACKAGE");
                        }
                        return ((TRCMethod)cov.getTraceObj()).getDefiningClass().getPackage().getName();
                    }
                    if (cov.getTraceObj() instanceof TRCClass) {
                        if (((TRCClass)cov.getTraceObj()).getPackage().getName().equals("")) {
                            return TraceUIPlugin.getString("DEFAULT_PACKAGE");
                        }
                        return ((TRCClass)cov.getTraceObj()).getPackage().getName();
                    }
                    return "";
                }
                case 3: {
                    return String.valueOf(cov.getCalls());
                }
                case 4: {
                    if (cov.getTraceObj() instanceof TRCMethod) {
                        if (cov.getCalls() == 0) {
                            return TraceUIPlugin.getString("ST_MISSED");
                        }
                        return "";
                    }
                    return String.valueOf(cov.getMethodsMissed());
                }
                case 5: {
                    if (cov.getTraceObj() instanceof TRCMethod) {
                        if (cov.getCalls() != 0) {
                            return TraceUIPlugin.getString("ST_HIT");
                        }
                        return "";
                    }
                    return String.valueOf(cov.getMethodsHit());
                }
                case 6: {
                    if (cov.getTraceObj() instanceof TRCMethod) {
                        return "";
                    }
                    return TString.formatAsPercentage((double)cov.getPercentage());
                }
            }
            if (CoverageStatistic.this._listOfColumExtension.size() != 0) {
                ColumnExtensionValue elt = (ColumnExtensionValue)CoverageStatistic.this._listOfColumExtension.get(pos - 7);
                return elt.getClassOfColumnExtension().getColumnText(obj, elt.getInitialColumnPos());
            }
            return "";
        }
    }

    public class CoverageContentProvider
    implements ITreeContentProvider {
        public void dispose() {
        }

        public Object getParent(Object element) {
            return null;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            ArrayList<Coverage> tmpList = new ArrayList<Coverage>();
            tmpList.clear();
            CoverageAnalysis covAnalysis = ((CoveragePage)CoverageStatistic.this._page).getCovAnalysis();
            if (covAnalysis.getRoot() != null) {
                switch (CoverageStatistic.this._level) {
                    case 1: {
                        tmpList.add(covAnalysis.getRoot());
                        return tmpList.toArray();
                    }
                    case 2: {
                        tmpList.add(covAnalysis.getClassLevel());
                        return tmpList.toArray();
                    }
                    case 3: {
                        tmpList.add(covAnalysis.getMethodLevel());
                        return tmpList.toArray();
                    }
                }
                return tmpList.toArray();
            }
            return tmpList.toArray();
        }

        public Object[] getChildren(Object element) {
            ArrayList childs = ((Coverage)element).getChilds();
            if (childs == null) {
                return null;
            }
            return childs.toArray();
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element) != null;
        }
    }

    public class CoverageStatisticFilter
    extends StatisticView.StatisticFilter {
        public CoverageStatisticFilter() {
            super(CoverageStatistic.this);
        }

        public boolean select(Viewer viewer, Object parent, Object element) {
            Coverage cov = (Coverage)element;
            boolean flag = true;
            String compareText = "";
            switch (CoverageStatistic.this._level) {
                case 1: {
                    if (!(cov.getTraceObj() instanceof TRCPackage)) {
                        return true;
                    }
                    if (((TRCPackage)cov.getTraceObj()).getName().equals("")) {
                        compareText = TraceUIPlugin.getString("DEFAULT_PACKAGE");
                        break;
                    }
                    compareText = ((TRCPackage)cov.getTraceObj()).getName();
                    break;
                }
                case 2: {
                    if (!(cov.getTraceObj() instanceof TRCClass)) {
                        return true;
                    }
                    compareText = ((TRCClass)cov.getTraceObj()).getName();
                    break;
                }
                case 3: {
                    if (!(cov.getTraceObj() instanceof TRCMethod)) {
                        return true;
                    }
                    compareText = ((TRCMethod)cov.getTraceObj()).getName();
                }
            }
            if (this._noPattern) {
                return true;
            }
            if (!this._caseSensitive) {
                compareText = compareText.toLowerCase();
            }
            if (this._exactMatch) {
                return compareText.compareTo(this._prefix) == 0;
            }
            if (this._prefix != "") {
                flag = compareText.startsWith(this._prefix);
            }
            if (flag && this._suffix != "") {
                flag = compareText.endsWith(this._suffix);
            }
            if (flag) {
                int k = 0;
                while (k < this._textList.size()) {
                    String str1 = (String)this._textList.get(k);
                    int index = compareText.lastIndexOf(str1);
                    if (index == -1) {
                        flag = false;
                        break;
                    }
                    compareText = compareText.substring(index + str1.length());
                    ++k;
                }
            }
            return flag;
        }
    }

    public class CoverageStatisticSorter
    extends StatisticView.StatisticSorter {
        public CoverageStatisticSorter() {
            super(CoverageStatistic.this);
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            Coverage cov1 = (Coverage)e1;
            Coverage cov2 = (Coverage)e2;
            String name1 = null;
            String name2 = null;
            switch (this._pos) {
                case 0: {
                    if (cov1.getTraceObj() instanceof TRCPackage) {
                        name1 = ((TRCPackage)cov1.getTraceObj()).getName().equals("") ? TraceUIPlugin.getString("DEFAULT_PACKAGE") : ((TRCPackage)cov1.getTraceObj()).getName();
                    } else if (cov1.getTraceObj() instanceof TRCClass) {
                        name1 = ((TRCClass)cov1.getTraceObj()).getName();
                    } else if (cov1.getTraceObj() instanceof TRCMethod) {
                        name1 = ((TRCMethod)cov1.getTraceObj()).getName();
                    }
                    if (cov2.getTraceObj() instanceof TRCPackage) {
                        name2 = ((TRCPackage)cov2.getTraceObj()).getName().equals("") ? TraceUIPlugin.getString("DEFAULT_PACKAGE") : ((TRCPackage)cov2.getTraceObj()).getName();
                    } else if (cov2.getTraceObj() instanceof TRCClass) {
                        name2 = ((TRCClass)cov2.getTraceObj()).getName();
                    } else if (cov2.getTraceObj() instanceof TRCMethod) {
                        name2 = ((TRCMethod)cov2.getTraceObj()).getName();
                    }
                    return this._sortSequence * name1.compareToIgnoreCase(name2);
                }
                case 1: {
                    if (cov1.getTraceObj() instanceof TRCMethod && cov2.getTraceObj() instanceof TRCMethod) {
                        TRCMethod m1 = (TRCMethod)cov1.getTraceObj();
                        TRCMethod m2 = (TRCMethod)cov2.getTraceObj();
                        return this._sortSequence * m1.getDefiningClass().getName().compareToIgnoreCase(m2.getDefiningClass().getName());
                    }
                    return 0;
                }
                case 2: {
                    if (cov1.getTraceObj() instanceof TRCMethod && cov2.getTraceObj() instanceof TRCMethod && CoverageStatistic.this._level == 3) {
                        TRCMethod m1 = (TRCMethod)cov1.getTraceObj();
                        TRCMethod m2 = (TRCMethod)cov2.getTraceObj();
                        name1 = m1.getDefiningClass().getPackage().getName().equals("") ? TraceUIPlugin.getString("DEFAULT_PACKAGE") : m1.getDefiningClass().getPackage().getName();
                        name2 = m2.getDefiningClass().getPackage().getName().equals("") ? TraceUIPlugin.getString("DEFAULT_PACKAGE") : m2.getDefiningClass().getPackage().getName();
                        return this._sortSequence * name1.compareToIgnoreCase(name2);
                    }
                    if (cov1.getTraceObj() instanceof TRCClass && cov2.getTraceObj() instanceof TRCClass) {
                        name1 = ((TRCClass)cov1.getTraceObj()).getPackage().getName().equals("") ? TraceUIPlugin.getString("DEFAULT_PACKAGE") : ((TRCClass)cov1.getTraceObj()).getPackage().getName();
                        name2 = ((TRCClass)cov2.getTraceObj()).getPackage().getName().equals("") ? TraceUIPlugin.getString("DEFAULT_PACKAGE") : ((TRCClass)cov2.getTraceObj()).getPackage().getName();
                        return this._sortSequence * name1.compareToIgnoreCase(name2);
                    }
                    return 0;
                }
                case 3: {
                    return this._sortSequence * (cov1.getCalls() - cov2.getCalls());
                }
                case 4: {
                    return this._sortSequence * (cov1.getMethodsMissed() - cov2.getMethodsMissed());
                }
                case 5: {
                    return this._sortSequence * (cov1.getMethodsHit() - cov2.getMethodsHit());
                }
                case 6: {
                    return this._sortSequence * (int)((cov1.getPercentage() - cov2.getPercentage()) * 10000.0);
                }
            }
            if (CoverageStatistic.this._listOfColumExtension.size() != 0) {
                ColumnExtensionValue elt = (ColumnExtensionValue)CoverageStatistic.this._listOfColumExtension.get(this._pos - 7);
                return this._sortSequence * elt.getClassOfColumnExtension().compare(elt.getInitialColumnPos(), e1, e2);
            }
            return 0;
        }
    }
}

