/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.views.internal;

import java.util.ArrayList;
import org.eclipse.hyades.loaders.trace.IDelta;
import org.eclipse.hyades.models.trace.TRCClass;
import org.eclipse.hyades.models.trace.TRCMethod;
import org.eclipse.hyades.models.trace.TRCMethodInvocation;
import org.eclipse.hyades.models.trace.impl.TRCMethodImpl;
import org.eclipse.hyades.trace.ui.ITraceSelection;
import org.eclipse.hyades.trace.ui.TraceViewerPage;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.ViewSelectionChangedEvent;
import org.eclipse.hyades.trace.ui.internal.util.TString;
import org.eclipse.hyades.trace.views.adapter.internal.MethodStatisticPage;
import org.eclipse.hyades.trace.views.internal.StatisticView;
import org.eclipse.hyades.trace.views.internal.TracePluginImages;
import org.eclipse.hyades.trace.views.internal.TraceUIPlugin;
import org.eclipse.hyades.trace.views.util.internal.PerftraceUtil;
import org.eclipse.hyades.trace.views.util.internal.StatisticTableColumnInfo;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableTreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.TableTree;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;

public class MethodStatistic
extends StatisticView {
    private final TRCMethodImpl.TRCMethodSnapshot delta1 = new TRCMethodImpl.TRCMethodSnapshot();
    private final TRCMethodImpl.TRCMethodSnapshot delta2 = new TRCMethodImpl.TRCMethodSnapshot();

    public MethodStatistic(Composite parent, TraceViewerPage page) {
        super(parent, page);
        this._viewerFilter = new StatisticView.StatisticFilter(this);
    }

    public String getColumnsPreferencesKey() {
        return "M60";
    }

    public String getDefaultColumnsTemplate() {
        String methodColumn = TraceUIPlugin.getString("STR_ST_METHOD_NAME") + ":0:" + String.valueOf(7) + ":left:200," + TraceUIPlugin.getString("STR_ST_CLASS_NAME") + ":1:" + String.valueOf(1) + ":left:200," + TraceUIPlugin.getString("STR_ST_PACKAGE") + ":2:0:left:200," + TraceUIPlugin.getString("STR_ST_CPU_TIME") + ":3:" + String.valueOf(17) + ":right:100," + TraceUIPlugin.getString("STR_ST_CPU_TIME_AVERAGE") + ":4:" + String.valueOf(1) + ":right:100," + TraceUIPlugin.getString("STR_ST_STACK_TIME") + ":5:" + String.valueOf(17) + ":right:100," + TraceUIPlugin.getString("STR_ST_CALLS") + ":6:" + String.valueOf(17) + ":right:55";
        return methodColumn;
    }

    protected Composite createTable(Composite parent, int options) {
        return new TableTree(parent, options);
    }

    protected TableTreeViewer getTableTreeViewer(TableTree table) {
        return new TableTreeViewer(table);
    }

    protected IContentProvider getContentProvider() {
        return new MethodStatisticContentProvider();
    }

    public LabelProvider getTableLabelProvider() {
        return new MethodStatisticLabelProvider(this);
    }

    public Table getTable() {
        return ((TableTree)this.getTableViewer().getControl()).getTable();
    }

    protected void handleSelectionEvent() {
        ITraceSelection model = UIPlugin.getDefault().getSelectionModel(this._page.getMOFObject());
        if (model.size() > 0) {
            ((MethodStatisticPage)this.getTraceViewerPage()).openSource().setEnabled(true);
            Object sel = model.getFirstElement();
            if (sel instanceof TRCMethodInvocation) {
                this.select(((TRCMethodInvocation)sel).getMethod());
            }
            if (sel instanceof TRCMethod) {
                this.select((TRCMethod)sel);
            }
        }
    }

    private void select(TRCMethod object) {
        Table table = this.getTable();
        int idx = 0;
        while (idx < table.getItemCount()) {
            Object item = table.getItem(idx).getData();
            if (item == object) {
                table.setSelection(idx);
                this.setNewSelection();
                return;
            }
            ++idx;
        }
        table.deselectAll();
    }

    public void menuAboutToShow(IMenuManager menu) {
        menu.add((IAction)this.getUpdateAction());
        menu.add((IContributionItem)this.fSeparator);
        menu.add((IAction)this.getChooseColumnsAction(this.getColumnDataList(), this.getColumnsPreferencesKey()));
    }

    public void updateButtons() {
        ((MethodStatisticPage)this.getTraceViewerPage()).openSource().setEnabled(this.canOpenSourceOnThisObject());
        ((MethodStatisticPage)this.getTraceViewerPage()).deltaColumns().setChecked(this.showingDeltaColumns());
        ((MethodStatisticPage)this.getTraceViewerPage()).percentMode().setChecked(this.isShowPercent());
    }

    private boolean canOpenSourceOnThisObject() {
        ITraceSelection model = UIPlugin.getDefault().getSelectionModel(this._page.getMOFObject());
        if (model.size() == 0 || model.getFirstElement() == null) {
            return false;
        }
        Object sel = model.getFirstElement();
        return sel instanceof TRCMethod;
    }

    public void updateModelSelection() {
        ISelection selection = this.getTableViewer().getSelection();
        if (selection != null && !selection.isEmpty()) {
            Object sel = ((IStructuredSelection)selection).getFirstElement();
            this.notifyViewSelectionChanged(this, sel);
        }
    }

    protected StatisticView.StatisticSorter getViewerSorterInstance() {
        return new MethodStatisticSorter();
    }

    protected void showPercentUpdate() {
        if (this.isShowPercent()) {
            this._totalCalls = PerftraceUtil.getTotalCalls(this._page.getMOFObject());
            this._maxTime = PerftraceUtil.getMaximumTime(this._page.getMOFObject());
        }
    }

    public void handleViewSelectionChangedEvent(ViewSelectionChangedEvent event) {
        Object source = event.getSource();
        if (source != this) {
            this.handleSelectionEvent();
        }
    }

    public boolean isEmpty() {
        Object[] classes = PerftraceUtil.getAllClasses(this._page.getMOFObject());
        int size = 0;
        int idx = 0;
        while (idx < classes.length) {
            size += ((TRCClass)classes[idx]).getMethods().size();
            ++idx;
        }
        return size <= 0;
    }

    protected String getViewTypeStr() {
        return "viewoption.method";
    }

    public class MethodStatisticLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        protected StatisticView _viewer;

        public MethodStatisticLabelProvider(StatisticView viewer) {
            this._viewer = viewer;
        }

        public Image getColumnImage(Object obj, int col) {
            StatisticTableColumnInfo info = StatisticTableColumnInfo.getStatisticTableColumnInfo(this._viewer.getTable().getColumn(col));
            int pos = info.getColumnData().getInitalPos();
            if (info.isDeltaColumn()) {
                return null;
            }
            int state = 0;
            double d = 0.0;
            TRCMethod m = (TRCMethod)obj;
            if (m.computeDelta((IDelta)MethodStatistic.this.delta1, 6) < 0) {
                if (col == 1) {
                    return TracePluginImages.getImage("newentry_obj.gif");
                }
                return null;
            }
            switch (pos) {
                case 3: {
                    m.computeDelta((IDelta)MethodStatistic.this.delta1, 6);
                    d = MethodStatistic.this.delta1.getBaseTime();
                    if (d < 0.0) {
                        state = -1;
                        break;
                    }
                    if (!(d > 0.0)) break;
                    state = 1;
                    break;
                }
                case 4: {
                    state = 0;
                    break;
                }
                case 5: {
                    m.computeDelta((IDelta)MethodStatistic.this.delta1, 7);
                    d = MethodStatistic.this.delta1.getCumulativeTime();
                    if (d < 0.0) {
                        state = -1;
                        break;
                    }
                    if (!(d > 0.0)) break;
                    state = 1;
                    break;
                }
                case 6: {
                    m.computeDelta((IDelta)MethodStatistic.this.delta1, 8);
                    state = MethodStatistic.this.delta1.getCalls();
                }
            }
            if (state < 0) {
                return TracePluginImages.getImage("decreasedvalue_obj.gif");
            }
            if (state > 0) {
                return TracePluginImages.getImage("increasedvalue_obj.gif");
            }
            return null;
        }

        public String getColumnText(Object obj, int col) {
            StatisticTableColumnInfo info = StatisticTableColumnInfo.getStatisticTableColumnInfo(this._viewer.getTable().getColumn(col));
            int pos = info.getColumnData().getInitalPos();
            TRCMethod m = (TRCMethod)obj;
            TRCMethodImpl.TRCMethodSnapshot ms = (TRCMethodImpl.TRCMethodSnapshot)m.retrieveSnapshot();
            switch (pos) {
                case 0: {
                    StringBuffer buf = new StringBuffer();
                    return buf.append(m.getName()).append(m.getSignature()).toString();
                }
                case 1: {
                    return m.getDefiningClass().getName();
                }
                case 2: {
                    return PerftraceUtil.getPackageName(m.getDefiningClass().getPackage(), MethodStatistic.this._page.getMOFObject()).toString();
                }
                case 3: {
                    if (!info.isDeltaColumn()) {
                        if (MethodStatistic.this.isShowPercent()) {
                            return PerftraceUtil.formatAsPercentage(ms.getBaseTime() / MethodStatistic.this._maxTime);
                        }
                        return TString.formatTimeValue((double)ms.getBaseTime());
                    }
                    m.computeDelta((IDelta)MethodStatistic.this.delta1, 6);
                    return TString.formatTimeValue((double)MethodStatistic.this.delta1.getBaseTime());
                }
                case 4: {
                    int calls = ms.getCalls();
                    if (calls == 0) {
                        calls = 1;
                    }
                    if (MethodStatistic.this.isShowPercent()) {
                        return TString.formatAsPercentage((double)(ms.getBaseTime() / ((double)calls * MethodStatistic.this._maxTime)));
                    }
                    return TString.formatTimeValue((double)(ms.getBaseTime() / (double)calls));
                }
                case 5: {
                    if (!info.isDeltaColumn()) {
                        if (MethodStatistic.this.isShowPercent()) {
                            return TString.formatAsPercentage((double)(ms.getCumulativeTime() / MethodStatistic.this._maxTime));
                        }
                        return TString.formatTimeValue((double)ms.getCumulativeTime());
                    }
                    m.computeDelta((IDelta)MethodStatistic.this.delta1, 7);
                    return TString.formatTimeValue((double)MethodStatistic.this.delta1.getCumulativeTime());
                }
                case 6: {
                    if (!info.isDeltaColumn()) {
                        if (MethodStatistic.this.isShowPercent()) {
                            return TString.formatAsPercentage((double)((double)ms.getCalls() / (double)MethodStatistic.this._totalCalls));
                        }
                        return String.valueOf(ms.getCalls());
                    }
                    m.computeDelta((IDelta)MethodStatistic.this.delta1, 8);
                    return String.valueOf(MethodStatistic.this.delta1.getCalls());
                }
            }
            return "";
        }
    }

    public class MethodStatisticContentProvider
    implements ITreeContentProvider {
        public void dispose() {
        }

        public Object getParent(Object element) {
            return null;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            Object[] classes = PerftraceUtil.getAllClasses(MethodStatistic.this._page.getMOFObject());
            ArrayList methods = new ArrayList();
            int idx = 0;
            while (idx < classes.length) {
                methods.addAll(((TRCClass)classes[idx]).getMethods());
                ++idx;
            }
            return methods.toArray();
        }

        public Object[] getChildren(Object element) {
            MethodStatistic.this.tmpList.clear();
            return MethodStatistic.this.tmpList.toArray();
        }

        public boolean hasChildren(Object element) {
            return false;
        }
    }

    public class MethodStatisticSorter
    extends StatisticView.StatisticSorter {
        public MethodStatisticSorter() {
            super(MethodStatistic.this);
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            double d = 0.0;
            if (e1 instanceof TRCMethod) {
                TRCMethod m1 = (TRCMethod)e1;
                TRCMethod m2 = (TRCMethod)e2;
                TRCMethodImpl.TRCMethodSnapshot ms1 = (TRCMethodImpl.TRCMethodSnapshot)m1.retrieveSnapshot();
                TRCMethodImpl.TRCMethodSnapshot ms2 = (TRCMethodImpl.TRCMethodSnapshot)m2.retrieveSnapshot();
                switch (this._pos) {
                    case 0: {
                        StringBuffer buf1 = new StringBuffer();
                        StringBuffer buf2 = new StringBuffer();
                        return this._sortSequence * buf1.append(m1.getName()).append(m1.getSignature()).toString().compareToIgnoreCase(buf2.append(m2.getName()).append(m2.getSignature()).toString());
                    }
                    case 1: {
                        return this._sortSequence * m1.getDefiningClass().getName().compareToIgnoreCase(m2.getDefiningClass().getName());
                    }
                    case 2: {
                        return this._sortSequence * m1.getDefiningClass().getPackage().getName().compareToIgnoreCase(m2.getDefiningClass().getPackage().getName());
                    }
                    case 3: {
                        if (!this._info.isDeltaColumn()) {
                            d = ms1.getBaseTime() - ms2.getBaseTime();
                        } else {
                            m1.computeDelta((IDelta)MethodStatistic.this.delta1, 6);
                            m2.computeDelta((IDelta)MethodStatistic.this.delta2, 6);
                            d = MethodStatistic.this.delta1.getBaseTime() - MethodStatistic.this.delta2.getBaseTime();
                        }
                        if (d < 0.0) {
                            return -1 * this._sortSequence;
                        }
                        if (d > 0.0) {
                            return this._sortSequence;
                        }
                        return 0;
                    }
                    case 4: {
                        int calls2;
                        int calls1 = ms1.getCalls();
                        if (calls1 == 0) {
                            calls1 = 1;
                        }
                        if ((calls2 = ms2.getCalls()) == 0) {
                            calls2 = 1;
                        }
                        if ((d = ms1.getBaseTime() / (double)calls1 - ms2.getBaseTime() / (double)calls2) < 0.0) {
                            return -1 * this._sortSequence;
                        }
                        if (d > 0.0) {
                            return this._sortSequence;
                        }
                        return 0;
                    }
                    case 5: {
                        if (!this._info.isDeltaColumn()) {
                            d = ms1.getCumulativeTime() - ms2.getCumulativeTime();
                        } else {
                            m1.computeDelta((IDelta)MethodStatistic.this.delta1, 7);
                            m2.computeDelta((IDelta)MethodStatistic.this.delta2, 7);
                            d = MethodStatistic.this.delta1.getCumulativeTime() - MethodStatistic.this.delta2.getCumulativeTime();
                        }
                        if (d < 0.0) {
                            return -1 * this._sortSequence;
                        }
                        if (d > 0.0) {
                            return this._sortSequence;
                        }
                        return 0;
                    }
                    case 6: {
                        if (!this._info.isDeltaColumn()) {
                            return this._sortSequence * (ms1.getCalls() - ms2.getCalls());
                        }
                        m1.computeDelta((IDelta)MethodStatistic.this.delta1, 8);
                        m2.computeDelta((IDelta)MethodStatistic.this.delta2, 8);
                        return this._sortSequence * (MethodStatistic.this.delta1.getCalls() - MethodStatistic.this.delta2.getCalls());
                    }
                }
            }
            return 0;
        }
    }
}

