/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.internal.ui;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCMonitor;
import org.eclipse.hyades.models.hierarchy.TRCNode;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.trace.internal.ui.PDProjectExplorer;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.util.DeleteUtil;
import org.eclipse.hyades.ui.extension.INavigatorItem;
import org.eclipse.hyades.ui.internal.extension.NavigatorExtensionUtil;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Control;

public class PDContentProvider
implements ITreeContentProvider,
IResourceChangeListener {
    protected static Hashtable fMonitors = new Hashtable();
    private IStatus error;
    private Object[] objList;
    protected PDProjectExplorer fViewer;

    public PDContentProvider(PDProjectExplorer viewer) {
        this.fViewer = viewer;
        UIPlugin.getPluginWorkbench().addResourceChangeListener((IResourceChangeListener)this);
    }

    public static void addMonitor(IResource container, TRCMonitor monitor) {
        Object monitors = fMonitors.get(container);
        if (monitors == null) {
            monitors = new ArrayList();
            ((ArrayList)monitors).add(monitor);
            fMonitors.put(container, monitors);
        } else if (!((ArrayList)monitors).contains(monitor)) {
            ((ArrayList)monitors).add(monitor);
        }
    }

    public void dispose() {
        UIPlugin.getPluginWorkbench().removeResourceChangeListener((IResourceChangeListener)this);
    }

    public Object[] getChildren(Object elem) {
        final Object element = elem;
        BusyIndicator.showWhile(null, (Runnable)new Runnable(){

            public void run() {
                try {
                    if (element instanceof IProject) {
                        PDContentProvider.access$102(PDContentProvider.this, PDContentProvider.this.getContainerMonitors((IContainer)((IProject)element)));
                    } else if (element instanceof IFolder) {
                        PDContentProvider.access$102(PDContentProvider.this, PDContentProvider.this.getContainerMonitors((IContainer)((IFolder)element)));
                    } else if (element instanceof TRCMonitor) {
                        PDContentProvider.access$102(PDContentProvider.this, PDContentProvider.this.getMonitorChildren((TRCMonitor)element));
                    } else if (element instanceof TRCNode) {
                        PDContentProvider.access$102(PDContentProvider.this, PDContentProvider.this.getNodeProcesses((TRCNode)element));
                    } else if (element instanceof TRCProcessProxy) {
                        PDContentProvider.access$102(PDContentProvider.this, PDContentProvider.this.getProcessAgents((TRCProcessProxy)element));
                    } else if (element instanceof TRCAgentProxy) {
                        PDContentProvider.access$102(PDContentProvider.this, null);
                    } else if (element instanceof INavigatorItem) {
                        PDContentProvider.access$102(PDContentProvider.this, null);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        if (this.objList == null) {
            this.objList = new Object[0];
        }
        Object[] delegates = NavigatorExtensionUtil.getAllChildren((Object)element, (String)"org.eclipse.hyades.trace.ui.profileNavigator").toArray();
        Object[] finalList = new Object[this.objList.length + delegates.length];
        System.arraycopy(this.objList, 0, finalList, 0, this.objList.length);
        System.arraycopy(delegates, 0, finalList, this.objList.length, delegates.length);
        return finalList;
    }

    private Object[] getContainerMonitors(IContainer res) {
        return this.getContainerMonitorsArray(res).toArray();
    }

    private ArrayList getContainerMonitorsArray(IContainer res) {
        ArrayList list = this.getContainerMonitors0(res);
        ArrayList<Object> result = new ArrayList<Object>();
        int idx = 0;
        while (idx < list.size()) {
            Object obj = list.get(idx);
            if (obj instanceof TRCMonitor) {
                TRCMonitor monitor = (TRCMonitor)obj;
                result.add(monitor);
            } else if (obj instanceof IContainer) {
                IContainer cont = (IContainer)obj;
                result.add(cont);
            }
            ++idx;
        }
        return result;
    }

    protected ArrayList getContainerMonitors0(IContainer res) {
        int idx;
        ArrayList<Object> childList = new ArrayList<Object>();
        if (res == null || !res.exists()) {
            return childList;
        }
        try {
            IResource[] rmembers = res.members();
            idx = 0;
            while (idx < rmembers.length) {
                IResource member = rmembers[idx];
                if (member != null && member.exists() && member instanceof IFolder) {
                    childList.add(member);
                }
                ++idx;
            }
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
        Object monitors = fMonitors.get(res);
        if (monitors == null) {
            try {
                IResource[] members = res.members();
                int idx2 = 0;
                while (idx2 < members.length) {
                    IResource member = members[idx2];
                    if (member != null && member.exists() && member instanceof IFile && member.getFileExtension() != null && member.getFileExtension().equals("trcmxmi")) {
                        this.getMonitors(member, childList);
                    }
                    ++idx2;
                }
            }
            catch (CoreException exc) {
                this.error = new Status(2, "org.eclipse.core.resources", 566, exc.toString(), (Throwable)exc);
            }
            if (childList.size() > 0) {
                ArrayList v = new ArrayList();
                int i = 0;
                while (i < childList.size()) {
                    Object obj = childList.get(i);
                    if (obj instanceof TRCMonitor) {
                        v.add(obj);
                    }
                    ++i;
                }
                if (v.size() > 0) {
                    fMonitors.put(res, v);
                }
            }
            return childList;
        }
        idx = 0;
        while (idx < ((ArrayList)monitors).size()) {
            childList.add(((ArrayList)monitors).get(idx));
            ++idx;
        }
        if (childList == null || childList.size() == 0) {
            return new ArrayList();
        }
        return childList;
    }

    public Object[] getElements(Object elem) {
        final Object element = elem;
        BusyIndicator.showWhile(null, (Runnable)new Runnable(){

            public void run() {
                try {
                    if (element instanceof IWorkspace) {
                        PDContentProvider.access$102(PDContentProvider.this, ((IWorkspace)element).getRoot().getProjects());
                    } else if (element instanceof IWorkspaceRoot) {
                        PDContentProvider.access$102(PDContentProvider.this, ((IWorkspaceRoot)element).getProjects());
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        if (this.objList == null) {
            this.objList = new Object[0];
        }
        Object[] delegates = NavigatorExtensionUtil.getAllChildren((Object)element, (String)"org.eclipse.hyades.trace.ui.profileNavigator").toArray();
        Object[] finalList = new Object[this.objList.length + delegates.length];
        System.arraycopy(this.objList, 0, finalList, 0, this.objList.length);
        System.arraycopy(delegates, 0, finalList, this.objList.length, delegates.length);
        return finalList;
    }

    protected Object[] getMonitorChildren(TRCMonitor monitor) {
        return this.getMonitorChildren0(monitor).toArray();
    }

    protected ArrayList getMonitorChildren0(TRCMonitor monitor) {
        ArrayList<TRCNode> list = new ArrayList<TRCNode>();
        try {
            Iterator i = monitor.getNodes().iterator();
            while (i.hasNext()) {
                TRCNode node = (TRCNode)i.next();
                if (node.eIsProxy()) continue;
                list.add(node);
            }
        }
        catch (Exception exc) {
            return list;
        }
        return list;
    }

    public static ArrayList getMonitors() {
        Enumeration list = fMonitors.elements();
        ArrayList v = new ArrayList();
        while (list.hasMoreElements()) {
            ArrayList monitors = (ArrayList)list.nextElement();
            int idx = 0;
            while (idx < monitors.size()) {
                v.add(monitors.get(idx));
                ++idx;
            }
        }
        return v;
    }

    public static ArrayList getMonitors(IContainer container) {
        Object monitors = fMonitors.get(container);
        if (monitors == null) {
            return new ArrayList();
        }
        return (ArrayList)monitors;
    }

    private void getMonitors(IResource member, ArrayList childList) {
        ResourceSet resourceSet = UIPlugin.getDefault().getResourceSet();
        Resource res = null;
        try {
            String monPath;
            String name = monPath = member.getFullPath().toString();
            res = resourceSet.getResource(URI.createURI((String)("platform:/resource" + name)), true);
            EList ext = res.getContents();
            Iterator i = ext.iterator();
            while (i.hasNext()) {
                Object obj = i.next();
                if (!(obj instanceof TRCMonitor)) continue;
                childList.add(obj);
            }
        }
        catch (Exception e) {
            String msg = "Exception caught while loading " + member.getFullPath().toOSString() + " document: " + e;
            this.error = new Status(2, "org.eclipse.core.resources", 566, e.toString(), (Throwable)e);
            e.printStackTrace();
            return;
        }
    }

    protected Object[] getNodeProcesses(TRCNode node) {
        return this.getNodeProcesses0(node).toArray();
    }

    protected ArrayList getNodeProcesses0(TRCNode node) {
        ArrayList<TRCProcessProxy> list = new ArrayList<TRCProcessProxy>();
        try {
            Iterator i = node.getProcessProxies().iterator();
            while (i.hasNext()) {
                TRCProcessProxy process = (TRCProcessProxy)i.next();
                if (process.eIsProxy()) continue;
                list.add(process);
            }
        }
        catch (Exception exc) {
            return list;
        }
        return list;
    }

    public Object getParent(Object element) {
        return null;
    }

    protected Object[] getProcessAgents(TRCProcessProxy process) {
        return this.getProcessAgents0(process).toArray();
    }

    protected ArrayList getProcessAgents0(TRCProcessProxy process) {
        ArrayList<TRCAgentProxy> list = new ArrayList<TRCAgentProxy>();
        try {
            Object[] agents = process.getAgentProxies().toArray();
            int idx = 0;
            while (idx < agents.length) {
                TRCAgentProxy agent = (TRCAgentProxy)agents[idx];
                if (!agent.eIsProxy()) {
                    list.add(agent);
                }
                ++idx;
            }
        }
        catch (Exception exc) {
            return list;
        }
        return list;
    }

    public boolean hasChildren(Object element) {
        if (NavigatorExtensionUtil.hasChildren((Object)element, (String)"org.eclipse.hyades.trace.ui.profileNavigator")) {
            return true;
        }
        return this.getChildren(element).length > 0;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public boolean isDeleted(Object element) {
        if (element instanceof IResource) {
            return ((IResource)element).exists();
        }
        return false;
    }

    public static void removeContainer(IContainer container) {
        fMonitors.remove(container);
    }

    private void removeDoc(IContainer res) {
        PDContentProvider.removeContainer(res);
        try {
            DeleteUtil.deleteContainer(res, true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void removeMonitor(IContainer container, TRCMonitor monitor) {
        if (container == null) {
            return;
        }
        PDContentProvider.removeMonitor(container.getFullPath().toOSString(), monitor);
    }

    public static void removeMonitor(String strPath, TRCMonitor monitor) {
        Path path = new Path(strPath);
        IWorkspaceRoot root = UIPlugin.getPluginWorkbench().getRoot();
        IResource res = root.findMember((IPath)path);
        if (res == null) {
            return;
        }
        Object monitors = fMonitors.get(res);
        if (monitors == null) {
            return;
        }
        ((ArrayList)monitors).remove(monitor);
    }

    public static void resetMonitors() {
        fMonitors.clear();
    }

    public void resourceChanged(IResourceChangeEvent event) {
        IWorkspace workbench = UIPlugin.getPluginWorkbench();
        if (event.getType() == 1 && event.getSource() instanceof IWorkspace) {
            IResource resource = event.getResource();
            IResourceDelta delta = event.getDelta();
            try {
                ResourceDeltaVisitor visitor = new ResourceDeltaVisitor();
                delta.accept((IResourceDeltaVisitor)visitor);
            }
            catch (Exception exc) {
                exc.printStackTrace();
            }
            Control ctrl = this.fViewer.getControl();
            if (ctrl != null && !ctrl.isDisposed()) {
                ctrl.getDisplay().syncExec(new Runnable(){

                    public void run() {
                        PDContentProvider.this.fViewer.refresh();
                    }
                });
            }
        }
    }

    static /* synthetic */ Object[] access$102(PDContentProvider x0, Object[] x1) {
        x0.objList = x1;
        return x1;
    }

    class ResourceDeltaVisitor
    implements IResourceDeltaVisitor {
        ResourceDeltaVisitor() {
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            IResource resource = delta.getResource();
            if (resource.getType() == 8) {
                return true;
            }
            if (delta.getKind() == 2) {
                if (resource instanceof IContainer) {
                    PDContentProvider.this.removeDoc((IContainer)resource);
                }
                return true;
            }
            if (delta.getKind() == 1) {
                return false;
            }
            if (delta.getKind() == 4) {
                return true;
            }
            return true;
        }
    }
}

