/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.core;

import java.net.UnknownHostException;
import org.eclipse.hyades.internal.execution.local.control.Node;
import org.eclipse.hyades.internal.execution.local.control.NodeFactory;
import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.hyades.trace.internal.ui.PDPluginImages;
import org.eclipse.hyades.trace.ui.HyadesUtil;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.util.AbstractChangeable;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.help.WorkbenchHelp;

public class TraceHostUI
extends AbstractChangeable
implements SelectionListener,
ModifyListener {
    private Button _delete;
    private Button _add;
    private Button _testConnection;
    private Text _host;
    private Text _port;
    private Table _list;
    private WizardPage _wizardPage = null;

    public TraceHostUI(WizardPage wp) {
        this.setWizardPage(wp);
    }

    public TraceHostUI() {
    }

    public void addHost() {
        this.addHost(this._host.getText().trim() + ":" + this._port.getText().trim());
        this._host.setText("");
        this._port.setText(String.valueOf(10002));
        this._host.setFocus();
    }

    public void addHost(String text) {
        int idx = 0;
        while (idx < this._list.getItemCount()) {
            if (text.equals(this._list.getItem(idx).getText())) {
                return;
            }
            ++idx;
        }
        TableItem item = new TableItem(this._list, 0);
        item.setText(text);
        item.setImage(PDPluginImages.getImage("node_obj.gif"));
        this._list.setSelection(new TableItem[]{item});
    }

    private void addHosts(String hosts) {
        if (hosts != null && !hosts.equals("")) {
            int idx = 0;
            while (idx != -1) {
                idx = hosts.indexOf(",");
                if (idx != -1) {
                    String host = hosts.substring(0, idx);
                    this.addHost(host);
                    hosts = hosts.substring(idx + 1);
                    continue;
                }
                this.addHost(hosts);
            }
        }
    }

    public Composite createControl(Composite parent) {
        Composite result = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.verticalSpacing = 10;
        result.setLayout((Layout)layout);
        GridData data = GridUtil.createFill();
        result.setLayoutData((Object)data);
        Label desc = new Label(result, 0);
        data = GridUtil.createHorizontalFill();
        data.horizontalSpan = 2;
        desc.setLayoutData((Object)data);
        desc.setText(UIPlugin.getResourceString("STR_PREF_HOST_NODE"));
        Composite dataGroup = new Composite(result, 0);
        layout = new GridLayout();
        layout.numColumns = 1;
        layout.verticalSpacing = 10;
        dataGroup.setLayout((Layout)layout);
        data = GridUtil.createFill();
        dataGroup.setLayoutData((Object)data);
        this._list = new Table(dataGroup, 2304);
        data = GridUtil.createFill();
        this._list.setLayoutData((Object)data);
        Composite bottomWidget = new Composite(dataGroup, 0);
        data = new GridData();
        bottomWidget.setLayoutData((Object)GridUtil.createHorizontalFill());
        layout = new GridLayout();
        layout.numColumns = 2;
        bottomWidget.setLayout((Layout)layout);
        Label hostLabel = new Label(bottomWidget, 0);
        hostLabel.setText(UIPlugin.getResourceString("STR_PREF_HOST_IP"));
        this._host = new Text(bottomWidget, 2048);
        this._host.setLayoutData((Object)GridUtil.createHorizontalFill());
        Label portLabel = new Label(bottomWidget, 0);
        portLabel.setText(UIPlugin.getResourceString("RAC_PORT_TEXT"));
        this._port = new Text(bottomWidget, 2048);
        this._port.setLayoutData((Object)GridUtil.createHorizontalFill());
        this._port.setText(String.valueOf(10002));
        Composite buttonWidget = new Composite(result, 0);
        data = GridUtil.createVerticalFill();
        buttonWidget.setLayoutData((Object)data);
        layout = new GridLayout();
        layout.numColumns = 1;
        buttonWidget.setLayout((Layout)layout);
        Composite buttonWidget1 = new Composite(buttonWidget, 0);
        data = GridUtil.createFill();
        buttonWidget1.setLayoutData((Object)data);
        layout = new GridLayout();
        layout.numColumns = 1;
        buttonWidget1.setLayout((Layout)layout);
        this._delete = new Button(buttonWidget1, 0);
        this._delete.setLayoutData((Object)GridUtil.createHorizontalFill());
        this._delete.setText(UIPlugin.getResourceString("DELETE"));
        this._testConnection = new Button(buttonWidget1, 0);
        this._testConnection.setLayoutData((Object)GridUtil.createHorizontalFill());
        this._testConnection.setText(UIPlugin.getResourceString("TEST_CONNECTION_TEXT"));
        Label l = new Label(buttonWidget1, 0);
        l.setLayoutData((Object)GridUtil.createVerticalFill());
        Composite buttonWidget2 = new Composite(buttonWidget, 0);
        data = GridUtil.createHorizontalFill();
        buttonWidget2.setLayoutData((Object)data);
        layout = new GridLayout();
        layout.numColumns = 1;
        buttonWidget2.setLayout((Layout)layout);
        this._add = new Button(buttonWidget2, 0);
        this._add.setLayoutData((Object)GridUtil.createHorizontalFill());
        this._add.setText(UIPlugin.getResourceString("STR_PREF_ADD"));
        this._add.addSelectionListener((SelectionListener)this);
        this._delete.addSelectionListener((SelectionListener)this);
        this._testConnection.addSelectionListener((SelectionListener)this);
        this._list.addSelectionListener((SelectionListener)this);
        this._host.addModifyListener((ModifyListener)this);
        this._port.addModifyListener((ModifyListener)this);
        this._add.setEnabled(false);
        this._delete.setEnabled(false);
        this._testConnection.setEnabled(false);
        this.initializeValues();
        this._host.setFocus();
        this._host.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 4) {
                    if (TraceHostUI.this._host.getText().trim() == "" || TraceHostUI.this._port.getText().trim() == "") {
                        return;
                    }
                    TraceHostUI.this.addHost();
                    e.doit = false;
                    if (TraceHostUI.this._wizardPage != null) {
                        TraceHostUI.this._wizardPage.setPageComplete(TraceHostUI.this._list.getSelectionIndex() != -1);
                    }
                }
            }
        });
        WorkbenchHelp.setHelp((Control)this._list, (String)(UIPlugin.getPluginId() + ".hstp0001"));
        WorkbenchHelp.setHelp((Control)this._host, (String)(UIPlugin.getPluginId() + ".hstp0002"));
        WorkbenchHelp.setHelp((Control)this._delete, (String)(UIPlugin.getPluginId() + ".hstp0003"));
        WorkbenchHelp.setHelp((Control)this._add, (String)(UIPlugin.getPluginId() + ".hstp0004"));
        WorkbenchHelp.setHelp((Control)this._testConnection, (String)(UIPlugin.getPluginId() + ".hstp0005"));
        WorkbenchHelp.setHelp((Control)this._port, (String)(UIPlugin.getPluginId() + ".hstp0006"));
        return result;
    }

    public Table getListUI() {
        return this._list;
    }

    public Text getHostUI() {
        return this._host;
    }

    public Text getPortUI() {
        return this._port;
    }

    public Button getDeleteUI() {
        return this._delete;
    }

    public Button getAddUI() {
        return this._add;
    }

    public WizardPage getWizardPage() {
        return this._wizardPage;
    }

    public void setWizardPage(WizardPage wp) {
        this._wizardPage = wp;
    }

    private void deleteHost() {
        int i = this._list.getSelectionIndex();
        if (i != -1) {
            this._list.remove(i);
        }
    }

    private void testConnection() {
        BusyIndicator.showWhile(null, (Runnable)new Runnable(){

            public void run() {
                TableItem tblItem;
                String hosts;
                int i = TraceHostUI.this._list.getSelectionIndex();
                if (i != -1 && (hosts = (tblItem = TraceHostUI.this._list.getItem(i)).getText()) != null && !hosts.equals("")) {
                    int idx = 0;
                    idx = hosts.indexOf(":");
                    if (idx != -1) {
                        String host = hosts.substring(0, idx);
                        String port = hosts.substring(idx + 1);
                        HyadesUtil.testConnection(host, port, true, TraceHostUI.this._list.getShell());
                    }
                }
            }
        });
    }

    public String getHost() {
        String name = null;
        int idx = this._list.getSelectionIndex();
        if (idx == -1) {
            return name;
        }
        name = this._list.getItem(idx).getText();
        int id = name.indexOf(":");
        if (id != -1) {
            name = name.substring(0, id);
        }
        return name;
    }

    public int getPort() {
        int id;
        String port = String.valueOf(10002);
        int idx = this._list.getSelectionIndex();
        if (idx != -1) {
            port = this._list.getItem(idx).getText();
        }
        port = (id = port.indexOf(":")) != -1 ? port.substring(id + 1) : String.valueOf(10002);
        return Integer.parseInt(port);
    }

    public boolean isLocalHost(String hostname) {
        String name = "localhost";
        if (name.equals(hostname)) {
            return true;
        }
        try {
            Node fnode = NodeFactory.createNode((String)name);
            name = fnode.getInetAddress().getHostName();
        }
        catch (UnknownHostException exc) {
            return false;
        }
        return hostname.equals(name);
    }

    public TableItem[] getHosts() {
        return this._list.getItems();
    }

    private void initializeValues() {
        IPreferenceStore store = UIPlugin.getDefault().getPreferenceStore();
        String hosts = store.getString("use_host");
        this.addHosts(hosts);
        this.enableButtons();
    }

    public void modifyText(ModifyEvent e) {
        block4: {
            block3: {
                if (e.widget != this._host) break block3;
                this._add.setEnabled(!this._host.getText().trim().equals("") && !this._port.getText().trim().equals(""));
                break block4;
            }
            if (e.widget != this._port) break block4;
            try {
                int value = Integer.parseInt(this._port.getText().trim());
                if (value < 0 || value > 65535) {
                    this._add.setEnabled(false);
                    return;
                }
                this._add.setEnabled(!this._host.getText().trim().equals("") && !this._port.getText().trim().equals(""));
            }
            catch (NumberFormatException nfe) {
                this._add.setEnabled(false);
            }
        }
    }

    public void reset() {
        this._list.removeAll();
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        if (e.widget == this._list && this._wizardPage != null && this._wizardPage.getNextPage() != null) {
            this._wizardPage.getWizard().getContainer().showPage(this._wizardPage.getNextPage());
        }
    }

    private void enableButtons() {
        this._delete.setEnabled(this._list.getSelectionIndex() != -1);
        this._testConnection.setEnabled(this._list.getSelectionIndex() != -1 && this._list.getSelectionCount() == 1);
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.widget == this._add) {
            this.addHost();
            this.enableButtons();
            this.changed();
            if (this._wizardPage != null) {
                this._wizardPage.setPageComplete(this._list.getSelectionIndex() != -1);
            }
        } else if (e.widget == this._delete) {
            this.deleteHost();
            this.enableButtons();
            this.changed();
            if (this._wizardPage != null) {
                this._wizardPage.setPageComplete(this._list.getSelectionIndex() != -1);
            }
        } else if (e.widget == this._list) {
            TableItem[] selected = this._list.getSelection();
            this.enableButtons();
            this._list.setSelection(selected);
            this.changed();
            if (this._wizardPage != null) {
                this._wizardPage.setPageComplete(this._list.getSelectionIndex() != -1);
            }
        } else if (e.widget == this._testConnection) {
            this.testConnection();
            this.enableButtons();
            this._testConnection.setFocus();
        }
    }

    public void selectHost(String hostname) {
        int idx = 0;
        while (idx < this._list.getItemCount()) {
            if (hostname.equals(this._list.getItem(idx).getText())) {
                this._list.setSelection(idx);
                return;
            }
            ++idx;
        }
    }
}

