/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.core;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.hyades.trace.internal.ui.PDPluginImages;
import org.eclipse.hyades.trace.internal.ui.TraceConstants;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.util.AbstractChangeable;
import org.eclipse.hyades.trace.ui.internal.util.FilterElementModifier;
import org.eclipse.hyades.trace.ui.internal.util.FilterList;
import org.eclipse.hyades.trace.ui.internal.util.FilterListContentProvider;
import org.eclipse.hyades.trace.ui.internal.util.FilterListLabelProvider;
import org.eclipse.hyades.trace.ui.internal.util.FilterSetElement;
import org.eclipse.hyades.trace.ui.internal.util.FilterTableElement;
import org.eclipse.hyades.ui.internal.util.XMLUtil;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IBasicPropertyConstants;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.help.WorkbenchHelp;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class TraceProfileFiltersUI
extends AbstractChangeable
implements SelectionListener,
ICheckStateListener {
    private Composite _result;
    protected FilterList _filterList;
    protected FilterSetList _filterSetList;
    private Button _upBtn;
    private Button _downBtn;
    private Button _addBtn;
    private Button _editBtn;
    private Button _removeBtn;
    protected Table _table;
    protected CheckboxTableViewer _tableViewer;
    private static String[] tableColumnProperties = new String[]{"string", "method", "combo"};
    private Table _filterSetTable;
    private CheckboxTableViewer _filterSetTableViewer;
    private Button _addSetBtn;
    private Button _editSetBtn;
    private Button _removeSetBtn;
    private Label _contentLabel;
    private FilterSetElement _oldSelection;
    private String activeFS;
    private boolean agentTerminated = false;
    private static final String OPEN_FILTERS_TAG = "<filters>";
    private static final String CLOSE_FILTERS_TAG = "</filters>";
    private static final String OPEN_FILTER_TAG = "<filter";
    private static final String CLOSE_FILTER_TAG = "</filter>";
    private static final String FILTER_NAME_ATTRIBUTE = "name";
    private static final String FILTER_ENABLED_ATTRIBUTE = "enabled";
    private static final String OPEN_CONTENTS_TAG = "<contents>";
    private static final String CLOSE_CONTENTS_TAG = "</contents>";
    private static final String OPEN_CONTENT_TAG = "<content";
    private static final String CLOSE_CONTENT_TAG = "/>";
    private static final String CONTENT_TEXT_ATTRIBUTE = "text";
    private static final String CONTENT_METHOD_ATTRIBUTE = "method";
    private static final String CONTENT_VISIBILITY_ATTRIBUTE = "visibility";

    private void createColumns() {
        TableLayout layout = new TableLayout();
        this._table.setLayout((Layout)layout);
        this._table.setHeaderVisible(true);
        String[] headers = new String[]{UIPlugin.getResourceString("HEADER_FILTER"), UIPlugin.getResourceString("HEADER_METHOD"), UIPlugin.getResourceString("HEADER_VISIBILITY")};
        ColumnLayoutData[] layouts = new ColumnLayoutData[]{new ColumnPixelData(120, true), new ColumnPixelData(110, true), new ColumnPixelData(70, true)};
        TableColumn[] columns = new TableColumn[headers.length];
        boolean ncolumns = false;
        int i = 0;
        while (i < headers.length) {
            layout.addColumnData(layouts[i]);
            TableColumn tc = new TableColumn(this._table, 0, i);
            tc.setResizable(layouts[i].resizable);
            tc.setText(headers[i]);
            columns[i] = tc;
            ++i;
        }
    }

    public Composite createControl(Composite parent) {
        this._result = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.verticalSpacing = 0;
        this._result.setLayout((Layout)layout);
        GridData data = GridUtil.createFill();
        this._result.setLayoutData((Object)data);
        this.createFilterSet(this._result);
        this.createFilterContents(this._result);
        Label label = new Label(this._result, 0);
        label.setText(UIPlugin.getResourceString("STR_FILTER_NOTE"));
        data = new GridData();
        data.horizontalSpan = 2;
        label.setLayoutData((Object)data);
        return this._result;
    }

    private void createFilterContents(Composite parent) {
        Label label = new Label(parent, 0);
        GridData data = new GridData();
        data.horizontalSpan = 2;
        label.setLayoutData((Object)data);
        this._contentLabel = new Label(parent, 0);
        this._contentLabel.setText(UIPlugin.getResourceString("STR_FILTER_CONTENTS"));
        data = new GridData();
        data.horizontalSpan = 2;
        this._contentLabel.setLayoutData((Object)data);
        Composite tableGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        tableGroup.setLayout((Layout)layout);
        data = GridUtil.createFill();
        data.heightHint = 180;
        tableGroup.setLayoutData((Object)data);
        this.initializeTable(tableGroup);
        Composite btnGroup = new Composite(parent, 0);
        layout = new GridLayout();
        layout.numColumns = 1;
        btnGroup.setLayout((Layout)layout);
        btnGroup.setLayoutData((Object)GridUtil.createVerticalFill());
        Composite addGroup = new Composite(btnGroup, 0);
        layout = new GridLayout();
        layout.numColumns = 1;
        layout.makeColumnsEqualWidth = true;
        addGroup.setLayout((Layout)layout);
        addGroup.setLayoutData((Object)GridUtil.createVerticalFill());
        this._addBtn = new Button(addGroup, 8);
        this._addBtn.setText(UIPlugin.getResourceString("ADD_FILTER_TEXT1"));
        this._addBtn.setToolTipText(UIPlugin.getResourceString("ADD_FILTER_TOOLTIP_TEXT"));
        this._addBtn.setLayoutData((Object)GridUtil.createHorizontalFill());
        this._editBtn = new Button(addGroup, 8);
        this._editBtn.setText(UIPlugin.getResourceString("STR_EDIT_FILTER_BTN1"));
        this._editBtn.setToolTipText(UIPlugin.getResourceString("EDIT_FILTER_TOOLTIP_TEXT"));
        this._editBtn.setLayoutData((Object)GridUtil.createHorizontalFill());
        this._removeBtn = new Button(addGroup, 8);
        this._removeBtn.setText(UIPlugin.getResourceString("REMOVE_TEXT1"));
        this._removeBtn.setToolTipText(UIPlugin.getResourceString("REMOVE_TOOLTIP_TEXT"));
        this._removeBtn.setLayoutData((Object)GridUtil.createHorizontalFill());
        Composite moveGroup = new Composite(btnGroup, 0);
        layout = new GridLayout();
        layout.numColumns = 1;
        layout.makeColumnsEqualWidth = true;
        moveGroup.setLayout((Layout)layout);
        moveGroup.setLayoutData((Object)GridUtil.createHorizontalFill());
        this._upBtn = new Button(moveGroup, 8);
        this._upBtn.setText(UIPlugin.getResourceString("MOVEUP_TEXT"));
        this._upBtn.setToolTipText(UIPlugin.getResourceString("MOVEUP_TOOLTIP_TEXT"));
        this._upBtn.setLayoutData((Object)GridUtil.createHorizontalFill());
        this._downBtn = new Button(moveGroup, 8);
        this._downBtn.setText(UIPlugin.getResourceString("MOVEDOWN_TEXT"));
        this._downBtn.setToolTipText(UIPlugin.getResourceString("MOVEDOWN_TOOLTIP_TEXT"));
        this._downBtn.setLayoutData((Object)GridUtil.createHorizontalFill());
        this._editBtn.setEnabled(false);
        this._removeBtn.setEnabled(false);
        this._upBtn.setEnabled(false);
        this._downBtn.setEnabled(false);
        this._removeBtn.addSelectionListener((SelectionListener)this);
        this._upBtn.addSelectionListener((SelectionListener)this);
        this._downBtn.addSelectionListener((SelectionListener)this);
        this._addBtn.addSelectionListener((SelectionListener)this);
        this._editBtn.addSelectionListener((SelectionListener)this);
        this._table.addSelectionListener((SelectionListener)this);
        WorkbenchHelp.setHelp((Control)this._table, (String)(UIPlugin.getPluginId() + ".pfpp0002"));
    }

    private void createFilterSet(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(UIPlugin.getResourceString("STR_SELECT_FILTER_SET"));
        GridData data = new GridData();
        data.horizontalSpan = 2;
        label.setLayoutData((Object)data);
        Composite tableGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        tableGroup.setLayout((Layout)layout);
        data = GridUtil.createFill();
        data.heightHint = 100;
        tableGroup.setLayoutData((Object)data);
        this._filterSetTable = new Table(tableGroup, 68132);
        this._filterSetTable.setLinesVisible(false);
        this._filterSetTable.setLayoutData((Object)GridUtil.createFill());
        this._filterSetTableViewer = new CheckboxTableViewer(this._filterSetTable);
        this._filterSetTableViewer.setContentProvider((IContentProvider)new FilterSetContentProvider(this._filterSetTableViewer));
        this._filterSetTableViewer.setLabelProvider((IBaseLabelProvider)new FilterSetLabelProvider());
        this._filterSetList = new FilterSetList((TableViewer)this._filterSetTableViewer);
        this._filterSetTableViewer.setInput((Object)this._filterSetList);
        this._filterSetTableViewer.addCheckStateListener((ICheckStateListener)this);
        TableLayout layoutt = new TableLayout();
        this._filterSetTable.setLayout((Layout)layoutt);
        ColumnPixelData l = new ColumnPixelData(420, true);
        layoutt.addColumnData((ColumnLayoutData)l);
        TableColumn tc = new TableColumn(this._filterSetTable, 0, 0);
        tc.setResizable(l.resizable);
        Composite btnGroup = new Composite(parent, 0);
        layout = new GridLayout();
        layout.numColumns = 1;
        btnGroup.setLayout((Layout)layout);
        btnGroup.setLayoutData((Object)GridUtil.createVerticalFill());
        Composite addGroup = new Composite(btnGroup, 0);
        layout = new GridLayout();
        layout.numColumns = 1;
        layout.makeColumnsEqualWidth = true;
        addGroup.setLayout((Layout)layout);
        addGroup.setLayoutData((Object)GridUtil.createVerticalFill());
        this._addSetBtn = new Button(addGroup, 8);
        this._addSetBtn.setText(UIPlugin.getResourceString("ADD_FILTER_TEXT"));
        this._addSetBtn.setToolTipText(UIPlugin.getResourceString("ADD_FILTER_TOOLTIP_TEXT"));
        this._addSetBtn.setLayoutData((Object)GridUtil.createHorizontalFill());
        this._editSetBtn = new Button(addGroup, 8);
        this._editSetBtn.setText(UIPlugin.getResourceString("STR_EDIT_SET_BTN"));
        this._editSetBtn.setToolTipText(UIPlugin.getResourceString("EDIT_SET_TOOLTIP_TEXT"));
        this._editSetBtn.setLayoutData((Object)GridUtil.createHorizontalFill());
        this._removeSetBtn = new Button(addGroup, 8);
        this._removeSetBtn.setText(UIPlugin.getResourceString("REMOVE_TEXT"));
        this._removeSetBtn.setToolTipText(UIPlugin.getResourceString("REMOVE_TOOLTIP_TEXT"));
        this._removeSetBtn.setLayoutData((Object)GridUtil.createHorizontalFill());
        this._editSetBtn.setEnabled(false);
        this._removeSetBtn.setEnabled(false);
        this._removeSetBtn.addSelectionListener((SelectionListener)this);
        this._addSetBtn.addSelectionListener((SelectionListener)this);
        this._editSetBtn.addSelectionListener((SelectionListener)this);
        this._filterSetTable.addSelectionListener((SelectionListener)this);
        WorkbenchHelp.setHelp((Control)this._filterSetTable, (String)(UIPlugin.getPluginId() + ".pfps0001"));
    }

    private void createTable(Composite parent) {
        this._table = new Table(parent, 68354);
        this._table.setLinesVisible(true);
        this._table.setLayoutData((Object)GridUtil.createFill());
    }

    public void enable(boolean enable) {
        this._addSetBtn.setEnabled(enable);
        this._removeSetBtn.setEnabled(enable);
        this._editSetBtn.setEnabled(enable);
        this._filterSetTable.setEnabled(enable);
        this._filterSetTableViewer.getTable().setEnabled(enable);
        this._addBtn.setEnabled(enable);
        this._removeBtn.setEnabled(enable);
        this._editBtn.setEnabled(enable);
        this._upBtn.setEnabled(enable);
        this._downBtn.setEnabled(enable);
        if (!enable) {
            this._tableViewer.setCellEditors(null);
            this._tableViewer.setCellModifier(null);
        }
    }

    protected void enableButtons() {
        if (this.isAgentTerminated()) {
            this.enable(false);
            return;
        }
        int selection = this._table.getSelectionIndex();
        int selectionCount = this._table.getSelectionCount();
        this._removeBtn.setEnabled(this._filterList.getSize() > 0 && selection != -1);
        this._editBtn.setEnabled(this._filterList.getSize() > 0 && selection != -1);
        this._upBtn.setEnabled(selection > 0 && selectionCount == 1);
        this._downBtn.setEnabled(selection >= 0 && selection < this._table.getItemCount() - 1 && selectionCount == 1);
        selection = this._filterSetTable.getSelectionIndex();
        this._removeSetBtn.setEnabled(this._filterSetList.getSize() > 1 && selection != -1);
        this._editSetBtn.setEnabled(this._filterSetList.getSize() > 0 && selection != -1);
    }

    public ArrayList getFilterSet() {
        if (this._oldSelection != null) {
            this._oldSelection.setChildren((ArrayList)this._filterList.getFilters().clone());
        }
        this.validateFilterSet(this._filterSetList);
        return this._filterSetList.getFilters();
    }

    public static String getFilterSet(ArrayList list) {
        StringBuffer temp = new StringBuffer();
        int i = 0;
        while (i < list.size()) {
            temp.append(OPEN_FILTER_TAG);
            FilterSetElement elem = (FilterSetElement)list.get(i);
            temp.append(" name = '" + elem.getName() + "'>");
            ArrayList children = elem.getChildren();
            temp.append(OPEN_CONTENTS_TAG);
            int j = 0;
            while (j < children.size()) {
                temp.append(OPEN_CONTENT_TAG);
                FilterTableElement childElem = (FilterTableElement)children.get(j);
                temp.append(" text = '" + childElem.getText() + "'");
                temp.append(" method = '" + childElem.getMethod() + "'");
                temp.append(" visibility = '" + childElem.getVisibility() + "'");
                temp.append(CLOSE_CONTENT_TAG);
                ++j;
            }
            temp.append(CLOSE_CONTENTS_TAG);
            temp.append(CLOSE_FILTER_TAG);
            ++i;
        }
        return temp.toString();
    }

    private void validateFilterSet(FilterSetList filterSet) {
        boolean hasIncludeFilterOnly = true;
        ArrayList filters = filterSet.getFilters();
        int idx = 0;
        while (idx < filters.size()) {
            FilterSetElement set = (FilterSetElement)filters.get(idx);
            ArrayList elements = set.getChildren();
            boolean addExcludeFilter = true;
            int i = 0;
            while (i < elements.size()) {
                FilterTableElement elem = (FilterTableElement)elements.get(i);
                if (elem.getVisibility().equals(UIPlugin.getResourceString("STR_EXCLUDE"))) {
                    addExcludeFilter = false;
                    break;
                }
                if (elem.getText().equals("*")) {
                    addExcludeFilter = false;
                    break;
                }
                ++i;
            }
            if (elements.size() > 0 && addExcludeFilter) {
                elements.add(new FilterTableElement("*", "*", UIPlugin.getResourceString("STR_EXCLUDE")));
                set.setChildren(elements);
            }
            ++idx;
        }
    }

    protected void initializeTable(Composite parent) {
        this.createTable(parent);
        this._tableViewer = new CheckboxTableViewer(this._table);
        this.createColumns();
        this._tableViewer.setContentProvider((IContentProvider)new FilterListContentProvider(this._tableViewer));
        this._tableViewer.setLabelProvider((IBaseLabelProvider)new FilterListLabelProvider());
        this._filterList = new FilterList((TableViewer)this._tableViewer);
        this._tableViewer.setInput((Object)this._filterList);
        CellEditor[] editors = new CellEditor[this._table.getColumnCount()];
        editors[0] = new TextCellEditor((Composite)this._table);
        editors[1] = new TextCellEditor((Composite)this._table);
        editors[2] = new ComboBoxCellEditor((Composite)this._table, FilterTableElement.getVisibilityStates());
        this._tableViewer.setCellEditors(editors);
        FilterElementModifier modifier = new FilterElementModifier(this._tableViewer);
        this._tableViewer.setCellModifier((ICellModifier)modifier);
        this._tableViewer.setColumnProperties(tableColumnProperties);
    }

    public static ArrayList getFiltersSet(String filters) {
        Element prefElement = XMLUtil.loadDom((String)filters, (String)"filters");
        return TraceProfileFiltersUI.getFiltersSet(prefElement);
    }

    public static ArrayList getFiltersSet(Element filters) {
        ArrayList<FilterSetElement> list = new ArrayList<FilterSetElement>();
        NodeList nodeList = filters.getChildNodes();
        int i = 0;
        while (i < nodeList.getLength()) {
            Element elem = (Element)nodeList.item(i);
            FilterSetElement fse = new FilterSetElement(elem.getAttribute(FILTER_NAME_ATTRIBUTE));
            ArrayList children = TraceProfileFiltersUI.getFilter(elem);
            fse.setChildren(children);
            list.add(fse);
            ++i;
        }
        return list;
    }

    private void setXMLFilterSet(Element filters) {
        ArrayList list = TraceProfileFiltersUI.getFiltersSet(filters);
        int idx = 0;
        while (idx < list.size()) {
            this.addFilterSet((FilterSetElement)list.get(idx));
            ++idx;
        }
        this.selectTableItem(this._filterSetTable, 0);
    }

    public void setFilterSet(String filters) {
        Element prefElement = XMLUtil.loadDom((String)filters, (String)"filters");
        this.setXMLFilterSet(prefElement);
    }

    public void setFilterSet(Element filters) {
        this.setXMLFilterSet(filters);
    }

    private void addFilterSet(String name, ArrayList children) {
        FilterSetElement elem = new FilterSetElement(name);
        this.addFilterSet(elem);
    }

    public void addFilterSet(FilterSetElement elem) {
        this._filterSetList.add(elem);
        this._filterSetTableViewer.refresh();
        this._filterSetTableViewer.setChecked((Object)elem, false);
    }

    public void reset() {
        this.activeFS = null;
        this._oldSelection = null;
        this._table.removeAll();
        this._filterList.removeAll();
        this._filterSetList.removeAll();
        this._filterSetTableViewer.refresh();
    }

    protected void selectTableItem(Table table, int selection) {
        table.setFocus();
        table.setSelection(selection);
        table.showSelection();
        if (table == this._filterSetTable) {
            this.showFiltersForSelection((FilterSetElement)this._filterSetList.getElementAt(selection));
        }
    }

    private void showFiltersForSelection(FilterSetElement elem) {
        if (this._oldSelection != null) {
            this._oldSelection.setChildren((ArrayList)this._filterList.getFilters().clone());
        }
        this._table.setRedraw(false);
        this._filterList.removeAll();
        ArrayList list = elem.getChildren();
        int idx = 0;
        while (idx < list.size()) {
            FilterTableElement filter = (FilterTableElement)list.get(idx);
            filter.setParent(this._filterList);
            this._filterList.add(filter, this._filterList.getSize());
            this._tableViewer.refresh();
            ++idx;
        }
        this._tableViewer.refresh();
        this._oldSelection = elem;
        this._table.setRedraw(true);
    }

    public void widgetDefaultSelected(SelectionEvent event) {
    }

    public void widgetSelected(SelectionEvent event) {
        if (event.widget == this._addSetBtn) {
            this.showWSetDialog(UIPlugin.getResourceString("STR_ADD_SET_DLG"), null);
            this.enableButtons();
            return;
        }
        if (event.widget == this._editSetBtn) {
            int idx = this._filterSetTable.getSelectionIndex();
            if (idx != -1) {
                this.showWSetDialog(UIPlugin.getResourceString("STR_EDIT_SET_DLG"), this._filterSetTable.getItem(idx).getText());
            }
            return;
        }
        if (event.widget == this._removeSetBtn) {
            int selection = this._filterSetTable.getSelectionIndex();
            if (selection != -1) {
                boolean select = false;
                if (this._filterSetTable.getItem(selection).getChecked()) {
                    select = true;
                }
                this._filterSetList.removeElementAt(selection);
                if (select) {
                    FilterSetElement elem = (FilterSetElement)this._filterSetList.getElementAt(0);
                    this.activeFS = elem.getName();
                    this._filterSetTableViewer.setChecked((Object)elem, true);
                }
                this._filterSetTableViewer.refresh();
                this.selectTableItem(this._filterSetTable, 0);
            }
            this.enableButtons();
            return;
        }
        if (event.widget == this._addBtn) {
            this.showEditDialog(UIPlugin.getResourceString("STR_ADD_FILTER_DLG"), null, "*", null);
            this.enableButtons();
        } else if (event.widget == this._editBtn) {
            int idx = this._table.getSelectionIndex();
            if (idx != -1) {
                FilterTableElement sel = (FilterTableElement)this._filterList.getElementAt(idx);
                String filter = sel.getText();
                String method = sel.getMethod();
                String vis = sel.getVisibility();
                this.showEditDialog(UIPlugin.getResourceString("STR_EDIT_FILTER_DLG"), filter, method, vis);
            }
        } else {
            if (event.widget == this._table) {
                this.enableButtons();
                return;
            }
            if (event.widget == this._filterSetTable) {
                int idx = this._filterSetTable.getSelectionIndex();
                if (idx != -1) {
                    FilterSetElement elem1 = (FilterSetElement)this._filterSetList.getElementAt(idx);
                    this.showFiltersForSelection(elem1);
                    this._filterSetTableViewer.setChecked((Object)elem1, true);
                    this.activeFS = elem1.getName();
                    int kdx = 0;
                    while (kdx < this._filterSetList.getSize()) {
                        if (kdx != idx) {
                            FilterSetElement elem2 = (FilterSetElement)this._filterSetList.getElementAt(kdx);
                            this._filterSetTableViewer.setChecked((Object)elem2, false);
                        }
                        ++kdx;
                    }
                    this._filterSetTableViewer.refresh();
                }
                this.enableButtons();
                return;
            }
            if (event.widget == this._removeBtn) {
                int selection = this._table.getSelectionIndex();
                this._filterList.removeElements(this._table.getSelectionIndices());
                this._tableViewer.refresh();
                int size = this._filterList.getSize();
                if (size > 0) {
                    if (selection > 0 && selection < size) {
                        this.selectTableItem(this._table, selection - 1);
                    } else {
                        this.selectTableItem(this._table, 0);
                    }
                }
                this.enableButtons();
            } else if (event.widget == this._upBtn) {
                this._tableViewer.refresh();
                int selection = this._table.getSelectionIndex();
                if (selection > 0) {
                    FilterTableElement sel = (FilterTableElement)this._filterList.getElementAt(selection);
                    FilterTableElement previous = (FilterTableElement)this._filterList.getElementAt(selection - 1);
                    String filter = sel.getText();
                    String method = sel.getMethod();
                    String vis = sel.getVisibility();
                    sel.setText(previous.getText());
                    sel.setMethod(previous.getMethod());
                    previous.setText(filter);
                    previous.setMethod(method);
                    sel.setVisibility(previous.getVisibility());
                    previous.setVisibility(vis);
                    this.selectTableItem(this._table, selection - 1);
                }
                this._tableViewer.refresh();
                this.enableButtons();
            } else if (event.widget == this._downBtn) {
                this._tableViewer.refresh();
                int selection = this._table.getSelectionIndex();
                if (selection < this._table.getItemCount() - 1) {
                    FilterTableElement sel = (FilterTableElement)this._filterList.getElementAt(selection);
                    FilterTableElement next = (FilterTableElement)this._filterList.getElementAt(selection + 1);
                    String filter = sel.getText();
                    String method = sel.getMethod();
                    String vis = sel.getVisibility();
                    sel.setText(next.getText());
                    sel.setMethod(next.getMethod());
                    next.setText(filter);
                    next.setMethod(method);
                    sel.setVisibility(next.getVisibility());
                    next.setVisibility(vis);
                    this.selectTableItem(this._table, selection + 1);
                }
                this._tableViewer.refresh();
                this.enableButtons();
            }
        }
    }

    private void showEditDialog(String title, String clas, String method, String rule) {
        EditDialog dialog = new EditDialog(this._result.getShell(), title, clas, method, rule);
        dialog.open();
        if (dialog.getReturnCode() == 0) {
            if (clas == null) {
                FilterTableElement elem = new FilterTableElement(dialog.clas(), dialog.method(), dialog.rule());
                if (dialog.rule().equals(UIPlugin.getResourceString("STR_EXCLUDE"))) {
                    this._filterList.add(elem, this._filterList.getSize());
                } else {
                    this._filterList.add(elem, 0);
                }
                elem.setParent(this._filterList);
                this._tableViewer.refresh();
                if (dialog.rule().equals(UIPlugin.getResourceString("STR_EXCLUDE"))) {
                    this.selectTableItem(this._table, this._filterList.getSize() - 1);
                } else {
                    this.selectTableItem(this._table, 0);
                }
            } else {
                int idx = this._table.getSelectionIndex();
                if (idx != -1) {
                    FilterTableElement sel = (FilterTableElement)this._filterList.getElementAt(idx);
                    sel.setText(dialog.clas());
                    sel.setMethod(dialog.method());
                    sel.setVisibility(dialog.rule());
                    this._tableViewer.refresh();
                }
            }
        }
    }

    private void showWSetDialog(String title, String name) {
        EditWSetDialog dialog = new EditWSetDialog(this._result.getShell(), title, name);
        dialog.open();
        if (dialog.getReturnCode() == 0) {
            if (name == null) {
                int idx = 0;
                while (idx < this._filterSetList.getSize()) {
                    FilterSetElement el = (FilterSetElement)this._filterSetList.getElementAt(idx);
                    if (el.getName().equals(dialog._name)) {
                        this.selectTableItem(this._filterSetTable, idx);
                        return;
                    }
                    ++idx;
                }
                FilterSetElement elem = new FilterSetElement(dialog._name);
                String filters = TraceConstants.DEFAULT_FILTER_SET;
                Element prefElement = XMLUtil.loadDom((String)filters, (String)"filters");
                ArrayList list = TraceProfileFiltersUI.getFiltersSet(prefElement);
                if (list.size() > 0) {
                    FilterSetElement set = (FilterSetElement)list.get(0);
                    elem.setChildren((ArrayList)set.getChildren().clone());
                }
                this.addFilterSet(elem);
                this.setActiveFilterSet(elem);
            } else {
                int idx = this._filterSetTable.getSelectionIndex();
                if (idx != -1) {
                    ((FilterSetElement)this._filterSetList.getElementAt(idx)).setName(dialog._name);
                    this._filterSetTableViewer.refresh((Object)((FilterSetElement)this._filterSetList.getElementAt(idx)));
                    this.setActiveFilterSet((FilterSetElement)this._filterSetList.getElementAt(idx));
                }
            }
        }
    }

    private static ArrayList getFilter(Element elem) {
        ArrayList<FilterTableElement> list = new ArrayList<FilterTableElement>();
        Element contents = (Element)elem.getFirstChild();
        NodeList contentList = contents.getChildNodes();
        int i = 0;
        while (i < contentList.getLength()) {
            Element temp = (Element)contentList.item(i);
            FilterTableElement fte = temp.getAttribute(CONTENT_VISIBILITY_ATTRIBUTE).equals("0") || temp.getAttribute(CONTENT_VISIBILITY_ATTRIBUTE).equals("EXCLUDE") ? new FilterTableElement(temp.getAttribute(CONTENT_TEXT_ATTRIBUTE), temp.getAttribute(CONTENT_METHOD_ATTRIBUTE), "EXCLUDE") : new FilterTableElement(temp.getAttribute(CONTENT_TEXT_ATTRIBUTE), temp.getAttribute(CONTENT_METHOD_ATTRIBUTE), "INCLUDE");
            list.add(fte);
            ++i;
        }
        return list;
    }

    private static void getFilter(FilterSetElement elem, String filterList) {
        ArrayList<FilterTableElement> list = new ArrayList<FilterTableElement>();
        int idx = filterList.indexOf("#");
        while (idx != -1) {
            String filter = filterList.substring(0, idx);
            filterList = filterList.substring(idx + 1);
            idx = filter.indexOf("!");
            String text = filter.substring(0, idx);
            filter = filter.substring(idx + 1);
            idx = filter.indexOf("!");
            String method = filter.substring(0, idx);
            String include = (filter = filter.substring(idx + 1)).equals("0") ? UIPlugin.getResourceString("STR_EXCLUDE") : UIPlugin.getResourceString("STR_INCLUDE");
            FilterTableElement filterElem = new FilterTableElement(text, method, include);
            list.add(filterElem);
            idx = filterList.indexOf("#");
        }
        if (!filterList.equals("")) {
            idx = filterList.indexOf("!");
            String text = filterList.substring(0, idx);
            filterList = filterList.substring(idx + 1);
            idx = filterList.indexOf("!");
            String method = filterList.substring(0, idx);
            String include = (filterList = filterList.substring(idx + 1)).equals("0") ? UIPlugin.getResourceString("STR_EXCLUDE") : UIPlugin.getResourceString("STR_INCLUDE");
            FilterTableElement filterElem = new FilterTableElement(text, method, include);
            list.add(filterElem);
        }
        elem.setChildren(list);
    }

    public void checkStateChanged(CheckStateChangedEvent event) {
        FilterSetElement elem = (FilterSetElement)event.getElement();
        int i = 0;
        while (i < this._filterSetList.getSize()) {
            FilterSetElement data = (FilterSetElement)this._filterSetList.getElementAt(i);
            if (data == elem && this._filterSetTableViewer.getChecked((Object)data)) {
                this._filterSetTable.setSelection(i);
            }
            ++i;
        }
        this._filterSetTableViewer.refresh();
    }

    public static void storeValues(ArrayList items) {
        String filters = "";
        IPreferenceStore store = UIPlugin.getDefault().getPreferenceStore();
        store.setValue("set_filters", OPEN_FILTERS_TAG + TraceProfileFiltersUI.getFilterSet(items) + CLOSE_FILTERS_TAG);
    }

    public boolean isAgentTerminated() {
        return this.agentTerminated;
    }

    public void setAgentTerminated(boolean agentTerminated) {
        this.agentTerminated = agentTerminated;
    }

    public void removeFilterSet(int idx) {
        if (idx < 0 || idx > this._filterSetList.getSize()) {
            return;
        }
        this._filterSetList.removeElementAt(idx);
    }

    public void alterFilterSetChildren(FilterSetElement elem, ArrayList children) {
        elem.setChildren(children);
    }

    public String getActiveFilterSet() {
        return this.activeFS;
    }

    public void setActiveFilterSet(FilterSetElement set) {
        this.activeFS = set.getName();
        this._filterSetTableViewer.setCheckedElements(new Object[]{set});
        this._filterSetTableViewer.setSelection((ISelection)new StructuredSelection((Object)set));
        this.showFiltersForSelection(set);
        this._filterSetTableViewer.refresh();
    }

    public void addFilterSets(FilterSetElement[] list) {
        int idx = 0;
        while (idx < list.length) {
            this.addFilterSet(list[idx]);
            ++idx;
        }
    }

    class EditWSetDialog
    extends Dialog
    implements ModifyListener {
        private String _name;
        private Text _nameText;
        private String _title;

        public EditWSetDialog(Shell shell, String title, String name) {
            super(shell);
            this._name = name;
            this._title = title;
        }

        protected void configureShell(Shell shell) {
            super.configureShell(shell);
            shell.setText(this._title);
        }

        protected Control createDialogArea(Composite parent) {
            Composite result = (Composite)super.createDialogArea(parent);
            GridLayout layout = new GridLayout();
            layout.numColumns = 2;
            result.setLayout((Layout)layout);
            GridData data = GridUtil.createFill();
            data.widthHint = 400;
            result.setLayoutData((Object)data);
            Label label = new Label(result, 0);
            label.setText(UIPlugin.getResourceString("STR_FILTER_SET_NAME"));
            this._nameText = new Text(result, 2048);
            this._nameText.setLayoutData((Object)GridUtil.createHorizontalFill());
            this._nameText.addModifyListener((ModifyListener)this);
            if (this._name != null) {
                this._nameText.setText(this._name);
            }
            return result;
        }

        public void modifyText(ModifyEvent e) {
            if (e.widget == this._nameText && this.getButton(0) != null) {
                this.getButton(0).setEnabled(this._nameText.getText().trim().length() > 0);
            }
        }

        protected void okPressed() {
            this._name = this._nameText.getText().trim();
            super.okPressed();
        }

        protected Control createContents(Composite parent) {
            Control result = super.createContents(parent);
            this.getButton(0).setEnabled(this._nameText.getText().trim().length() > 0);
            return result;
        }
    }

    class EditDialog
    extends Dialog
    implements ModifyListener {
        private String _class = "mypackage.*";
        private String _method;
        private String _rule;
        private Text _classText;
        private Text _methodText;
        private Combo _ruleText;
        private String _title;

        public EditDialog(Shell shell, String title, String clas, String method, String rule) {
            super(shell);
            if (clas != null) {
                this._class = clas;
            }
            this._method = method;
            this._rule = rule;
            this._title = title;
        }

        protected void configureShell(Shell shell) {
            super.configureShell(shell);
            shell.setText(this._title);
        }

        public void clas(String clas) {
            this._class = clas;
        }

        public String clas() {
            return this._class;
        }

        public void method(String method) {
            this._method = method;
        }

        public String method() {
            return this._method;
        }

        public void rule(String rule) {
            this._rule = rule;
        }

        public String rule() {
            return this._rule;
        }

        protected Control createDialogArea(Composite parent) {
            Composite result = (Composite)super.createDialogArea(parent);
            GridLayout layout = new GridLayout();
            layout.numColumns = 2;
            result.setLayout((Layout)layout);
            GridData data = GridUtil.createFill();
            data.widthHint = 400;
            result.setLayoutData((Object)data);
            Label label = new Label(result, 0);
            label.setText(UIPlugin.getResourceString("HEADER_FILTER"));
            this._classText = new Text(result, 2048);
            this._classText.setLayoutData((Object)GridUtil.createHorizontalFill());
            label = new Label(result, 0);
            label.setText(UIPlugin.getResourceString("HEADER_METHOD"));
            this._methodText = new Text(result, 2048);
            this._methodText.setLayoutData((Object)GridUtil.createHorizontalFill());
            label = new Label(result, 0);
            label.setText(UIPlugin.getResourceString("HEADER_VISIBILITY"));
            this._ruleText = new Combo(result, 2056);
            this._ruleText.setLayoutData((Object)GridUtil.createHorizontalFill());
            this._ruleText.add(UIPlugin.getResourceString("STR_EXCLUDE"));
            this._ruleText.add(UIPlugin.getResourceString("STR_INCLUDE"));
            this._classText.addModifyListener((ModifyListener)this);
            this._methodText.addModifyListener((ModifyListener)this);
            this._ruleText.select(1);
            if (this._class != null) {
                this._classText.setText(this._class);
            }
            if (this._method != null) {
                this._methodText.setText(this._method);
            }
            if (this._rule != null) {
                this._ruleText.setText(this._rule);
            }
            this._classText.setFocus();
            this._classText.selectAll();
            return result;
        }

        public void modifyText(ModifyEvent e) {
            if ((e.widget == this._classText || e.widget == this._methodText) && this.getButton(0) != null) {
                this.getButton(0).setEnabled(this._classText.getText().trim() != "" || this._methodText.getText().trim() != "");
            }
        }

        protected void okPressed() {
            this._class = this._classText.getText().trim();
            this._method = this._methodText.getText().trim();
            this._rule = this._ruleText.getText();
            super.okPressed();
        }
    }

    public class FilterSetList
    implements IBasicPropertyConstants {
        ArrayList filters = new ArrayList();
        TableViewer fViewer;
        private ArrayList listeners;

        public FilterSetList(TableViewer viewer) {
            this.fViewer = viewer;
        }

        public void add(FilterSetElement element) {
            this.add(element, -1);
        }

        public void add(FilterSetElement element, int index) {
            if (index < 0) {
                this.filters.add(element);
            } else {
                this.filters.add(index, element);
            }
        }

        public void addElementChangedListener(FilterSetContentProvider newListener) {
            if (newListener == null) {
                return;
            }
            if (this.listeners == null) {
                this.listeners = new ArrayList();
            }
            if (!this.listeners.contains(newListener)) {
                this.listeners.add(newListener);
            }
        }

        public Object[] elements() {
            return this.filters.toArray();
        }

        public void fireElementChanged(FilterSetElement changedElement, String changedProperty) {
            if (this.listeners != null) {
                Iterator e = this.listeners.iterator();
                while (e.hasNext()) {
                    FilterSetContentProvider l = (FilterSetContentProvider)e.next();
                    l.elementChanged(changedElement, changedProperty);
                }
            }
        }

        public Object getElementAt(int index) {
            return this.filters.get(index);
        }

        public ArrayList getFilters() {
            return (ArrayList)this.filters.clone();
        }

        public int getSize() {
            return this.filters.size();
        }

        public void removeAll() {
            this.filters.clear();
        }

        public Object removeElementAt(int idx) {
            Object element = this.filters.get(idx);
            if (element == null) {
                return null;
            }
            this.filters.remove(element);
            return element;
        }

        public void removeElementChangedListener(FilterSetContentProvider listener) {
            if (this.listeners != null) {
                this.listeners.remove(listener);
            }
        }

        public Object[] uiElements() {
            return this.filters.toArray();
        }
    }

    class FilterSetContentProvider
    implements IStructuredContentProvider {
        private CheckboxTableViewer fViewer;
        protected FilterSetElement fChangedElement;

        public FilterSetContentProvider(CheckboxTableViewer tableViewer) {
            this.fViewer = tableViewer;
        }

        public void dispose() {
        }

        public void elementChanged(FilterSetElement changedElement, String changedProperty) {
            this.fChangedElement = changedElement;
            this.fViewer.getControl().getDisplay().asyncExec(new Runnable(this){
                private final /* synthetic */ FilterSetContentProvider this$1;
                {
                    this.this$1 = this$1;
                }

                public void run() {
                    FilterSetContentProvider.access$000(this.this$1).refresh((Object)this.this$1.fChangedElement);
                }
            });
        }

        public Object[] getElements(Object parent) {
            return ((FilterSetList)parent).elements();
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.fViewer = (CheckboxTableViewer)viewer;
            if (oldInput != null && oldInput instanceof FilterList) {
                ((FilterSetList)oldInput).removeElementChangedListener(this);
            }
            if (newInput != null && newInput instanceof FilterList) {
                ((FilterSetList)newInput).addElementChangedListener(this);
            }
        }

        public boolean isDeleted(Object element) {
            return false;
        }

        static /* synthetic */ CheckboxTableViewer access$000(FilterSetContentProvider x0) {
            return x0.fViewer;
        }
    }

    public class FilterSetLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        public Image getColumnImage(Object element, int columnIndex) {
            return PDPluginImages.getImage("filter_obj.gif");
        }

        public Image getColumnImage(Viewer viewer, Object element, int columnIndex) {
            return PDPluginImages.getImage("filter_obj.gif");
        }

        public String getColumnText(Object element, int columnIndex) {
            return ((FilterSetElement)element).getName();
        }

        public String getColumnText(Viewer viewer, Object element, int columnIndex) {
            return ((FilterSetElement)element).getName();
        }
    }
}

