/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.editors;

import java.util.Iterator;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.hyades.models.hierarchy.TRCMonitor;
import org.eclipse.hyades.models.hierarchy.TRCNode;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.core.TraceLocationUI;
import org.eclipse.hyades.trace.ui.internal.core.TraceNodeUI;
import org.eclipse.hyades.trace.ui.internal.util.TString;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.part.FileEditorInput;

public class TRCNodeEditor
extends EditorPart {
    private TRCNode fNode;

    public void createPartControl(Composite parent) {
        WorkbenchHelp.setHelp((Control)parent, (String)(UIPlugin.getPluginId() + ".node0000"));
        Composite content = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.verticalSpacing = 5;
        content.setLayout((Layout)layout);
        GridData gd = new GridData();
        gd.verticalAlignment = 4;
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.widthHint = 500;
        content.setLayoutData((Object)gd);
        TraceLocationUI locationUI = new TraceLocationUI();
        locationUI.createControl(content);
        locationUI.setEnabled(false);
        TraceNodeUI nodeUI = new TraceNodeUI();
        nodeUI.createControl(content);
        nodeUI.setEnabled(false);
        if (this.fNode != null) {
            TRCMonitor fMonitor = this.fNode.getMonitor();
            Path path = new Path(TString.resourcePath(fMonitor.eResource().getURI()));
            locationUI.getLocation().setText(path.uptoSegment(path.segmentCount() - 1).toOSString());
            locationUI.getMonitor().setText(fMonitor.getName());
            nodeUI.getNodeNameUI().setText(this.fNode.getName());
            if (this.fNode.getIpAddress() != null) {
                nodeUI.getAddressUI().setText(this.fNode.getIpAddress());
            }
            if (this.fNode.getDeltaTime() != 0.0) {
                nodeUI.setDeltaTime(this.fNode.getDeltaTime());
            }
        }
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public void gotoMarker(IMarker marker) {
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        if (input instanceof IFileEditorInput) {
            this.setSite((IWorkbenchPartSite)site);
            this.setInput(input);
            this.loadNodeDoc();
            if (this.fNode != null) {
                this.setTitle(this.fNode.getName());
            } else {
                this.setTitle("UnknownNode");
            }
        }
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public boolean isSaveOnCloseNeeded() {
        return false;
    }

    private TRCNode loadNodeDoc() {
        block4: {
            if (this.fNode != null) break block4;
            try {
                String name = ((FileEditorInput)this.getEditorInput()).getFile().getFullPath().toString();
                ResourceSet resourceSet = UIPlugin.getDefault().getResourceSet();
                Resource res = resourceSet.getResource(URI.createURI((String)("platform:/resource" + name)), true);
                if (res == null) {
                    return this.fNode;
                }
                Iterator it = res.getContents().iterator();
                while (it.hasNext()) {
                    Object current = it.next();
                    if (!(current instanceof TRCNode)) continue;
                    this.fNode = (TRCNode)current;
                    break;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.fNode;
    }

    public void setFocus() {
    }
}

