/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.launcher;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.hyades.internal.execution.local.common.Options;
import org.eclipse.hyades.internal.execution.local.control.AgentConfigurationEntry;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.launcher.IProfileLaunchConfigurationConstants;
import org.eclipse.hyades.trace.ui.internal.launcher.ProfilingSet;
import org.eclipse.hyades.trace.ui.internal.launcher.ProfilingSetType;
import org.eclipse.hyades.trace.ui.internal.launcher.ProfilingSetTypeGroup;
import org.eclipse.hyades.trace.ui.internal.util.FilterSetElement;
import org.eclipse.hyades.trace.ui.internal.util.FilterTableElement;
import org.eclipse.hyades.trace.ui.launcher.IProfilingSet;
import org.eclipse.hyades.trace.ui.launcher.IProfilingSetType;
import org.eclipse.hyades.trace.ui.launcher.IProfilingType;
import org.eclipse.hyades.trace.ui.launcher.ProfilingAttribute;
import org.eclipse.hyades.ui.internal.util.XMLUtil;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ProfilingSetsManager {
    protected static ProfilingSetsManager instance;
    protected Map profilingSets;
    protected Map profilingTypesGroups;
    protected Map profilingTypes;
    protected Map filterSets;
    protected IProfilingSet defaultSet = null;
    protected FilterSetElement defaultFilterSet = null;
    protected final String profilingTypesGroupsExtPoint = "profilingTypesGroups";
    protected final String profilingTypesExtPoint = "profilingTypes";
    protected final String profilingSetsExtPoint = "profilingSets";
    protected final String profilingSetsStore = "profilingTypeSets";
    protected final String defaultProfilingSet = "defaultProfilingSet";

    protected ProfilingSetsManager() {
    }

    public static ProfilingSetsManager instance() {
        if (instance == null) {
            instance = new ProfilingSetsManager();
        }
        return instance;
    }

    public Map getProfilingTypesGroups() {
        if (this.profilingTypesGroups == null) {
            this.initialize();
        }
        return this.profilingTypesGroups;
    }

    public Map getProfilingTypes() {
        if (this.profilingTypes == null) {
            this.initialize();
        }
        return this.profilingTypes;
    }

    public Map getProfilingSets() {
        if (this.profilingSets == null) {
            this.initialize();
        }
        return this.profilingSets;
    }

    protected void initialize() {
        this.initializeProfilingTypesGroups();
        this.initializeProfilingTypes();
        this.initializeProfilingSets();
        this.initializeProfilingFilters();
    }

    protected void initializeProfilingTypesGroups() {
        this.profilingTypesGroups = new HashMap();
        IExtensionPoint point = UIPlugin.getDefault().getDescriptor().getExtensionPoint("profilingTypesGroups");
        if (point != null) {
            IConfigurationElement[] elements = point.getConfigurationElements();
            int i = 0;
            while (i < elements.length) {
                IConfigurationElement elem = elements[i];
                String name = elem.getAttribute("name");
                String id = elem.getAttribute("id");
                String iconPath = elem.getAttribute("icon");
                String description = UIPlugin.getResourceString("DEFAULT_PROFILING_GROUP_DESCRIPTION");
                String[] attributes = elem.getAttributeNames();
                int j = 0;
                while (j < attributes.length) {
                    String temp;
                    if (attributes[j].equalsIgnoreCase("description") && (temp = elem.getAttribute("description")).length() > 0) {
                        description = temp;
                    }
                    ++j;
                }
                if (id != null && name != null) {
                    ImageDescriptor icon = null;
                    if (iconPath != null) {
                        try {
                            icon = ImageDescriptor.createFromURL((URL)new URL(elem.getDeclaringExtension().getDeclaringPluginDescriptor().getInstallURL() + iconPath));
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    this.profilingTypesGroups.put(id, new ProfilingSetTypeGroup(id, name, description, icon));
                }
                ++i;
            }
        }
    }

    protected void initializeProfilingTypes() {
        this.profilingTypes = new HashMap();
        IExtensionPoint point = UIPlugin.getDefault().getDescriptor().getExtensionPoint("profilingTypes");
        if (point != null) {
            IConfigurationElement[] elements = point.getConfigurationElements();
            int i = 0;
            while (i < elements.length) {
                IConfigurationElement elem = elements[i];
                String id = elem.getAttribute("id");
                String name = elem.getAttribute("name");
                if (id != null && name != null) {
                    String iconPath = elem.getAttribute("icon");
                    ImageDescriptor icon = null;
                    if (iconPath != null) {
                        try {
                            icon = ImageDescriptor.createFromURL((URL)new URL(elem.getDeclaringExtension().getDeclaringPluginDescriptor().getInstallURL() + iconPath));
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    String description = elem.getAttribute("description");
                    String group = elem.getAttribute("group");
                    boolean useFilter = elem.getAttribute("useFilters") == null ? false : elem.getAttribute("useFilters").equalsIgnoreCase("true");
                    IProfilingType profileType = null;
                    try {
                        profileType = (IProfilingType)elem.createExecutableExtension("className");
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    if (profileType != null) {
                        ProfilingSetType pTypes = new ProfilingSetType(id, name, description, icon, useFilter, group, profileType);
                        this.profilingTypes.put(id, pTypes);
                    }
                }
                ++i;
            }
        }
    }

    protected void initializeProfilingSets() {
        this.profilingSets = new HashMap();
        this.readSetsFromRegistry();
        this.readSetsFromPreferences("profilingTypeSets", "defaultProfilingSet");
        if (this.getDefaultSet() == null && this.profilingSets.size() > 0) {
            Object[] sets = this.profilingSets.values().toArray();
            int j = 0;
            while (j < this.profilingSets.values().size()) {
                IProfilingSet set = (IProfilingSet)sets[j];
                if (set.getId().equals(this.getDefaultProfilingSet())) {
                    this.setDefaultSet(set);
                }
                ++j;
            }
        }
    }

    protected void readSetsFromRegistry() {
        IExtensionPoint point = UIPlugin.getDefault().getDescriptor().getExtensionPoint("profilingSets");
        if (point != null) {
            IConfigurationElement[] elements = point.getConfigurationElements();
            int i = 0;
            while (i < elements.length) {
                IConfigurationElement elem = elements[i];
                String id = elem.getAttribute("id");
                String name = elem.getAttribute("name");
                String description = elem.getAttribute("description");
                if (id != null && name != null) {
                    ProfilingSet pSets = new ProfilingSet(id, name, description);
                    IConfigurationElement[] types = elem.getChildren("profilingTypes");
                    int k = 0;
                    while (k < types.length) {
                        IConfigurationElement[] aelements = types[k].getChildren("profilingType");
                        int ak = 0;
                        while (ak < aelements.length) {
                            IConfigurationElement aelem = aelements[ak];
                            String aid = aelem.getAttribute("id");
                            if (aid != null) {
                                pSets.getProfilingTypes().add(aid);
                            }
                            ++ak;
                        }
                        ++k;
                    }
                    IConfigurationElement[] attributes = elem.getChildren("attributes");
                    List attributeList = ProfilingSetsManager.getDefaultProfilingOptions();
                    int k2 = 0;
                    while (k2 < attributes.length) {
                        IConfigurationElement[] aelements = attributes[k2].getChildren("attribute");
                        int ak = 0;
                        while (ak < aelements.length) {
                            IConfigurationElement aelem = aelements[ak];
                            String type = aelem.getAttribute("type");
                            String aname = aelem.getAttribute("name");
                            String value = aelem.getAttribute("value");
                            if (type != null && aname != null && value != null) {
                                aname = "ATTR".equals(type) ? UIPlugin.getPluginId() + ".ATTR_" + aname : type + "_" + aname;
                                ProfilingAttribute option = new ProfilingAttribute(aname, value);
                                attributeList.add(option);
                            }
                            ++ak;
                        }
                        ++k2;
                    }
                    Map map = pSets.getAttributes();
                    Iterator iter = ProfilingSetsManager.filterDuplicateOptions(attributeList).iterator();
                    while (iter.hasNext()) {
                        ProfilingAttribute option = (ProfilingAttribute)iter.next();
                        map.put(option.getName(), option);
                    }
                    this.profilingSets.put(id, pSets);
                }
                ++i;
            }
        }
    }

    protected void readSetsFromPreferences(String profilingSetsString, String defaultSetId) {
        IPreferenceStore store = UIPlugin.getDefault().getPreferenceStore();
        String profilingSetsStr = store.getString(profilingSetsString);
        String defaultSet = store.getString(defaultSetId);
        if (profilingSetsStr == null || profilingSetsStr.length() == 0) {
            return;
        }
        this.readSets(profilingSetsStr, defaultSet);
    }

    protected void readSets(String profilingSetsStr, String defaultSet) {
        Object set;
        if (profilingSetsStr == null || profilingSetsStr.length() == 0) {
            return;
        }
        Element prefElement = XMLUtil.loadDom((String)profilingSetsStr, (String)"profilingSets");
        NodeList profilingSetsNodeList = XMLUtil.getChildrenByName((Element)prefElement, (String)"profilingSet");
        Element element = null;
        int i = 0;
        while (i < profilingSetsNodeList.getLength()) {
            if (profilingSetsNodeList.item(i) instanceof Element) {
                element = (Element)profilingSetsNodeList.item(i);
            }
            String name = element.getAttribute("name");
            String description = element.getAttribute("description");
            String id = element.getAttribute("id");
            if (id != null) {
                IProfilingSet set2;
                Object obj = this.profilingSets.get(id);
                if (obj == null) {
                    set2 = new ProfilingSet(id, name, description);
                    this.profilingSets.put(id, set2);
                } else {
                    set2 = (IProfilingSet)obj;
                    set2.setName(name);
                    set2.setDescription(description);
                    set2.getAttributes().clear();
                    set2.getProfilingTypes().clear();
                }
                NodeList types = XMLUtil.getChildrenByName((Element)element, (String)"profilingTypes");
                int j = 0;
                while (j < types.getLength()) {
                    Element atype = (Element)types.item(j);
                    NodeList atypes = XMLUtil.getChildrenByName((Element)atype, (String)"profilingType");
                    int k = 0;
                    while (k < atypes.getLength()) {
                        Element atypeElem = (Element)atypes.item(k);
                        String atypeId = atypeElem.getAttribute("name");
                        if (atypeId != null && atypeId.length() > 0) {
                            set2.getProfilingTypes().add(atypeId);
                        }
                        ++k;
                    }
                    ++j;
                }
                List attributeList = ProfilingSetsManager.getDefaultProfilingOptions();
                NodeList attributes = XMLUtil.getChildrenByName((Element)element, (String)"attributes");
                int j2 = 0;
                while (j2 < attributes.getLength()) {
                    Element atype = (Element)attributes.item(j2);
                    NodeList atypes = XMLUtil.getChildrenByName((Element)atype, (String)"attribute");
                    int k = 0;
                    while (k < atypes.getLength()) {
                        Element atypeElem = (Element)atypes.item(k);
                        String atypeId = atypeElem.getAttribute("type");
                        String aname = atypeElem.getAttribute("name");
                        String value = atypeElem.getAttribute("value");
                        if (atypeId.length() > 0) {
                            aname = atypeId + "_" + aname;
                        }
                        ProfilingAttribute option = new ProfilingAttribute(aname, value);
                        attributeList.add(option);
                        ++k;
                    }
                    ++j2;
                }
                Iterator iter = ProfilingSetsManager.filterDuplicateOptions(attributeList).iterator();
                while (iter.hasNext()) {
                    ProfilingAttribute option = (ProfilingAttribute)iter.next();
                    set2.getAttributes().put(option.getName(), option);
                }
            }
            ++i;
        }
        if (defaultSet != null && (set = this.getProfilingSets().get(defaultSet)) != null) {
            this.setDefaultSet((IProfilingSet)set);
        }
        if (this.getDefaultSet() == null && this.profilingSets.size() > 0) {
            Object[] sets = this.profilingSets.values().toArray();
            this.setDefaultSet((IProfilingSet)sets[0]);
        }
    }

    protected void readFilters(String profilingSetsStr) {
        if (profilingSetsStr == null || profilingSetsStr.length() == 0) {
            return;
        }
        Element prefElement = XMLUtil.loadDom((String)profilingSetsStr, (String)"filters");
        NodeList profilingSetsNodeList = XMLUtil.getChildrenByName((Element)prefElement, (String)"filter");
        Element element = null;
        int i = 0;
        while (i < profilingSetsNodeList.getLength()) {
            FilterSetElement set;
            String name;
            Object obj;
            if (profilingSetsNodeList.item(i) instanceof Element) {
                element = (Element)profilingSetsNodeList.item(i);
            }
            if ((obj = this.filterSets.get(name = element.getAttribute("name"))) == null) {
                set = new FilterSetElement(name);
                this.filterSets.put(name, set);
            } else {
                set = (FilterSetElement)obj;
                set.setName(name);
                set.getChildren().clear();
            }
            ArrayList<FilterTableElement> children = new ArrayList<FilterTableElement>();
            NodeList types = XMLUtil.getChildrenByName((Element)element, (String)"contents");
            int j = 0;
            while (j < types.getLength()) {
                Element atype = (Element)types.item(j);
                NodeList atypes = XMLUtil.getChildrenByName((Element)atype, (String)"content");
                int k = 0;
                while (k < atypes.getLength()) {
                    Element atypeElem = (Element)atypes.item(k);
                    String text = atypeElem.getAttribute("text");
                    String method = atypeElem.getAttribute("method");
                    String visibility = atypeElem.getAttribute("visibility");
                    visibility = visibility.equals("0") || visibility.equals(UIPlugin.getResourceString("STR_EXCLUDE")) ? UIPlugin.getResourceString("STR_EXCLUDE") : UIPlugin.getResourceString("STR_INCLUDE");
                    FilterTableElement child = new FilterTableElement(text, method, visibility);
                    children.add(child);
                    ++k;
                }
                ++j;
            }
            set.setChildren(children);
            ++i;
        }
    }

    public void writeSetsToPreferences() {
        IPreferenceStore store = UIPlugin.getDefault().getPreferenceStore();
        store.setValue("profilingTypeSets", this.getProfilingSetsString().toString());
        store.setValue("set_filters", this.getProfilingFiltersString().toString());
        if (this.getDefaultSet() != null) {
            store.setValue("defaultProfilingSet", this.getDefaultSet().getId());
        }
    }

    protected StringBuffer getProfilingSetsString() {
        StringBuffer xmlString = new StringBuffer();
        xmlString.append("<?xml");
        xmlString.append(XMLUtil.createXMLAttribute((String)"version", (String)"1.0", (boolean)false)).append(XMLUtil.createXMLAttribute((String)"encoding", (String)"UTF-8", (boolean)false));
        xmlString.append("?>");
        xmlString.append("<profilingSets>");
        Iterator sets = this.getProfilingSets().keySet().iterator();
        while (sets.hasNext()) {
            Object key = sets.next();
            IProfilingSet elem = (IProfilingSet)this.profilingSets.get(key);
            xmlString.append("<profilingSet");
            xmlString.append(XMLUtil.createXMLAttribute((String)"id", (String)elem.getId(), (boolean)false));
            xmlString.append(XMLUtil.createXMLAttribute((String)"name", (String)elem.getName(), (boolean)false));
            xmlString.append(XMLUtil.createXMLAttribute((String)"description", (String)elem.getDescription(), (boolean)false));
            xmlString.append(">");
            xmlString.append("<profilingTypes>");
            List types = elem.getProfilingTypes();
            int i = 0;
            while (i < types.size()) {
                xmlString.append("<profilingType");
                xmlString.append(XMLUtil.createXMLAttribute((String)"name", (String)types.get(i).toString(), (boolean)false));
                xmlString.append("/>");
                ++i;
            }
            xmlString.append("</profilingTypes>");
            xmlString.append("<attributes>");
            Iterator attributes = elem.getAttributes().keySet().iterator();
            while (attributes.hasNext()) {
                Object akey = attributes.next();
                ProfilingAttribute option = (ProfilingAttribute)elem.getAttributes().get(akey);
                xmlString.append("<attribute");
                xmlString.append(XMLUtil.createXMLAttribute((String)"name", (String)option.getName(), (boolean)false));
                xmlString.append(XMLUtil.createXMLAttribute((String)"value", (String)option.getValue(), (boolean)false));
                xmlString.append("/>");
            }
            xmlString.append("</attributes>");
            xmlString.append("</profilingSet>");
        }
        xmlString.append("</profilingSets>");
        return xmlString;
    }

    protected StringBuffer getProfilingFiltersString() {
        StringBuffer xmlString = new StringBuffer();
        xmlString.append("<?xml");
        xmlString.append(XMLUtil.createXMLAttribute((String)"version", (String)"1.0", (boolean)false)).append(XMLUtil.createXMLAttribute((String)"encoding", (String)"UTF-8", (boolean)false));
        xmlString.append("?>");
        xmlString.append("<filters>");
        Iterator sets = this.getFilterSets().keySet().iterator();
        while (sets.hasNext()) {
            Object key = sets.next();
            FilterSetElement elem = (FilterSetElement)this.filterSets.get(key);
            xmlString.append("<filter");
            xmlString.append(XMLUtil.createXMLAttribute((String)"name", (String)elem.getName(), (boolean)false));
            xmlString.append(">");
            xmlString.append("<contents>");
            ArrayList types = elem.getChildren();
            int i = 0;
            while (i < types.size()) {
                FilterTableElement fElem = (FilterTableElement)types.get(i);
                xmlString.append("<content");
                xmlString.append(XMLUtil.createXMLAttribute((String)"text", (String)fElem.getText(), (boolean)false));
                xmlString.append(XMLUtil.createXMLAttribute((String)"method", (String)fElem.getMethod(), (boolean)false));
                xmlString.append(XMLUtil.createXMLAttribute((String)"visibility", (String)fElem.getVisibility(), (boolean)false));
                xmlString.append("/>");
                ++i;
            }
            xmlString.append("</contents>");
            xmlString.append("</filter>");
        }
        xmlString.append("</filters>");
        return xmlString;
    }

    public IProfilingSetType[] getProfilingTypesForGroup(String groupId) {
        if (groupId == null) {
            return new IProfilingSetType[0];
        }
        ArrayList<IProfilingSetType> list = new ArrayList<IProfilingSetType>();
        Iterator profileType = this.getProfilingTypes().values().iterator();
        while (profileType.hasNext()) {
            IProfilingSetType profType = (IProfilingSetType)profileType.next();
            if (!profType.getGroup().equals(groupId)) continue;
            list.add(profType);
        }
        IProfilingSetType[] array = new IProfilingSetType[list.size()];
        return list.toArray(array);
    }

    public IProfilingSet getDefaultSet() {
        if (this.profilingSets == null) {
            this.initialize();
        }
        return this.defaultSet;
    }

    public void setDefaultSet(IProfilingSet defaultSet) {
        this.defaultSet = defaultSet;
    }

    protected void initializeProfilingFilters() {
        this.filterSets = new HashMap();
        IPreferenceStore store = UIPlugin.getDefault().getPreferenceStore();
        String filtersStr = store.getString("set_filters");
        this.readFilters(filtersStr);
        if (this.getDefaultFilterSet() == null && this.filterSets.size() > 0) {
            FilterSetElement defaultFilter = (FilterSetElement)this.filterSets.get(UIPlugin.getResourceString("STR_DEFAULT_SET_NAME"));
            if (defaultFilter != null) {
                this.setDefaultFilterSet(defaultFilter);
            } else {
                Object[] sets = this.filterSets.values().toArray();
                this.setDefaultFilterSet((FilterSetElement)sets[0]);
            }
        }
    }

    public Map getFilterSets() {
        if (this.filterSets == null) {
            this.initialize();
        }
        return this.filterSets;
    }

    public void setFilterSets(Map filterSets) {
        this.filterSets = filterSets;
    }

    public FilterSetElement getDefaultFilterSet() {
        if (this.profilingSets == null) {
            this.initialize();
        }
        return this.defaultFilterSet;
    }

    public void setDefaultFilterSet(FilterSetElement defaultFilterSet) {
        this.defaultFilterSet = defaultFilterSet;
    }

    public Vector getLimitOptions(ILaunchConfiguration conf) throws CoreException {
        IPreferenceStore store = UIPlugin.getDefault().getPreferenceStore();
        Vector<AgentConfigurationEntry> options = new Vector<AgentConfigurationEntry>();
        boolean limitInvocations = conf.getAttribute(IProfileLaunchConfigurationConstants.ATTR_PROFILING_LIMIT_INVOCATIONS, store.getBoolean("limitInvoc"));
        int invocations = conf.getAttribute(IProfileLaunchConfigurationConstants.ATTR_PROFILING_LIMIT_INVOCATIONS_NUM, store.getInt("invoc_nb"));
        boolean limitTime = conf.getAttribute(IProfileLaunchConfigurationConstants.ATTR_PROFILING_LIMIT_SECONDS, store.getBoolean("limitTime"));
        int seconds = conf.getAttribute(IProfileLaunchConfigurationConstants.ATTR_PROFILING_LIMIT_SECONDS_NUM, store.getInt("timeSec"));
        if (limitInvocations) {
            AgentConfigurationEntry entry1;
            AgentConfigurationEntry entry = new AgentConfigurationEntry();
            entry.setName("BURST_MODE");
            entry.setType("SETOPTION");
            if (limitTime) {
                entry.setValue("secondsAndInvocations");
                entry1 = new AgentConfigurationEntry();
                entry1.setName("BURST_SECONDS");
                entry1.setValue(String.valueOf(seconds));
                entry1.setType("SETOPTION");
                options.addElement(entry1);
            } else {
                entry.setValue("invocations");
            }
            options.addElement(entry);
            entry1 = new AgentConfigurationEntry();
            entry1.setName("BURST_INVOCATIONS");
            entry1.setValue(String.valueOf(invocations));
            entry1.setType("SETOPTION");
            options.addElement(entry1);
        } else if (limitTime) {
            AgentConfigurationEntry entry = new AgentConfigurationEntry();
            entry.setName("BURST_MODE");
            entry.setType("SETOPTION");
            entry.setValue("seconds");
            options.addElement(entry);
            entry = new AgentConfigurationEntry();
            entry.setName("BURST_SECONDS");
            entry.setValue(String.valueOf(seconds));
            entry.setType("SETOPTION");
            options.addElement(entry);
        }
        return options;
    }

    public Vector getOptions(ILaunchConfiguration conf) throws CoreException {
        Vector options = this.getLimitOptions(conf);
        String profilingSetID = conf.getAttribute(IProfileLaunchConfigurationConstants.ATTR_PROFILING_SET, (String)null);
        IProfilingSet set = (IProfilingSet)this.getProfilingSets().get(profilingSetID);
        if (set != null) {
            options.addAll(this.getProfileOptions(set));
        }
        return options;
    }

    public Vector getProfileOptions(IProfilingSet set) throws CoreException {
        List types;
        Vector<AgentConfigurationEntry> options = new Vector<AgentConfigurationEntry>();
        Map attributes = set.getAttributes();
        Iterator attrNames = attributes.keySet().iterator();
        String prefixName = "SETOPTION_";
        int numRACoptions = 0;
        while (attrNames.hasNext()) {
            AgentConfigurationEntry entry;
            String name = attrNames.next().toString();
            if (name.startsWith(prefixName)) {
                entry = new AgentConfigurationEntry();
                entry.setName(name.substring(prefixName.length()));
                entry.setValue(((ProfilingAttribute)attributes.get(name)).getValue());
                entry.setType("SETOPTION");
                options.addElement(entry);
                ++numRACoptions;
                continue;
            }
            if (this.filterOption(name)) continue;
            entry = new AgentConfigurationEntry();
            entry.setName(name);
            entry.setValue(((ProfilingAttribute)attributes.get(name)).getValue());
            entry.setType("SETOPTION");
            options.addElement(entry);
        }
        if (numRACoptions == 0) {
            IProfilingSet defaultSet = this.getDefaultSet();
            Iterator defaultOptions = defaultSet.getAttributes().values().iterator();
            while (defaultOptions.hasNext()) {
                ProfilingAttribute attr = (ProfilingAttribute)defaultOptions.next();
                if (!attr.getName().startsWith(prefixName)) continue;
                AgentConfigurationEntry entry = new AgentConfigurationEntry();
                entry.setName(attr.getName().substring(prefixName.length()));
                entry.setValue(attr.getValue());
                entry.setType("SETOPTION");
                options.addElement(entry);
            }
        }
        if ((types = set.getProfilingTypes()) != null) {
            Collections.sort(types, new Comparator(){
                Map map;
                {
                    this.map = ProfilingSetsManager.this.getProfilingTypes();
                }

                public int compare(Object o1, Object o2) {
                    return ((IProfilingSetType)this.map.get(o1)).getName().compareTo(((IProfilingSetType)this.map.get(o2)).getName());
                }
            });
            int i = 0;
            while (i < types.size()) {
                AgentConfigurationEntry entry = new AgentConfigurationEntry();
                entry.setName(UIPlugin.getPluginId() + ".type" + i);
                entry.setValue((String)types.get(i));
                entry.setType("SETOPTION");
                options.addElement(entry);
                ++i;
            }
        }
        return options;
    }

    protected boolean filterOption(String name) {
        return name.equals(IProfileLaunchConfigurationConstants.ATTR_PROFILING_SET) || name.equals(IProfileLaunchConfigurationConstants.ATTR_FILTER_SET);
    }

    public boolean getAutoMonitoring(ILaunchConfiguration conf) throws CoreException {
        return conf.getAttribute(IProfileLaunchConfigurationConstants.ATTR_AUTO_MONITORING, true);
    }

    public ArrayList getFilters(ILaunchConfiguration conf) throws CoreException {
        String filterSetName = conf.getAttribute(IProfileLaunchConfigurationConstants.ATTR_FILTER_SET, this.getDefaultFilterSet().getName());
        FilterSetElement filters = (FilterSetElement)this.getFilterSets().get(filterSetName);
        if (filters == null) {
            return new ArrayList(0);
        }
        return filters.getChildren();
    }

    private String getDefaultFilterSetAsString() {
        StringBuffer filterStr = new StringBuffer();
        FilterSetElement filterSetElement = this.getDefaultFilterSet();
        ArrayList attrs = filterSetElement.getChildren();
        int idx = 0;
        while (idx < attrs.size()) {
            FilterTableElement elem = (FilterTableElement)attrs.get(idx);
            filterStr.append(elem.getText());
            if (elem.getMethod().length() > 0) {
                filterStr.append(":").append(elem.getMethod());
            }
            filterStr.append(":").append(elem.getVisibility());
            filterStr.append("&");
            ++idx;
        }
        return filterStr.toString();
    }

    private FilterTableElement getFilterElement(String name) {
        String text = name;
        String method = "*";
        int idx = text.indexOf(":");
        if (idx != -1) {
            text = text.substring(0, idx);
            method = name.substring(idx + 1);
        }
        idx = method.indexOf(":");
        String visibility = "EXCLUDE";
        if (idx != -1) {
            String temp = method;
            method = method.substring(0, idx);
            visibility = temp.substring(idx + 1);
        }
        FilterTableElement elem = new FilterTableElement(text, method, visibility);
        return elem;
    }

    public String getDefaultProfilingSet() {
        return "org.eclipse.hyades.defaultProfilingSets.memory";
    }

    public static List getDefaultProfilingOptions() {
        ArrayList<ProfilingAttribute> list = new ArrayList<ProfilingAttribute>();
        String[][] options = Options.OPTIONS_DEFAULT;
        String PREFIX = "SETOPTION_";
        int i = 0;
        while (i < options.length) {
            list.add(new ProfilingAttribute("SETOPTION_" + options[i][0], options[i][1]));
            ++i;
        }
        return list;
    }

    public static List filterDuplicateOptions(List original) {
        ArrayList result = new ArrayList();
        Iterator iter = original.iterator();
        while (iter.hasNext()) {
            ProfilingSetsManager.addProfilingOption(result, (ProfilingAttribute)iter.next());
        }
        return result;
    }

    public static void addProfilingOption(List options, ProfilingAttribute option) {
        String PREFIX = "SETOPTION_";
        int idx = 0;
        while (idx < options.size()) {
            ProfilingAttribute pOption = (ProfilingAttribute)options.get(idx);
            if (pOption.getName().equals(option.getName())) {
                if (pOption.getValue().equals("false")) {
                    pOption.setValue(option.getValue());
                } else if (pOption.getValue().equals("none")) {
                    pOption.setValue(option.getValue());
                } else {
                    if (option.getValue().equals("false")) {
                        return;
                    }
                    if (pOption.getValue().equals("none")) {
                        return;
                    }
                    if (pOption.getName().equals("SETOPTION_STACK_INFORMATION")) {
                        if (pOption.getValue().equals("boundary")) {
                            return;
                        }
                        if (!option.getValue().equals("none")) {
                            pOption.setValue(option.getValue());
                        }
                    } else if (pOption.getName().equals("SETOPTION_TRACE_MODE") && pOption.getValue().equals("noObjectCorrelation")) {
                        pOption.setValue(option.getValue());
                    }
                }
                return;
            }
            ++idx;
        }
        options.add(option);
    }
}

