/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.launcher;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.hyades.trace.ui.internal.launcher.IProfileLaunchConfigurationConstants;
import org.eclipse.hyades.trace.ui.internal.launcher.ProfilingSet;
import org.eclipse.hyades.trace.ui.internal.launcher.ProfilingSetType;
import org.eclipse.hyades.trace.ui.internal.launcher.ProfilingSetTypeGroup;
import org.eclipse.hyades.trace.ui.internal.launcher.ProfilingSetsManager;
import org.eclipse.hyades.trace.ui.internal.util.FilterSetElement;
import org.eclipse.hyades.trace.ui.internal.util.FilterTableElement;
import org.eclipse.hyades.trace.ui.launcher.IProfilingSet;
import org.eclipse.hyades.trace.ui.launcher.IProfilingSetType;
import org.eclipse.hyades.trace.ui.launcher.IProfilingSetTypeGroup;
import org.eclipse.hyades.ui.HyadesUIPlugin;

public class ProfilingSetsManagerCopy
extends ProfilingSetsManager {
    public ProfilingSetsManagerCopy() {
        this.initialize();
    }

    public void initializeFrom(ILaunchConfiguration conf) {
        String defaultProfilingSet = this.getDefaultSet().getId();
        String defaultFilterSet = this.getDefaultFilterSet().getName();
        try {
            Map map;
            String profilingSetId = conf.getAttribute(IProfileLaunchConfigurationConstants.ATTR_PROFILING_SET, defaultProfilingSet);
            String filterSetName = conf.getAttribute(IProfileLaunchConfigurationConstants.ATTR_FILTER_SET, defaultFilterSet);
            IProfilingSet profilingSet = (IProfilingSet)this.getProfilingSets().get(profilingSetId);
            FilterSetElement filterSet = (FilterSetElement)this.getFilterSets().get(filterSetName);
            if (profilingSet == null && (map = this.getProfilingSets()).size() > 0) {
                profilingSet = (IProfilingSet)map.values().iterator().next();
            }
            if (filterSet == null && (map = this.getFilterSets()).size() > 0) {
                filterSet = (FilterSetElement)map.values().iterator().next();
            }
            this.setDefaultSet(profilingSet);
            this.setDefaultFilterSet(filterSet);
        }
        catch (CoreException exc) {
            HyadesUIPlugin.logError((Throwable)exc);
        }
    }

    public static ProfilingSetsManager instance() {
        return null;
    }

    public void applyChanges() {
        ProfilingSetsManager manager = ProfilingSetsManager.instance();
        manager.getProfilingSets().clear();
        manager.getProfilingSets().putAll(this.getProfilingSets());
        manager.getProfilingTypes().clear();
        manager.getProfilingTypes().putAll(this.getProfilingTypes());
        manager.getProfilingTypesGroups().clear();
        manager.getProfilingTypesGroups().putAll(this.getProfilingTypesGroups());
        manager.getFilterSets().clear();
        manager.getFilterSets().putAll(this.getFilterSets());
        manager.setDefaultSet(this.getDefaultSet());
        manager.setDefaultFilterSet(this.getDefaultFilterSet());
        this.writeSetsToPreferences();
    }

    protected void initializeProfilingTypesGroups() {
        this.profilingTypesGroups = new HashMap();
        Map groups = ProfilingSetsManager.instance().getProfilingTypesGroups();
        Iterator keys = groups.keySet().iterator();
        while (keys.hasNext()) {
            String key = keys.next().toString();
            IProfilingSetTypeGroup group = (IProfilingSetTypeGroup)groups.get(key);
            this.profilingTypesGroups.put(key, new ProfilingSetTypeGroup(group.getId(), group.getName(), group.getDescription(), group.getIcon()));
        }
    }

    protected void initializeProfilingTypes() {
        this.profilingTypes = new HashMap();
        Map types = ProfilingSetsManager.instance().getProfilingTypes();
        Iterator keys = types.keySet().iterator();
        while (keys.hasNext()) {
            String key = keys.next().toString();
            IProfilingSetType type = (IProfilingSetType)types.get(key);
            this.profilingTypes.put(key, new ProfilingSetType(type.getId(), type.getName(), type.getDescription(), type.getImage(), type.isUseFilters(), type.getGroup(), type.getProfilingType()));
        }
    }

    protected void initializeProfilingSets() {
        this.profilingSets = new HashMap();
        IProfilingSet defaultSet = ProfilingSetsManager.instance().getDefaultSet();
        Map sets = ProfilingSetsManager.instance().getProfilingSets();
        Iterator keys = sets.keySet().iterator();
        while (keys.hasNext()) {
            String key = keys.next().toString();
            IProfilingSet set = (IProfilingSet)sets.get(key);
            ProfilingSet copy = new ProfilingSet(set.getId(), set.getName(), set.getDescription());
            copy.getProfilingTypes().addAll(set.getProfilingTypes());
            copy.getAttributes().putAll(set.getAttributes());
            this.profilingSets.put(key, copy);
            if (set != defaultSet) continue;
            this.setDefaultSet(copy);
        }
    }

    protected void initializeFilterSets() {
        this.filterSets = new HashMap();
        Map sets = ProfilingSetsManager.instance().getFilterSets();
        Iterator keys = sets.keySet().iterator();
        while (keys.hasNext()) {
            String key = keys.next().toString();
            FilterSetElement set = (FilterSetElement)sets.get(key);
            FilterSetElement copy = new FilterSetElement(set.getName());
            ArrayList children = set.getChildren();
            ArrayList<FilterTableElement> ccopy = new ArrayList<FilterTableElement>();
            int idx = 0;
            while (idx < children.size()) {
                FilterTableElement child = (FilterTableElement)children.get(idx);
                ccopy.add(new FilterTableElement(child.getText(), child.getMethod(), child.getVisibility()));
                ++idx;
            }
            copy.setChildren(ccopy);
            this.filterSets.put(key, copy);
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy wc) {
        IProfilingSet set = this.getDefaultSet();
        if (set != null) {
            FilterSetElement filterSet = this.getDefaultFilterSet();
            String filterSetName = null;
            if (filterSet != null) {
                filterSetName = filterSet.getName();
            }
            wc.setAttribute(IProfileLaunchConfigurationConstants.ATTR_PROFILING_SET, set.getId());
            wc.setAttribute(IProfileLaunchConfigurationConstants.ATTR_FILTER_SET, filterSetName);
        }
    }

    public ProfilingSetsManagerCopy createCopy() {
        ProfilingSetsManagerCopy copy = new ProfilingSetsManagerCopy();
        copy.resetFrom(this);
        return copy;
    }

    public void resetFrom(ProfilingSetsManagerCopy other) {
        this.getProfilingSets().clear();
        this.getProfilingSets().putAll(other.getProfilingSets());
        this.getProfilingTypes().clear();
        this.getProfilingTypes().putAll(other.getProfilingTypes());
        this.getProfilingTypesGroups().clear();
        this.getProfilingTypesGroups().putAll(other.getProfilingTypesGroups());
        this.getFilterSets().clear();
        this.getFilterSets().putAll(other.getFilterSets());
        this.setDefaultSet(other.getDefaultSet());
        this.setDefaultFilterSet(other.getDefaultFilterSet());
    }
}

