/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.statistical.ui.editor.internal;

import java.text.DecimalFormat;
import org.eclipse.hyades.statistical.ui.EditorPlugin;
import org.eclipse.hyades.statistical.ui.editor.internal.AlertTableMultiPanel;
import org.eclipse.hyades.statistical.ui.editor.internal.InvalidDataException;
import org.eclipse.hyades.statistical.ui.widgets.alert.internal.Alert;
import org.eclipse.hyades.statistical.ui.widgets.alert.internal.AlertRegistry;
import org.eclipse.hyades.statistical.ui.widgets.internal.GData;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class AlertTableDialog
extends Dialog
implements SelectionListener {
    DecimalFormat df = new DecimalFormat("###########################################.########################################");
    Alert monitor;
    Shell shell;
    Composite main_panel;
    boolean modified = false;
    AlertTableMultiPanel trigger_panel;
    AlertTableMultiPanel reset_panel;
    Composite button_panel;
    Button button_ok;
    Button button_cancel;

    public AlertTableDialog(Shell shell, Alert monitor) {
        super(shell);
        this.monitor = monitor;
    }

    public boolean open() {
        int WIDTH = 300;
        int HEIGHT = 300;
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 67696);
        this.shell.setText(EditorPlugin.getString("CONFIGURE_ALERT"));
        this.shell.setLayout((Layout)new FillLayout());
        this.shell.setBounds(0, 0, WIDTH, HEIGHT);
        this.initGraphics();
        this.initEventHandling();
        this.shell.pack();
        Rectangle r = parent.getBounds();
        Rectangle z = this.shell.getBounds();
        if (z.width < WIDTH) {
            z.width = WIDTH;
        }
        if (z.height < HEIGHT) {
            z.height = HEIGHT;
        }
        this.shell.setBounds(r.x + r.width / 2 - z.width / 2, r.y + r.height / 2 - z.height / 2, z.width, z.height);
        this.shell.open();
        Display display = parent.getDisplay();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.modified;
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        this.widgetSelected(e);
    }

    public void widgetSelected(SelectionEvent e) {
        Object o = e.getSource();
        if (o == this.button_ok) {
            try {
                this.writeToMonitor();
                this.modified = true;
                this.shell.dispose();
            }
            catch (Exception x) {}
        } else if (o == this.button_cancel) {
            this.shell.dispose();
        }
    }

    private void initEventHandling() {
        this.button_ok.addSelectionListener((SelectionListener)this);
        this.button_cancel.addSelectionListener((SelectionListener)this);
    }

    private void initGraphics() {
        this.main_panel = new Composite((Composite)this.shell, 0);
        this.main_panel.setLayout((Layout)new GridLayout(2, true));
        String DEF_TEXT = "               ";
        int groupHints = 16;
        this.trigger_panel = new AlertTableMultiPanel(this.main_panel, this.monitor.trigger_actions, EditorPlugin.getString("TRIGGER_DESCRIPTION"));
        this.trigger_panel.setLayoutData(GData.getGridData(true, true, -1, -1, 1, 1, 4, 4));
        this.reset_panel = new AlertTableMultiPanel(this.main_panel, this.monitor.reset_actions, EditorPlugin.getString("RESET_DESCRIPTION"));
        this.reset_panel.setLayoutData(GData.getGridData(true, true, -1, -1, 1, 1, 4, 4));
        this.button_panel = new Composite(this.main_panel, 0);
        this.button_panel.setLayoutData((Object)GData.getGridData(true, false, -1, -1, 2, 1, 4, 3));
        this.button_panel.setLayout((Layout)new GridLayout(1, true));
        Composite bptmp = new Composite(this.button_panel, 0);
        bptmp.setLayoutData((Object)GData.getGridData(false, false, -1, -1, 1, 1, 2, 2));
        bptmp.setLayout((Layout)new GridLayout(2, true));
        this.button_ok = new Button(bptmp, 8);
        this.button_ok.setLayoutData((Object)GData.getGridData(false, false, -1, -1, 1, 1, 4, 2));
        this.button_ok.setText(EditorPlugin.getString("OK"));
        this.button_cancel = new Button(bptmp, 8);
        this.button_cancel.setLayoutData((Object)GData.getGridData(false, false, -1, -1, 1, 1, 4, 2));
        this.button_cancel.setText(EditorPlugin.getString("CANCEL"));
    }

    public Alert getMonitor() {
        return this.monitor;
    }

    private int getProviderIndex(String name) {
        String[] provider_names = AlertRegistry.getProviderNames();
        int i = 0;
        while (i < provider_names.length) {
            if (name.equals(provider_names[i])) {
                return i;
            }
            ++i;
        }
        return 0;
    }

    private void writeToMonitor() throws InvalidDataException {
        try {
            this.monitor.trigger_actions = this.trigger_panel.getConfiguredActions();
            this.monitor.reset_actions = this.reset_panel.getConfiguredActions();
        }
        catch (NullPointerException e) {
            EditorPlugin.DBG.error("NullPointer on alert table dialog", e);
        }
        catch (SWTException e) {}
    }
}

