/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.statistical.ui.editor.internal;

import org.eclipse.hyades.statistical.ui.EditorPlugin;
import org.eclipse.hyades.statistical.ui.editor.internal.AlertTablePanel;
import org.eclipse.hyades.statistical.ui.editor.internal.InvalidDataException;
import org.eclipse.hyades.statistical.ui.widgets.alert.internal.AlertAction;
import org.eclipse.hyades.statistical.ui.widgets.alert.internal.AlertRegistry;
import org.eclipse.hyades.statistical.ui.widgets.internal.GData;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;

public class AlertTableMultiPanel
extends Composite
implements SelectionListener {
    int curr_index = 0;
    AlertAction[] actions;
    Label error_img;
    Label error_label;
    List list;
    Button list_add;
    Button list_remove;
    AlertTablePanel alertpanel;

    public AlertTableMultiPanel(Composite parent, AlertAction[] actions, String description) {
        super(parent, 16);
        this.actions = actions;
        this.initGraphics(description);
        this.initEventHandling();
        this.loadFromIndex();
    }

    private void setErrorMessage(String msg) {
        if (msg == null) {
            this.error_img.setImage(null);
            this.error_label.setText("        ");
            this.layout(true);
            this.error_label.redraw();
            this.error_img.redraw();
        } else {
            this.error_label.setText(msg);
            EditorPlugin.DBG.warning(msg);
            this.error_img.setImage(EditorPlugin.img.getImage("error_st_obj.gif"));
            this.layout(true);
            this.error_label.redraw();
            this.error_img.redraw();
        }
    }

    private boolean saveFromIndex() {
        if (this.alertpanel.getEnabled()) {
            try {
                this.actions[this.curr_index] = this.alertpanel.getConfiguredAction();
                this.setErrorMessage(null);
                return true;
            }
            catch (InvalidDataException x) {
                this.list.setItem(this.curr_index, this.alertpanel.getCurrentDescription());
                this.setErrorMessage(EditorPlugin.getString("ERROR_LABEL") + x.getMessage());
                this.list.setSelection(this.curr_index);
                return false;
            }
        }
        return true;
    }

    private void loadFromIndex() {
        this.setErrorMessage(null);
        String[] summaries = new String[this.actions.length];
        int i = 0;
        while (i < this.actions.length) {
            summaries[i] = this.actions[i].getDescription();
            ++i;
        }
        int index = this.list.getSelectionIndex();
        this.list.setItems(summaries);
        if (index >= 0 && index < summaries.length) {
            this.list.setSelection(index);
        }
        if (this.actions.length == 0 || this.curr_index < 0 || this.curr_index >= this.actions.length) {
            this.alertpanel.setConfiguredAction(AlertRegistry.getProvider(EditorPlugin.getString("ALERT_ACTION_NAME_DONOTHING")).newAlertAction());
            this.alertpanel.setEnabled(false);
        } else {
            this.alertpanel.setEnabled(true);
            this.alertpanel.setConfiguredAction(this.actions[this.curr_index]);
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        this.widgetSelected(e);
    }

    public void widgetSelected(SelectionEvent e) {
        Object o = e.getSource();
        if (o == this.list) {
            if (this.saveFromIndex()) {
                this.curr_index = this.list.getSelectionIndex();
                this.loadFromIndex();
            }
        } else if (o == this.list_add) {
            if (this.saveFromIndex()) {
                AlertAction[] tmp = new AlertAction[this.actions.length + 1];
                int index = this.actions.length;
                System.arraycopy(this.actions, 0, tmp, 0, index);
                tmp[index] = AlertRegistry.getProviders()[0].newAlertAction();
                this.actions = tmp;
                this.curr_index = index;
                this.loadFromIndex();
                this.list.setSelection(this.curr_index);
            }
        } else if (o == this.list_remove) {
            AlertAction[] tmp = new AlertAction[this.actions.length - 1];
            if (this.curr_index > 0) {
                System.arraycopy(this.actions, 0, tmp, 0, this.curr_index);
            }
            if (this.curr_index < this.actions.length - 1) {
                System.arraycopy(this.actions, this.curr_index + 1, tmp, this.curr_index, this.actions.length - (this.curr_index + 1));
            }
            this.actions = tmp;
            this.curr_index = 0;
            this.loadFromIndex();
        }
    }

    private void initEventHandling() {
        this.list.addSelectionListener((SelectionListener)this);
        this.list_add.addSelectionListener((SelectionListener)this);
        this.list_remove.addSelectionListener((SelectionListener)this);
    }

    private void initGraphics(String description) {
        this.setLayoutData(GData.getGridData(true, true, -1, -1, 1, 1, 4, 4));
        this.setLayout((Layout)new GridLayout(2, false));
        Composite error_tmp = new Composite((Composite)this, 0);
        error_tmp.setLayout((Layout)new GridLayout(2, false));
        error_tmp.setLayoutData((Object)GData.getGridData(true, false, -1, -1, 2, 1, 4, 4));
        this.error_img = new Label(error_tmp, 0);
        this.error_img.setLayoutData((Object)GData.getGridData(false, false, -1, -1, 1, 1, 4, 4));
        this.error_label = new Label(error_tmp, 0);
        this.error_label.setText("            ");
        this.error_label.setLayoutData((Object)GData.getGridData(true, false, -1, -1, 1, 1, 4, 4));
        this.list = new List((Composite)this, 2052);
        this.list.setLayoutData((Object)GData.getGridData(true, true, -1, -1, 1, 1, 4, 4));
        Composite list_tmp = new Composite((Composite)this, 0);
        list_tmp.setLayout((Layout)new GridLayout(1, true));
        list_tmp.setLayoutData((Object)GData.getGridData(false, true, -1, -1, 1, 1, 4, 1));
        this.list_add = new Button(list_tmp, 0);
        this.list_add.setText(EditorPlugin.getString("ALERT_ACTION_ADD"));
        this.list_add.setLayoutData((Object)GData.getGridData(false, false, -1, -1, 1, 1, 4, 1));
        this.list_remove = new Button(list_tmp, 0);
        this.list_remove.setText(EditorPlugin.getString("ALERT_ACTION_REMOVE"));
        this.list_remove.setLayoutData((Object)GData.getGridData(false, false, -1, -1, 1, 1, 4, 1));
        this.alertpanel = new AlertTablePanel(this, description);
        this.list_remove.setLayoutData((Object)GData.getGridData(true, true, -1, -1, 2, 1, 4, 4));
    }

    private int getProviderIndex(String name) {
        String[] provider_names = AlertRegistry.getProviderNames();
        int i = 0;
        while (i < provider_names.length) {
            if (name.equals(provider_names[i])) {
                return i;
            }
            ++i;
        }
        return 0;
    }

    public AlertAction[] getConfiguredActions() throws InvalidDataException {
        if (!this.saveFromIndex()) {
            throw new InvalidDataException(this.error_label.getText());
        }
        return this.actions;
    }
}

